<?php

include 'includes/application_top.php';

$postAction = $_POST['post-action'];
$postData = $_POST['post-data'];
$status = array(
    "code" => 1,
    "message" => "No action occurred",
);

$customerId = $_SESSION['customer_id'];
$emailAddress = $_SESSION['customers_email_address'];
switch($postAction) {
    case "update-account-subscription":
        $wantsToSub = $postData['subscribed'];
        try {
            $subEmailData = $db->Execute("SELECT * FROM zen_email_subscriptions WHERE subscription_email = '$emailAddress'");
            if($wantsToSub == "true") {
                if($subEmailData->RecordCount() > 0) {
                    $status['message'] = "No Action Required";
                } else { 
                    $query = "INSERT INTO zen_email_subscriptions (subscription_email) VALUES('$emailAddress')";
                    $db->Execute($query);
                    $status['message'] = "Email Added To Newsletter";
                }
            } else {
                if($subEmailData->RecordCount() == 0) {
                    $status['message'] = "No Action Required";
                } else { 
                    $query = "DELETE FROM zen_email_subscriptions WHERE subscription_email = '$emailAddress'";
                    $db->Execute($query);
                    $status['message'] = "Email Removed From Newsletter";
                }
            }
        } catch (Exception $e){ 
            $status['code'] = 0;
            $status['message'] = $e->getMessage();
        }
        break;
    case "update-account-password":
        $password_regex = "/(?=(.*[0-9])+)(?=(.*[a-z])+)(?=(.*[A-Z])+).{10,}/";    
        $currentPassword = $postData["currentPassword"];
        $confirmPassword = $postData["confirmNewPassword"];
        $newPassword = $postData["newPassword"];
        try {
            $currentUser = $db->Execute("SELECT customers_password FROM zen_customers WHERE customers_id = $customerId");
            $isVerified = password_verify($currentPassword, $currentUser->fields['customers_password']);
            if($currentPassword == "" || $newPassword == "" || $confirmPassword == "") {
                throw new Exception("Missing Data, Please Fill Out All Information And Try Again");
            }
            if(!$isVerified) {
                throw new Exception("Current Password Incorrect");
            }
            if (!preg_match($password_regex, $newPassword)) {
                throw new Exception("The password you provided was invalid. Passwords require 10 characters, at least 1 upper-case letter, 1 lower-case, and 1 digit. If you believe this to be an error, please contact us.");
            }
            if($newPassword != $confirmPassword) {
                throw new Exception("New Password Fields Don't Match");
            }
            $sql = "
                UPDATE zen_customers
                SET customers_password = :password:
                WHERE customers_id = :customersID:
            ";
            $sql = $db->bindVars($sql, ':customersID:', $customerId, 'integer');
            $sql = $db->bindVars($sql, ':password:', zen_encrypt_password($newPassword), 'string');
            $db->Execute($sql);
            $sql = "UPDATE zen_customers_info
                    SET customers_info_date_account_last_modified = now()
                    WHERE customers_info_id = :customersID:";
            $sql = $db->bindVars($sql, ':customersID:', $customerId, 'integer');
            $db->Execute($sql);
            $status['message'] = "Password Reset";
        } catch (Exception $e) {
            $status['code'] = 0;
            $status['message'] = $e->getMessage();
        }
        break;
    case "update-account-info":
        $firstName = $postData["firstName"];
        $lastName = $postData["lastName"];
        $phone = $postData["phone"];
        if($firstName == "" || $lastName == "" || $phone == "") {
            throw new Exception("Missing Data, Please Fill Out All Information And Try Again");
        }
        try {
            $query = "
                UPDATE zen_customers
                SET customers_firstname = '$firstName', customers_lastname = '$lastName', customers_telephone = '$phone'
                WHERE customers_id = $customerId
            ";
            $db->Execute($query);

            $sql = "UPDATE zen_customers_info
                    SET customers_info_date_account_last_modified = now()
                    WHERE customers_info_id = :customersID:";
            $sql = $db->bindVars($sql, ':customersID:', $customerId, 'integer');
            $db->Execute($sql);
            $status['message'] = "Account Information Updated";
        } catch(Exception $e) {
            $status['code'] = 0;
            $status['message'] = $e->getMessage();
        }
        break;
    case "get-user-email":
        if(is_null($_SESSION['customers_email_address'])) {
            $status['message'] = "No user logged in";
            $status['email'] = "";
        } else {
            $status['message'] = 'User email Address Exists';
            $status['email'] = $_SESSION['customers_email_address'];
        }
        break;
    default:
        break;
}

echo json_encode($status);