<?php

include 'includes/application_top.php';

$postAction = "";
if (isset($_POST['post-action']))
{
    $postAction = $_POST['post-action'];
}
$postData = "";
if (isset($_POST['post-data']))
{
    $postData = $_POST['post-data'];
}
if ($postAction == "certificates" && $postData['data-action'] == "add")
{
    $postData = json_decode($_POST['post-data'], true);
}

$status = array(
    "code" => 0,
    "message" => "No post action implemented for " . $postAction,
);

switch ($postAction)
{
    case 'addresses':
        switch ($postData['data-action'])
        {
            case 'resolve':

                $streetAddressOne = $postData['addressLine1'];
                $streetAddressTwo = $postData['addressLine2'];
                $streetAddressThree = $postData['addressLine3'];
                $city = $postData['city'];
                $state = $postData['state'];
                $zip = $postData['zip'];
                $country = $postData['country'];

                $validate_address = array(
                    "line1" => $streetAddressOne,
                    "line2" => $streetAddressTwo,
                    "line3" => $streetAddressThree,
                    "textCase" => "Mixed",
                    "city" => $city,
                    "region" => $state,
                    "country" => $country,
                    "postalCode" => $zip
                );

                $ava_addressQualification = avatax_verify_address($validate_address);

                // if ($ava_addressQualification['validatedAddresses'][0]['addressType'] == "UnknownAddressType")
                // {
                //     $status = array(
                //         "code" => 0,
                //         "message" => "Address could not be validated. Please try again.",
                //         "response" => $ava_addressQualification
                //     );
                //     break;
                // }

                if (isset($ava_addressQualification['messages']['severity']) && $ava_addressQualification['messages']['severity'] == "Error")
                {
                    $status = array(
                        "code" => 0,
                        "message" => "Address resolution failed."
                    );
                    break;
                }

                $ava_qualifiedAddress = $ava_addressQualification['validatedAddresses'];

                $status = array(
                    "code" => 1,
                    "response" => $ava_qualifiedAddress,
                    "data" => $ava_qualifiedAddress[0]
                );
                break;
        }
        break;
    case 'taxes':
        switch ($postData['data-action'])
        {
            case 'get':

                /**
                 * Taxable
                 * 
                 *   "summary": [
                 *       {
                 *           "country": "US",
                 *           "region": "UT",
                 *           "jurisType": "State",
                 *           "jurisCode": "49",
                 *           "jurisName": "UTAH",
                 *           "taxAuthorityType": 45,
                 *           "stateAssignedNo": "",
                 *           "taxType": "Sales",
                 *           "taxSubType": "S",
                 *           "taxName": "UT STATE TAX",
                 *           "rateType": "General",
                 *           "taxable": 2882.09,
                 *           "rate": 0.0485,
                 *           "tax": 139.78,
                 *           "taxCalculated": 139.78,
                 *           "nonTaxable": 0,
                 *           "exemption": 0
                 *       },
                 *       {
                 *           "country": "US",
                 *           "region": "UT",
                 *           "jurisType": "County",
                 *           "jurisCode": "035",
                 *           "jurisName": "SALT LAKE",
                 *           "taxAuthorityType": 45,
                 *           "stateAssignedNo": "18-096",
                 *           "taxType": "Sales",
                 *           "taxSubType": "S",
                 *           "taxName": "UT COUNTY TAX",
                 *           "rateType": "General",
                 *           "taxable": 2882.09,
                 *           "rate": 0.024,
                 *           "tax": 69.17,
                 *           "taxCalculated": 69.17,
                 *           "nonTaxable": 0,
                 *           "exemption": 0
                 *       }
                 *   ]
                 * 
                 * Tax Exempt
                 * 
                 * 
                 *   "summary": [
                 *       {
                 *           "country": "US",
                 *           "region": "UT",
                 *           "jurisType": "State",
                 *           "jurisCode": "49",
                 *           "jurisName": "UTAH",
                 *           "taxAuthorityType": 45,
                 *           "stateAssignedNo": "",
                 *           "taxType": "Sales",
                 *           "taxSubType": "S",
                 *           "taxName": "UT STATE TAX",
                 *           "rateType": "General",
                 *           "taxable": 0,
                 *           "rate": 0.0485,
                 *           "tax": 0,
                 *           "taxCalculated": 0,
                 *           "nonTaxable": 0,
                 *           "exemption": 2882.09
                 *       },
                 *       {
                 *           "country": "US",
                 *           "region": "UT",
                 *           "jurisType": "County",
                 *           "jurisCode": "035",
                 *           "jurisName": "SALT LAKE",
                 *           "taxAuthorityType": 45,
                 *           "stateAssignedNo": "18-096",
                 *           "taxType": "Sales",
                 *           "taxSubType": "S",
                 *           "taxName": "UT COUNTY TAX",
                 *           "rateType": "General",
                 *           "taxable": 0,
                 *           "rate": 0.024,
                 *           "tax": 0,
                 *           "taxCalculated": 0,
                 *           "nonTaxable": 0,
                 *           "exemption": 2882.09
                 *       }
                 *   ]
                 */

                $_SESSION['taxes'] = array(
                    'values' => array(
                        'total' => 0.00,
                        'exempt' => FALSE,
                        'summary' => array(),
                        'display' => array()
                    )
                );

                $cartContents = ($_SESSION['cart']->contents);
                $products = array();

                foreach ($cartContents as $productID => $productInfo)
                {
                    if (strpos($productID, ':'))
                    {
                        $productID = substr($productID, 0, strpos($productID, ':'));
                    }

                    $prodManfZoneResults = $db->Execute("SELECT
                    p.products_id, p.products_model, p.products_price, p.manufacturers_id,
                    d.products_name,
                    m.manufacturers_id, m.manufacturers_name, m.manufacturers_address_1, m.manufacturers_city, m.manufacturers_zip,
                    z.zone_code, z.zone_name
                    FROM zen_products AS p
                    LEFT JOIN zen_products_description AS d ON p.products_id = d.products_id
                    LEFT JOIN zen_manufacturers AS m ON p.manufacturers_id = m.manufacturers_id
                    LEFT JOIN zen_zones AS z ON m.manufacturers_state = z.zone_id
                    WHERE p.products_id = $productID
                    ");

                    $pmzr = $prodManfZoneResults;

                    array_push($products, array(
                        "itemCode" => $pmzr->fields['products_model'],
                        "manf" => $pmzr->fields['manufacturers_id'],
                        "name" => $pmzr->fields['products_name'],
                        "quantity" => $productInfo['qty'],
                        "final_price" => $pmzr->fields['products_price']
                    ));
                }

                $customerId = $_SESSION['customer_id'] ?? "GUEST_CHECKOUT";

                $orderIDQuery = $db->Execute("SELECT orders_id FROM zen_orders ORDER BY orders_id DESC LIMIT 1");
                $nextOrderID = $orderIDQuery->fields['orders_id'] + 1;

                $order = array(
                    'customer_id' => $customerId,
                    'id' => $nextOrderID,
                    'subtotal' => $_SESSION['cart']->total
                );

                $shipping = array(
                    "code" => 1,
                    "values" => array(
                        "total" => $_SESSION['shipping']['values']['total']
                    ),
                    'line1' => $postData['name'],
                    'line2' => $postData['addressLine1'],
                    'city' => $postData['city'],
                    'region' => $postData['state'],
                    'postalCode' => $postData['zip'],
                    'country' => $postData['country']
                );

                $APIresponse = avatax_lookup_tax($order, $products, $shipping);

                $requestOfAPI = $APIresponse['request'];
                $resultOfAPI = $APIresponse['response'];

                $displaySummary = '';

                $_SESSION['taxes']['values']['exempt'] = FALSE;
                if ($resultOfAPI['status'] == 'Saved')
                {
                    $displaySummary .= '<table class="table table-hover">';
                    $displaySummary .= '<caption>Jusidiction Summary</caption>';
                    $displaySummary .= '<thead>';
                    $displaySummary .= '<tr>';
                    $displaySummary .= '<th>Type</th><th>Name</th><th>Rate</th><th>Amount</th>';
                    $displaySummary .= '</tr>';
                    $displaySummary .= '</thead>';
                    $displaySummary .= '<tbody>';
                    foreach ($resultOfAPI['summary'] as $summary)
                    {
                        $jurisType = $summary['jurisType'];
                        $jurisName = $summary['jurisName'];
                        $jurisRate = $summary['rate'];
                        $jurisAmount = '$' . number_format($summary['tax'], 2);
                        if ($summary['exemption'] > 0)
                        {
                            $jurisAmount = "EXEMPT";
                            $_SESSION['taxes']['values']['exempt'] = TRUE;
                        }
                        $displaySummary .= '<tr>';
                        $displaySummary .= "<td>$jurisType</td><td>$jurisName</td><td>$jurisRate</td><td>$jurisAmount</td>";
                        $displaySummary .= '</tr>';
                    }
                    $displaySummary .= '</tbody>';
                    $displaySummary .= '</table>';

                    $displayButtons = '';
                    if ($customerId == "GUEST_CHECKOUT")
                    {
                        $displayButtons = '
                        <p class="text-center mt-3">Do you need to upload an exemption certificate?</p>
                        <div class="d-flex col-10 offset-1 col-md-8 offset-md-2">
                            <a href="/index.php?main_page=register" class="w-100">
                                <button type="button" class="btn bg-westech-green text-white w-100">Yes</button>
                            </a>
                            <div class="vr ms-4 me-4"></div>
                            <button type="button" class="btn bg-westech-green text-white w-100" id="checkout-tax-continue-button">No</button>
                        </div>
                        ';
                    }
                    else
                    {
                        if ($_SESSION['taxes']['values']['exempt'])
                        {
                            $displayButtons = '
                                <svg xmlns="http://www.w3.org/2000/svg" class="d-none">
                                    <symbol id="check-circle-fill" viewBox="0 0 16 16">
                                        <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.97-3.03a.75.75 0 0 0-1.08.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-.01-1.05z"/>
                                    </symbol>
                                    <symbol id="info-fill" viewBox="0 0 16 16">
                                        <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16zm.93-9.412-1 4.705c-.07.34.029.533.304.533.194 0 .487-.07.686-.246l-.088.416c-.287.346-.92.598-1.465.598-.703 0-1.002-.422-.808-1.319l.738-3.468c.064-.293.006-.399-.287-.47l-.451-.081.082-.381 2.29-.287zM8 5.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2z"/>
                                    </symbol>
                                    <symbol id="exclamation-triangle-fill" viewBox="0 0 16 16">
                                        <path d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z"/>
                                    </symbol>
                                </svg>
                                <div class="d-flex align-items-center alert alert-success" role="alert">
                                    <svg class="bi flex-shrink-0 me-2" role="img" aria-label="Info:"><use xlink:href="#check-circle-fill"/></svg>
                                    <div>Your exemption was applied to this order.</div>
                                </div>
                                <div class="d-flex col-10 offset-1 col-md-8 offset-md-2">
                                    <button type="button" class="btn bg-westech-green text-white w-100" id="checkout-tax-continue-button">Continue</button>
                                </div>
                            ';
                        }
                        else
                        {
                            $displayButtons = '
                                <p class="text-center mt-3">Do you need to upload an exemption certificate?</p>
                                <div class="d-flex col-10 offset-1 col-md-8 offset-md-2">
                                    <a href="?main_page=account&display=tax-exemptions" class="w-100">
                                        <button type="button" class="btn bg-westech-green text-white w-100">Yes</button>
                                    </a>
                                    <div class="vr ms-4 me-4"></div>
                                    <button type="button" class="btn bg-westech-green text-white w-100" id="checkout-tax-continue-button">No</button>
                                </div>
                            ';
                        }
                    }

                    $_SESSION['taxes']['values']['display'] = array(
                        'summary' => $displaySummary,
                        'buttons' => $displayButtons
                    );
                    $_SESSION['taxes']['values']['total'] = $resultOfAPI['totalTax'];
                    $_SESSION['taxes']['values']['summary'] = $resultOfAPI['summary'];
                    $status = array(
                        'code' => 1,
                        'display' => array(
                            'summary' => $displaySummary,
                            'buttons' => $displayButtons
                        )
                    );

                    $avaDocCode = $resultOfAPI['code'];
                    $avaSent = print_r($requestOfAPI, true);
                    $resultOfAPI = print_r($resultOfAPI, true);
                    
                    $avaInsertQuery = "INSERT INTO `zen_apid_avalara`
                    (`customer_id`, `order_id`, `transaction_id`, `sent`,
                    `received`, `time`, `session_id`)
                    VALUES
                    (:cID:, :oID:, :avaDocCode:, :avaSent:,
                    :avaReceived:, now(), :sessionID:)";

                    
                    $avaInsertQueryValues = array(
                        "cID" => $_SESSION['customer_id'],
                        "oID" => $order['id'],
                        "avaDocCode" => $avaDocCode,
                        "avaSent" => $avaSent,
                        "avaReceived" => $resultOfAPI,
                        "sessionID" => session_id()
                    );
                    
                    $avaInsertQuery = foreachBindVars($avaInsertQueryValues, $avaInsertQuery);

                    $db->Execute($avaInsertQuery);
                }
                else
                {
                    $status = array(
                        'code' => 0,
                        'sent' => $requestOfAPI,
                        'received' => $resultOfAPI
                    );
                }

                $_SESSION['taxes']['status']['api'] = array(
                    "request" => $requestOfAPI,
                    "response" => $resultOfAPI
                );

            break;
        }
        break;
    case 'certificates':
        switch ($postData['data-action'])
        {
            case 'get':

                $currentExemptions = avatax_get_certificates_by_customer($_SESSION['customer_id']);
                $status = array(
                    "code" => 1,
                    "data" => $currentExemptions
                );

                break;
            case 'add':

                $fileUploaded = false;

                try
                {
                    if (is_array($_FILES['file']['error']))
                    {
                        throw new Exception('Invalid or missing file (' . $_FILES['file']['error'] . ')');
                    }

                    switch ($_FILES['file']['error'])
                    {
                        case UPLOAD_ERR_OK:
                            break;
                        case UPLOAD_ERR_NO_FILE:
                            throw new Exception("No file uploaded.");
                        case UPLOAD_ERR_INI_SIZE:
                        case UPLOAD_ERR_FORM_SIZE:
                            throw new Exception("File exceeded server limits.");
                        default:
                            throw new Exception("Unknown error occurred. Try again. (" . $_FILES['file']['error'] . ")");
                    }

                    $accept_types = array(
                        "pdf",
                        "application/pdf"
                    );
                
                    $conv_types = array(
                        "application/pdf" => "pdf"
                    );
                
                    $finfo = finfo_open(FILEINFO_MIME_TYPE);
                    $ext = finfo_file($finfo, $_FILES['file']['tmp_name']);
                
                    foreach ($conv_types as $k => $v)
                    {
                        if ($ext == $k) $ext = $v;
                    }
                
                    if (!in_array($ext, $accept_types))
                    {
                        throw new Exception("Invalid file format. Expected extensions: (" . implode(",", $accept_types) . ') Found extension(s):(' . $ext . ')');
                    }

                    $fileUploaded = sha1_file($_FILES['file']['tmp_name']) . date("Y-m-d H:i:s") . '.' . $ext;

                    if (!move_uploaded_file($_FILES['file']['tmp_name'], sprintf('includes/modules/avatax/certs/%s', $fileUploaded)))
                    {
                        throw new Exception('Failed to move uploaded file.');
                    }
                    else
                    {
                        $fileUploaded = 'includes/modules/avatax/certs/' . $fileUploaded;
                    }
                }
                catch (Exception $e)
                {
                    $status = array(
                        "code" => 1,
                        "message" => $e
                    );
                    break;
                }

                $customerId = $_SESSION['customer_id'];
                $companyName = $postData['exCompanyName'];
                $firstName = $postData['exFirstName'];
                $lastName = $postData['exLastName'];
                $streetAddressOne = $postData['exAddr1'];
                $streetAddressTwo = $postData['exAddr2'];
                $city = $postData['exCity'];
                $state = $postData['exState'];
                $zip = $postData['exZip'];

                $validate_address = array(
                    "line1" => $streetAddressOne,
                    "line2" => $streetAddressTwo,
                    "textCase" => "Mixed",
                    "city" => $city,
                    "region" => $state,
                    "country" => "US",
                    "postalCode" => $zip
                );

                $ava_addressQualification = avatax_verify_address($validate_address);

                if ($ava_addressQualification['validatedAddresses'][0]['addressType'] == "UnknownAddressType")
                {
                    $status = array(
                        "code" => 2,
                        "message" => "Address could not be validated. Please try again."
                    );
                    break;
                }

                $ava_qualifiedAddress = $ava_addressQualification['validatedAddresses'][0];

                $ava_customerDetailsWeb = array(
                    "customers_id" => $_SESSION['customer_id'],
                    "customers_firstname" => $postData['exFirstName'],
                    "customers_lastname" => $postData['exLastName'],
                    "customers_telephone" => "000-000-0000",
                    "customers_email_address" => $_SESSION['customers_email_address']
                );

                $ava_addressDetails = array(
                    "line1" => $ava_qualifiedAddress['line1'],
                    "city" => $ava_qualifiedAddress['city'],
                    "postalCode" => $ava_qualifiedAddress['postalCode'],
                    "country" => "US",
                    "region" => $ava_qualifiedAddress['region']
                );

                $exposureZones = explode(",", $postData['exSelectedStates']);
                $ava_zones = array();
                foreach ($exposureZones as $zone)
                {
                    array_push($ava_zones, array("name" => $zone));
                }
                $ava_profileWeb = avatax_create_customer($ava_customerDetailsWeb, $ava_addressDetails, $ava_zones);

                $expire = ($postData['exNoExp'])? '9999-12-31' : $postData['exDateExpire'];

                $ava_exemptionDetailsWeb = array(
                    "signedDate" => $postData['exDateSigned'],
                    "expDate" => $expire,
                    "filename" => $fileUploaded,
                    "taxNumber" => $postData['exNumber'],
                    "taxType" => $postData['exType'],
                    "exemptionReason" => $postData['exReason'],
                    "customers" => avatax_get_customer($_SESSION['customer_id']),
                    "customerExposureZone" => $postData['exState'],
                    "zones" => $ava_zones
                );

                $ava_createExemptionWeb = avatax_create_certificate($ava_exemptionDetailsWeb, $ava_zones);

                //CREATE QUICKBOOKS COPY

                $ava_customerDetailsQB = array(
                    "customers_id" => "{$postData['exFirstName']} {$postData['exLastName']}",
                    "customers_firstname" => $postData['exFirstName'],
                    "customers_lastname" => $postData['exLastName'],
                    "customers_telephone" => "000-000-0000",
                    "customers_email_address" => $_SESSION['customers_email_address']
                );

                $ava_profileQB = avatax_create_customer($ava_customerDetailsQB, $ava_addressDetails, $ava_zones);

                $ava_exemptionDetailsQB = array(
                    "signedDate" => $postData['exDateSigned'],
                    "expDate" => $expire,
                    "filename" => $fileUploaded,
                    "taxNumber" => $postData['exNumber'],
                    "taxType" => $postData['exType'],
                    "exemptionReason" => $postData['exReason'],
                    "customers" => avatax_get_customer("{$postData['exFirstName']} {$postData['exLastName']}"),
                    "customerExposureZone" => $postData['exState'],
                    "zones" => $ava_zones
                );

                $ava_createExemptionQB = avatax_create_certificate($ava_exemptionDetailsQB, $ava_zones);

                $status = array(
                    "exemptionDetailsSubmittedWeb" => $ava_exemptionDetailsWeb,
                    "exemptionDetailsSubmittedQB" => $ava_exemptionDetailsQB,
                    "zones" => $ava_zones,
                    "exemptionResultsReceivedWeb" => $ava_createExemptionWeb,
                    "exemptionResultsReceivedQB" => $ava_createExemptionQB,
                    "code" => 3,
                    "message" => "Certificate was created successfully. When shipping to a state in the Selected States field above, your exemption should apply automatically. New exemptions are reviewed after an order is placed, and we'll contact you when processing your order if we require additional information.",
                    "POST" => $postData
                );

                break;
            case 'update':
                break;
            case 'delete':

                $unlink = avatax_unlink_customers_from_certificate($_SESSION['customer_id'], $postData['id']);
                $delete = avatax_delete_certificate($postData['id']);

                $status = array(
                    "code" => 1,
                    "unlink" => $unlink,
                    "delete" => $delete
                );

                break;
        }
        break;
    case 'customers':
        break;
}

echo json_encode($status);