<?php

include 'includes/application_top.php';


function getCartData() {
    global $db;
    $runningTotal = 0.0;

    $_SESSION['cart']->calculate();
    
    $cart_items = $_SESSION['cart']->get_products();

    // prePrintPre($cart_items);

    $numberOfCartItems = $_SESSION['cart']->count_contents();
    $cartList = "";
    $cartData = array();
    $coreData = array();
    foreach($cart_items as $item) {
        $itemId = $item['id'];
        $url = "?main_page=product_info&products_id=$itemId";
        $attributes = $item['attributes'] ?: "";
        $attributesValues = array();

        $corePriceTotal = 0.0;
        $productPriceTotal = 0.0;


        $isExchange = false;
        $coreData = array();
        $productQuery = "
            SELECT p.products_id, zp.products_alt_name, p.is_exchange, p.is_core, p.products_image, m.manufacturers_name
            FROM zen_products p
            LEFT JOIN zen_products_description zp ON zp.products_id = p.products_id
            LEFT JOIN zen_manufacturers m ON m.manufacturers_id = p.manufacturers_id
            WHERE p.products_id = '$itemId'
        ";
        $product = $db->Execute($productQuery);
        $manufacturerName = $product->fields['manufacturers_name'];
        $itemCoreId = $product->fields['products_id']; 
        $isExchange = $product->fields['is_exchange'];
        $isCore = $product->fields['is_core'];
        $imgPath = $item['image'];
        if($isCore) {
            continue;
        }
        if($isExchange) {
            $productQuery = "
                SELECT x.products_id, p.products_image
                FROM zen_products_xsell x
                LEFT JOIN zen_products p on x.products_id = p.products_id
                WHERE xsell_id = $itemId 
            ";
            $queryResults = $db->Execute($productQuery);
            $queryProductId = $queryResults->fields['products_id'];
            $imgPath = $queryResults->fields['products_image'];
            $url = "?main_page=product_info&products_id=$queryProductId";
            $coreQuery = "
                SELECT xsell_id 
                FROM zen_products_xsell 
                WHERE products_id = $queryProductId AND xsell_id != $itemId
            ";
            $queryResults = $db->Execute($coreQuery);
            $xsellId = $queryResults->fields['xsell_id'];
            $coreProductInfoQuery = "
                SELECT zm.manufacturers_name, p.products_id, p.products_image, 
                p.products_price, p.products_model, zp.products_alt_name, 
                zp.products_name, zp.products_alt_name, p.is_exchange, p.is_core 
                FROM zen_products p
                LEFT JOIN zen_products_description zp ON zp.products_id = p.products_id
                LEFT JOIN zen_manufacturers zm ON zm.manufacturers_id = p.manufacturers_id
                WHERE p.products_id = '$xsellId'
            ";
            $queryResults = $db->Execute($coreProductInfoQuery);

            $coreData = array(
                "corePrice" => $queryResults->fields['products_price'],
                "coreId" => $queryResults->fields['products_id'],
                "coreAltName" => $queryResults->fields['products_alt_name'],
                "coreName" => $queryResults->fields['products_name'],
                "coreModel"=> $queryResults->fields['products_model'],
                "coreManufacturersName" => $queryResults->fields['manufacturers_name'],
            );

            $corePriceTotal += $coreData['corePrice'] * $item['quantity'];

        }
        
        if(is_array($attributes)) {
            foreach($attributes as $optionsId => $optionsValueId) {
                $optionalIndex = $optionsId;
                if (strpos($optionsId, "chk") !== false) {
                    $optionalIndex = substr($optionsId, (strpos($optionsId, "chk") + 3));
                    $optionsId = strtok($optionsId, "_");
                }
                $typeQuery = "
                    SELECT products_options_type
                    FROM zen_products_options
                    WHERE products_options_id = $optionsId
                ";
                $typeResult = $db->Execute($typeQuery);
                if($typeResult->fields['products_options_type'] == 1) {
                    $optionInfoQuery = "
                        SELECT products_options_name
                        FROM `zen_products_options`
                        WHERE `products_options_id` = $optionsId
                    ";
                    $optionsInfo = $db->Execute($optionInfoQuery);
                    $attributesValues[$optionalIndex] = array(
                        "name" => $optionsInfo->fields['products_options_name'],
                        "optionsId" => $optionsId,
                        "optionsValueId" => null,
                        "optionsValueText" => $optionsValueId,
                        "optionsValuePrice" => 0.00,
                    );
                    continue;
                }
                $optionInfoQuery = "
                    SELECT pa.options_values_price, pa.price_prefix, poa.products_options_values_name, po.products_options_name
                    FROM `zen_products_attributes` pa
                    LEFT JOIN `zen_products_options_values` poa ON poa.products_options_values_id = pa.options_values_id
                    LEFT JOIN `zen_products_options` po ON po.products_options_id = pa.options_id
                    WHERE `products_id` = '$itemId' AND `options_id` = $optionsId AND `options_values_id` = $optionsValueId
                ";
                $optionsInfo = $db->Execute($optionInfoQuery);
                
                $attributesValues[$optionalIndex] = array(
                    "name" => $optionsInfo->fields['products_options_name'],
                    "optionsId" => $optionsId,
                    "optionsValueId" => $optionsValueId,
                    "optionsValueText" => $optionsInfo->fields['products_options_values_name'],
                    "optionsValuePrice" => ($optionsInfo->fields['price_prefix'] == "+")? $optionsInfo->fields['options_values_price'] : -1 * $optionsInfo->fields['options_values_price'],
                );
            }
        }
        // update price
        $productPriceTotal += $item['price'] * $item['quantity'];
        $productTotalPrice = $productPriceTotal + $corePriceTotal;
        $runningTotal += $productTotalPrice;
        
        $cartData[$itemId] = array(
            "id" => $itemId,
            "mainId" => $itemCoreId,
            "qty" => $item['quantity'],
            "urlLink" => $url,
            "manufacturers_name"=> $manufacturerName,
            "products_image" => $imgPath,
            "products_price" => $item['price'],
            "products_model" => $item['model'],
            "products_alt_name" => $product->fields['products_alt_name'],
            "products_name" => $item['name'],
            "attributes" => $attributes,
            "attributesValues" => $attributesValues,
            "hasCore" => $isExchange,
            "coreData" => $coreData,
            "productTotalPrice" => number_format($productTotalPrice, 2)
        );
    }

    $runningTotal = number_format($runningTotal, 2);

    return array( 
        "code" => 1,
        "total" => $runningTotal,
        "itemCount" => $numberOfCartItems,
        "itemData" => $cartData,
        "cartLink" => zen_href_link('cart', '', 'SSL'),
        "isLoggedIn" => $logged_in = ((isset($_SESSION['customer_id'])) && (zen_is_logged_in()))
    );
}

function removeFromCart($productId) {
    global $_SESSION;
    global $db;
    $_SESSION['cart']->remove($productId);
        
    $query_core = "SELECT px.xsell_id AS cid
        FROM zen_products_xsell px JOIN zen_products p ON px.xsell_id = p.products_id
        WHERE px.products_id =
        (
            SELECT px.products_id
            FROM zen_products_xsell px
            JOIN zen_products p ON px.xsell_id = p.products_id
            WHERE px.xsell_id = $productId AND p.is_exchange = 1
        )
            AND px.xsell_id <> $productId
            AND p.is_core = 1;";

    $query_core_result = $db->Execute($query_core);

    if (!empty($query_core_result->fields['cid']))
    {
        $_SESSION['cart']->remove($query_core_result->fields['cid']);
    }
}

switch ($_POST['cart-action'])
{
    case 'add':
        $status = "Adding products to cart...";

        foreach ($_POST['products'] as $product => $qty)
        {
            $query_core = "SELECT px.xsell_id AS cid
            FROM zen_products_xsell px JOIN zen_products p ON px.xsell_id = p.products_id
            WHERE px.products_id =
            (
                SELECT px.products_id
                FROM zen_products_xsell px
                JOIN zen_products p ON px.xsell_id = p.products_id
                WHERE px.xsell_id = $product AND p.is_exchange = 1
            )
                AND px.xsell_id <> $product
                AND p.is_core = 1;";

            $query_core_result = $db->Execute($query_core);

            if (empty($query_core_result->fields['cid']))
            {
                $status .= "adding $qty of $product...";
                $_SESSION['cart']->add_cart($product, $qty);
                $status .= "added...";
            }
            else
            {
                $status .= "adding $qty of $product...";
                $_SESSION['cart']->add_cart($product, $qty);
                $status .= "added...";
                $status .= "adding $qty of {$query_core_result->fields['cid']}...";
                $_SESSION['cart']->add_cart($query_core_result->fields['cid'], $qty);
                $status .= "added...";
            }
        }
        echo json_encode(array($status));
        break;
    case 'add-configurable':

        $_SESSION['cart']->add_cart($_POST['post-data']['productId'], $_POST['post-data']['quantity'], $_POST['post-data']['attributes']);

        $status = array(
            $_SESSION['cart']
        );
        echo json_encode($status);
        break;
    case 'update':
        $productId = $_POST['product_id'];
        $newQty = $_POST['new_quantity'];
        if($newQty == 0) {
            removeFromCart($productId);
            break;
        }
        $productAttributes = $_SESSION['cart']->contents[$productId]['attributes'] ?: array();  


        $_SESSION['cart']->update_quantity($productId, $newQty, $productAttributes);
        $query_for_exchange = $db->Execute("SELECT p.is_exchange, x.products_id FROM zen_products p LEFT JOIN zen_products_xsell x ON x.xsell_id = " . $productId . " WHERE p.products_id = " . $productId);
        if ($query_for_exchange->fields['is_exchange'] == 1)
        {
            $query_for_core = $db->Execute("SELECT xsell_id FROM zen_products_xsell WHERE products_id = " . $query_for_exchange->fields['products_id'] . " AND xsell_id <> " . $productId);
            $coreId = $query_for_core->fields['xsell_id'];
            $_SESSION['cart']->update_quantity($coreId, $newQty);
        }
        break;
    case 'remove':
        $productId = $_POST['product_id'];
        $_SESSION['cart']->remove($productId);
        
        $query_core = "SELECT px.xsell_id AS cid
            FROM zen_products_xsell px JOIN zen_products p ON px.xsell_id = p.products_id
            WHERE px.products_id =
            (
                SELECT px.products_id
                FROM zen_products_xsell px
                JOIN zen_products p ON px.xsell_id = p.products_id
                WHERE px.xsell_id = $productId AND p.is_exchange = 1
            )
                AND px.xsell_id <> $productId
                AND p.is_core = 1;";

        $query_core_result = $db->Execute($query_core);

        if (!empty($query_core_result->fields['cid']))
        {
            $_SESSION['cart']->remove($query_core_result->fields['cid']);
        }
        break;
    case 'display':

        $cartLink = zen_href_link('cart', '', 'SSL');
        $cartCountDisplay = "";
        $cartCount = $_SESSION['cart']->count_contents();
        if ($cartCount != 0)
        {
            $cartCountDisplay = "
            <p id='navbar-cart-number'>$cartCount</p>";
        }

        $cartDisplay = "
            <a 
                class='text-black'
                href='$cartLink'
                id='navbar-cart-group'
                aria-label='Cart page naviagtion link'
            >
                <i class='fa-solid fa-cart-shopping fa-xl navbar-cart'></i>
                $cartCountDisplay
            </a>
            <div id='checkout-popup' class='container-fluid checkout-popup'></div>
        ";

        echo json_encode(array(
            'code' => 1,
            'content' => $cartDisplay
        ));
        break;
    default:
        try {
            $data = getCartData();
            echo json_encode($data);
        } catch(Exception $e) {
            $result = array(
                "code" => 1,
                "message" => "An unknown error occured"
            );
            echo json_encode($result);
            
        }
        
}

$_SESSION['cart']->calculate();

function addToCart_efficient() {
    if (zen_is_logged_in())
    {
        global $db;

        $productsToAdd = array();
        $productsCount = sizeof($_POST['products']);
        $productsIndex = 0;

        foreach ($_POST['products'] as $product_id => $qty)
        {
            $productsToAdd[] = "({$_SESSION['customer_id']}, '{$product_id}', {$qty})";
        }

        $productsToAddQuery = "INSERT INTO `zen_customers_basket` (`customers_id`, `products_id`, `customers_basket_quantity`) VALUES " . implode(", ", $productsToAdd);

        $db->Execute($productsToAddQuery);
    }

    return $_POST;
}

