<?php

include 'includes/application_top.php';

$safePost = filter_input_array(INPUT_POST, [
    'email' => FILTER_SANITIZE_EMAIL,
]);
$isSubscribing = $_POST['isSubscribing'];
$isUnSubscribing = $_POST['isUnSubscribing'];

function unsubscribe($email) {
    global $safePost;
    $results = array(
        "result_code" => 0,
        "message" => "The email you provided was invalid. If you believe this to be an error, please contact us.",
    );
    if (!filter_var($safePost['email'], FILTER_SANITIZE_EMAIL))
    {
        $results['message'] = "The email you provided was invalid. If you believe this to be an error, please contact us.";
    }
    // Connect To the Database
    $db = mysqli_connect(DB_SERVER, DB_SERVER_USERNAME, DB_SERVER_PASSWORD, DB_DATABASE);
    // Try all Database Operations
    try {
        // Set reporting for MySQL Errors - UNCOMMENT THE NEXT LINE -
        // mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
        // Prepare Statement SQL Statement
        // INSERT INTO `zen_email_subscriptions` (subscription_email) VALUES (?)
        $queryStatement = $db->prepare("DELETE FROM `zen_email_subscriptions` WHERE subscription_email='{$email}'");
        // Bind ? With Email Value
        $queryStatement->bind_param("s", $email);
        // Execute SQL Statement
        $queryStatement->execute();
        // Close SQL Statement
        $queryStatement->close();
        // Close DB Connection
        $db->close();
        // Now update customers table
        $queryStatement = $db->prepare("UPDATE `zen_customers` SET customers_newsletter = 0 WHERE customers_email_address = ?");
        // Bind
        $queryStatement->bind_param('s', $email);
        // Execute
        $queryStatement->execute();
        // Close
        $queryStatement->close();
        // Set result code to 1
        $results['result_code'] = 1;
        // Set resul message to happy message
        $results['message'] = "Email has been unsubscribed :'(";
    } catch (Exception $e) { // Oops!!! an error occured
        // Set default Unhappy Message
        $results['message'] = $e->getMessage();
        // Close Query Statement
        $queryStatement->close();
        // Close Database Connection
        $db->close();
    }
    // Return Results
    return $results;
}

function subscribeEmail($email) {
    global $safePost;
    // Create regex for email
    $emailRegex = '/^([a-z0-9_\.-]+)@([\da-z\.-]+)\.([a-z\.]{2,6})$/';
    $results = array(
        "result_code" => 0,
        "message" => "The email you provided was invalid. If you believe this to be an error, please contact us.",
    );
    // Connect To the Database
    $db = mysqli_connect(DB_SERVER, DB_SERVER_USERNAME, DB_SERVER_PASSWORD, DB_DATABASE);
    // Try all Database Operations
    try {
        // Check for invalid email
        if (!preg_match($emailRegex, $safePost['email']))
        {
            // Throw exception saying that the email is invalid
            throw new Exception("The email you provided ($email) was invalid. If you believe this to be an error, please contact us.");
        }
        // Set reporting for MySQL Errors - UNCOMMENT THE NEXT LINE -
        // mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
        // Prepare Statement SQL Statement
        // INSERT INTO `zen_email_subscriptions` (subscription_email) VALUES (?)
        $queryStatement = $db->prepare("INSERT IGNORE INTO `zen_email_subscriptions` (subscription_email) VALUES (?)");
        // Bind ? With Email Value
        $queryStatement->bind_param("s", $email);
        // Execute SQL Statement
        $queryStatement->execute();
        // Close SQL Statement
        $queryStatement->close();
        // Now update customers table
        $queryStatement = $db->prepare("UPDATE `zen_customers` SET customers_newsletter = 1 WHERE customers_email_address = ?");
        // Bind
        $queryStatement->bind_param('s', $email);
        // Execute
        $queryStatement->execute();
        // Close
        $queryStatement->close();
        // Close DB Connection
        $db->close();
        // Set result code to 1
        $results['result_code'] = 1;
        // Set resul message to happy message
        $results['message'] = "Email has been subscribed!";
    } catch (Exception $e) { // Oops!!! an error occured
        // Get Error Code
        $errorCode = $e->getCode();
        // Check if error code is 1062 - Duplicate Entry
        if($errorCode == 1062) {
            // Set Unhappy Message
            $results['message'] = "Email is already subscribed!";
        } else {
            // Set default Unhappy Message
            $results['message'] = $e->getMessage();
        }
        if($queryStatement) {
            // Close Query Statement
            $queryStatement->close();

        }
        if($db) {
            $db->close();
        }
        // Close Database Connection
        
    }
    // Return Results
    return $results;
}


$emailSubscriptionResults = subscribeEmail($safePost['email']);
echo json_encode($emailSubscriptionResults);