<?php

include 'includes/application_top.php';

$postAction = "";
if (isset($_POST['post-action']))
{
    $postAction = $_POST['post-action'];
}
$postData = "";
if (isset($_POST['post-data']))
{
    $postData = $_POST['post-data'];
}
if ($postAction == "add-exemption")
{
    $postData = json_decode($_POST['post-data'], true);
}

$status = array(
    "code" => 0,
    "message" => "No post action implemented for " . $postAction,
);

switch ($postAction)
{
    case 'get-exemptions':
        $currentExemptions = avatax_get_certificates_by_customer($_SESSION['customer_id']);
        $status = array(
            "code" => 1,
            "data" => $currentExemptions
        );
        break;
    case 'add-exemption':

        /**
         * Error Codes:
         * 1: Data submitted was invalid, didn't attempt any logic (not implemented)
         * 2: Address was not qualifiable by Avalara
         * 3: Successfully created exemption
         */

        $fileUploaded = false;

        try
        {
            if (is_array($_FILES['file']['error']))
            {
                throw new Exception('Invalid or missing file (' . $_FILES['file']['error'] . ')');
            }

            switch ($_FILES['file']['error'])
            {
                case UPLOAD_ERR_OK:
                    break;
                case UPLOAD_ERR_NO_FILE:
                    throw new Exception("No file uploaded.");
                case UPLOAD_ERR_INI_SIZE:
                case UPLOAD_ERR_FORM_SIZE:
                    throw new Exception("File exceeded server limits.");
                default:
                    throw new Exception("Unknown error occurred. Try again. (" . $_FILES['file']['error'] . ")");
            }

            $accept_types = array(
                "pdf",
                "application/pdf"
            );
        
            $conv_types = array(
                "application/pdf" => "pdf"
            );
        
            $finfo = finfo_open(FILEINFO_MIME_TYPE);
            $ext = finfo_file($finfo, $_FILES['file']['tmp_name']);
        
            foreach ($conv_types as $k => $v)
            {
                if ($ext == $k) $ext = $v;
            }
        
            if (!in_array($ext, $accept_types))
            {
                throw new Exception("Invalid file format. Expected extensions: (" . implode(",", $accept_types) . ') Found extension(s):(' . $ext . ')');
            }

            $fileUploaded = sha1_file($_FILES['file']['tmp_name']) . date("Y-m-d H:i:s") . '.' . $ext;

            if (!move_uploaded_file($_FILES['file']['tmp_name'], sprintf(__DIR__ . '/includes/modules/avatax/certs/%s', $fileUploaded)))
            {
                $warning = error_get_last()['message'];
                throw new Exception("Failed to move uploaded file. ($warning)");
            }
            else
            {
                $fileUploaded = 'includes/modules/avatax/certs/' . $fileUploaded;
            }
        }
        catch (Exception $e)
        {
            $status = array(
                "code" => 1,
                "message" => $e->getMessage()
            );
            break;
        }

        $customerId = $_SESSION['customer_id'];
        $companyName = $postData['exCompanyName'];
        $firstName = $postData['exFirstName'];
        $lastName = $postData['exLastName'];
        $streetAddressOne = $postData['exAddr1'];
        $streetAddressTwo = $postData['exAddr2'];
        $city = $postData['exCity'];
        $state = $postData['exState'];
        $zip = $postData['exZip'];

        $validate_address = array(
            "line1" => $streetAddressOne,
            "line2" => $streetAddressTwo,
            "textCase" => "Mixed",
            "city" => $city,
            "region" => $state,
            "country" => "US",
            "postalCode" => $zip
        );

        $ava_addressQualification = avatax_verify_address($validate_address);

        if ($ava_addressQualification['validatedAddresses'][0]['addressType'] == "UnknownAddressType")
        {
            $status = array(
                "code" => 2,
                "message" => "Address could not be validated. Please try again."
            );
            break;
        }

        $ava_qualifiedAddress = $ava_addressQualification['validatedAddresses'][0];

        $ava_customerDetailsWeb = array(
            "customers_id" => $_SESSION['customer_id'],
            "customers_firstname" => $_SESSION['customer_first_name'],
            "customers_lastname" => $_SESSION['customer_last_name'],
            "customers_telephone" => "000-000-0000",
            "customers_email_address" => $_SESSION['customers_email_address']
        );

        $ava_addressDetails = array(
            "line1" => $ava_qualifiedAddress['line1'],
            "city" => $ava_qualifiedAddress['city'],
            "postalCode" => $ava_qualifiedAddress['postalCode'],
            "country" => "US",
            "region" => $ava_qualifiedAddress['region']
        );

        $exposureZones = explode(",", $postData['exSelectedStates']);
        $ava_zones = array();
        foreach ($exposureZones as $zone)
        {
            array_push($ava_zones, array("name" => $zone));
        }
        $ava_profileWeb = avatax_create_customer($ava_customerDetailsWeb, $ava_addressDetails, $ava_zones);

        $expire = ($postData['exNoExp'])? '9999-12-31' : $postData['exDateExpire'];

        $ava_exemptionDetailsWeb = array(
            "signedDate" => $postData['exDateSigned'],
            "expDate" => $expire,
            "filename" => $fileUploaded,
            "taxNumber" => $postData['exNumber'],
            "taxType" => $postData['exType'],
            "exemptionReason" => $postData['exReason'],
            "customers" => avatax_get_customer($_SESSION['customer_id']),
            "customerExposureZone" => $postData['exState'],
            "zones" => $ava_zones
        );
        $ava_createExemptionWeb = avatax_create_certificate($ava_exemptionDetailsWeb, $ava_zones);

        //create Quickbooks certificate copy

        $ava_customerDetailsQB = array(
            "customers_id" => "{$_SESSION['customer_first_name']} {$_SESSION['customer_last_name']}",
            "customers_firstname" => $postData['exFirstName'],
            "customers_lastname" => $postData['exLastName'],
            "customers_telephone" => "000-000-0000",
            "customers_email_address" => $_SESSION['customers_email_address']
        );
        $ava_profile = avatax_create_customer($ava_customerDetailsQB, $ava_addressDetails, $ava_zones);
        $ava_exemptionDetailsQB = array(
            "signedDate" => $postData['exDateSigned'],
            "expDate" => $expire,
            "filename" => $fileUploaded,
            "taxNumber" => $postData['exNumber'],
            "taxType" => $postData['exType'],
            "exemptionReason" => $postData['exReason'],
            "customers" => avatax_get_customer("{$_SESSION['customer_first_name']} {$_SESSION['customer_last_name']}"),
            "customerExposureZone" => $postData['exState'],
            "zones" => $ava_zones
        );
        $ava_createExemptionQB = avatax_create_certificate($ava_exemptionDetailsQB, $ava_zones);

        $status = array(
            "exemptionDetailsSubmittedWeb" => $ava_exemptionDetailsWeb,
            "exemptionDetailsSubmittedQB" => $ava_exemptionDetailsQB,
            "zones" => $ava_zones,
            "exemptionResultsReceivedWeb" => $ava_createExemptionWeb,
            "exemptionResultsReceivedQB" => $ava_createExemptionQB,
            "code" => 3,
            "message" => "Certificate was created successfully. When shipping to a state in the Selected States field above, your exemption should apply automatically. New exemptions are reviewed after an order is placed, and we'll contact you when processing your order if we require additional information.",
            "POST" => $postData
        );

        break;
    case 'edit-exemption':
        break;
    case 'delete-exemption':

        $unlink = avatax_unlink_customers_from_certificate($_SESSION['customer_id'], $postData['id']);
        $delete = avatax_delete_certificate($postData['id']);

        $status = array(
            "code" => 1,
            "unlink" => $unlink,
            "delete" => $delete
        );

        break;
}

echo json_encode($status);