<?php

include 'includes/application_top.php';

$mode = htmlspecialchars($_POST['mode']);

$status = array(
    "code" => 0,
    "message" => "There was an error trying to reset your password. Please try again or contact us for assistance."
);

switch ($mode)
{
    case 'forgot':

        $email = filter_input(INPUT_POST, "email", FILTER_SANITIZE_EMAIL);

        if (!filter_var($email, FILTER_VALIDATE_EMAIL))
        {
            $status = array(
                "code" => 0,
                "message" => "The email you provided appears to be invalid. Please try again."
            );
            break;
        }

        $customer_query_from_email = $db->Execute("SELECT customers_id, customers_firstname, customers_lastname FROM zen_customers WHERE customers_email_address = '$email' ORDER BY customers_id DESC LIMIT 1");

        // if ($customer_query_from_email->RecordCount() !== 1)
        // {
        //     $status = array(
        //         "code" => 0,
        //         "message" => "There was an error trying to locate your account. Please try again or contact us for assistance."
        //     );
        //     break;
        // }

        $resetToken = md5($email . date('Ymd'));

        $content = array(
            "CHARSET" => "UTF-8",
            "BASE_HREF" => "https://westechequipment.com",
            "EMAIL_COMMON_CSS" => "FGC:./email_common.css",
            "EMAIL_LOGO_FILE" => "/images/westech-logo.png",
            "EMAIL_LOGO_ALT_TEXT" => "westechequipment logo",
            "EMAIL_LOGO_WIDTH" => "150px",
            "EXTRA_HEADER_INFO" => "",
            "EMAIL_SUBJECT" => "Reset Your Password",
            "EMAIL_CUSTOMERS_NAME" => "Dear customer,",
            "EMAIL_MESSAGE_HTML" => "We received a request to reset the password of an account belonging to $email. You can <a href='?main_page=forgot_password&token=$resetToken'>click here</a> to reset your password now. If you didn't request this service, you can simply ignore this email.",
            "EMAIL_DISCLAIMER" => "By requesting this email you agreed to receive this communication. This will not sign you up for future emails or newsletters. You can view our <a href='?main_page=terms_and_conditions'>terms and conditions here</a>.",
            "EMAIL_SPAM_DISCLAIMER" => "We comply with the CAN-SPAM Act. You can unsubscribe from future emails <a href='?main_page=unsubscribe&token=$email'>here</a>.",
            "EXTRA_INFO" => "",
        );

        $cID = $customer_query_from_email->fields['customers_id'];

        $update_customer_secret = $db->Execute("UPDATE zen_customers SET customers_secret = '$resetToken' WHERE customers_id = '$cID'");
    
        zen_mail($customer_query_from_email->fields['customers_firstname'] . ' ' . $customer_query_from_email->fields['customers_lastname'], $email, "Reset Your Password", "Reset Your Password", "Westech Equipment", "contact@westechequipment.com", $content, "password_forgotten");
    
        $status = array(
            "code" => 1,
            "message" => "Email sent."
        );

        break;
    case 'reset':

        $token = htmlspecialchars($_POST['token']);
        $email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);

        if (!filter_var($email, FILTER_VALIDATE_EMAIL))
        {
            $status = array(
                "code" => 0,
                "message" => "The email you provided appears to be invalid. Please try again."
            );
            break;
        }

        $new_password = password_hash($_POST['password'], PASSWORD_DEFAULT);

        $cID_query = $db->Execute("SELECT customers_id FROM zen_customers WHERE customers_email_address = '$email' ORDER BY customers_id DESC LIMIT 1");
        $cID_result = $cID_query->fields['customers_id'];

        $update_account = $db->Execute("UPDATE zen_customers SET customers_password = '$new_password', customers_secret = '' WHERE customers_id = '$cID_result'");

        $content = array(
            "CHARSET" => "UTF-8",
            "BASE_HREF" => "https://westechequipment.com",
            "EMAIL_COMMON_CSS" => "FGC:./email_common.css",
            "EMAIL_LOGO_FILE" => "/images/westech-logo.png",
            "EMAIL_LOGO_ALT_TEXT" => "westechequipment logo",
            "EMAIL_LOGO_WIDTH" => "150px",
            "EXTRA_HEADER_INFO" => "",
            "EMAIL_SUBJECT" => "Your Password Was Reset",
            "EMAIL_CUSTOMERS_NAME" => "Dear customer,",
            "EMAIL_MESSAGE_HTML" => "Your password has been reset. If this was you, great! If this wasn't, please contact us immediately to secure your account.",
            "EMAIL_DISCLAIMER" => "This email was given to us by you or someone you know, and contains important security information regarding your account.",
            "EMAIL_SPAM_DISCLAIMER" => "We comply with the CAN-SPAM Act. You can unsubscribe from future emails <a href='?main_page=unsubscribe&token=$email'>here</a>.",
            "EXTRA_INFO" => "",
        );

        zen_mail($customer_query_from_email->fields['customers_firstname'] . ' ' . $customer_query_from_email->fields['customers_lastname'], $email, "Your Password Was Reset", "Your Password Was Reset", "Westech Equipment", "contact@westechequipment.com", $content, "password_forgotten");

        $status = array(
            "code" => 1,
            "message" => "Password reset successfully."
        );

        break;
}

echo json_encode($status);