<?php

include 'includes/application_top.php';

$postAction = "";
if (isset($_POST['post-action'])) {
    $postAction = $_POST['post-action'];
}

$status = array(
    "code" => 0,
    "message" => "No post action implemented for " . $postAction,
);

$_SESSION['cart']->calculate();
$cartContents = $_SESSION['cart']->contents;
$cartTotal = $_SESSION['cart']->total;
$shippingTotal = 0.00;
$lowOrderThreshold = 50.00;
$lowOrderFee = 20.00;
$lofTotal = ($cartTotal < $lowOrderThreshold)? $lowOrderFee : 0.00;
$taxesTotal = 0.00;

$coupon_code = "";
$shippingTotal = $_SESSION['shipping']['values']['total'] ?? 0.00;
$taxesTotal = $_SESSION['taxes']['values']['total'] ?? 0.00;

switch ($postAction) {
    case "renderCart":

        unset($_SESSION['shipping']);
        unset($_SESSION['taxes']);
        $cartItems = "";
        $total = 0.00;
        $total += $cartTotal;
        $coupon_code = $_SESSION['coupon']['code'] ?? '';
        $couponAmount = $_SESSION['coupon']['amount'] ?? 0.00;
        $couponAmountDisplay = "$0.00";
        if ($couponAmount > 0.00) {
            $coupon_type = $_SESSION['coupon']['type'];
            switch ($coupon_type) {
                case 'P':
                    $couponAmountDisplay = '-'. ($couponAmount * 100 ). '%';
                    $couponAmount = $couponAmount * $total;
                    break;
                case 'F':
                    $couponAmountDisplay = '- $' . number_format($couponAmount, 2);
                    break;
                default:
                $couponAmount = 0;
                $couponAmountDisplay = '';
                    break;
            }
        }
        $couponCodeValue = empty($coupon_code)? '' : " value='$coupon_code'";
        $couponButton = "";
        $couponDisplay = "";
        if (isset($_SESSION['coupon']['code'])) {
            $couponButton = "<button type='button' class='btn btn-danger text-white mx-1' id='coupon-code-remove'>Remove</button>";
            $couponDisplay = "
            <div class='d-flex align-items-center pb-2 cart-collapsible'>
                <p class='fw-bold mb-0'>Coupon:</p>
                <p class='ms-auto mb-0' id='coupon-amount'>
                    $couponAmountDisplay
                </p>
            </div>
            ";
        } else {
            $couponButton = "<button type='button' class='btn bg-darker-gray text-white mx-1' id='coupon-code-apply'>Apply</button>";
            $couponDisplay = "";
        }
        
        $cartTotal = number_format($cartTotal, 2);

        foreach($cartContents as $id => $content) {
            $productQuery = "
                SELECT zm.manufacturers_name, p.products_id, p.products_image, p.products_price, p.products_model, zp.products_alt_name, zp.products_name, zp.products_alt_name  
                FROM zen_products p
                LEFT JOIN zen_products_description zp ON zp.products_id = p.products_id
                LEFT JOIN zen_manufacturers zm ON zm.manufacturers_id = p.manufacturers_id
                WHERE p.products_id = '$id'
            ";
            $product = $db->Execute($productQuery);
            $qty = $content['qty'];
            $manufacturerName = $product->fields['manufacturers_name'];

            if (strpos($manufacturerName, "manfStock") !== FALSE) {
                $manufacturerName = substr($manufacturerName, 23, -6);
            }

            $image = $product->fields['products_image'];
            $price = $product->fields['products_price'];
            $model = $product->fields['products_model'];
            $altName = $product->fields['products_alt_name'];
            $name = $product->fields['products_name'] ?: $altName;
            $product_total = "$" . number_format($qty * $price, 2);
            $cartItemText = "
            
        <div class='col-13'>
            <div class='row cart-popup-product-display'>
                <div class='col-3'>
                        <img src='images/$image' alt='$altName' class='imgSize' class='img-fluid' />
                </div>
                <div class='col-9'>
                        <span class='brand-text-color' class='cart-page-item-brand'>$manufacturerName </span>
                        <span class='model-text-color' class='cart-page-item-model'>$model </span> 
                        <span class='cart-page-item-name'>$name </span>
                    <div class='sizing'>
                        <span class='cart-page-item-quantity'>Qty: $qty</span>
                        <span class='cart-page-item-product_total'>$product_total</span>
                </div>
                </div> 
            </div>
        </div>
        <hr />
            ";
            $cartItems .= $cartItemText;
        }

        $lowOrder = "";
        if ($lofTotal > 0.00) {
            $lowOrder = "
                <div class='d-flex align-items-center cart-collapsible'>
                    <p class='fw-bold mb-3'>Low Order Fee:</p>
                    <p class='ms-auto mb-3' id='LOF-cost'>
                        $20.00
                    </p>
                </div>
            ";
        }

        $subTotalsSection = "
            <div class='d-flex align-items-center pt-3 cart-collapsible'>
                <p class='fw-bold mb-0'>Subtotal:</p>
                <p class='ms-auto mb-0' id='subtotal-cost'>
                    $$cartTotal
                </p>
            </div>
            <div class='d-flex align-items-center cart-collapsible'>
                <p class='fw-bold mb-0'>Shipping:<span id='shipping-method'></span></p>
                <p class='ms-auto mb-0' id='shipping-cost'>
                    TBD
                </p>
            </div>
            <div class='d-flex align-items-center pb-3 cart-collapsible'>
                <p class='fw-bold mb-0'>Taxes:</p>
                <p class='ms-auto mb-0' id='taxes-cost'>
                    TBD
                </p>
            </div>
            $lowOrder
            <div class='d-flex align-items-center cart-collapsible'>
                <div class='form-floating-label-container coupon-input-container'>
                    <input type='text' id='coupon-code-input' class='form-control' placeholder='Coupon Code'$couponCodeValue>
                </div>
                $couponButton
            </div>
            $couponDisplay
        ";

        $total -= $couponAmount;
        $total += $lofTotal;
        $total += $shippingTotal;
        $total += $taxesTotal;

        $total = number_format($total, 2);

        $cartBox = "
            <div id='summary-details'>
                <div class='summary-caret-container'>
                    <button type='button' class='btn w-100' id='summary-container-button'>
                        &#9660;
                    </button>
                    <div class='d-flex align-items-center  pb-3 checkout-collapsed-total d-none'>
                        <p class='fw-bold mb-0 cart-collapsible'>Total:</p>
                        <p class='ms-auto mb-0 cart-collapsible' id='total-cost'>
                            $$total
                        </p>
                    </div>
                </div>
                <div class='summary-container pt-3 ps-2 pe-2' id='summary-details-container'>
                    <h5 class='mb-1'>Order Summary</h5>
                    $cartItems
                </div>
            </div>
            <div id='summary-line-items' class='ps-2 pe-2'>
                $subTotalsSection

                <div class='d-flex align-items-center pt-3 pb-3'>
                    <p class='fw-bold mb-0 cart-collapsible'>Total:</p>
                    <p class='ms-auto mb-0 cart-collapsible' id='total-cost'>
                        $$total
                    </p>
                </div>
            </div>
        ";

        $status = array(
            "code" => 1,
            "content" => $cartBox,
            "cart" => $_SESSION['cart']->get_products()
        );

        break;
    case "updateCart":

        $total = 0.00;
        $total += $cartTotal;

        $couponCode = $_SESSION['coupon']['code'] ?? FALSE;
        $couponAmount = $_SESSION['coupon']['amount'] ?? 0.00; 
        $couponAmountDisplay = "$0.00";
        if ($couponAmount > 0.00) {
            $coupon_type = $_SESSION['coupon']['type'];
            switch ($coupon_type) {
                case 'P':
                    $couponAmountDisplay = '-'. ($couponAmount * 100 ). '%';
                    $couponAmount = $couponAmount * $total;
                    break;
                    
                case 'F':
                    $couponAmountDisplay = '- $' . number_format($couponAmount, 2);
                    break;
                    
                default:
                    $couponAmount = 0;
                    $couponAmountDisplay = '';
                    break;
            }
        }

        $couponButton = "";
        $couponDisplay = "";
        if ($couponCode !== FALSE) {
            $couponButton = "<button type='button' class='btn btn-danger text-white mx-1' id='coupon-code-remove'>Remove</button>";
            $couponDisplay = "
            <div class='d-flex align-items-center pb-2 cart-collapsible'>
                <p class='fw-bold mb-0'>Coupon:</p>
                <p class='ms-auto mb-0' id='coupon-amount'>
                    $couponAmountDisplay
                </p>
            </div>
            ";
        } else {
            $couponButton = "<button type='button' class='btn bg-darker-gray text-white mx-1' id='coupon-code-apply'>Apply</button>";
            $couponDisplay = "";
        }

        $total -= $couponAmount;
        $total += $shippingTotal;
        $total += $lofTotal;
        $total += $taxesTotal;

        $_SESSION['cart_calculated'] = array(
            "subtotal" => $cartTotal,
            "shipping" => $shippingTotal,
            "low-order" => $lofTotal,
            "coupon" => $couponAmount,
            "taxes" => $taxesTotal,
            "total" => $total
        );
        
        $cartTotal = number_format($cartTotal, 2) . '';
        $cartTotal = "$$cartTotal";
        $shippingTotal = number_format($shippingTotal, 2) . '';
        if (isset($_SESSION['shipping']['values']['method'])) {
            $shippingTotal = " ({$_SESSION['shipping']['values']['method']}) $$shippingTotal";
        } else {
            $shippingTotal = "$$shippingTotal";
        }
        $taxesTotal = number_format($taxesTotal, 2) . '';
        $taxesTotal = "$$taxesTotal";
        $couponAmount = number_format($couponAmount, 2) . '';
        $couponAmount = "$$couponAmount";
        $couponCode = empty($coupon_code)? '' : " value='$coupon_code'";
        $total = number_format($total, 2) . '';
        $total = "$$total";

        $lowOrder = "";
        if ($lofTotal > 0.00) {
            $lowOrder = "
                <div class='d-flex align-items-center cart-collapsible'>
                    <p class='fw-bold mb-3'>Low Order Fee:</p>
                    <p class='ms-auto mb-3' id='LOF-cost'>
                        $$lowOrderFee
                    </p>
                </div>
            ";
        }

        $subTotalsSection = "
            <div class='d-flex align-items-center pt-3 cart-collapsible'>
                <p class='fw-bold mb-0'>Subtotal:</p>
                <p class='ms-auto mb-0' id='subtotal-cost'>
                    $cartTotal
                </p>
            </div>
            <div class='d-flex align-items-center cart-collapsible'>
                <p class='fw-bold mb-0'>Shipping:</p>
                <p class='ms-auto mb-0' id='shipping-cost'>
                    $shippingTotal
                </p>
            </div>
            <div class='d-flex align-items-center pb-3 cart-collapsible'>
                <p class='fw-bold mb-0'>Taxes:</p>
                <p class='ms-auto mb-0' id='taxes-cost'>
                    $taxesTotal
                </p>
            </div>
            $lowOrder
            <div class='d-flex align-items-center cart-collapsible'>
                <div class='form-floating-label-container coupon-input-container'>
                    <input type='text' id='coupon-code-input' class='form-control' placeholder='Coupon Code'$couponCode>
                </div>
                $couponButton
            </div>
            $couponDisplay
        ";

        $summaryLineItems = "
            $subTotalsSection
            <div class='d-flex align-items-center pt-3 pb-3'>
                <p class='fw-bold mb-0 cart-collapsible'>Total:</p>
                <p class='ms-auto mb-0 cart-collapsible' id='total-cost'>
                    $total
                </p>
            </div>
        ";

        $status = array(
            "code" => 1,
            "content" => $summaryLineItems,
            "total" => $total
        );

        break;
}

echo json_encode($status);