<?php

include 'includes/application_top.php';

$status = array(
    'code' => 0,
    'message' => 'API call failed.'
);

try {

    $productID = htmlspecialchars($_POST['productID']);
    if (!is_numeric($productID)) throw new Exception("Unknown product ID");
    $customerID = htmlspecialchars($_POST['customerID']);
    if (!is_numeric($customerID)) throw new Exception("Unknown customer ID");
    $customerName = htmlspecialchars($_POST['customerName']);
    if (empty($customerName)) $customerName = 'Anonymous';
    $customerEmail = htmlspecialchars($_POST['customerEmail']);
    if (empty($customerEmail)) throw new Exception("Email cannot be empty.");
    $rating = htmlspecialchars($_POST['rating']);
    if (!is_numeric($rating)) throw new Exception("Unrecognized rating value.");
    $reviewTitle = htmlspecialchars($_POST['reviewTitle']);
    if (empty($reviewTitle)) throw new Exception("Title cannot be empty.");
    $reviewText = htmlspecialchars($_POST['reviewText']);
    if (empty($reviewText)) throw new Exception("Review cannot be empty.");
  
    $db->execute("LOCK TABLE zen_reviews");
    $db->execute("INSERT INTO zen_reviews (products_id, customers_id, customers_name, reviews_rating, status) VALUES ($productID, $customerID, '$customerName:$customerEmail', $rating, 1)");
    $db->execute("INSERT INTO zen_reviews_description (reviews_id, reviews_title, reviews_text) VALUES ((SELECT MAX(reviews_id) FROM zen_reviews), '$reviewTitle', '$reviewText')");
    $db->execute("UNLOCK TABLES");

    $status = array(
        'code' => 1,
        'post' => $_POST,
        'santitized' => array(
            $productID,
            $customerID,
            $customerName,
            $customerEmail,
            $rating,
            $reviewTitle,
            $reviewText
        )
    );

} catch (Exception $e) {

    $status = array(
        'code' => 0,
        'message' => $e->getMessage()
    );

}

echo json_encode($status);