<?php

    include 'includes/application_top.php';

    $resultsListItems = "";
    $listItemData = array();

    $postAction = "";
    if (isset($_POST['post-action']))
    {
        $postAction = $_POST['post-action'];
    }

    $postData = "";
    if (isset($_POST['post-data']))
    {
        $postData = $_POST['post-data'];
    }

    $status = array(
        "code" => 0,
        "message" => "No post action implemented for " . $postAction,
        'results' => array(),
    );
    
    $matchedProducts = array();

    switch($postAction) {
        case "quick-search":
            $searchTerm = '%' . strtolower($postData['term']) . '%';
            
            if (empty($searchTerm))
            {
                $status = array(
                    'code' => 0,
                    'message' => 'Empty search term'
                );
                break;
            }

            $searchQuery_string = "
            SELECT
                pd.products_id, pd.products_name, pd.products_alt_name, pd.products_description, pd.products_model,
                p.products_image,
                m.manufacturers_name
            FROM zen_products_description pd
            LEFT JOIN zen_products p ON pd.products_id = p.products_id
            LEFT JOIN zen_manufacturers m ON p.manufacturers_id = m.manufacturers_id
            WHERE MATCH(pd.products_model, pd.products_name, pd.products_alt_name, pd.products_description) AGAINST (:term:)
            LIMIT 25
            ";

            $searchQuery_string = $db->bindVars($searchQuery_string, ":term:", $searchTerm, 'string');

            $searchQuery_result = $db->Execute($searchQuery_string);

            while (!$searchQuery_result->EOF) {

                $pID = $searchQuery_result->fields['products_id'];
                $pModel = $searchQuery_result->fields['products_model'];
                $pImg = $searchQuery_result->fields['products_image'];
                $pName = $searchQuery_result->fields['products_name'];
                $pAlt = $searchQuery_result->fields['products_alt_name'];
                $pD = $searchQuery_result->fields['products_description'];
                $mName = $searchQuery_result->fields['manufacturers_name'];

                if ($mName !== strip_tags($mName))
                {
                    $mName = strip_tags($mName);
                }

                $brands_to_rebuilt = array(
                    "FREEDOM ELECTRONICS", "RDM", "PMP",
                );
                if (in_array(strtoupper($mName), $brands_to_rebuilt))
                {
                    $mName = '<em>Rebuilt Part</em>';
                }

                $matchedProducts[$pID] = array(
                    "id" => $pID,
                    "manufacturesId" => $mID,
                    "manufacturesName" => $mName,
                    "productModel" => $pModel,
                    "productName" => $pName,
                    "productImage" => $pImg,
                    "urlLink" => "?main_page=product_info&products_id=$pID"
                );

                $searchQuery_result->MoveNext();
            }
            $status['results'] = $matchedProducts;
            $status['message'] = "Products search successful";
            break;
        default:
            break;
    }

echo json_encode($status);