<?php

    include 'includes/application_top.php';

    $resultsListItems = "";
    $listItemData = array();

    $postAction = "";
    if (isset($_POST['post-action']))
    {
        $postAction = $_POST['post-action'];
    }

    $postData = "";
    if (isset($_POST['post-data']))
    {
        $postData = $_POST['post-data'];
    }

    $status = array(
        "code" => 0,
        "message" => "No post action implemented for " . $postAction,
        'results' => array(),
    );
    
    $data = array();
    switch($postAction) {
        case "quick-search":
            $q = strtolower($postData['term']);
            
            if (!$q) {
                $status['message'] = "Input required";
                $status['code'] = 1;
                break;
            }
            $items = array();

            $select_str = "SELECT DISTINCT " . $select_column_list .
                        " m.manufacturers_id, p.products_id, p.products_model, pd.products_name, pd.products_alt_name, p.products_image, p.products_price, p.products_tax_class_id, p.products_price_sorter, p.products_qty_box_status, p.master_categories_id ";

            $cust_query = "FROM (" . TABLE_PRODUCTS . " p
                        LEFT JOIN " . TABLE_MANUFACTURERS . " m
                        USING(manufacturers_id), " . TABLE_PRODUCTS_DESCRIPTION . " pd, " . TABLE_CATEGORIES . " c, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c )
                        LEFT JOIN " . TABLE_META_TAGS_PRODUCTS_DESCRIPTION . " mtpd
                        ON mtpd.products_id= p2c.products_id
                        AND mtpd.language_id = :languagesID:";

            $cust_query = $db->bindVars($cust_query, ':languagesID:', $_SESSION['languages_id'], 'integer');

            $where_str = " WHERE (p.products_status = 1
                        AND p.products_id = pd.products_id
                        AND pd.language_id = :languagesID:
                        AND p.products_id = p2c.products_id
                        AND p2c.categories_id = c.categories_id ";

            $where_str = $db->bindVars($where_str, ':languagesID:', $_SESSION['languages_id'], 'integer');

            if (isset($q) && zen_not_null($q)) {
                if (zen_parse_search_string(stripslashes($q), $search_keywords)) {
                    $where_str .= " AND (";
                    for ($i=0, $n=sizeof($search_keywords); $i<$n; $i++ ) {
                        switch ($search_keywords[$i]) {
                            case '(':
                            case ')':
                            case 'and':
                            case 'or':
                            $where_str .= " " . $search_keywords[$i] . " ";
                            break;
                            default:
                            $where_str .= "(pd.products_name LIKE '%:keywords:%'
                                                            OR pd.products_alt_name
                                                            LIKE '%:keywords:%'
                                                            OR p.products_model
                                                            LIKE '%:keywords:%'
                                                            OR m.manufacturers_name
                                                            LIKE '%:keywords:%'";

                            $where_str = $db->bindVars($where_str, ':keywords:', $search_keywords[$i], 'noquotestring');
                            // search meta tags
                            $where_str .= " OR (mtpd.metatags_keywords
                                            LIKE '%:keywords:%'
                                            AND mtpd.metatags_keywords !='')";

                            $where_str = $db->bindVars($where_str, ':keywords:', $search_keywords[$i], 'noquotestring');

                            $where_str .= " OR (mtpd.metatags_description
                                            LIKE '%:keywords:%'
                                            AND mtpd.metatags_description !='')";

                            $where_str = $db->bindVars($where_str, ':keywords:', $search_keywords[$i], 'noquotestring');

                            $where_str .= ')';
                            break;
                        }
                    }
                    $where_str .= " ))";
                }
            }
            if (!isset($q) || $q == "") {
                $where_str .= ')';
            }

            $order_str = ' order by pd.products_name LIMIT 15';

            $cust_query = $select_str . $cust_query . $where_str . $order_str;
            $cust_result = "";
            try {
                $cust_result = $db->Execute($cust_query);
            } catch(Exception $e) {
                $status['message'] = "Product Cannot Be Found";
                $status['code'] = 0;
            }

            while (!$cust_result->EOF) {
                
                if($_GET["site"] == "tops") {
                    
                    $pid = $cust_result->fields['products_id'];

                    $result = $db->Execute("SELECT p.master_categories_id, c.categories_id, c.categories_description
                                            FROM " . TABLE_PRODUCTS . " p 
                                            LEFT JOIN " . TABLE_CATEGORIES_DESCRIPTION . " c 
                                            ON p.master_categories_id = c.categories_id 
                                            WHERE p.products_id = $pid 
                                            LIMIT 1"
                                        );
                    
                    $invalidProduct = true;
                    if(!$result->EOF) {
                        $description = $result->fields['categories_description'];
                        if(stripos($description, "-Tops Equipment-") !== false) {
                            $invalidProduct = false;
                        }
                    }		

                    if($invalidProduct) {
                        $cust_result->MoveNext();
                        continue;
                    }
                }

                // $image_drop = '<div class="back searchimage">' . zen_image(DIR_WS_IMAGES . $cust_result->fields['products_image'], $cust_result->fields['products_name'], 100, 100) . '</div>';

                // $manu_drop = '<div class="searchmanu">' . zen_get_products_manufacturers_name($cust_result->fields['products_id']) . '</div>';

                $product_name = empty($cust_result->fields['products_alt_name'])? $cust_result->fields['products_name'] : $cust_result->fields['products_name'] . ' - ' . $cust_result->fields['products_alt_name'];

                // $items[$image_drop . '<div class="back searchcontent">'. $manu_drop .'<div class="searchmodel">' . $cust_result->fields['products_model'] . '</div><div class="searchname">'. $product_name . '</div></div><br class="clearBoth" />'] = $cust_result->fields['products_id'];
                
                $pid = $cust_result->fields['products_id'];
                // $manufacturerImage = zen_get_products_image($cust_result->fields['products_id'], 100, 100);
                $manufacturerName = zen_get_products_manufacturers_name($cust_result->fields['products_id']);
                $brands_to_rebuilt = array(
                    "FREEDOM ELECTRONICS", "RDM", "PMP", 
                );
                if (in_array(strtoupper($manufacturerName), $brands_to_rebuilt))
                {
                    $manufacturerName = '<em>Rebuilt Part</em>';
                }
                // $resultsListItems .= "
                //     <li class='list-group-item quick-search-item'>
                //         <a class='quick-search-link' href='?main_page=product_info&products_id=$pid' title='$manufacturerName quick search result'>
                //             <div class='row'>
                //                 <div class='col-3'>$manufacturerImage</div>
                //                 <div class='col-9'>
                //                     <p class='mb-1'>$manufacturerName</p>
                //                     <p class='mb-0'>$product_name</p>   
                //                 </div>
                //             </div>
                //         </a>
                //     </li>
                // ";
                $data[$pid] = array(
                    "id" => $pid,
                    "manufacturesId" => $cust_result->fields['manufacturers_id'],
                    "manufacturesName" => $manufacturerName,
                    "productModel" => $cust_result->fields['products_model'],
                    "productName" => $product_name,
                    "productImage" => $cust_result->fields['products_image'],
                    "urlLink" => "?main_page=product_info&products_id=$pid",
                );

                if (strpos($data[$pid]['manufacturesName'], '<div class="manfStock">') !== FALSE)
                {
                    $data[$pid]['manufacturesName'] = strip_tags($data[$pid]['manufacturesName']);
                }

                $cust_result->MoveNext();
            }
            $status['results'] = $data;
            $status['message'] = "Products search successful";
            break;
        default:
            break;
    }

echo json_encode($status);