<?php

include 'includes/application_top.php';

$postAction = $_POST['post-action'] ?? '';
$postData = $_POST['post-data'] ?? array();

$testScript = (empty($postAction) && strpos($_SERVER['HTTP_HOST'], 'xdev.') || $_SERVER['REMOTE_ADDR'] == '65.121.68.3' && !isset($_POST)) !== FALSE;
if ($testScript) {
    $postAction = 'getShippingQuote';
    $postData = array(
        'name' => 'John Smith',
        'addressLine1' => '59 Keel Court',
        'city' => 'Stansbury Park',
        'state' => 'UT',
        'zip' => '84074',
        'country' => 'US',
        'residentialCharge' => 1,
        'liftgateCharge' => 0,
        'restrictedAccessCharge' => 0
    );
}

$status = array(
    'code' => 0,
    'message' => "Incorrect POST body. Please try again. (0x0)"
);
if (!empty($postAction)) {
    $status = array(
        'code' => 0,
        'message' => "Incorrect POST body. Please try again. (0x1:" . $postAction . ')',
    );
}
if (!empty($postData)) {
    $status = array(
        'code' => 0,
        'message' => "Incorrect POST body. Please try again. (0x2)"
    );
}

function parseSurchargeTags($surcharge, &$result = array()) {
    $pattern = '/<(.*?)>(.*?)<\/\1>/';
    $matches = array();
    if (preg_match_all($pattern, $surcharge, $matches, PREG_SET_ORDER)) {
        foreach ($matches as $match) {
            $tagName = $match[1];
            $tagContent = $match[2];
            $result[$tagName] = array();

            if (preg_match($pattern, $tagContent, $innerMatches)) {
                parseSurchargeTags($tagContent, $result[$tagName]);
            } else {
                $result[$tagName] = $tagContent;
            }
        }
    }
}

function calculateSurcharge($surcharge) {
    if (empty($surcharge)) return false;

    if (is_numeric($surcharge)) {
        return array(
            array(
                'surcharge' => $surcharge,
                'method' => "flatrate",
                'value' => $surcharge
            )
        );
    }

    $surchargesToParse = array();
    if ($surcharge == strip_tags($surcharge)) throw new Exception("Unrecognized surcharge syntax ($surcharge)");
    parseSurchargeTags($surcharge, $surchargesToParse);
    $surchargesParsed = array();

    foreach ($surchargesToParse as $parsedMethod => $parsedValue) {
        $surchargesParsed[] = array(
            'surcharge' => $surcharge,
            'method' => ($parsedMethod == 'surcharge') ? 'flatrate' : $parsedMethod,
            'value' => $parsedValue
        );
    }

    return $surchargesParsed;
}

function advShipperZipMatchesRegion($address, $target) {
    $ranges = explode(',', trim($target));

    foreach ($ranges as $range) {
        $range = trim($range);

        if (strpos($range, $address['country']) !== FALSE) {
            if (strpos($range, ":") === FALSE) return ($address['country'] == $range);
            
            $zip = $address['zip'];
            $minmax = explode('-', substr($range, (strpos($range, ":") + 1)));

            if (sizeof($minmax) == 1) {
                if ($zip == $minmax[0]) return true;
            }

            $min = $minmax[0];
            $max = $minmax[1];


            if (($min <= $zip) && ($zip <= $max)) return true;
        }
    }

    return false;
}

function getAdvShipperDetails($method, $shipTo) {
    global $db;

    $advShipperMethodQuery = "SELECT
    rc.region, rc.countries_postcodes, rc.max_weight_per_package, rc.surcharge,
    ruc.shipping_service_2da, ruc.shipping_service_gnd
    FROM zen_advshipper_region_configs rc
    LEFT JOIN zen_advshipper_region_ups_configs ruc ON rc.method = ruc.method AND rc.region = ruc.region
    LEFT JOIN zen_advshipper_method_configs mc ON mc.method = ruc.method
    WHERE rc.method = '$method' AND mc.enabled = 1
    ORDER BY rc.region ASC";

    $advShipperMethodResult = $db->Execute($advShipperMethodQuery);

    $maxPackageWeight = 150;
    $surcharge = array();
    $service = 0;

    //loop through all matching regions. it's assumed that the first matching region is the region to use for calculation, as they should be in a "fall-through" order
    while (!$advShipperMethodResult->EOF) {
        $methodZips = $advShipperMethodResult->fields['countries_postcodes'];
        //check if this method applies to customer's zip code
        $shipToZipAndCountry = array(
            'zip' => $shipTo['zip'],
            'country' => $shipTo['country']
        );
        if (advShipperZipMatchesRegion($shipToZipAndCountry, $methodZips)) {
            $maxPackageWeight = $advShipperMethodResult->fields['max_weight_per_package'];
    
            //can be either a flat rate or a a formatted rate ((int)value OR <format>value</format> OR <formatA>valueA</formatA><formatB>valueB</formatB>)
            $surcharge = calculateSurcharge($advShipperMethodResult->fields['surcharge']);
    
            //if 2da is true, make service code = 2, which is 2nd day air, or 3, which is UPS ground, or error ($service == 0 || ($service !== 2 || 3))
            if ($advShipperMethodResult->fields['shipping_service_2da'] == 1) $service = '02';
            if ($advShipperMethodResult->fields['shipping_service_gnd'] == 1) $service = '03';
            //should realistically never throw, as all products should be 2da or ground
            if (!in_array($service, array(2, 3))) throw new Exception('(m' . $method . ') Invalid service type. (' . $service . ') (' . $advShipperMethodResult->fields['shipping_service_gnd'] . ')');
            
            return array(
                'targetZone' => $advShipperMethodResult->fields['countries_postcodes'],
                'region' => $advShipperMethodResult->fields['region'],
                'maxPackageWeight' => $maxPackageWeight,
                'surcharge' => $surcharge,
                'service' => $service,
                'method' => $method
            );
        }

        $advShipperMethodResult->MoveNext();
    }

    return false;
}

function checkAdvShipperMethods($manfID, $prid, $shipTo) {
    global $db;

    //check if product has specific configuration
    $advShipperProductQuery = "SELECT
    zamp.method
    FROM zen_advshipper_method_products zamp
    LEFT JOIN zen_advshipper_method_configs zamc on zamp.method = zamc.method
    WHERE zamp.product_id = '$prid'
    ORDER BY zamc.sort_order ASC LIMIT 1";

    $advShipperProductResult = $db->Execute($advShipperProductQuery);

    //if it does, return that configuration
    if ($advShipperProductResult->RecordCount() == 1) return getAdvShipperDetails($advShipperProductResult->fields['method'], $shipTo);

    //check if manufacturer has specific configuration
    $advShipperManfQuery = "SELECT
    zamm.method
    FROM zen_advshipper_method_manufacturers zamm
    LEFT JOIN zen_advshipper_method_configs zamc on zamm.method = zamc.method
    WHERE zamm.manufacturer_id = '$manfID'
    ORDER BY zamc.sort_order ASC LIMIT 1";

    $advShipperManfResult = $db->Execute($advShipperManfQuery);

    //if it does, return that configuration
    if ($advShipperManfResult->RecordCount() == 1) return getAdvShipperDetails($advShipperManfResult->fields['method'], $shipTo);

    //use ups fallback method if neither of the above apply
    return getAdvShipperDetails(1, $shipTo);
}

function callAPIs($cartShipInfo, $shipTo) {
    global $db;

    $apiDetails = array(
        'products' => array(
            'freight' => array(),
            'package' => array()
        ),
        'advShipper' => array(),
        'sent' => array(
            'freight' => array(),
            'package' => array()
        ),
        'received' => array(
            'freight' => array(),
            'package' => array()
        ),
        'totals' => array(
                'freight' => 0.00,
                'package' => 0.00
            )
    );

    $_SESSION['shipping'] = array(
        'status' => array(
            'code' => 0,
            'message' => 'Shipping calculation was interrupted.'
        ),
        'values' => array(
            'total' => 0.00
        )
    );

    foreach ($cartShipInfo as $cartShipInfoXManfId => $cartShipInfoXManf) {
        if (!empty($cartShipInfoXManf['freight'])) {
            foreach ($cartShipInfoXManf['freight'] as $freightItemID => $freightItemInfo) {
                if (!$freightItemInfo['core']) {
                    $freightToShip = array();

                    $freightItem = array(
                        'id' => $freightItemID,
                        'model' => $freightItemInfo['model'],
                        'price' => $freightItemInfo['price'],
                        'weight' => $freightItemInfo['weight'],
                        'length' => $freightItemInfo['length'],
                        'width' => $freightItemInfo['width'],
                        'height' => $freightItemInfo['height'],
                        'freight_class' => $freightItemInfo['freight_class'],
                        'packing_type' => $freightItemInfo['packing_type'],
                        'quantity' => $freightItemInfo['quantity']
                    );

                    $freightToShip[] = $freightItem;
                    $apiDetails['products']['freight'][] = $freightItem;
                }

                $freightquoteFreightRateCall = freightquote_rate_freight($cartShipInfoXManf['address'], $shipTo, $freightToShip);

                $apiDetails['sent']['freight'][] = $freightquoteFreightRateCall['sent'];
                $apiDetails['received']['freight'][] = $freightquoteFreightRateCall['received'];

                $freightquoteFreightRateCallReceived = $freightquoteFreightRateCall['received'];
                $preferredQuoteSlot = 4;
                $freightquotePreferredQuote = $freightquoteFreightRateCallReceived['quoteSummaries'][$preferredQuoteSlot - 1] ?? end($freightquoteFreightRateCallReceived['quoteSummaries']);
                $freightquoteMarkup = 0;
                $freightquoteMarkupPercent = $freightquoteMarkup / 100;

                if (isset($freightquoteFreightRateCall['code']) && $freightquoteFreightRateCall['code'] == 1) {
                    $apiDetails['totals']['freight'] += ($freightquotePreferredQuote['totalCharge'] * (1 + $freightquoteMarkupPercent));
                } else {
                    throw new Exception("An error occurred while calculating shipping. Please refresh the page and try again. If this issue persists, please contact us for assistance. (" . print_r($freightquoteFreightRateCall, true) . ")");
                }
            }
        }
        if (!empty($cartShipInfoXManf['package'])) {
            foreach ($cartShipInfoXManf['package'] as $packageItemID => $packageItemInfo) {
                if (!$packageItemInfo['core']) {
                    $productsToShip = array();

                    $advShipperDetail = checkAdvShipperMethods($cartShipInfoXManfId, $packageItemID, $shipTo);
                    $advShipperSurchargeTotals = 0.00;
                    $apiDetails['advShipper'][] = $advShipperDetail;

                    $minimumPackageWeight = 7;
                    $packageItemInfo['weight'] = max($packageItemInfo['weight'], $minimumPackageWeight);

                    $maxWeightPerPackage = $advShipperDetail['maxPackageWeight'] ?? 150;
                    $maxNumberOfItemsToPack = floor($maxWeightPerPackage/$packageItemInfo['weight']);
                    $numberOfPackages = 0;
                    $valueOfShipment = 0.00;

                    while ($packageItemInfo['quantity'] > 0) {
                        $numberOfItemsToPack = min($packageItemInfo['quantity'], $maxNumberOfItemsToPack);

                        $packageItemInfo['quantity'] -= $numberOfItemsToPack;

                        $packageItem = array(
                            'id' => $packageItemID,
                            'model' => $packageItemInfo['model'],
                            'weight' => $packageItemInfo['weight'],
                            'quantity' => $numberOfItemsToPack,
                            'price' => (float)$numberOfItemsToPack * (float)$packageItemInfo['price']
                        );

                        $productsToShip[] = $packageItem;
                        $apiDetails['products']['package'][] = $packageItem;

                        $numberOfPackages++;
                        $valueOfShipment += $packageItem['price'];
                    }

                    $service = in_array($shipTo['state'], array('AK', 'HI'))? '02' : ($advShipperDetail['service'] ?? '03');
                    $upsPackageRateCall = ups_rate_package($shipTo, $cartShipInfoXManf['address'], $productsToShip, $service);

                    $apiDetails['sent']['package'][] = $upsPackageRateCall['sent'];
                    $apiDetails['received']['package'][] = $upsPackageRateCall['received'];

                    if (isset($upsPackageRateCall['code']) && $upsPackageRateCall['code'] == 1) {
                        $groundQuote = isset($upsPackageRateCall['received']['RateResponse']['RatedShipment']['NegotiatedRateCharges']['TotalCharge']['MonetaryValue'])? $upsPackageRateCall['received']['RateResponse']['RatedShipment']['NegotiatedRateCharges']['TotalCharge']['MonetaryValue'] * 1.25 : $upsPackageRateCall['received']['RateResponse']['RatedShipment']['TotalCharges']['MonetaryValue'] * 1.10;
                        $apiDetails['totals']['package'] += $groundQuote;
                        
                        //apply advshipper charges PER PACKAGE
                        if ($advShipperDetail !== FALSE) {
                            foreach ($advShipperDetail['surcharge'] as $advShipperSurcharge) {
                                switch ($advShipperSurcharge['method']) {
                                    case 'flatrate':
                                        $advShipperSurchargeTotals += ($advShipperSurcharge['value'] * $numberOfPackages);
                                        break;
                                    case 'percent':
                                        $advShipperSurchargeTotals += $valueOfShipment * ($advShipperSurcharge['value'] / 100);
                                        break;
                                }
                            }
                        }
                        
                        $apiDetails['totals']['package'] += $advShipperSurchargeTotals;
                    } else {
                        if (isset($upsPackageRateCall['received']['response']['errors'])) throw new Exception("An error occurred while calculating shipping. Please refresh the page and try again. If this issue persists, please contact us for assistance. ({$upsPackageRateCall['received']['response']['errors'][0]['code']}) (" . print_r($upsPackageRateCall['received'], true) . ")");
                        if (isset($upsPackageRateCall['received']['Fault'])) throw new Exception("An error occurred while calculating shipping. Please refresh the page and try again. If this issue persists, please contact us for assistance. ({$upsPackageRateCall['received']['Fault']['faultstring']}) (" . print_r($upsPackageRateCall['received'], true) . ")");
                        throw new Exception("An error occurred while calculating shipping. Please refresh the page and try again. If this issue persists, please contact us for assistance. (1971)");
                    }
                }
            }
        }
    }

    $upsTransactionIDs = findAllValuesInArray($apiDetails['received'], "TransactionIdentifier");
    $upsTransactionIDs = print_r($upsTransactionIDs, true);
    $upsSent = print_r($apiDetails['sent'], true);
    $upsReceived = print_r($apiDetails['received'], true);

    $nextOrderQuery = $db->Execute("SELECT orders_id FROM zen_orders ORDER BY orders_id DESC LIMIT 1");
    $nextOrderID = $nextOrderQuery->fields['orders_id'] + 1;

    $upsInsertQuery = "INSERT INTO `zen_apid_ups`
    (`customer_id`, `order_id`, `transaction_id`, `sent`,
    `received`, `time`, `session_id`)
    VALUES
    (:cID:, :oID:, :upsTransactionIDs:, :upsSent:,
    :upsReceived:, now(), :sessionID:)";
    
    $upsInsertQueryValues = array(
        "cID" => $_SESSION['customer_id'] ?? $_SESSION['temp_customer_id'],
        "oID" => $nextOrderID,
        "upsTransactionIDs" => $upsTransactionIDs,
        "upsSent" => $upsSent,
        "upsReceived" => $upsReceived,
        "sessionID" => session_id()
    );

    $upsInsertQuery = foreachBindVars($upsInsertQueryValues, $upsInsertQuery);

    $db->Execute($upsInsertQuery);

    return $apiDetails;
}

function stripAttributesDataFromPrid($prid) {
    if (strpos($prid, ':') !== FALSE) {
        return substr($prid, 0, strpos($prid, ':'));
    }

    return $prid;
}

function sortCartByManfs($shipToState) {
    global $db;

    $cartContents = $_SESSION['cart']->contents;

    $pridsStrippedWithInfo = array();

    foreach ($cartContents as $productID => $productInfo) {
        $pridStripped = stripAttributesDataFromPrid($productID);

        $pridsStrippedWithInfo[$pridStripped] = $productInfo;
    }

    $pridsStrippedAndImploded = implode('\', \'', array_keys($pridsStrippedWithInfo));

    $prodManfZoneQuery = 
        "SELECT
        p.products_id, p.products_model, p.products_price_w, p.products_weight, p.manufacturers_id, 
        p.product_is_always_free_shipping, p.is_core, p.products_freightquote_enable, p.products_freightquote_class,
        p.products_freightquote_length, p.products_freightquote_width, p.products_freightquote_height,
        p.products_freightquote_package_type, m.manufacturers_id, m.manufacturers_name, m.manufacturers_address_1, m.manufacturers_city,
        m.manufacturers_zip, z.zone_code, z.zone_name
        FROM zen_products AS p
        LEFT JOIN zen_manufacturers AS m ON p.manufacturers_id = m.manufacturers_id
        LEFT JOIN zen_zones AS z ON m.manufacturers_state = z.zone_id
        WHERE p.products_id IN ('$pridsStrippedAndImploded')
        ";
    
    $prodManfZoneResults = $db->Execute($prodManfZoneQuery);

    $cartByManfs = array();

    while (!$prodManfZoneResults->EOF) {
        if ($prodManfZoneResults->fields['products_weight'] == 0) {
            //can't ship products that weigh 0
            return "0W";
        }

        $manfID = $prodManfZoneResults->fields['manufacturers_id'];
        $manfName = $prodManfZoneResults->fields['manufacturers_name'];
        $manfStreet = $prodManfZoneResults->fields['manufacturers_address_1'];
        $manfCity = $prodManfZoneResults->fields['manufacturers_city'];
        $manfZip = $prodManfZoneResults->fields['manufacturers_zip'];
        $manfZC = $prodManfZoneResults->fields['zone_code'];
        $manfZN = $prodManfZoneResults->fields['zone_name'];
        $prid = $prodManfZoneResults->fields['products_id'];
        $pmod = $prodManfZoneResults->fields['products_model'];
        $price = $prodManfZoneResults->fields['products_price_w'];
        $weight = $prodManfZoneResults->fields['products_weight'];
        $freeShipping = $prodManfZoneResults->fields['product_is_always_free_shipping'];
        $core = $prodManfZoneResults->fields['is_core'];
        $fqE = $prodManfZoneResults->fields['products_freightquote_enable'];
        $fqC = $prodManfZoneResults->fields['products_freightquote_class'];
        $fqL = $prodManfZoneResults->fields['products_freightquote_length'];
        $fqW = $prodManfZoneResults->fields['products_freightquote_width'];
        $fqH = $prodManfZoneResults->fields['products_freightquote_height'];
        $fqP = $prodManfZoneResults->fields['products_freightquote_package_type'];
        $packageTypesToCodes = array(
            'Bag' => '07',
            'Bale' => '31',
            'Barrel' => '08',
            'Basket' => '32',
            'Bin' => '33',
            'Box' => '34',
            'Bunch' => '35',
            'Bundle' => '10',
            'Cabinet' => '36',
            'Can' => '11',
            'Carboy' => '37',
            'Carrier' => '38',
            'Carton' => '39',
            'Case' => '40',
            'Cask' => '54',
            'Container' => '41',
            'Crate' => '14',
            'Cylinder' => '15',
            'Drum' => '16',
            'Loose' => '42',
            'Other' => '99',
            'Package' => '43',
            'Pail' => '44',
            'Pallet' => '18',
            'Pieces' => '45',
            'Pipe Line' => '46',
            'Rack' => '53',
            'Reel' => '47',
            'Roll' => '20',
            'Skid' => '48',
            'Spool' => '19',
            'Tank' => '49',
            'Tube' => '03',
            'Unit' => '50',
            'Van Pack' => '51',
            'Wrapped' => '52'
        );
        //if code isn't found, default to pallet
        $fqP = $packageTypesToCodes[$fqP] ?? '18';

        if (!isset($cartByManfs[$manfID])) {
            $cartByManfs[$manfID] = array(
                'address' => array(
                    'name' => $manfName,
                    'addressLine1' => $manfStreet,
                    'city' => $manfCity,
                    'state' => $manfZC,
                    'zip' => $manfZip,
                    'country' => 'US',
                    'ZC' => $manfZC,
                    'ZN' => $manfZN
                ),
                'freight' => array(),
                'package' => array(),
                'free' => array()
            );
        }

        if ($freeShipping && !in_array($shipToState, array('AK', 'HI'))) {
            $cartByManfs[$manfID]['free'][$prid] = array(
                'quantity' => $pridsStrippedWithInfo[$prid]['qty']
            );
        }
        else {
            if ($fqE == 1) {
                $cartByManfs[$manfID]['freight'][$prid] = array(
                    'model' => $pmod,
                    'price' => (float)$price,
                    'weight' => $weight,
                    'length' => $fqL,
                    'width' => $fqW,
                    'height' => $fqH,
                    'freight_class' => $fqC,
                    'packing_type' => $fqP,
                    'quantity' => $pridsStrippedWithInfo[$prid]['qty'],
                    'core' => ($core == 1)
                );
            }
            else {
                $cartByManfs[$manfID]['package'][$prid] = array(
                    'model' => $pmod,
                    'weight' => $weight,
                    'quantity' => $pridsStrippedWithInfo[$prid]['qty'],
                    'price' => (float)$price,
                    'core' => ($core == 1)
                );
            }
        }

        $prodManfZoneResults->MoveNext();
    }

    return $cartByManfs;
}

switch ($postAction) {
    case 'getShippingQuote':
        $status = array(
            'code' => 0,
            'message' => 'AJAX call interrupted.'
        );

        try {
            //verify input
            //keys of input that cannot be empty
            $inputNotEmptyKeys = array(
                'name',
                'addressLine1',
                'city',
                'state',
                'zip',
                'country'
            );
            foreach ($inputNotEmptyKeys as $key) {
                if (empty($postData[$key])) throw new Exception("Shipping line $key required. If you believe this to be an error, please contact us for assistance.");
            }

            $cartShipInfo = sortCartByManfs($postData['state']);

            // $status = array(
            //     'code' => 0,
            //     'cart' => $cartShipInfo
            // );

            // break;

            if ($cartShipInfo == "0W") throw new Exception("One or more products in your cart are not configured for shipping. Please contact us for assitance.");

            //prepare API calls
            $shipTo = array(
                'name' => $postData['name'],
                'addressLine1' => $postData['addressLine1'],
                'city' => $postData['city'],
                'state' => $postData['state'],
                'zip' => $postData['zip'],
                'country' => $postData['country'],
                'residentialIndicator' => $postData['residentialCharge'],
                'liftgateIndicator' => $postData['liftgateCharge'],
                'restrictedAccessIndicator' => $postData['restrictedAccessCharge']
            );

            // $status = array(
            //     'code' => 0,
            //     'shipTo' => $shipTo
            // );

            // break;

            //make API calls
            $apiCalls = callAPIs($cartShipInfo, $shipTo);

            $shippingTotalFreight = $apiCalls['totals']['freight'];
            $shippingTotalPackage = $apiCalls['totals']['package'];
            $shippingMethod = "";
            if ($shippingTotalPackage > 0) {
                // $shippingMethod = "UPS Ground";
                $shippingMethod = "Ground";
            }
            if ($shippingTotalFreight > 0) {
                // $shippingMethod = "TForce Freight";
                $shippingMethod = "Freight LTL";
            }
            if ($shippingTotalPackage > 0 && $shippingTotalFreight > 0) {
                // $shippingMethod = "UPS Ground + TForce Freight";
                $shippingMethod = "Ground + Freight LTL";
            }
            if ($shippingTotalPackage == 0 && $shippingTotalFreight == 0) {
                $shippingMethod = "Free Shipping";
            }
            if ($shippingTotalPackage < 0 || $shippingTotalPackage === null || $shippingTotalFreight < 0 || $shippingTotalFreight === null) {
                throw new Exception('UPS costs cannot be NULL or negative.');
            }

            $valuesArray = array(
                'totals' => array(
                    'freight' => $shippingTotalFreight,
                    'package' => $shippingTotalPackage,
                ),
                'total' => $shippingTotalFreight + $shippingTotalPackage,
                'method' => $shippingMethod
            );

            $status = array(
                'code' => 1,
                'api' => $apiCalls,
                'values' => $valuesArray
            );

            $_SESSION['shipping']['status'] = array('code' => 1);
            $_SESSION['shipping']['values']['total'] = $valuesArray['total'];
            $_SESSION['shipping']['values']['method'] = $valuesArray['method'];

        } catch (Exception $e) {
            $status = array(
                'code' => 0,
                'message' => "An exception occurred: {$e->getMessage()}"
            );
        }

        break;
}

if ($testScript) {
    prePrintPre($status);
} else {
    echo json_encode($status);
}