<?php
/**
 *
 * @package google product search feeder
 * @copyright Copyright 2007-2008 Numinix Technology http://www.numinix.com
 * @copyright Portions Copyright 2003-2006 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: google_product_search.php 21 2012-09-27 17:48:54Z numinix $
 * @author Numinix Technology
 */
/* configuration */
if (phpversion() < 5)
    die('PHP 5+ required, please contact your host to upgrade.');
$current_page_base = 'gpsf';
$loaderPrefix      = 'gpsf';
$show_all_errors   = FALSE;

require('includes/application_top.php');
//BEGIN Codes for Magic SEO
if (file_exists('includes/magic_seo_url.php')){
    define('MSU_LOAD_LIB_ONLY_ZC', true);
    include('includes/magic_seo_url.php');
}
//END Codes for Magic SEO
require(DIR_WS_CLASSES . 'googleProducts.php');
include_once(zen_get_file_directory(DIR_WS_LANGUAGES . $_SESSION['language'] . '/', 'google_product_search_defines.php', 'false'));
if (GOOGLE_PRODUCTS_ENABLED != 'true')
    die('Google Product Search Feeder is disabled');
$googleProducts = new googleProducts();

if ((int) GOOGLE_PRODUCTS_MAX_EXECUTION_TIME > 0)
{
    ini_set('max_execution_time', (int) GOOGLE_PRODUCTS_MAX_EXECUTION_TIME); // change to whatever time you need
    set_time_limit((int) GOOGLE_PRODUCTS_MAX_EXECUTION_TIME); // change to whatever time you need
}
if ((int) GOOGLE_PRODUCTS_MEMORY_LIMIT > 0)
    ini_set('memory_limit', (int) GOOGLE_PRODUCTS_MEMORY_LIMIT . 'M'); // change to whatever you need

// include shipping class
if (GOOGLE_PRODUCTS_SHIPPING_METHOD == 'percategory') { 
    if (!file_exists(DIR_WS_MODULES . 'shipping/percategory.php')) {
        echo "Required file does not exist on system. Please install <a href='https://www.numinix.com/zen-cart-plugins-modules-shipping-c-179_250_373_163/per-category-shipping-standard-dl-771'>PER CATEGORY SHIPPING STANDARD plugin</a> to use percategory shipping method on GPSF configuration";
        exit();
    }
    include(DIR_WS_MODULES . 'shipping/percategory.php');
    $percategory = new percategory();
} elseif (GOOGLE_PRODUCTS_SHIPPING_METHOD == 'free rules shipping') {
    if (!file_exists(DIR_WS_MODULES . 'shipping/freerules.php')) {
        echo "Required file does not exist on system. Please install <a href='https://www.numinix.com/zen-cart-plugins-modules-shipping-c-179_250_373_163/free-shipping-rules-dl-755'>FREE SHIPPING RULES plugin</a> to use freerules shipping method on GPSF configuration";
        exit();
    }
    include(DIR_WS_MODULES . 'shipping/freerules.php');
    $freerules = new freerules();
}

if (GOOGLE_PRODUCTS_ASA_UPC == 'true') {
    if (!file_exists(DIR_WS_FUNCTIONS . 'extra_functions/npf_field_functions.php')) {
        echo "Required file does not exist on system. Please install <a href='https://www.numinix.com/zen-cart-plugins-modules-admin-c-179_250_373_164/numinix-product-fields-dl-800'>NUMINIX PRODUCT FIELDS plugin</a> and set up fields for UPC/ISBN/EAN to use UPC/ISBN/EAN on GPSF configuration";
        exit();
    }
    $upc_exist = $db->Execute("SHOW COLUMNS FROM " . TABLE_PRODUCTS . " LIKE 'products_upc';");
    if ($upc_exist->RecordCount() <= 0) {
        echo "products_upc field does not exist in products table"; exit();
    }
    $isbn_exist = $db->Execute("SHOW COLUMNS FROM " . TABLE_PRODUCTS . " LIKE 'products_isbn';");
    if ($isbn_exist->RecordCount() <= 0) {
        echo "products_isbn field does not exist in products table"; exit();
    }
    $ean_exist = $db->Execute("SHOW COLUMNS FROM " . TABLE_PRODUCTS . " LIKE 'products_ean';");
    if ($ean_exist->RecordCount() <= 0) {
        echo "products_ean field does not exist in products table"; exit();
    }
}

@define('GOOGLE_PRODUCTS_EXPIRATION_BASE', 'now'); // now/product
@define('GOOGLE_PRODUCTS_OFFER_ID', 'id'); // id/model/false
@define('GOOGLE_PRODUCTS_DIRECTORY', 'feed/google/');
@define('GOOGLE_PRODUCTS_OUTPUT_BUFFER_MAXSIZE', 1024 * 1024 * 8); // 8MB
$products_processed           = 0; //for timeout issues as well as counting number of products processed
$googleProducts_start_counter = 0; //for counting all products regardless of inclusion
@define('GOOGLE_PRODUCTS_USE_CPATH', 'false');
@define('NL', "<br />\n");

$stock_attributes = false;
if (GOOGLE_PRODUCTS_SWITCH_STOCK_PLUGIN !== 'none')
{
    $stock_attributes = true;
}

// if run through command line, parse cli arguments into $_REQUEST variable
if (is_cli()) {
    parse_str(implode('&', array_slice($argv, 1)), $_REQUEST);
}

// process parameters
$parameters       = explode('_', $_REQUEST['feed']); // ?feed=fy_uy_tp
$feed_parameter   = $parameters[0];
$feed             = $googleProducts->get_feed($feed_parameter);
$upload_parameter = $parameters[1];
$upload           = $googleProducts->get_upload($upload_parameter);
$type_parameter   = $parameters[2];
$type             = $googleProducts->get_type($type_parameter);
$key              = $_REQUEST['key'];
if ($key != GOOGLE_PRODUCTS_ACCESS_KEY)
    exit('<p>Incorrect key supplied!</p>');
$limit = $offset = '';
?>
<html>
<body>
<?php
$language_id     = (isset($_GET['language_id']) ? $_GET['language_id'] : GOOGLE_PRODUCTS_LANGUAGE);
$languages_query = "SELECT code, languages_id, directory FROM " . TABLE_LANGUAGES . " WHERE languages_id = " . (int) $language_id . " LIMIT 1";
$languages       = $db->Execute($languages_query);
if (isset($_REQUEST['upload_file']))
{
    $upload_file = DIR_FS_CATALOG . GOOGLE_PRODUCTS_DIRECTORY . $_REQUEST['upload_file'];
}
else
{
    // sql limiters
    if ((int) GOOGLE_PRODUCTS_MAX_PRODUCTS > 0 || (isset($_REQUEST['limit']) && (int) $_REQUEST['limit'] > 0))
    {
        $query_limit = (isset($_REQUEST['limit']) && (int) $_REQUEST['limit'] > 0) ? (int) $_REQUEST['limit'] : (int) GOOGLE_PRODUCTS_MAX_PRODUCTS;
        $limit       = ' LIMIT ' . $query_limit;
    }
    if ((int) GOOGLE_PRODUCTS_START_PRODUCTS > 0 || (isset($_REQUEST['offset']) && (int) $_REQUEST['offset'] > 0))
    {
        $query_offset = (isset($_REQUEST['offset']) && (int) $_REQUEST['offset'] > 0) ? (int) $_REQUEST['offset'] : (int) GOOGLE_PRODUCTS_START_PRODUCTS;
        $offset       = ' OFFSET ' . $query_offset;
    }

    $outfile = DIR_FS_CATALOG . GOOGLE_PRODUCTS_DIRECTORY . GOOGLE_PRODUCTS_OUTPUT_FILENAME . "_" . $type . "_" . $languages->fields['code'];
    if ($query_limit > 0)
        $outfile .= '_' . $query_limit;
    if ($query_offset > 0)
        $outfile .= '_' . $query_offset;
    $outfile .= '.xml'; //example domain_products.xml

    if(isset($_REQUEST['batch']) && (int) $_REQUEST['batch'] == "true"){
        if(!is_dir(DIR_FS_CATALOG . 'feed/batch/')){
            mkdir(DIR_FS_CATALOG . 'feed/batch/', 0755, true);
        }

        $outfile = DIR_FS_CATALOG . 'feed/batch/' . GOOGLE_PRODUCTS_OUTPUT_FILENAME . "_" . $type . "_" . $languages->fields['code'];
        $max_pro = $db->Execute("SELECT COUNT(products_id) FROM products");
        $loop = (int)$max_pro->fields["COUNT(products_id)"] / 1000;
        $loop = (int)floor($loop) + 1;

        $filename_yesterday = strtotime('yesterday').'gpsf_log_file.csv';
        if (file_exists($filename_yesterday)) {
            unlink($filename_yesterday);
        }
        
        // specify the name of the file to create
        $filename = strtotime('today').'gpsf_log_file.csv';

        // check if the file exists
        if (file_exists($filename)) {
            $file = fopen($filename, 'r+');
            $num_rows = 0;
            while (($row = fgetcsv($file)) !== false) {
                $num_rows++;
            }

            if ($num_rows < $loop) {
                $totalNewRec = $num_rows + 1;
                $new_rows = array(
                    array('Batch ' . $totalNewRec),
                );
                foreach ($new_rows as $row) {
                    fputcsv($file, $row);
                }
                
                // close the file
                fclose($file);
                $limit       = ' LIMIT ' . 1000;
                $offset       = ' OFFSET ' . 1000 * $num_rows;  
                $outfile .= '_part'.$totalNewRec.'batch.xml';
            } else {
        
                // specify the directory where the XML files are located
                $dir = './feed/batch/';
        
                // get a list of all XML files in the directory
                $files = glob($dir . '*batch.xml');

                // create a new DOMDocument object to store the combined XML
                $combined_xml = new DOMDocument();
                $root = $combined_xml->createElement('rss');
                $root->setAttribute('version', '2.0'); // add attribute to the root element
                $root->setAttribute('xmlns:g', 'http://base.google.com/ns/1.0'); // add attribute to the root element
                $combined_xml->appendChild($root);

                // $combined_xml->appendChild($combined_xml->createElement('rss'));

                // loop through the files and append their contents to the combined XML
                foreach ($files as $file) {
                    // load the XML file
                    $xml = new DOMDocument();
                    $xml->load($file);
                    // loop through the child nodes and add them to the combined XML
                    foreach ($xml->documentElement->childNodes as $node) {
                        $imported_node = $combined_xml->importNode($node, true);
                        $combined_xml->documentElement->appendChild($imported_node);
                    }

                    unlink($file);
                }

                // save the combined XML to a file
                $combined_xml->save('./'.GOOGLE_PRODUCTS_DIRECTORY . GOOGLE_PRODUCTS_OUTPUT_FILENAME . "_" . $type . "_" . $languages->fields['code'].'.xml');
        
                echo "Batch completed";
                die;
            }
        } else {
            // if the file does not exist, create it
            $file = fopen($filename, 'w');
            // array with one value
            $data = array('Batch 1');
            // write the data to the file
            fputcsv($file, $data);
            // close the file
            fclose($file);

            $limit       = ' LIMIT ' . 1000;
            $outfile .= '_part1batch.xml';

        }
    }

}

ob_start();
if (isset($_GET['currency_code']))
{
    $currency_code = $_GET['currency_code'];
}
else
{
    $currency_code = GOOGLE_PRODUCTS_CURRENCY;
}

// include the currency and language code if they aren't the default
$product_url_add = $language_url_add = ((GOOGLE_PRODUCTS_LANGUAGE_DISPLAY == 'true' && $languages->RecordCount() > 0) || DEFAULT_LANGUAGE != $languages->fields['code'] ? "&language=" . $languages->fields['code'] : '') . (GOOGLE_PRODUCTS_CURRENCY_DISPLAY == 'true' || DEFAULT_CURRENCY != $currency_code ? "&currency=" . $currency_code : '');
//require(DIR_WS_LANGUAGES . $languages->fields['directory'] .'/googlefroogle.php');
?>
<?php
echo '<p>' . sprintf(TEXT_GOOGLE_PRODUCTS_STARTED, GOOGLE_PRODUCTS_VERSION) . '</p>';
echo '<p>' . TEXT_GOOGLE_PRODUCTS_FILE_LOCATION . (($upload_file != '') ? $upload_file : $outfile) . '</p>';
echo "<p>Processing: Feed - " . (isset($feed) && $feed == "yes" ? "Yes" : "No") . ", Upload - " . (isset($upload) && $upload == "yes" ? "Yes" : "No") . '</p>';
ob_flush();
flush();

if (isset($feed) && $feed == "yes")
{
    if (is_dir(DIR_FS_CATALOG . GOOGLE_PRODUCTS_DIRECTORY))
    {
        if (!is_writeable(DIR_FS_CATALOG . GOOGLE_PRODUCTS_DIRECTORY))
        {
            echo ERROR_GOOGLE_PRODUCTS_DIRECTORY_NOT_WRITEABLE . NL;
            die;
        }
    }
    else
    {
        echo ERROR_GOOGLE_PRODUCTS_DIRECTORY_DOES_NOT_EXIST . NL;
        die;
    }

    $fp = fopen($outfile, "wb");

    // acquire an exclusive lock
    $lockfile = "$outfile.lock";
    if(file_exists($lockfile) || !flock($fp, LOCK_EX)) {
        // Last time file ws modified grater than current time minus one hour
        if (filemtime($lockfile) > time() - (1 * 60 * 60)) {
            echo "File already opened by another process!";
            fclose($fp);
            exit();
        }
    }
    
    touch($lockfile);
    ftruncate($fp, 0);
    
    $stimer_feed = $googleProducts->microtime_float();

    $xmlWriter = new XMLWriter();
    $xmlWriter->openMemory();
    $xmlWriter->startDocument('1.0', 'UTF-8');
    $xmlWriter->setIndent(true);
    $xmlWriter->startElement('rss');
    $xmlWriter->writeAttribute('version', '2.0');
    $xmlWriter->writeAttribute('xmlns:g', 'http://base.google.com/ns/1.0');
    $xmlWriter->startElement('channel');
    $xmlWriter->startElement('title');
    $xmlWriter->writeCData($googleProducts->googleProducts_xml_sanitizer(STORE_NAME));
    $xmlWriter->endElement(); // end title
    $xmlWriter->writeElement('link', GOOGLE_PRODUCTS_ADDRESS);
    $xmlWriter->writeElement('description', $googleProducts->googleProducts_xml_sanitizer(GOOGLE_PRODUCTS_DESCRIPTION));
    fwrite($fp, $xmlWriter->outputMemory(true));

    $additional_attributes = '';
    $additional_tables     = '';

    //change configuration if columns doesn't exist
    $all_configurations_to_check = array(
        array(
            'GOOGLE_PRODUCTS_ASA_UPC',
            GOOGLE_PRODUCTS_ASA_UPC,
            TABLE_PRODUCTS,
            array(
                'products_upc',
                'products_isbn',
                'products_ean'
            )
        ),
        array(
            'GOOGLE_PRODUCTS_ASA_DESCRIPTION_2',
            GOOGLE_PRODUCTS_ASA_DESCRIPTION_2,
            TABLE_PRODUCTS_DESCRIPTION,
            array(
                'products_description2'
            )
        ),
        array(
            'GOOGLE_PRODUCTS_MAP_PRICING',
            GOOGLE_PRODUCTS_MAP_PRICING,
            TABLE_PRODUCTS,
            array(
                'map_price',
                'map_enabled'
            )
        ),
        array(
            'GOOGLE_PRODUCTS_META_TITLE',
            GOOGLE_PRODUCTS_META_TITLE,
            TABLE_META_TAGS_PRODUCTS_DESCRIPTION,
            array(
                'metatags_title'
            )
        ),
        array(
            'GOOGLE_PRODUCTS_PRODUCT_CONDITION',
            GOOGLE_PRODUCTS_PRODUCT_CONDITION,
            TABLE_PRODUCTS,
            array(
                'products_condition'
            )
        )
    );

    $googleProducts->do_column_exist_configuration($all_configurations_to_check);

    // upc
    if (GOOGLE_PRODUCTS_ASA_UPC == 'true')
    {
        $additional_attributes .= ", p.products_upc, p.products_isbn, p.products_ean";
    }
    // description 2
    if (GOOGLE_PRODUCTS_ASA_DESCRIPTION_2 == 'true')
    {
        $additional_attributes .= ", pd.products_description2";
    }

    if (GOOGLE_PRODUCTS_MAP_PRICING == 'true')
    {
        $additional_attributes .= ", p.map_price, p.map_enabled";
        $gb_map_enabled = true;
    } else {
        $gb_map_enabled = false;
    }

    if (GOOGLE_PRODUCTS_META_TITLE == 'true')
    {
        $additional_attributes .= ", mtpd.metatags_title";
        $additional_tables .= " LEFT JOIN " . TABLE_META_TAGS_PRODUCTS_DESCRIPTION . " mtpd ON (p.products_id = mtpd.products_id) ";
    }

    if (GOOGLE_PRODUCTS_PRODUCT_CONDITION == 'true')
    {
        $additional_attributes .= ", p.products_condition";
    }

    if (defined('GOOGLE_PRODUCTS_PAYMENT_METHODS') && GOOGLE_PRODUCTS_PAYMENT_METHODS != '')
    {
        $payments_accepted = explode(',', GOOGLE_PRODUCTS_PAYMENT_METHODS);
    }

    if(GOOGLE_PRODUCTS_INCLUDE_PROMOTION_ID == 'true'){
        $additional_attributes .= ", p.promotion_id, m.manufacturers_promotion_id";
    }

    if(defined('GOOGLE_PRODUCTS_INCLUDE_MIN_QUANITY')) {
        $additional_attributes .= ", p.products_quantity_order_units";
    }

    if(defined('GOOGLE_PRODUCTS_INCLUDE_MIN_QUANITY')) {
        $additional_attributes .= ", p.products_quantity_order_units";
    }
    
    if($sniffer->field_exists(TABLE_PRODUCTS, 'gtin')) {
        $additional_attributes .= ", p.gtin";
    }
    
    switch ($type)
    {
        case "products":
            $order_by = '';
            if (GOOGLE_PRODUCTS_SKIP_DUPLICATE_TITLES == 'true')
            {
                $products_query = "SELECT p.products_id, p.products_model, pd.products_description, pd.products_name, p.products_image, p.products_tax_class_id, p.products_price, p.products_price_sorter, p.products_priced_by_attribute, p.products_type, p.master_categories_id, GREATEST(p.products_date_added, IFNULL(p.products_last_modified, 0), IFNULL(p.products_date_available, 0)) AS base_date, p.products_date_available, m.manufacturers_name, p.products_quantity, pt.type_handler, p.products_weight" . $additional_attributes . "
                             FROM " . TABLE_PRODUCTS . " p
                               LEFT JOIN " . TABLE_MANUFACTURERS . " m ON (p.manufacturers_id = m.manufacturers_id)
                               LEFT JOIN " . TABLE_PRODUCTS_DESCRIPTION . " pd ON (p.products_id = pd.products_id)
                               LEFT JOIN " . TABLE_PRODUCT_TYPES . " pt ON (p.products_type=pt.type_id)
                               LEFT JOIN " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c ON (p2c.products_id = p.products_id)" . $additional_tables;
                $order_by .= " GROUP BY pd.products_name, p.products_id";
            }
            else
            {
                $products_query = "SELECT p.products_id, p.products_model, pd.products_description, pd.products_name, p.products_image, p.products_tax_class_id, p.products_price, p.products_price_sorter, p.products_priced_by_attribute, p.products_type, p.master_categories_id, GREATEST(p.products_date_added, IFNULL(p.products_last_modified, 0), IFNULL(p.products_date_available, 0)) AS base_date, p.products_date_available, m.manufacturers_name, p.products_quantity, pt.type_handler, p.products_weight" . $additional_attributes . "
                             FROM " . TABLE_PRODUCTS . " p
                               LEFT JOIN " . TABLE_MANUFACTURERS . " m ON (p.manufacturers_id = m.manufacturers_id)
                               LEFT JOIN " . TABLE_PRODUCTS_DESCRIPTION . " pd ON (p.products_id = pd.products_id)
                               LEFT JOIN " . TABLE_PRODUCT_TYPES . " pt ON (p.products_type=pt.type_id)
                               LEFT JOIN " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c ON (p2c.products_id = p.products_id)" . $additional_tables;
                $order_by .= " GROUP BY p.products_id";
            }

            $where = " WHERE p.products_status = 1
                   AND p.products_type <> 3
                   AND p.product_is_call <> 1
                   AND p.product_is_free <> 1
                   AND pd.language_id = " . (int) $languages->fields['languages_id'] . "
                   AND (
                     p.products_image IS NOT NULL
                     AND p.products_image != ''
                     AND p.products_image != '" . PRODUCTS_IMAGE_NO_IMAGE . "'
                   )";

            // Segmentation set from configuration
            if (GOOGLE_PRODUCTS_INCLUDE_OUT_OF_STOCK == 'false')
            {
                $where = str_replace('WHERE p.products_status = 1', 'WHERE p.products_status = 1 AND p.products_quantity > 0', $where);
                if (GOOGLE_PRODUCTS_INCLUDE_MAP == 'false' && $gb_map_enabled)
                {
                    $where = str_replace('WHERE p.products_status = 1', 'WHERE p.products_status = 1 AND p.products_quantity > 0 AND p.map_enabled = 0', $where);
                }

            }

            else
            {
                if (GOOGLE_PRODUCTS_INCLUDE_MAP == 'false' && $gb_map_enabled)
                {
                    $where = str_replace('WHERE p.products_status = 1', 'WHERE p.products_status = 1 AND p.map_enabled = 0', $where);
                }

            }

            if (GOOGLE_PRODUCTS_NEG_MANUFACTURERS != '')
            {
                $where .= " AND p.manufacturers_id NOT IN (" . GOOGLE_PRODUCTS_NEG_MANUFACTURERS . ")";
            }

            if (GOOGLE_PRODUCTS_POS_MANUFACTURERS != '')
            {
                $where .= " AND p.manufacturers_id IN (" . GOOGLE_PRODUCTS_POS_MANUFACTURERS . ")";
            }

            if (GOOGLE_PRODUCTS_POS_CATEGORIES != '')
            {
                $where .= " AND p2c.categories_id IN (" . GOOGLE_PRODUCTS_POS_CATEGORIES . ")";
            }

            if (GOOGLE_PRODUCTS_NEG_CATEGORIES != '')
            {
                $where .= " AND p2c.categories_id NOT IN (" . GOOGLE_PRODUCTS_NEG_CATEGORIES . ")";
            }


            /*
            // these have to be done in a function
            if (GOOGLE_PRODUCTS_POS_CATEGORIES != '') {
            $where .= " AND p2c.categories_id IN (" . GOOGLE_PRODUCTS_POS_CATEGORIES. ")";
            }
            if (GOOGLE_PRODUCTS_NEG_CATEGORIES != '') {
            $where .= " AND p2c.categories_id NOT IN (" . GOOGLE_PRODUCTS_NEG_CATEGORIES. ")";
            }
            */
            $order_by .= " ORDER BY p.products_id ASC" . $limit . $offset;
            $products_query .= $where . $order_by;

            $products                    = $db->Execute($products_query);
            $total_products              = $products->RecordCount();
            $possible_variant_attributes = array(
                'color',
                'colour',
                'material',
                'pattern',
                'size',
                'size type',
                'size system',
                'age group',
                'gender',
                'google product category',
                'upc',
                'ean',
                'isbn',
                'jan',
                'gtin',
                'adwords grouping',
                'adwords labels',
                'adwords publish'
            );
            $skipped                     = array();
            //die('record count: ' . $products->RecordCount());
            while (!$products->EOF) // run until end of file or until maximum number of products reached
            {
                $googleProducts_start_counter++;
                ob_start();
                /* BEGIN GLOBAL ELEMENTS USED IN ALL ITEMS */
                // reset tax array
                $tax_rate = array();
                list($categories_list, $cPath) = $googleProducts->googleProducts_get_category($products->fields['master_categories_id']);
                //if (GOOGLE_PRODUCTS_DEBUG == 'true') {
                //if (!$googleProducts->check_product($products->fields['products_id'])) echo $products->fields['products_id'] . ' skipped due to user restrictions<br />';
                //}
                //if ($googleProducts->check_product($products->fields['products_id'])) {
                if ($gb_map_enabled && $products->fields['map_enabled'] == '1' && $products->fields['map_price'] > 0)
                {
                    $price = $products->fields['map_price'];
                }
                else
                {
                    $price      = zen_get_products_base_price($products->fields['products_id']);
                    $sale_price = $googleProducts->google_get_products_actual_price($products->fields['products_id'], $products->fields['products_price'], $products->fields['products_model'], $products->fields['products_priced_by_attribute'], $products->fields['master_categories_id']);
                }
                // price must be greater than 0
                if ($price <= 0 && $products->fields['products_priced_by_attribute'] != 1)
                {
                    $skipped[$products->fields['products_id']] = 'price below 0';
                    $products->MoveNext();
                    continue;
                }

                $products_quantity_order_units = (isset($products->fields['products_quantity_order_units']) && $products->fields['products_quantity_order_units'] > 1) ? (int)$products->fields['products_quantity_order_units'] : 1;

                $tax_rate   = zen_get_tax_rate($products->fields['products_tax_class_id']);
                // the following will only add the tax if DISPLAY_PRICE_WITH_TAX is set to true in the Zen Cart admin
                $price      = zen_add_tax($price, $tax_rate);
                $sale_price = zen_add_tax($sale_price, $tax_rate);
                // modify price to match defined currency
                $price      = $currencies->value($price, true, $currency_code, $currencies->get_value($currency_code));
                $sale_price = $currencies->value($sale_price, true, $currency_code, $currencies->get_value($currency_code));

                $products_description = $products->fields['products_description'];
                if (GOOGLE_PRODUCTS_ASA_DESCRIPTION_2 == 'true')
                {
                    $products_description .= $products->fields['products_description2'];
                }
                $products_description = $googleProducts->googleProducts_xml_sanitizer($products_description, $products->fields['products_id']);
                if ((GOOGLE_PRODUCTS_META_TITLE == 'true') && ($products->fields['metatags_title'] != ''))
                {
                    $productstitle = $googleProducts->googleProducts_xml_sanitizer($products->fields['metatags_title']);
                }
                else
                {
                    $productstitle = $googleProducts->googleProducts_xml_sanitizer($products->fields['products_name']);
                }
                if (strlen($productstitle) < 3)
                {
                    $skipped[$products->fields['products_id']] = 'title less than 3 chars';
                    $products->MoveNext();
                    continue;
                }
                $default_google_product_category = $googleProducts->googleProducts_xml_sanitizer(GOOGLE_PRODUCTS_DEFAULT_PRODUCT_CATEGORY);

                //$link = ($products->fields['type_handler'] ? $products->fields['type_handler'] : 'product') . '_info';
                $link       = zen_get_info_page($products->fields['products_id']);
                $cPath_href = (GOOGLE_PRODUCTS_USE_CPATH == 'true' ? 'cPath=' . implode('_', $cPath) . '&' : '');
                $link       = zen_href_link($link, $cPath_href . 'products_id=' . (int) $products->fields['products_id'], 'NONSSL', false);
                if (GOOGLE_PRODUCTS_OFFER_ID != 'false')
                {
                    switch (GOOGLE_PRODUCTS_OFFER_ID)
                    {
                        case 'model':
                            if ($products->fields['products_model'])
                            {
                                $id = $googleProducts->googleProducts_xml_sanitizer($products->fields['products_model']);
                                break;
                            }
                        case 'UPC':
                            if ($products->fields['products_upc'])
                            {
                                $id = $products->fields['products_upc'];
                                break;
                            }
                        case 'ISBN':
                            if ($products->fields['products_isbn'])
                            {
                                $id = $products->fields['products_isbn'];
                                break;
                            }
                        case 'EAN':
                            if ($products->fields['products_ean'])
                            {
                                $id = $products->fields['products_ean'];
                                break;
                            }
                        case 'id':
                        // continue
                        default:
                            $id = $products->fields['products_id'];
                            break;
                    }
                }
                if (GOOGLE_PRODUCTS_PRODUCT_TYPE == 'default' && GOOGLE_PRODUCTS_DEFAULT_PRODUCT_TYPE != '')
                {
                    $product_type = htmlentities(GOOGLE_PRODUCTS_DEFAULT_PRODUCT_TYPE);
                }
                else
                {
                    $product_type = $categories_list;
                    //print_r($product_type);
                    //die();
                    //$product_type = explode(',', $product_type);
                    if (GOOGLE_PRODUCTS_PRODUCT_TYPE == 'top')
                    {
                        $product_type = $product_type[0];
                    }
                    elseif (GOOGLE_PRODUCTS_PRODUCT_TYPE == 'bottom')
                    {
                        $bottom_level = $product_type[sizeof($product_type) + 1]; // sets last category in array as bottom-level
                        $product_type = $bottom_level;
                    }
                    elseif (GOOGLE_PRODUCTS_PRODUCT_TYPE == 'full')
                    {
                        $full_path    = implode(",", $product_type);
                        $product_type = $full_path;
                    }
                }
                if ((strlen($products_description) >= 15))
                {
                    // check if product has attributes
                    if (zen_has_product_attributes($products->fields['products_id'], false))
                    {
                        // check if stock by attributes
                        $sba_failed = true; // default
                        if ($stock_attributes)
                        {
                            // get attributes
                            if (GOOGLE_PRODUCTS_SWITCH_STOCK_PLUGIN == 'numinixproductvariants' && defined('TABLE_PRODUCTS_VARIANTS_ATTRIBUTES_STOCK'))
                            {
                                $stock_attributes = $db->Execute("SELECT stock_id, quantity FROM " . TABLE_PRODUCTS_VARIANTS_ATTRIBUTES_STOCK . "
                                                    WHERE products_id = " . $products->fields['products_id'] . "
                                                    ORDER BY stock_id ASC;");

                            }
                            elseif (defined('TABLE_PRODUCTS_WITH_ATTRIBUTES_STOCK'))
                            {
                                $stock_attributes = $db->Execute("SELECT stock_id, stock_attributes, quantity FROM " . TABLE_PRODUCTS_WITH_ATTRIBUTES_STOCK . "
                                                    WHERE products_id = " . $products->fields['products_id'] . "
                                                    ORDER BY stock_id ASC;");
                            }
                            else
                            {
                                $stock_attributes = false;
                            }

                            if ($stock_attributes != false && $stock_attributes->RecordCount() > 0)
                            {
                                // check for acceptable variant attributes
                                $variant_count = 0;
                                while (!$stock_attributes->EOF)
                                {
                                    $ean_set             = $isbn_set = $upc_set = $jan_set = $gtin_set = false;
                                    $variants_title      = $productstitle;
                                    $variants_price      = $price;
                                    $variants_sale_price = $sale_price;
                                    $custom_fields       = array();
                                    $unique_identifiers            = 0;
                                    if (GOOGLE_PRODUCTS_SWITCH_STOCK_PLUGIN == 'numinixproductvariants')
                                    {
                                        $attribute_ids          = array();
                                        $stock_attributes_group = $db->Execute('SELECT products_attributes_id FROM ' . TABLE_PRODUCTS_VARIANTS_ATTRIBUTES_GROUPS . ' WHERE stock_id = ' . (int) $stock_attributes->fields['stock_id']);

                                        if(!is_null(TABLE_PRODUCTS_VARIANTS_ATTRIBUTES_FIELDS)){
                                            $variant_attributes = $db->Execute('SELECT pvaa.products_variants_attributes_name,pvaa.products_variants_attributes_value FROM ' . TABLE_PRODUCTS_VARIANTS_ATTRIBUTES_ATTRIBUTES . ' pvaa INNER JOIN ' . TABLE_PRODUCTS_VARIANTS_ATTRIBUTES_FIELDS . ' pvaf on pvaf.fields = pvaa.products_variants_attributes_name WHERE pvaa.stock_id = ' . $stock_attributes->fields['stock_id'] . ' AND pvaa.products_variants_attributes_name != "'.NMX_PRODUCT_VARIANTS_SKU.'" AND pvaf.products_id = ' . $products->fields['products_id'] . ' AND pvaa.products_variants_attributes_value != ""');

                                            if($variant_attributes->RecordCount() > 0){
                                                while(!$variant_attributes->EOF){
                                                        switch ($variant_attributes->fields['products_variants_attributes_name']) {
                                                            case NUMINIX_PRODUCTS_VARIANTS_UPC:
                                                                if (!array_key_exists(strtolower(NUMINIX_PRODUCTS_VARIANTS_UPC), $custom_fields))
                                                                {
                                                                    $custom_fields[strtolower(NUMINIX_PRODUCTS_VARIANTS_UPC)] = strtolower($variant_attributes->fields['products_variants_attributes_value']);
                                                                    $unique_identifiers++;
                                                                    $upc_set = true;
                                                                }
                                                                break;
                                                            case NUMINIX_PRODUCTS_VARIANTS_EAN:
                                                                if (!array_key_exists(strtolower(NUMINIX_PRODUCTS_VARIANTS_EAN), $custom_fields))
                                                                {
                                                                    $custom_fields[strtolower(NUMINIX_PRODUCTS_VARIANTS_EAN)] = strtolower($variant_attributes->fields['products_variants_attributes_value']);
                                                                    $unique_identifiers++;
                                                                    $ean_set = true;
                                                                }
                                                                break;
                                                            case NUMINIX_PRODUCTS_VARIANTS_ISBN:
                                                                if (!array_key_exists(strtolower(NUMINIX_PRODUCTS_VARIANTS_ISBN), $custom_fields))
                                                                {
                                                                    $custom_fields[strtolower(NUMINIX_PRODUCTS_VARIANTS_ISBN)] = strtolower($variant_attributes->fields['products_variants_attributes_value']);
                                                                    $unique_identifiers++;
                                                                    $isbn_set = true;
                                                                }
                                                                break;
                                                            default:
                                                        }
                                                    $variant_attributes->MoveNext();
                                                }
                                            }
                                        }

                                        if (GOOGLE_PRODUCTS_SHOW_ATTRIBUTE_PRICING == 'true')
                                        {
                                            $product_url_add = '&stock_id=' . (int) $stock_attributes->fields['stock_id'] . $language_url_add;
                                            //$link .= $product_url_add;
                                        }
                                        while (!$stock_attributes_group->EOF)
                                        {
                                            $attribute_ids[] = $stock_attributes_group->fields['products_attributes_id'];
                                            $stock_attributes_group->MoveNext();
                                        }
                                    }
                                    else
                                    {
                                        $attribute_ids = explode(',', $stock_attributes->fields['stock_attributes']);
                                    }
                                    $variant          = false;
                                    
                                    //will be used later to check if interaction attribute is variant or not
                                    $only_variants_attribute_ids = $attribute_ids;
                                    
                                    // add all other attributes to the array
                                    $attributes_query = "SELECT products_attributes_id FROM " . TABLE_PRODUCTS_ATTRIBUTES . " WHERE products_id = " . $products->fields['products_id'] . " ORDER BY products_attributes_id ASC;";
                                    if (sizeof($attribute_ids) > 0)
                                        $attributes_query = str_replace('WHERE', "WHERE products_attributes_id NOT IN (" . implode(',', $attribute_ids) . ") AND ", $attributes_query);
                                    $attributes = $db->Execute($attributes_query);
                                    if ($attributes->RecordCount() > 0)
                                    {
                                        while (!$attributes->EOF)
                                        {
                                            if (!in_array($attributes->fields['products_attributes_id'], $attribute_ids))
                                            {
                                                $attribute_ids[] = $attributes->fields['products_attributes_id'];
                                            }
                                            $attributes->MoveNext();
                                        }
                                    }
                                    
                                    $google_product_category_check = false;
                                    $adwords_attributes            = false;
                                    foreach ($attribute_ids as $attribute_id)
                                    {
                                        $options = $db->Execute("SELECT po.products_options_name, pov.products_options_values_name, pa.options_values_price, pa.price_prefix, pa.products_attributes_weight, pa.products_attributes_weight_prefix FROM " . TABLE_PRODUCTS_ATTRIBUTES . " pa
                                                 LEFT JOIN " . TABLE_PRODUCTS_OPTIONS_VALUES . " pov ON (pov.products_options_values_id = pa.options_values_id)
                                                 LEFT JOIN " . TABLE_PRODUCTS_OPTIONS . " po ON (po.products_options_id = pa.options_id)
                                                 WHERE pa.products_attributes_id = " . (int) $attribute_id . "
                                                 LIMIT 1;");
                                        // create variants
                                        if ($options->RecordCount() > 0)
                                        {
                                            $options_name        = strtolower($options->fields['products_options_name']);
                                            $options_values_name = $googleProducts->googleProducts_xml_sanitizer($options->fields['products_options_values_name']);
                                            //echo !in_array($options_name, $attributes_used) . ' ' . $googleProducts->strapos(strtolower($options_values_name), array('please choose', 'please select')) . '<br />';
                                            if ($googleProducts->strapos(strtolower($options_values_name), array(
                                                'choose',
                                                'please select'
                                            )) === FALSE)
                                            {
                                                switch (true)
                                                {
                                                    case (stripos($options_name, 'color') !== FALSE):
                                                    case (stripos($options_name, 'colour') !== FALSE):
                                                        if (!array_key_exists('color', $custom_fields))
                                                        {
                                                            $custom_fields['color'] = strtolower($options_values_name);
                                                            $variants_title .= ' ' . $options_values_name;
                                                            $variant = true;
                                                        }
                                                        break;
                                                    case (stripos($options_name, 'material') !== FALSE):
                                                        if (!array_key_exists('material', $custom_fields))
                                                        {
                                                            $custom_fields['material'] = strtolower($options_values_name);
                                                            //$variants_title .= ' ' . $options_values_name;
                                                            $variant                   = true;
                                                        }
                                                        break;
                                                    case (stripos($options_name, 'pattern') !== FALSE):
                                                        if (!array_key_exists('pattern', $custom_fields))
                                                        {
                                                            $custom_fields['pattern'] = strtolower($options_values_name);
                                                            //$variants_title .= ' ' . $options_values_name;
                                                            $variant                  = true;
                                                        }
                                                        break;
                                                    case (stripos($options_name, 'size system') !== FALSE):
                                                        if (!array_key_exists('size_system', $custom_fields))
                                                        {
                                                            $custom_fields['size_system'] = strtolower($options_values_name);
                                                            //$variants_title .= ' ' . $options_values_name;
                                                            $variant                      = true;
                                                        }
                                                        break;
                                                    case (stripos($options_name, 'size type') !== FALSE):
                                                        if (!array_key_exists('size_type', $custom_fields))
                                                        {
                                                            $custom_fields['size_type'] = strtolower($options_values_name);
                                                            //$variants_title .= ' ' . $options_values_name;
                                                            $variant                    = true;
                                                        }
                                                        break;
                                                    case (stripos($options_name, 'size') !== FALSE):
                                                        if (!array_key_exists('size', $custom_fields))
                                                        {
                                                            $custom_fields['size'] = strtolower($options_values_name);
                                                            $variants_title .= ' ' . $options_values_name;
                                                            $variant = true;
                                                        }
                                                        break;
                                                    case (stripos($options_name, 'age group') !== FALSE):
                                                        if (!array_key_exists('age_group', $custom_fields))
                                                        {
                                                            $custom_fields['age_group'] = strtolower($options_values_name);
                                                            //$variants_title .= ' ' . $options_values_name;
                                                            $variant                    = true;
                                                        }
                                                        break;
                                                    case (stripos($options_name, 'gender') !== FALSE):
                                                        if (!array_key_exists('gender', $custom_fields))
                                                        {
                                                            $custom_fields['gender'] = strtolower($options_values_name);
                                                            //$variants_title .= ' ' . $options_values_name;
                                                            $variant                 = true;
                                                        }
                                                        break;
                                                    case ($options_name == 'google product category'):
                                                        if (!array_key_exists('google_product_category', $custom_fields))
                                                        {
                                                            $google_product_category_check            = true;
                                                            $custom_fields['google_product_category'] = strtolower($options_values_name);
                                                        }
                                                        break;
                                                    case ($options_name === 'upc'):
                                                        if (!array_key_exists('upc', $custom_fields))
                                                        {
                                                            $custom_fields['upc'] = strtolower($options_values_name);
                                                            $unique_identifiers++;
                                                            $upc_set = true;
                                                        }
                                                        break;
                                                    case ($options_name == 'ean'):
                                                        if (!array_key_exists('ean', $custom_fields))
                                                        {
                                                            $custom_fields['ean'] = strtolower($options_values_name);
                                                            $unique_identifiers++;
                                                            $ean_set = true;
                                                        }
                                                        break;
                                                    case ($options_name == 'isbn'):
                                                        if (!array_key_exists('isbn', $custom_fields))
                                                        {
                                                            $custom_fields['isbn'] = strtolower($options_values_name);
                                                            $unique_identifiers++;
                                                            $isbn_set = true;
                                                        }
                                                        break;
                                                    case ($options_name == 'jan'):
                                                        if (!array_key_exists('jan', $custom_fields))
                                                        {
                                                            $custom_fields['jan'] = strtolower($options_values_name);
                                                            $unique_identifiers++;
                                                            $jan_set = true;
                                                        }
                                                        break;
                                                    case ($options_name == 'gtin'):
                                                        if (!array_key_exists('gtin', $custom_fields))
                                                        {
                                                            $custom_fields['gtin'] = strtolower($options_values_name);
                                                            $unique_identifiers++;
                                                            $gtin_set = true;
                                                        }
                                                        break;
                                                    case ($options_name == 'adwords grouping'):
                                                        if (!array_key_exists('adwords_grouping', $custom_fields))
                                                        {
                                                            $adwords_attributes                = true;
                                                            $custom_fields['adwords_grouping'] = strtolower($options_values_name);
                                                        }
                                                        break;
                                                    case ($options_name == 'adwords labels'):
                                                        if (!array_key_exists('adwords_labels', $custom_fields))
                                                        {
                                                            $adwords_attributes              = true;
                                                            $custom_fields['adwords_labels'] = strtolower($options_values_name);
                                                        }
                                                        break;
                                                    case ($options_name == 'adwords publish'):
                                                        if (!array_key_exists('adwords_publish', $custom_fields))
                                                        {
                                                            $custom_fields['adwords_publish'] = strtolower($options_values_name);
                                                        }
                                                        break;
                                                    default:
                                                        // only supporting English, a properly coded site shouldn't need this condition but use JavaScript to add the default option
                                                        
                                                        //if the attribute is not a variant and none of the expected attributes, don't include it in the name
                                                        if(in_array($attribute_id, $only_variants_attribute_ids)){
                                                            $variants_title .= ' ' . $options_values_name;
                                                        }
                                                        $variant = true;
                                                        break;
                                                }
                                            }
                                            else
                                            {
                                                continue;
                                            }

                                            if (GOOGLE_PRODUCTS_SHOW_ATTRIBUTE_PRICING == 'true')
                                            {
                                                if ($options->fields['price_prefix'] == '-')
                                                {
                                                    $variants_price -= $options->fields['options_values_price'];
                                                    if ($variants_sale_price > 0)
                                                        $variants_sale_price -= $options->fields['options_values_price'];
                                                }
                                                else
                                                {
                                                    $variants_price += $options->fields['options_values_price'];
                                                    if ($variants_sale_price > 0)
                                                        $variants_sale_price += $options->fields['options_values_price'];
                                                }
                                            }
                                            $variants_weight = $products->fields['products_weight'];
                                            if ($options->fields['products_attributes_weight_prefix'] == '-')
                                            {
                                                $variants_weight -= $options->fields['products_attributes_weight'];
                                            }
                                            else
                                            {
                                                $variants_weight += $options->fields['products_attributes_weight'];
                                            }
                                            $variants_quantity = $stock_attributes->fields['quantity'];
                                        }
                                    }
                                    if ($variant == false)
                                    {
                                        // no matching variants found, move to next stock combination
                                        $stock_attributes->MoveNext();
                                        continue;
                                    }
                                    else
                                    {
                                        $sba_failed = false;
                                        $total_products++;
                                        $products_processed++;
                                        $variant_count++;
                                        $xmlWriter->startElement('item');
                                        if ($variant_count == 1)
                                        {
                                            $xmlWriter->writeElement('g:id', $id);
                                        }
                                        else
                                        {
                                            $xmlWriter->writeElement('g:item_group_id', $id);
                                            $xmlWriter->writeElement('g:id', $id . '-' . $stock_attributes->fields['stock_id']);
                                        }
                                        if ($adwords_attributes == false && GOOGLE_PRODUCTS_AUTOMATIC_ADWORDS == 'true')
                                        {
                                            $custom_fields = $googleProducts->google_create_adwords_attributes($products->fields['products_id'], $custom_fields, $categories_list);
                                        }
                                        foreach ($custom_fields as $key => $value)
                                        {
                                            $xmlWriter->startElement('g:' . $key);
                                            $xmlWriter->writeCData($value);
                                            $xmlWriter->endElement();
                                        }
                                        if ($variants_sale_price < $variants_price && $variants_sale_price > 0)
                                        {
                                            if ($products_quantity_order_units > 1) {
                                                $xmlWriter->writeElement('g:unit_pricing_base_measure', '1 ct');
                                                $xmlWriter->writeElement('g:unit_pricing_measure', $products_quantity_order_units.' ct');
                                                $xmlWriter->writeElement('g:sale_price', number_format($variants_sale_price*$products_quantity_order_units, 2, '.', '') . ' ' . $currency_code);
                                                $xmlWriter->writeElement('g:price', number_format($variants_price*$products_quantity_order_units, 2, '.', '') . ' ' . $currency_code);
                                            } else {
                                                if ($products_quantity_order_units > 1) {
                                                    $xmlWriter->writeElement('g:unit_pricing_base_measure', number_format($variants_sale_price, 2, '.', '') . 'ct');
                                                    $xmlWriter->writeElement('g:unit_pricing_measure', '1ct');  
                                                    $xmlWriter->writeElement('g:sale_price', number_format($variants_sale_price*$products_quantity_order_units, 2, '.', '') . ' ' . $currency_code);
                                                    $xmlWriter->writeElement('g:price', number_format($variants_price*$products_quantity_order_units, 2, '.', '') . ' ' . $currency_code);  
                                                } else {
                                                    $xmlWriter->writeElement('g:sale_price', number_format($variants_sale_price, 2, '.', '') . ' ' . $currency_code);
                                                    $xmlWriter->writeElement('g:price', number_format($variants_price, 2, '.', '') . ' ' . $currency_code);
                                                }
                                            }
                                        }
                                        elseif ($variants_price > 0)
                                        {
                                            if ($products_quantity_order_units > 1) {
                                                $xmlWriter->writeElement('g:unit_pricing_base_measure', '1 ct');
                                                $xmlWriter->writeElement('g:unit_pricing_measure', $products_quantity_order_units.' ct');
                                                $xmlWriter->writeElement('g:price', number_format($variants_price*$products_quantity_order_units, 2, '.', '') . ' ' . $currency_code);
                                            } else {
                                                if ($products_quantity_order_units > 1) {
                                                    $xmlWriter->writeElement('g:unit_pricing_base_measure', number_format($variants_price, 2, '.', '') . 'ct');
                                                    $xmlWriter->writeElement('g:unit_pricing_measure', '1ct');  
                                                        $xmlWriter->writeElement('g:price', number_format($variants_price*$products_quantity_order_units, 2, '.', '') . ' ' . $currency_code);  
                                                } else {
                                                    $xmlWriter->writeElement('g:price', number_format($variants_price, 2, '.', '') . ' ' . $currency_code);
                                                }
                                            }
                                        }
                                        else
                                        {
                                            // skip this variant
                                            $stock_attributes->MoveNext();
                                            continue;
                                        }
                                        if (GOOGLE_PRODUCTS_TAX_DISPLAY == 'true' && GOOGLE_PRODUCTS_TAX_COUNTRY == 'US' && $tax_rate != '')
                                        {
                                            if (GOOGLE_PRODUCTS_TAX_REGION != '')
                                            {
                                                $regions = explode(',', GOOGLE_PRODUCTS_TAX_REGION);
                                                foreach ($regions as $region)
                                                {
                                                    if (trim($region) != '')
                                                    {
                                                        $xmlWriter->startElement('g:tax');
                                                        $xmlWriter->writeElement('g:country', GOOGLE_PRODUCTS_TAX_COUNTRY);
                                                        $xmlWriter->writeElement('g:region', trim($region));
                                                        if (GOOGLE_PRODUCTS_TAX_SHIPPING == 'y')
                                                        {
                                                            $xmlWriter->writeElement('g:tax_ship', GOOGLE_PRODUCTS_TAX_SHIPPING);
                                                        }
                                                        $xmlWriter->writeElement('g:rate', $tax_rate);
                                                        $xmlWriter->endElement();
                                                    }
                                                }
                                            }
                                            else
                                            {
                                                $xmlWriter->startElement('g:tax');
                                                $xmlWriter->writeElement('g:country', GOOGLE_PRODUCTS_TAX_COUNTRY);
                                                if (GOOGLE_PRODUCTS_TAX_SHIPPING == 'y')
                                                {
                                                    $xmlWriter->writeElement('g:tax_ship', GOOGLE_PRODUCTS_TAX_SHIPPING);
                                                }
                                                $xmlWriter->writeElement('g:rate', $tax_rate);
                                                $xmlWriter->endElement();
                                            }
                                        }
                                        $xmlWriter->startElement('title');
                                        $xmlWriter->writeCData(substr($variants_title, 0, 150 - 12));
                                        $xmlWriter->endElement();

                                        if (STOCK_CHECK == 'true')
                                        {
                                            if ($variants_quantity > 0)
                                            {
                                                if ($products_quantity_order_units > $variants_quantity) {
                                                    $xmlWriter->writeElement('g:availability', 'out of stock');
                                                } else {
                                                    $xmlWriter->writeElement('g:availability', 'in stock');
                                                }
                                            }
                                            else
                                            {
                                                // are back orders allowed?
                                                if (STOCK_ALLOW_CHECKOUT == 'true')
                                                {
                                                    if (($products->fields['products_date_available'] != 'NULL') || (strtotime($products->fields['products_date_available']) < time()))
                                                    {
                                                        $xmlWriter->writeElement('g:availability', 'in stock');
                                                    }
                                                    else
                                                    {
                                                        $xmlWriter->writeElement('g:availability_date', date('Y-m-d', strtotime($products->fields['products_date_available']) . 'T00:00:00'));
                                                        $xmlWriter->writeElement('g:availability', 'preorder');
                                                    }
                                                }
                                                else
                                                {
                                                    $xmlWriter->writeElement('g:availability', 'out of stock');
                                                }
                                            }
                                        }
                                        else
                                        {
                                            $xmlWriter->writeElement('g:availability', 'in stock');
                                        }
                                        if (GOOGLE_PRODUCTS_WEIGHT == 'true' && $variants_weight >= 0)
                                        {
                                            $xmlWriter->writeElement('g:shipping_weight', $variants_weight . ' ' . str_replace(array(
                                                'pounds',
                                                'kilograms'
                                            ), array(
                                                'lb',
                                                'kg'
                                            ), GOOGLE_PRODUCTS_UNITS));
                                        }
                                        if(GOOGLE_PRODUCTS_SHIPPING_LABEL == 'categories') {
                                            $xmlWriter->writeElement('g:shipping_label', $products->fields['master_categories_id']);
                                        } else {
                                            $xmlWriter->writeElement('g:shipping_label', $products->fields['products_id']);
                                        }
                                        if (defined('GOOGLE_PRODUCTS_SHIPPING_METHOD') && (GOOGLE_PRODUCTS_SHIPPING_METHOD != '') && (GOOGLE_PRODUCTS_SHIPPING_METHOD != 'none'))
                                        {
                                            $shipping_rate = $googleProducts->shipping_rate(GOOGLE_PRODUCTS_SHIPPING_METHOD, $percategory, $freerules, GOOGLE_PRODUCTS_RATE_ZONE, $products->fields['products_weight'], $variants_price, $products->fields['products_id']);
                                            if ((float) $shipping_rate >= 0)
                                            {
                                                $xmlWriter->startElement('g:shipping');
                                                if (GOOGLE_PRODUCTS_SHIPPING_COUNTRY != '')
                                                {
                                                    $xmlWriter->writeElement('g:country', $googleProducts->get_countries_iso_code_2(GOOGLE_PRODUCTS_SHIPPING_COUNTRY));
                                                }
                                                if (GOOGLE_PRODUCTS_SHIPPING_REGION != '')
                                                {
                                                    $xmlWriter->writeElement('g:region', GOOGLE_PRODUCTS_SHIPPING_REGION);
                                                }
                                                if (GOOGLE_PRODUCTS_SHIPPING_SERVICE != '')
                                                {
                                                    $xmlWriter->writeElement('g:service', GOOGLE_PRODUCTS_SHIPPING_SERVICE);
                                                }
                                                $xmlWriter->writeElement('g:price', (float) $shipping_rate . ' ' . $currency_code);
                                                $xmlWriter->endElement();
                                            }
                                        }

                                        //re-generate links to include stock_id

                                        //$link = ($products->fields['type_handler'] ? $products->fields['type_handler'] : 'product') . '_info';
                                        $link       = zen_get_info_page($products->fields['products_id']);
                                        $cPath_href = (GOOGLE_PRODUCTS_USE_CPATH == 'true' ? 'cPath=' . implode('_', $cPath) . '&' : '');
                                        if (!strlen($product_url_add))
                                        {
                                            $product_url_add = '';
                                        }
                                        $link = zen_href_link($link, $cPath_href . 'products_id=' . (int) $products->fields['products_id'] . $product_url_add, 'NONSSL', false);

                                        // add universal elements/attributes to products
                                        $googleProducts->universal_attributes($products);
                                        $xmlWriter->endElement(); // end item

                                        // Save variant on file to avoid timeout and memory exaustion
                                        fwrite($fp, $xmlWriter->outputMemory(true));
                                        $googleProducts->google_output_debug();
                                        ob_flush();
                                        flush();
                                    }
                                
                                    $stock_attributes->MoveNext();
                                }
                            }
                        }
                        // if no variants
                        if (($sba_failed || !$stock_attributes || !($stock_attributes->RecordCount() > 0)) && $price > 0)
                        {
                            $unique_identifiers = 0;
                            $ean_set            = $isbn_set = $upc_set = $jan_set = $gtin_set = false;
                            // product still has attributes
                            $attribute_ids      = array();
                            // add attributes to the array
                            $attributes         = $db->Execute("SELECT po.products_options_name, pov.products_options_values_name FROM " . TABLE_PRODUCTS_ATTRIBUTES . " pa
                                               LEFT JOIN " . TABLE_PRODUCTS_OPTIONS_VALUES . " pov ON (pov.products_options_values_id = pa.options_values_id)
                                               LEFT JOIN " . TABLE_PRODUCTS_OPTIONS . " po ON (po.products_options_id = pa.options_id)
                                               WHERE pa.products_id = " . (int) $products->fields['products_id'] . "
                                               ORDER BY products_attributes_id ASC;");
                            if ($attributes->RecordCount() > 0)
                            {
                                /*
                                while (!$attributes->EOF) {
                                if (!in_array($attributes->fields['products_attributes_id'], $attribute_ids)) {
                                $attribute_ids[] = $attributes->fields['products_attributes_id'];
                                }
                                $attributes->MoveNext();
                                }*/
                                $google_product_category_check = false;
                                $custom_fields                 = array();
                                $adwords_attributes            = false;
                                while (!$attributes->EOF)
                                {
                                    //foreach($attribute_ids as $attribute_id) {
                                    /*
                                    $options = $db->Execute("SELECT po.products_options_name, pov.products_options_values_name FROM " . TABLE_PRODUCTS_ATTRIBUTES . " pa
                                    LEFT JOIN " . TABLE_PRODUCTS_OPTIONS_VALUES . " pov ON (pov.products_options_values_id = pa.options_values_id)
                                    LEFT JOIN " . TABLE_PRODUCTS_OPTIONS . " po ON (po.products_options_id = pa.options_id)
                                    WHERE pa.products_attributes_id = " . (int)$attribute_id . "
                                    LIMIT 1;");
                                    */

                                    $variant_key = $googleProducts->strapos(strtolower($attributes->fields['products_options_name']), $possible_variant_attributes);
                                    if ($variant_key !== FALSE)
                                    {
                                        $options_name = str_replace(' ', '_', strtolower($variant_key));
                                        // check that we haven't already processed an option for this variant and that the option isn't a default value like please choose or please select (obviously this has limitations)
                                        if (array_key_exists($options_name, $custom_fields) || $googleProducts->strapos(strtolower($attributes->fields['products_options_values_name']), array(
                                            'choose',
                                            'please select'
                                        )) !== FALSE)
                                        {
                                            // we already have a value for this attribute, move to the next attribute
                                            $attributes->MoveNext();
                                            continue;
                                        }
                                        if ($options_name == 'google_product_category')
                                        {
                                            $google_product_category_check = true;
                                        }
                                        else if ($options_name == 'colour')
                                        {
                                            $options_name = 'color';
                                        }
                                        else if (in_array($options_name, array(
                                                'adwords_labels',
                                                'adwords_grouping'
                                            )))
                                        {
                                            $adwords_attributes = true;
                                        }
                                        switch ($options_name)
                                        {
                                            case 'upc':
                                                $upc_set = true;
                                                break;
                                            case 'isbn':
                                                $isbn_set = true;
                                                break;
                                            case 'ean':
                                                $ean_set = true;
                                                break;
                                            case 'jan':
                                                $jan_set = true;
                                                break;
                                            case 'gtin':
                                                $gtin_set = true;
                                                break;
                                        }
                                        $custom_fields[(string) $options_name] = strtolower($googleProducts->googleProducts_xml_sanitizer($attributes->fields['products_options_values_name']));
                                    }
                                    $attributes->MoveNext();
                                }
                                if ($adwords_attributes == false && GOOGLE_PRODUCTS_AUTOMATIC_ADWORDS == 'true')
                                {
                                    $custom_fields = $googleProducts->google_create_adwords_attributes($products->fields['products_id'], $custom_fields, $categories_list);
                                }
                            }
                            //$googleProducts->create_regular_product($products);

                            if ($gb_map_enabled && $products->fields['map_enabled'] == '1'){
                                $googleProducts->create_regular_product($products,$products->fields['map_enabled']);
                            } else {
                                $googleProducts->create_regular_product($products);
                            }

                            foreach ($custom_fields as $key => $value)
                            {
                                $xmlWriter->startElement('g:' . $key);
                                $xmlWriter->writeCData($value);
                                $xmlWriter->endElement();
                            }
                            // add universal elements/attributes to products
                            $googleProducts->universal_attributes($products);
                            // finalize item
                            $xmlWriter->endElement(); // end item
                            $products_processed++;
                        }
                        // if product doesn't have attributes, create a regular item without attributes
                    }
                    elseif ($price > 0)
                    {
                        $unique_identifiers = 0;
                        $ean_set            = $isbn_set = $upc_set = $jan_set = $gtin_set = false;
                        if($products->fields['map_enabled'] == '1'){
                            $googleProducts->create_regular_product($products,$products->fields['map_enabled']);
                        } else {
                            $googleProducts->create_regular_product($products);
                        }
                        // add universal elements/attributes to products
                        $googleProducts->universal_attributes($products);
                        // finalize item
                        $xmlWriter->endElement(); // end item
                        $products_processed++;
                    }
                }
                else
                {
                    $skipped[$products->fields['products_id']] = 'description length less than 15 chars';
                }
                //}
                fwrite($fp, $xmlWriter->outputMemory(true));
                $googleProducts->google_output_debug();
                ob_flush();
                flush();
                $products->MoveNext();
            }
            $xmlWriter->endElement(); // end channel
            $xmlWriter->endElement(); // end rss
            $xmlWriter->endDocument(); // end xml
            // Write uncompressed file
            fwrite($fp, $xmlWriter->outputMemory(true));
            fflush($fp);
            // release the lock
            flock($fp, LOCK_UN);
            fclose($fp);
            unlink($lockfile);

            $googleProducts->google_output_debug();
            if (GOOGLE_PRODUCTS_COMPRESS == 'true')
            {
                $gzcontent = file_get_contents($outfile);
                unlink($outfile);
                $outfile .= '.gz'; // Append .gz to end of file name
                $gz = gzopen("$outfile", 'w9'); // Open file for writing, 0 (no) to 9 (maximum) compression
                gzwrite($gz, $gzcontent); // Write compressed file
                gzclose($gz); // Close file handler
            }
            break;
    }

    $timer_feed = $googleProducts->microtime_float() - $stimer_feed;

    echo '<p>' . TEXT_GOOGLE_PRODUCTS_FEED_COMPLETE . ' ' . GOOGLE_PRODUCTS_TIME_TAKEN . ' ' . sprintf("%f " . TEXT_GOOGLE_PRODUCTS_FEED_SECONDS, number_format($timer_feed, 6)) . ' ' . $products_processed . ' of ' . $total_products . ' ' . TEXT_GOOGLE_PRODUCTS_FEED_RECORDS . '</p>';
    
}

if (isset($upload) && $upload == "yes")
{
    echo TEXT_GOOGLE_PRODUCTS_UPLOAD_STARTED . NL;
    if ($upload_file == '')
        $upload_file = $outfile; // use file just created if no upload file was specified
    if ($googleProducts->ftp_file_upload(GOOGLE_PRODUCTS_SERVER, GOOGLE_PRODUCTS_USERNAME, GOOGLE_PRODUCTS_PASSWORD, $upload_file))
    {
        echo TEXT_GOOGLE_PRODUCTS_UPLOAD_OK . NL;
        $db->execute("update " . TABLE_CONFIGURATION . " set configuration_value = '" . date("Y/m/d H:i:s") . "' where configuration_key='GOOGLE_PRODUCTS_UPLOADED_DATE'");
    }
    else
    {
        echo TEXT_GOOGLE_PRODUCTS_UPLOAD_FAILED . NL;
    }
}
?>
</body>
</html>