<?php

/**
 * Ceon Advanced Shipper Checkout Process Shipping Date Recording.
 *
 * @package     ceon_advanced_shipper
 * @author      Conor Kerr <zen-cart.advanced-shipper@dev.ceon.net>
 * @copyright   Copyright 2007-2012 Ceon
 * @copyright   Portions Copyright 2003-2006 Zen Cart Development Team
 * @link        http://dev.ceon.net/web/zen-cart/advanced-shipper
 * @license     http://www.gnu.org/copyleft/gpl.html   GNU Public License V2.0
 * @version     $Id: class.advshipperCheckoutProcess.php 989 2012-03-29 09:09:52Z conor $
 */

// {{{ class advshipperCheckoutProcess

/**
 * Records the shipping date for the current order, if a dated Advanced Shipper method was selected as the shipping
 * method for the order.
 *
 * @package     ceon_advanced_shipper
 * @author      Conor Kerr <zen-cart.advanced-shipper@dev.ceon.net>
 * @copyright   Copyright 2007-2012 Ceon
 * @copyright   Portions Copyright 2003-2006 Zen Cart Development Team
 * @link        http://dev.ceon.net/web/zen-cart/advanced-shipper
 * @license     http://www.gnu.org/copyleft/gpl.html   GNU Public License V2.0
 * @version     $Id: class.advshipperCheckoutProcess.php 989 2012-03-29 09:09:52Z conor $
 */
class advshipperCheckoutProcess extends base
{
	
//	function advshipperCheckoutProcess() // Uncomment for early PHP
	function __construct() // Used for PHP 7.0 compatibility starting in PHP 5
	{
//		global $zco_notifier;
		
//		$zco_notifier->attach($this, 
		$this->attach($this,
			array(
				'NOTIFY_CHECKOUT_PROCESS_AFTER_ORDER_CREATE'
				)
			);
	}
	
	function update($callingClass, $notifier, $paramsArray)
	{
		global $db, $order, $shipping_modules, $insert_id;
		
		// Did the order use a dated Advanced Shipper method?
		list($module, $method) = explode('_', $order->info['shipping_module_code']);
		
		if ($module == 'advshipper') {
			// Rebuild the quote so the timestamp can be identified/recorded			
			$quote = $shipping_modules->quote($method, $module);
			
			$shipping_ts = $quote[0]['methods'][0]['shipping_ts'];
			
			if (!is_null($shipping_ts)) {
				// Method has a shipping date so must be recorded!
				$order_shipping_record_query = "
					INSERT INTO
						" . TABLE_ADVANCED_SHIPPER_ORDERS . "
						(
						zen_order_id,
						shipping_ts,
						shipping_method
						)
					VALUES
						(
						:zen_order_id:,
						:shipping_ts:,
						:shipping_method:
						);";
					
				$order_shipping_record_query =
					$db->bindVars($order_shipping_record_query, ':zen_order_id:', $insert_id, 'integer');
				
				$order_shipping_record_query = $db->bindVars($order_shipping_record_query, ':shipping_ts:',
					date('Y-m-d H:i:00', $shipping_ts), 'date');
				
				$order_shipping_record_query = $db->bindVars($order_shipping_record_query, ':shipping_method:',
					$order->info['shipping_method'], 'string');
				
				$order_shipping_record_result = $db->Execute($order_shipping_record_query);
			}
		}
	}
}

// }}}
 
