<?php
/**
 * NOTE: This class is auto generated by the swagger code generator program. 
 * https://github.com/swagger-api/swagger-codegen 
 * Do not edit the class manually.
 */

namespace SquareConnect\Api;

use \SquareConnect\Configuration;
use \SquareConnect\ApiClient;
use \SquareConnect\ApiException;
use \SquareConnect\ObjectSerializer;

/**
 * TerminalApi Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://squareup.com/developers
 */
class TerminalApi
{

    /**
     * API Client
     * @var \SquareConnect\ApiClient instance of the ApiClient
     */
    protected $apiClient;
  
    /**
     * Constructor
     * @param \SquareConnect\ApiClient|null $apiClient The api client to use
     */
    function __construct($apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://connect.squareup.com');
        }
  
        $this->apiClient = $apiClient;
    }
  
    /**
     * Get API client
     * @return \SquareConnect\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }
  
    /**
     * Set the API client
     * @param \SquareConnect\ApiClient $apiClient set the API client
     * @return TerminalApi
     */
    public function setApiClient(ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }
  
    /**
     * cancelTerminalCheckout
     *
     * CancelTerminalCheckout
     * Note: This endpoint is in beta.
     *
     * @param string $checkout_id Unique ID for the desired &#x60;TerminalCheckout&#x60; (required)
     * @return \SquareConnect\Model\CancelTerminalCheckoutResponse
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function cancelTerminalCheckout($checkout_id)
    {
        list($response, $statusCode, $httpHeader) = $this->cancelTerminalCheckoutWithHttpInfo ($checkout_id);
        return $response; 
    }


    /**
     * cancelTerminalCheckoutWithHttpInfo
     *
     * CancelTerminalCheckout
     *
     * @param string $checkout_id Unique ID for the desired &#x60;TerminalCheckout&#x60; (required)
     * @return Array of \SquareConnect\Model\CancelTerminalCheckoutResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function cancelTerminalCheckoutWithHttpInfo($checkout_id)
    {
        
        // verify the required parameter 'checkout_id' is set
        if ($checkout_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $checkout_id when calling cancelTerminalCheckout');
        }
  
        // parse inputs
        $resourcePath = "/v2/terminals/checkouts/{checkout_id}/cancel";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/json'));
        $headerParams['Square-Version'] = "2020-05-28";

        
        
        // path params
        if ($checkout_id !== null) {
            $resourcePath = str_replace(
                "{" . "checkout_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($checkout_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'POST',
                $queryParams, $httpBody,
                $headerParams, '\SquareConnect\Model\CancelTerminalCheckoutResponse'
            );
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SquareConnect\ObjectSerializer::deserialize($response, '\SquareConnect\Model\CancelTerminalCheckoutResponse', $httpHeader), $statusCode, $httpHeader);
                    } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SquareConnect\ObjectSerializer::deserialize($e->getResponseBody(), '\SquareConnect\Model\CancelTerminalCheckoutResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    /**
     * createTerminalCheckout
     *
     * CreateTerminalCheckout
     * Note: This endpoint is in beta.
     *
     * @param \SquareConnect\Model\CreateTerminalCheckoutRequest $body An object containing the fields to POST for the request.  See the corresponding object definition for field details. (required)
     * @return \SquareConnect\Model\CreateTerminalCheckoutResponse
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function createTerminalCheckout($body)
    {
        list($response, $statusCode, $httpHeader) = $this->createTerminalCheckoutWithHttpInfo ($body);
        return $response; 
    }


    /**
     * createTerminalCheckoutWithHttpInfo
     *
     * CreateTerminalCheckout
     *
     * @param \SquareConnect\Model\CreateTerminalCheckoutRequest $body An object containing the fields to POST for the request.  See the corresponding object definition for field details. (required)
     * @return Array of \SquareConnect\Model\CreateTerminalCheckoutResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function createTerminalCheckoutWithHttpInfo($body)
    {
        
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling createTerminalCheckout');
        }
  
        // parse inputs
        $resourcePath = "/v2/terminals/checkouts";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/json'));
        $headerParams['Square-Version'] = "2020-05-28";

        
        
        
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'POST',
                $queryParams, $httpBody,
                $headerParams, '\SquareConnect\Model\CreateTerminalCheckoutResponse'
            );
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SquareConnect\ObjectSerializer::deserialize($response, '\SquareConnect\Model\CreateTerminalCheckoutResponse', $httpHeader), $statusCode, $httpHeader);
                    } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SquareConnect\ObjectSerializer::deserialize($e->getResponseBody(), '\SquareConnect\Model\CreateTerminalCheckoutResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    /**
     * getTerminalCheckout
     *
     * GetTerminalCheckout
     * Note: This endpoint is in beta.
     *
     * @param string $checkout_id Unique ID for the desired &#x60;TerminalCheckout&#x60; (required)
     * @return \SquareConnect\Model\GetTerminalCheckoutResponse
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function getTerminalCheckout($checkout_id)
    {
        list($response, $statusCode, $httpHeader) = $this->getTerminalCheckoutWithHttpInfo ($checkout_id);
        return $response; 
    }


    /**
     * getTerminalCheckoutWithHttpInfo
     *
     * GetTerminalCheckout
     *
     * @param string $checkout_id Unique ID for the desired &#x60;TerminalCheckout&#x60; (required)
     * @return Array of \SquareConnect\Model\GetTerminalCheckoutResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function getTerminalCheckoutWithHttpInfo($checkout_id)
    {
        
        // verify the required parameter 'checkout_id' is set
        if ($checkout_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $checkout_id when calling getTerminalCheckout');
        }
  
        // parse inputs
        $resourcePath = "/v2/terminals/checkouts/{checkout_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/json'));
        $headerParams['Square-Version'] = "2020-05-28";

        
        
        // path params
        if ($checkout_id !== null) {
            $resourcePath = str_replace(
                "{" . "checkout_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($checkout_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'GET',
                $queryParams, $httpBody,
                $headerParams, '\SquareConnect\Model\GetTerminalCheckoutResponse'
            );
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SquareConnect\ObjectSerializer::deserialize($response, '\SquareConnect\Model\GetTerminalCheckoutResponse', $httpHeader), $statusCode, $httpHeader);
                    } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SquareConnect\ObjectSerializer::deserialize($e->getResponseBody(), '\SquareConnect\Model\GetTerminalCheckoutResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    /**
     * searchTerminalCheckouts
     *
     * SearchTerminalCheckouts
     * Note: This endpoint is in beta.
     *
     * @param \SquareConnect\Model\SearchTerminalCheckoutsRequest $body An object containing the fields to POST for the request.  See the corresponding object definition for field details. (required)
     * @return \SquareConnect\Model\SearchTerminalCheckoutsResponse
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function searchTerminalCheckouts($body)
    {
        list($response, $statusCode, $httpHeader) = $this->searchTerminalCheckoutsWithHttpInfo ($body);
        return $response; 
    }


    /**
     * searchTerminalCheckoutsWithHttpInfo
     *
     * SearchTerminalCheckouts
     *
     * @param \SquareConnect\Model\SearchTerminalCheckoutsRequest $body An object containing the fields to POST for the request.  See the corresponding object definition for field details. (required)
     * @return Array of \SquareConnect\Model\SearchTerminalCheckoutsResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function searchTerminalCheckoutsWithHttpInfo($body)
    {
        
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling searchTerminalCheckouts');
        }
  
        // parse inputs
        $resourcePath = "/v2/terminals/checkouts/search";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/json'));
        $headerParams['Square-Version'] = "2020-05-28";

        
        
        
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'POST',
                $queryParams, $httpBody,
                $headerParams, '\SquareConnect\Model\SearchTerminalCheckoutsResponse'
            );
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SquareConnect\ObjectSerializer::deserialize($response, '\SquareConnect\Model\SearchTerminalCheckoutsResponse', $httpHeader), $statusCode, $httpHeader);
                    } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SquareConnect\ObjectSerializer::deserialize($e->getResponseBody(), '\SquareConnect\Model\SearchTerminalCheckoutsResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
}
