<?php
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace SquareConnect\Model;

use \ArrayAccess;
/**
 * CatalogQuickAmountsSettings Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 * @link     https://squareup.com/developers
 * Note: This endpoint is in beta.
 */
class CatalogQuickAmountsSettings implements ArrayAccess
{
    /**
      * Array of property to type mappings. Used for (de)serialization 
      * @var string[]
      */
    static $swaggerTypes = array(
        'option' => 'string',
        'eligible_for_auto_amounts' => 'bool',
        'amounts' => '\SquareConnect\Model\CatalogQuickAmount[]'
    );
  
    /** 
      * Array of attributes where the key is the local name, and the value is the original name
      * @var string[] 
      */
    static $attributeMap = array(
        'option' => 'option',
        'eligible_for_auto_amounts' => 'eligible_for_auto_amounts',
        'amounts' => 'amounts'
    );
  
    /**
      * Array of attributes to setter functions (for deserialization of responses)
      * @var string[]
      */
    static $setters = array(
        'option' => 'setOption',
        'eligible_for_auto_amounts' => 'setEligibleForAutoAmounts',
        'amounts' => 'setAmounts'
    );
  
    /**
      * Array of attributes to getter functions (for serialization of requests)
      * @var string[]
      */
    static $getters = array(
        'option' => 'getOption',
        'eligible_for_auto_amounts' => 'getEligibleForAutoAmounts',
        'amounts' => 'getAmounts'
    );
  
    /**
      * $option Represents the option seller currently uses on Quick Amounts. See [CatalogQuickAmountsSettingsOption](#type-catalogquickamountssettingsoption) for possible values
      * @var string
      */
    protected $option;
    /**
      * $eligible_for_auto_amounts Represents location's eligibility for auto amounts The boolean should be consistent with whether there are AUTO amounts in the `amounts`.
      * @var bool
      */
    protected $eligible_for_auto_amounts;
    /**
      * $amounts Represents a set of Quick Amounts at this location.
      * @var \SquareConnect\Model\CatalogQuickAmount[]
      */
    protected $amounts;

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initializing the model
     */
    public function __construct(array $data = null)
    {
        if ($data != null) {
            if (isset($data["option"])) {
              $this->option = $data["option"];
            } else {
              $this->option = null;
            }
            if (isset($data["eligible_for_auto_amounts"])) {
              $this->eligible_for_auto_amounts = $data["eligible_for_auto_amounts"];
            } else {
              $this->eligible_for_auto_amounts = null;
            }
            if (isset($data["amounts"])) {
              $this->amounts = $data["amounts"];
            } else {
              $this->amounts = null;
            }
        }
    }
    /**
     * Gets option
     * @return string
     */
    public function getOption()
    {
        return $this->option;
    }
  
    /**
     * Sets option
     * @param string $option Represents the option seller currently uses on Quick Amounts. See [CatalogQuickAmountsSettingsOption](#type-catalogquickamountssettingsoption) for possible values
     * @return $this
     */
    public function setOption($option)
    {
        $this->option = $option;
        return $this;
    }
    /**
     * Gets eligible_for_auto_amounts
     * @return bool
     */
    public function getEligibleForAutoAmounts()
    {
        return $this->eligible_for_auto_amounts;
    }
  
    /**
     * Sets eligible_for_auto_amounts
     * @param bool $eligible_for_auto_amounts Represents location's eligibility for auto amounts The boolean should be consistent with whether there are AUTO amounts in the `amounts`.
     * @return $this
     */
    public function setEligibleForAutoAmounts($eligible_for_auto_amounts)
    {
        $this->eligible_for_auto_amounts = $eligible_for_auto_amounts;
        return $this;
    }
    /**
     * Gets amounts
     * @return \SquareConnect\Model\CatalogQuickAmount[]
     */
    public function getAmounts()
    {
        return $this->amounts;
    }
  
    /**
     * Sets amounts
     * @param \SquareConnect\Model\CatalogQuickAmount[] $amounts Represents a set of Quick Amounts at this location.
     * @return $this
     */
    public function setAmounts($amounts)
    {
        $this->amounts = $amounts;
        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset 
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->$offset);
    }
  
    /**
     * Gets offset.
     * @param  integer $offset Offset 
     * @return mixed 
     */
    public function offsetGet($offset)
    {
        return $this->$offset;
    }
  
    /**
     * Sets value based on offset.
     * @param  integer $offset Offset 
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        $this->$offset = $value;
    }
  
    /**
     * Unsets offset.
     * @param  integer $offset Offset 
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->$offset);
    }
  
    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        } else {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this));
        }
    }
}
