<?php

/**
 * Ceon Advanced Shipper Language Definitions.
 *
 * @package     ceon_advanced_shipper
 * @author      Conor Kerr <zen-cart.advanced-shipper@dev.ceon.net>
 * @copyright   Copyright 2007-2012 Ceon
 * @link        http://dev.ceon.net/web/zen-cart/advanced-shipper
 * @license     http://www.gnu.org/copyleft/gpl.html   GNU Public License V2.0
 * @version     $Id: advshipper.php 981 2012-03-27 16:28:46Z conor update v6.0.4 $
 */

if (defined('TEXT_SHIPPING_WEIGHT')) {
define('MODULE_ADVANCED_SHIPPER_TEXT_WEIGHT_UNIT_PLURAL', ucfirst(strtolower(TEXT_SHIPPING_WEIGHT)));
define('MODULE_ADVANCED_SHIPPER_TEXT_WEIGHT_UNIT_SINGULAR', substr(ucfirst(strtolower(TEXT_SHIPPING_WEIGHT)), 0, 2));
}

define('MODULE_ADVANCED_SHIPPER_TEXT_FREE', 'Free');
define('MODULE_ADVANCED_SHIPPER_TEXT_PER', ' per ');

/**
 * The default title for the shipping module.
 *
 * Please Note: The module MUST have a title defined or it will not appear as an option at checkout.
 *
 * If it is preferred not to display a title for the module, please take a look at the FAQ
 * "How can the overall title for the shipping be changed..."
 */
define('MODULE_ADVANCED_SHIPPER_DEFAULT_TITLE', 'Shipping'); // DO NOT LEAVE BLANK!

/**
 * Message to be displayed if the customer's address doesn't match any of the defined regions.
 */
define('MODULE_ADVANCED_SHIPPER_ERROR_INVALID_REGION', 'Sorry but we do not ship to your address by this shipping method!');

/**
 * Messages to be displayed if only the country has been selected in the shipping estimator and no
 * methods were matched (give the customer a chance to specify their region in case that's the
 * reason no quotes are available).
 */
define('MODULE_ADVANCED_SHIPPER_ERROR_SPECIFY_SHIPPING_ADDRESS', 'Please select your Country, enter/select your State/Province and enter your Post/Zip Code.');
define('MODULE_ADVANCED_SHIPPER_ERROR_SPECIFY_POSTCODE', 'Please enter your Post/Zip Code.');
define('MODULE_ADVANCED_SHIPPER_ERROR_SPECIFY_STATE', 'Please select your Country and enter/select your State/Province.');

// Message to be displayed if postcode is reported as being invalid
define('MODULE_ADVANCED_SHIPPER_ERROR_INVALID_POSTCODE', 'The Post/Zip Code entered appears to be invalid. Please check and correct it and try again. If still experiencing problems, please <a href="' . zen_href_link(FILENAME_CONTACT_US, '', 'SSL') . '">contact us</a> for further assistance.');

/**
 * Message to be displayed if the customer's address is matched but no rates match the order.
 */
define('MODULE_ADVANCED_SHIPPER_ERROR_NO_RATES_MATCH', 'Sorry but there are no shipping options to your address at this time!');

/**
 * Message(s) to be displayed if one or more products the customer has ordered requires the customer
 * to contact the store to determine the shipping options.
 *
 * One message is defined here but additional messages can be defined and used by appending a number
 * to the "contact" rate string and creating a new define here with the same number appended. 
 *
 * For example, as standard, the message for MODULE_ADVANCED_SHIPPER_TEXT_CONTACT_STORE is displayed
 * when the rate string "contact" is encountered.
 *
 * The message for MODULE_ADVANCED_SHIPPER_TEXT_CONTACT_STORE1 will be used when the rate string
 * "contact1" is encountered. The message for MODULE_ADVANCED_SHIPPER_TEXT_CONTACT_STORE2 will be
 * used when the rate string "contact2" is encountered and so on.. go ahead and create as many extra
 * defines as is required to give specific messages for specific situations!
 */
define('MODULE_ADVANCED_SHIPPER_TEXT_CONTACT_STORE', 'One or more of the product(s) you are ordering require personal shipping arrangements. Please <a href="' . zen_href_link(FILENAME_CONTACT_US) . '" target="_blank">Contact Us</a> to arrange shipping and complete your order.');
//define('MODULE_ADVANCED_SHIPPER_TEXT_CONTACT_STORE1', 'One or more of the product(s)...');
//define('MODULE_ADVANCED_SHIPPER_TEXT_CONTACT_STORE2', 'One or more of the product(s)...');

/**
 * Message(s) to be displayed if one or more products the customer has ordered requires the customer
 * to contact the store to determine the shipping options AFTER the order has been completed.
 *
 * One message is defined here but additional messages can be defined and used by appending a number
 * to the "contact_after_order" rate string and creating a new define here with the same number
 * appended. 
 *
 * For example, as standard, the message for MODULE_ADVANCED_SHIPPER_TEXT_CONTACT_STORE_AFTER_ORDER
 * is displayed when the rate string "contact_after_order" is encountered.
 *
 * The message for MODULE_ADVANCED_SHIPPER_TEXT_CONTACT_STORE_AFTER_ORDER1 will be used when the
 * rate string "contact_after_order1" is encountered. The message for
 * MODULE_ADVANCED_SHIPPER_TEXT_CONTACT_STORE_AFTER_ORDER2 will be used when the rate string
 * "contact_after_order2" is encountered and so on.. go ahead and create as many extra defines as is
 * required to give specific messages for specific situations!
 */
define('MODULE_ADVANCED_SHIPPER_TEXT_CONTACT_STORE_AFTER_ORDER', '<strong>Contact Us</strong> - This method includes one or more products which require personal shipping arrangements. If you select this method, you <strong>must</strong> contact us to arrange shipping/finalise shipping costs after completing your order.');


/**
 * Message to be displayed if the customer's address is matched and a usable rate is found but the
 * method isn't available for use at the minute because of availability/shipping scheduling
 * settings.
 */
define('MODULE_ADVANCED_SHIPPER_ERROR_NO_RATES_AVAILABLE', 'Sorry but there are no shipping options available to your address at this time!');

/**
 * Message to be displayed if the no combination of shipping methods can be found to allocate each
 * product in the cart exactly one shipping method.
 */
define('MODULE_ADVANCED_SHIPPER_ERROR_NO_COMBINATIONS', 'Sorry but our shipping options don\'t cover the combination of products currently in the cart!');

/**
 * Shipping method output templates - can be used to customise the format of the output on the
 * checkout page etc. HTML is allowed.
 *
 * Individual tags are used to place the content at the appropriate points.
 *
 * There are two alternative layouts.. if an option contains a combination of methods, the
 * information about the applicable products is displayed for each method.
 *
 * If there is only one method, information about the applicable products isn't displayed (as all
 * are obviously applicable!)
 *
 *
 *
 * Layout 1) For a combination of methods, the templates are nested as follows:
 *
 * THe overall method combination is "wrapped" using the following template:
 *
 * MODULE_ADVANCED_SHIPPER_TEMPLATE_SHIPPING_METHOD_COMB
 *
 * Each shipping method within the method combination is wrapped using the following template, with
 * the following method being appended to the previous:
 *
 * MODULE_ADVANCED_SHIPPER_TEMPLATE_SHIPPING_METHOD_WITH_PRODUCT_INFO
 *
 * Each product within a method is wrapped using the following template, with the following product
 * being appended to the previous:
 *
 * MODULE_ADVANCED_SHIPPER_TEMPLATE_PRODUCT_INFO
 *
 * If a product has attributes, they make use of the following template. Like the method and product
 * templates, if there is more than one attribute, each following attribute is appended to the
 * previous attribute:
 *
 * MODULE_ADVANCED_SHIPPER_TEMPLATE_PRODUCT_INFO_ATTRIBUTE_INFO
 *
 *
 *
 * Layout 2) For a single method, only one template is necessary:
 * 
 * MODULE_ADVANCED_SHIPPER_TEMPLATE_SHIPPING_METHOD_NO_PRODUCT_INFO
 * 
 */
define('MODULE_ADVANCED_SHIPPER_TEMPLATE_SHIPPING_METHOD_COMB', '<div class="AdvancedShipperShippingMethodCombination">{method_comb}</div>');
define('MODULE_ADVANCED_SHIPPER_TEMPLATE_SHIPPING_METHOD_WITH_PRODUCT_INFO', '<p class="AdvancedShipperShippingMethod">{method_title}{product_info}</p>');
define('MODULE_ADVANCED_SHIPPER_TEMPLATE_PRODUCT_INFO', '<br />{quantity} x {name}{attribute_info}');
define('MODULE_ADVANCED_SHIPPER_TEMPLATE_PRODUCT_INFO_ATTRIBUTE_INFO', '<br />// {name} -- {value}');

define('MODULE_ADVANCED_SHIPPER_TEMPLATE_SHIPPING_METHOD_NO_PRODUCT_INFO', '{method_title}');

/**
 * Fallback/default output templates for method total, rate calculation description and handling fee
 * used if placement tag not used in title. These are appended to the method's title if they are
 * being used.
 */
define('MODULE_ADVANCED_SHIPPER_TEMPLATE_METHOD_TOTAL', ' ({method_total})');
define('MODULE_ADVANCED_SHIPPER_TEMPLATE_RATE_CALC_DESC', ' ({num_packages_desc}{rate_calc_desc})');
define('MODULE_ADVANCED_SHIPPER_TEMPLATE_SURCHARGE', ' (Inc Handling Fee: {surcharge_amount})');

/**
 * Default templates for information about number of packages which would have to be used for a
 * method - to be used alongside the rate_calc_desc.
 */
define('MODULE_ADVANCED_SHIPPER_TEXT_NUM_PACKAGES_SINGLE', '');
define('MODULE_ADVANCED_SHIPPER_TEXT_NUM_PACKAGES_MULTIPLE', '{num_packages} Packages: ');

/**
 * Default templates for information about the weights of the package(s) which would have to be used
 * for a method - to be used instead of the rate_calc_desc, NOT alongside it.
 */
define('MODULE_ADVANCED_SHIPPER_TEXT_PACKAGE_WEIGHTS_DESC_SINGLE', '{package_weight}');
define('MODULE_ADVANCED_SHIPPER_TEXT_PACKAGE_WEIGHTS_DESC_MULTIPLE', '{num_packages} Packages: {package_weights}');

/**
 * Message to be displayed if no title was found for the method for the current language (should
 * only happen if store's language settings have changed since method was last saved)
 */
define('MODULE_ADVANCED_SHIPPER_METHOD_TITLE_MISSING', 'Standard Shipping - TITLE NEEDS UPDATING');

/**
 * Titles for UPS shipping methods
 */
define('MODULE_ADVANCED_SHIPPER_TEXT_UPS_TITLE_PREFIX', ' - ');
define('MODULE_ADVANCED_SHIPPER_TEXT_UPS_SHIPPING_SERVICE_1DM', 'Next Day Air Early AM');
define('MODULE_ADVANCED_SHIPPER_TEXT_UPS_SHIPPING_SERVICE_1DML', 'Next Day Air Early AM Letter');
define('MODULE_ADVANCED_SHIPPER_TEXT_UPS_SHIPPING_SERVICE_1DA', 'Next Day Air');
define('MODULE_ADVANCED_SHIPPER_TEXT_UPS_SHIPPING_SERVICE_1DAL', 'Next Day Air Letter');
define('MODULE_ADVANCED_SHIPPER_TEXT_UPS_SHIPPING_SERVICE_1DAPI', 'Next Day Air Intra (Puerto Rico)');
define('MODULE_ADVANCED_SHIPPER_TEXT_UPS_SHIPPING_SERVICE_1DP', 'Next Day Air Saver');
define('MODULE_ADVANCED_SHIPPER_TEXT_UPS_SHIPPING_SERVICE_1DPL', 'Next Day Air Saver Letter');
define('MODULE_ADVANCED_SHIPPER_TEXT_UPS_SHIPPING_SERVICE_2DM', '2nd Day Air AM');
define('MODULE_ADVANCED_SHIPPER_TEXT_UPS_SHIPPING_SERVICE_2DML', '2nd Day Air AM Letter');
define('MODULE_ADVANCED_SHIPPER_TEXT_UPS_SHIPPING_SERVICE_2DA', '2nd Day Air');
define('MODULE_ADVANCED_SHIPPER_TEXT_UPS_SHIPPING_SERVICE_2DAL', '2nd Day Air Letter');
define('MODULE_ADVANCED_SHIPPER_TEXT_UPS_SHIPPING_SERVICE_3DS', '3 Day Select');
define('MODULE_ADVANCED_SHIPPER_TEXT_UPS_SHIPPING_SERVICE_GND', 'Ground');
define('MODULE_ADVANCED_SHIPPER_TEXT_UPS_SHIPPING_SERVICE_GNCRES', 'Ground Residential');
define('MODULE_ADVANCED_SHIPPER_TEXT_UPS_SHIPPING_SERVICE_GNDCOM', 'Ground Commercial');
define('MODULE_ADVANCED_SHIPPER_TEXT_UPS_SHIPPING_SERVICE_STD', 'Canada Standard');
define('MODULE_ADVANCED_SHIPPER_TEXT_UPS_SHIPPING_SERVICE_XPR', 'Worldwide Express');
define('MODULE_ADVANCED_SHIPPER_TEXT_UPS_SHIPPING_SERVICE_XPRL', 'Worldwide Express Letter');
define('MODULE_ADVANCED_SHIPPER_TEXT_UPS_SHIPPING_SERVICE_XDM', 'Worldwide Express Plus');
define('MODULE_ADVANCED_SHIPPER_TEXT_UPS_SHIPPING_SERVICE_XDML', 'Worldwide Express Plus Letter');
define('MODULE_ADVANCED_SHIPPER_TEXT_UPS_SHIPPING_SERVICE_XPD', 'Worldwide Expedited');
define('MODULE_ADVANCED_SHIPPER_TEXT_UPS_SHIPPING_SERVICE_WXS', 'Worldwide Saver');


/**
 * Titles for USPS shipping methods
 */
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_TITLE_PREFIX', ' - ');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_DOMESTIC_EXPRESS', 'Express Mail<sup>&reg;</sup>');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_DOMESTIC_PRIORITY', 'Priority Mail<sup>&reg;</sup>');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_DOMESTIC_FIRST_CLASS', 'First-Class Mail');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_DOMESTIC_PARCEL', 'Parcel Post<sup>&reg;</sup>');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_DOMESTIC_RETAIL_GROUND', 'Retail Ground<sup>&reg;</sup>');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_DOMESTIC_MEDIA', 'Media Mail');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_DOMESTIC_BPM', 'Bound Printed Matter');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_DOMESTIC_LIBRARY', 'Library');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_INTERNATIONAL_GEG', 'Global Express Guaranteed<sup>&reg;</sup> (GXG)');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_INTERNATIONAL_GEG_D', 'Global Express Guaranteed<sup>&reg;</sup> Document');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_INTERNATIONAL_GEG_NDR', 'Global Express Guaranteed<sup>&reg;</sup> Non-Document Rectangular');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_INTERNATIONAL_GEG_NDNR', 'Global Express Guaranteed<sup>&reg;</sup> Non-Document Non-Rectangular');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_INTERNATIONAL_GEG_E', 'USPS GXG<sup>&trade;</sup> Envelopes');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_INTERNATIONAL_EMI', 'Express Mail International<sup>&reg;</sup>');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_INTERNATIONAL_EMI_FRE', 'Express Mail International<sup>&reg;</sup> Flat Rate Envelope');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_INTERNATIONAL_EMI_LFRE', 'Express Mail International<sup>&reg;</sup> Legal Flat Rate Envelope');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_INTERNATIONAL_PMI', 'Priority Mail International<sup>&reg;</sup>');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_INTERNATIONAL_PMI_SFRB', 'Priority Mail International<sup>&reg;</sup> Small Flat Rate Box');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_INTERNATIONAL_PMI_MFRB', 'Priority Mail International<sup>&reg;</sup> Medium Flat Rate Box');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_INTERNATIONAL_PMI_LFRB', 'Priority Mail International<sup>&reg;</sup> Large Flat Rate Box');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_INTERNATIONAL_PMI_DFRB', 'Priority Mail International<sup>&reg;</sup> DVD Flat Rate Box');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_INTERNATIONAL_PMI_LVFRB', 'Priority Mail International<sup>&reg;</sup> Large Video Flat Rate Box');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_INTERNATIONAL_PMI_FRE', 'Priority Mail International<sup>&reg;</sup> Flat Rate Envelope');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_INTERNATIONAL_PMI_SFRE', 'Priority Mail International<sup>&reg;</sup> Small Flat Rate Envelope');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_INTERNATIONAL_PMI_PFRE', 'Priority Mail International<sup>&reg;</sup> Padded Flat Rate Envelope');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_INTERNATIONAL_PMI_GCFRE', 'Priority Mail International<sup>&reg;</sup> Gift Card Flat Rate Envelope');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_INTERNATIONAL_PMI_LFRE', 'Priority Mail International<sup>&reg;</sup> Legal Flat Rate Envelope');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_INTERNATIONAL_FCMI_LE', 'First-Class Mail International Large Envelope');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_INTERNATIONAL_FCMI_P', 'First-Class Mail International Package');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_INTERNATIONAL_FCMI_L', 'First-Class Mail International Letter');


define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_DAY', 'day');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_DAYS', 'days');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_WEEKS', 'weeks');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_TOMORROW_BY', 'Tomorrow by');

define('MODULE_ADVANCED_SHIPPER_ERROR_USPS_SERVER', 'An error occurred when attempting to obtain USPS shipping quotes.<br />If you prefer to use USPS as your shipping method, please <a href="index.php?main_page=contact_us">contact us</a> for  assistance. The error was: ');
define('MODULE_ADVANCED_SHIPPER_TEXT_USPS_TEST_MODE_NOTICE', '<br /><br /><span class="alert">The USPS account is in TEST MODE. Usable rate quotes may not be displayed until the USPS account is moved to the production server (1-800-344-7779) and the USPS calculation settings have been set to production mode in the admin.</span>');


/**
 * Titles for FedEx shipping methods
 */
define('MODULE_ADVANCED_SHIPPER_TEXT_FEDEX_TITLE_PREFIX', ' - ');
define('MODULE_ADVANCED_SHIPPER_TEXT_FEDEX_SATURDAY_DELIVERY', ' (Saturday delivery)');

define('MODULE_ADVANCED_SHIPPER_ERROR_FEDEX_CURRENCY_CONV_VALUE_MISSING', 'Unable to convert shipping rate to current currency as conversion rate for %s has not been defined for the store. Please <a href="' . zen_href_link(FILENAME_CONTACT_US, '', 'SSL') . '">contact us</a> to get this resolved!');
define('MODULE_ADVANCED_SHIPPER_ERROR_FEDEX_CURRENCY_CONV_VALUE_INVALID', 'Unable to convert shipping rate to current currency as conversion rate for %s as defined for the store is invalid. Please <a href="' . zen_href_link(FILENAME_CONTACT_US, '', 'SSL') . '">contact us</a> to get this resolved!');

define('MODULE_ADVANCED_SHIPPER_TEXT_FEDEX_1_DAY_FREIGHT', '1 Day Freight');
define('MODULE_ADVANCED_SHIPPER_TEXT_FEDEX_2_DAY', '2 Day');
define('MODULE_ADVANCED_SHIPPER_TEXT_FEDEX_2_DAY_FREIGHT', '2 Day Freight');
define('MODULE_ADVANCED_SHIPPER_TEXT_FEDEX_3_DAY_FREIGHT', '3 Day Freight');
define('MODULE_ADVANCED_SHIPPER_TEXT_FEDEX_EXPRESS_SAVER', 'Express Saver');
define('MODULE_ADVANCED_SHIPPER_TEXT_FEDEX_GROUND', 'Ground');
define('MODULE_ADVANCED_SHIPPER_TEXT_FEDEX_GROUND_HOME_DELIVERY', 'Ground Home Delivery');
define('MODULE_ADVANCED_SHIPPER_TEXT_FEDEX_STANDARD_OVERNIGHT', 'Standard Overnight');
define('MODULE_ADVANCED_SHIPPER_TEXT_FEDEX_FIRST_OVERNIGHT', 'First Overnight');
define('MODULE_ADVANCED_SHIPPER_TEXT_FEDEX_PRIORITY_OVERNIGHT', 'Priority Overnight');
define('MODULE_ADVANCED_SHIPPER_TEXT_FEDEX_SMART_POST', 'Smart Post');
define('MODULE_ADVANCED_SHIPPER_TEXT_FEDEX_FREIGHT', 'Freight');
define('MODULE_ADVANCED_SHIPPER_TEXT_FEDEX_NATIONAL_FREIGHT', 'National Freight');
define('MODULE_ADVANCED_SHIPPER_TEXT_FEDEX_INTERNATIONAL_GROUND', 'International Ground');
define('MODULE_ADVANCED_SHIPPER_TEXT_FEDEX_INTERNATIONAL_ECONOMY', 'International Economy');
define('MODULE_ADVANCED_SHIPPER_TEXT_FEDEX_INTERNATIONAL_ECONOMY_FREIGHT', 'International Economy Freight');
define('MODULE_ADVANCED_SHIPPER_TEXT_FEDEX_INTERNATIONAL_FIRST', 'International First');
define('MODULE_ADVANCED_SHIPPER_TEXT_FEDEX_INTERNATIONAL_PRIORITY', 'International Priority');
define('MODULE_ADVANCED_SHIPPER_TEXT_FEDEX_INTERNATIONAL_PRIORITY_FREIGHT', 'International Priority Freight');
define('MODULE_ADVANCED_SHIPPER_TEXT_FEDEX_EUROPE_FIRST_INTERNATIONAL_PRIORITY', 'Europe First International Priority');


/**
 * The default fallback error message for invalid postcode formats.
 */
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE', 'Sorry! It is not possible to calculate the shipping rate to the selected address as we are unable to verify the postcode. <br /><br />Please check that the postcode entered for this shipping address, &ldquo;%s&rdquo;, is correct. <br /><br />If not, please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order!');

/**
 * Specific error messages for invalid postcode formats for each country. 
 */
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_AT', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Austria should be 4 digits in length. An example is &ldquo;5020&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_AU', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Australia should be 4 or 3 digits in length. An example is &ldquo;2000&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_BA', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Bosnia and Herzegowina should be 5 digits in length. An example is &ldquo;71000&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_BE', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Belgium should be 4 digits in length. An example is &ldquo;3800&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_BG', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Bulgaria should be 4 digits in length. An example is &ldquo;29001&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_BR', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postal codes for Brazil should be 8 digits in length, with an optional dash. Examples are &ldquo;22070-002&rdquo;, &ldquo;22070002&rdquo; or &ldquo;63994-000&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_CA', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Canada should be in the format: &ldquo;X9X 9X9&rdquo;, where X is a letter and 9 is a digit. An example is &ldquo;K1A 0B1&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_CH', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Switzerland should be 4 digits in length. An example is &ldquo;3011&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_CZ', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for the Czech Republic should be 5 digits in length, normally in a group of 3 then 2 digits, separated by a space. An example is &ldquo;364 97&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_DE', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Germany should be 5 digits in length. An example is &ldquo;30011&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_DK', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Denmark should be 4 or 3 digits in length. An example is &ldquo;9700&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_EE', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Estonia should be 5 digits in length. An example is &ldquo;10381&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_ES', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Spain should be 5 digits in length. An example is &ldquo;46025&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_FI', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Finland should be 5 digits in length. An example is &ldquo;33000&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_FR', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for France should be 5 digits in length. An example is &ldquo;75008&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_GB', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />It should be in one of the following formats: &ldquo;X9 9XX&rdquo;, &ldquo;X99 9XX&rdquo;, &ldquo;X9X 9XX&rdquo;, &ldquo;XX9 9XX&rdquo;, &ldquo;XX99 9XX&rdquo; or &ldquo;XX9X 9XX&rdquo;, where X is a letter and 9 is a digit. An example is &ldquo;BT10 0JX&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_GR', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Greece should be 5 digits in length. An example is &ldquo;10480&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_HR', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Croatia should be 5 digits in length. An example is &ldquo;23000&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_HU', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Hungary should be 4 digits in length. An example is &ldquo;1048&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_ID', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Indonesia should be 5 digits in length. An example is &ldquo;80235&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_IN', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for India should be 6 digits in length. An example is &ldquo;625002&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_IT', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Italy should be 5 digits in length, with an optional two letter prefix. Examples are &ldquo;50121&rdquo; and &ldquo;FI-50121&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_LI', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Liechtenstein should be 4 digits in length. An example is &ldquo;9493&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_LT', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Lithuania should be 5 digits in length, with an optional two letter prefix. Examples are &ldquo;44280&rdquo; and &ldquo;LT-52316&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_LV', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Latvia should be 4 digits in length, with an optional two letter prefix. Examples are &ldquo;1011&rdquo; and &ldquo;LV-1051&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_MK', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Macedonia should be 4 digits in length. An example is &ldquo;1442&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_MY', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Malaysia should be 5 digits in length. An example is &ldquo;50101&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_NL', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for The Netherlands should be 4 digits in length followed by two letters, with an optional two letter prefix. Examples are &ldquo;3001 AA&rdquo;, &ldquo;3099ZZ&rdquo; &amp; &ldquo;NL-5476 DH&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_NO', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Norway should be 4 digits in length. An example is &ldquo;1120&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_NZ', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for New Zealand should be 4 digits in length. An example is &ldquo;6042&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_PH', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for the Philippines should be 4 digits in length. An example is &ldquo;1718&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_PL', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Poland should be 5 digits in length, normally with a dash/hyphen separating the second and third digits. An example is &ldquo;31-962&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_PT', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Portugal should have 4 digits at the beginning (the rest of the postcode is not necessary). An example is &ldquo;9101&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_RO', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Romania should be 6 digits in length. An example is &ldquo;034850&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_RS', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Serbia should be 5 or 6 digits in length. An example is &ldquo;11000&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_SE', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Sweden should be 5 digits in length, normally in a group of 3 then 2 digits, separated by a space. An example is &ldquo;113 51&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_SI', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Slovenia should be 4 digits in length. An example is &ldquo;8110&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_SK', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Slovakia should be 5 digits in length, normally in a group of 3 then 2 digits, separated by a space. An example is &ldquo;811 02&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_SM', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for San Marino should be 5 digits in length. An example is &ldquo;50121&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_US', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the ZIP code entered, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this ZIP code so that the shipping rate can be determined for your order! <br /><br />ZIP codes should be at least 5 digits long. An example is &ldquo;98102&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_VA', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postcode, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postcode so that the shipping rate can be determined for your order! <br /><br />Postcodes for Vatican City should be 5 digits in length. An example is &ldquo;50121&rdquo;.');
define('MODULE_ADVANCED_SHIPPER_ERROR_CUSTOMER_POSTCODE_PARSE_ZA', 'Sorry! It is not possible to calculate the shipping rate to the selected address as the postal code, &ldquo;%s&rdquo;, is not in the correct format. <br /><br />Please go to &ldquo;View or Change Entries in my Address Book&rdquo; in your account and update this postal code so that the shipping rate can be determined for your order! <br /><br />Postal codes for South Africa should be 4 digits in length. An example is &ldquo;7700&rdquo;.');

/**
 * Module configuration error messages. These will only be displayed if the store owner has made a
 * mistake when configuring the module.
 */
define('MODULE_ADVANCED_SHIPPER_ERROR_NO_METHODS_FOR_PRODUCT', 'Module configuration error: Product in cart is not covered by any of the store\'s shipping rates: %s');
define('MODULE_ADVANCED_SHIPPER_ERROR_NO_RATES_DEFINED', 'Module configuration error: No rates have been defined for region %s!');
define('MODULE_ADVANCED_SHIPPER_ERROR_RANGE_METHOD', 'Module configuration error: Method for determining matching postcode range for country "%s" has not been defined! (Please create the method "_getRegionMatchingRange%s()")');
define('MODULE_ADVANCED_SHIPPER_ERROR_POSTCODE_PARSE', 'Module configuration error: Could not parse the postcode range "%s".');
define('MODULE_ADVANCED_SHIPPER_ERROR_GEOLOCATION_FUNCTIONS_MISSING', 'Module configuration error: No Geolocation functions found for country code "%s".');
define('MODULE_ADVANCED_SHIPPER_ERROR_GEOLOCATION_STORE_POSTCODE_INVALID', 'Module configuration error: The Store\'s Postcode is not valid!');
define('MODULE_ADVANCED_SHIPPER_ERROR_GEOLOCATION_STORE_POSTCODE_NOT_FOUND', 'Module configuration error: The Store\'s Postcode was not found in the Geolocation database!');
define('MODULE_ADVANCED_SHIPPER_ERROR_NO_UPS_CONFIG', 'Module configuration error: The UPS configuration has not been specified for method %s, region %s.');
define('MODULE_ADVANCED_SHIPPER_ERROR_NO_USPS_CONFIG', 'Module configuration error: The USPS configuration has not been specified for method %s, region %s.');
define('MODULE_ADVANCED_SHIPPER_ERROR_NO_FEDEX_CONFIG', 'Module configuration error: The FedEx configuration has not been specified for method %s, region %s.');

define('MODULE_ADVANCED_SHIPPER_TEXT_CATALOG_TITLE', 'Ceon Advanced Shipper');

// Admin text definitions
define('MODULE_ADVANCED_SHIPPER_TEXT_ADMIN_TITLE', 'Ceon Advanced Shipper v%s');
define('MODULE_ADVANCED_SHIPPER_TEXT_DESCRIPTION_BASE', '');
define('MODULE_ADVANCED_SHIPPER_TEXT_NOT_INSTALLED', '<p id="ceon-footer"><a href="http://dev.ceon.net" target="_blank"><img src="' . DIR_WS_IMAGES . 'ceon-button-logo.png" alt="Made by Ceon. &copy; 2007-' . (date('Y') > 2012 ? date('Y') : 2012) . ' Ceon" /></a>Module &copy; 2007-' . (date('Y') > 2012 ? date('Y') : 2012) . ' Ceon</p>');

