<?php

function avatax_get_basic_configuration($value = array("company_config"), $production = true, $live = true)
{
    switch($value[0])
    {
      case "company_config":
        if ($live)
        {
          $curl_opts = avatax_get_basic_configuration(array("curl_opts", "GET"));
      
          $config = avatax_call_api("api/v2/companies/", $curl_opts);
      
          return $config;
        }
        else
        {
          if ($production)
          {
            return '{"@recordsetCount":3,"value":[{"id":1027877,"accountId":2000850042,"companyCode":"DEFAULT-26344","name":"Westech Equipment Company Inc","isDefault":true,"isActive":true,"taxpayerIdNumber":"85-4288987","IsFein":false,"hasProfile":true,"isReportingEntity":true,"defaultCountry":"US","roundingLevelId":"Line","warningsEnabled":false,"isTest":false,"inProgress":false,"createdDate":"2021-10-08T16:01:39.99","createdUserId":1167517,"modifiedDate":"2021-10-19T16:39:58.947","modifiedUserId":1217655},{"id":1030937,"accountId":2000850042,"companyCode":"DEFAULT","name":"Westech Equipment Company Inc","isDefault":false,"isActive":false,"taxpayerIdNumber":"85-4288987","IsFein":false,"hasProfile":true,"isReportingEntity":true,"defaultCountry":"US","roundingLevelId":"Line","warningsEnabled":false,"isTest":false,"inProgress":false,"createdDate":"2021-10-19T13:38:53.837","createdUserId":1167517,"modifiedDate":"2021-10-19T16:40:20.12","modifiedUserId":1217655},{"id":1030975,"accountId":2000850042,"companyCode":"TOPSINC","name":"TOPS Inc","isDefault":false,"isActive":true,"taxpayerIdNumber":"20-2689073","IsFein":false,"hasProfile":true,"isReportingEntity":true,"defaultCountry":"US","roundingLevelId":"Line","warningsEnabled":false,"isTest":false,"inProgress":false,"createdDate":"2021-10-19T16:19:02.31","createdUserId":1217655,"modifiedDate":"2021-10-19T16:22:20.11","modifiedUserId":1217655}]}';
          }
          else
          {
            return '{"@recordsetCount":1,"value":[{"id":2753304,"accountId":2001601824,"companyCode":"DEFAULT-26344","name":"Westech Equipment Company Inc","isDefault":true,"isActive":true,"taxpayerIdNumber":"85-4288987","IsFein":false,"hasProfile":true,"isReportingEntity":true,"defaultCountry":"US","roundingLevelId":"Line","warningsEnabled":false,"isTest":false,"inProgress":false,"createdDate":"2021-09-30T21:11:31.617","createdUserId":1440759,"modifiedDate":"2021-10-19T19:15:46.26","modifiedUserId":1441857}]}';
          }
        }
        break;
      case "curl_opts":
        $curl_opts = array();
  
        switch($value[1])
        {
          case "GET":
            $curl_opts = array(
              CURLOPT_HTTPHEADER => array(
                'Accept: application/json',
                'Authorization: Basic ' . base64_encode('webdev@westechequipment.com:WestechDev@1971'),
              ),
              CURLOPT_RETURNTRANSFER => TRUE,
              CURLOPT_FOLLOWLOCATION => FALSE,
              CURLOPT_SSL_VERIFYPEER => TRUE,
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_CONNECTTIMEOUT => 10
            );
            break;
          case "POST":
            $curl_opts = array(
              CURLOPT_HTTPHEADER => array(
                'Accept: application/json',
                'Authorization: Basic ' . base64_encode('webdev@westechequipment.com:WestechDev@1971'),
                'Content-type: application/json'
              ),
              CURLOPT_RETURNTRANSFER => TRUE,
              CURLOPT_FOLLOWLOCATION => FALSE,
              CURLOPT_POST => TRUE,
              CURLOPT_SSL_VERIFYPEER => TRUE,
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_CONNECTTIMEOUT => 10,
              CURLOPT_POSTFIELDS => json_encode($value[2]),
            );
            break;
          case "DELETE":
            $curl_opts = array(
              CURLOPT_HTTPHEADER => array(
                'Accept: application/json',
                'Authorization: Basic ' . base64_encode('webdev@westechequipment.com:WestechDev@1971'),
              ),
              CURLOPT_RETURNTRANSFER => TRUE,
              CURLOPT_FOLLOWLOCATION => FALSE,
              CURLOPT_CUSTOMREQUEST => "DELETE",
              CURLOPT_SSL_VERIFYPEER => TRUE,
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_CONNECTTIMEOUT => 10
            );
            break;
          default:
            break;
        }
        return $curl_opts;
        break;
    }
}

function avatax_call_api($endpoint, $opts, $production = true, $include_curl = false, $array = true, $associative = true, $debug = false)
{
  // if ($_SESSION['customer_id'] == 1) $debug = true;
  // if (IS_ADMIN_FLAG) $debug = true;

  $base_url = ($production) ? "https://rest.avatax.com/" : "https://sandbox-rest.avatax.com/";
  $url = $base_url . $endpoint;

  $curl = curl_init($url);
  foreach ($opts as $opt => $val)
  {
    curl_setopt($curl, $opt, $val);
  }

  $result = curl_exec($curl);
  curl_close($curl);

  $debugInfo = array(
    'URL' => $url,
    'OPTS' => $opts,
    'cURLsult' => json_decode($result, true),
    'cURLcode' => curl_getinfo($curl, CURLINFO_HTTP_CODE)
  );

  if ($debug)
  {
    echo '<pre>';
    print_r($debugInfo);
    echo '</pre>';
  }

  if (!$result)
  {
    return array("API failed.", $endpoint, $result);
  }
  else
  {
    if ($include_curl)
    {
      $result_with_curl = array();

      if ($array)
      {
        array_push($result_with_curl, (($associative)? json_decode($result, true) : json_decode($result)));
      }
      else
      {
        array_push($result_with_curl, $result);
      }
      $result_with_curl[] = array("curl-resp" => $curl);

      return $result_with_curl;

    }
    else
    {
      if ($array)
      {
        return ($associative)? json_decode($result, true) : json_decode($result);
      }
      else
      {
        return $result;
      }
    }
  }
}