<?php

if (file_exists('includes/modules/freightquote/config.freightquote.php')) {
    require 'includes/modules/freightquote/config.freightquote.php';
} else {
    require '../includes/modules/freightquote/config.freightquote.php';
}

function calculate_pallets_needed($products, $pallet_length = 40, $pallet_width = 48, $margin = 3) {
    $palletArea = $pallet_length * $pallet_width - ($margin * (($pallet_length + $pallet_width) - 2));

    $palletsNeeded = 0;
    $remainingSpace = $palletArea;

    foreach ($products as $commodity) {
        $commodityArea = ($commodity['length'] + (2 * $margin)) * ($commodity['width'] + (2 * $margin));

        if ($commodityArea <= $remainingSpace) {
            $remainingSpace -= $commodityArea;
        } else {
            $palletsNeeded++;
            $remainingSpace = $palletArea - $commodityArea;
        }
    }

    if ($remainingSpace < $palletArea) {
        $palletsNeeded++;
    }

    return $palletsNeeded;
}

function custom_sort($order_by) {
    return function($a, $b) use ($order_by) {
        $comparableA = $a[$order_by];
        $comparableB = $b[$order_by];

        if ($comparableA == $comparableB) return 0;
        return ($comparableA < $comparableB)? -1 : 1;
    };
}

function freightquote_rate_freight($shipFrom, $shipTo, $products, $order_by = 'totalCharge') {

    $commodities = array();

    foreach ($products as $commodity) {
        $numberOfPallets = calculate_pallets_needed($products);

        $commodities[] = array(
            'freightClass' => $commodity['freight_class'],
            'weight' => $commodity['weight'] * $commodity['quantity'],
            'weightUnitOfMeasure' => 'Pounds',
            'packagingLength' => $commodity['length'],
            'packagingWidth' => $commodity['width'],
            'packagingHeight' => $commodity['height'],
            'packagingUnitOfMeasure' => 'Inches',
            'pallets' => $numberOfPallets,
            'quantity' => $commodity['quantity'],
            'insuranceValue' => $commodity['price'] * $commodity['quantity'],
            'packagingType' => 'PLT',
            'productCode' => $commodity['model']
        );
    }

    $data = array(
        'items' => $commodities,
        'origin' => array(
            'address1' => $shipFrom['addressLine1'],
            'city' => $shipFrom['city'],
            'stateProvinceCode' => $shipFrom['state'],
            'countryCode' => 'US',
            'postalCode' => $shipFrom['zip']
        ),
        'destination' => array(
            'address1' => $shipTo['addressLine1'],
            'city' => $shipTo['city'],
            'stateProvinceCode' => $shipTo['state'],
            'countryCode' => 'US',
            'postalCode' => $shipTo['zip']
        ),
        'shipDate' => date('Y-m-d', strtotime('+5 days')),
        'customerCode' => 'C8841393',
        'transportModes' => array(
            array(
                'mode' => 'LTL'
            )
        )
    );

    $url = '/v1/quotes';

    $result = freightquote_call_api($url, $data);

    if (!isset($result['received']['quoteSummaries'])) {
        return array(
            'code' => 0,
            'message' => 'Unknown error occurred. Please try again later or contact us for assistance.',
            'result' => $result
        );
    }

    usort($result['received']['quoteSummaries'], custom_sort($order_by));

    return $result;
}