<?php

if (!zen_is_logged_in() && !isset($_SESSION['customer_id']))
{
    zen_redirect(zen_href_link('checkout_guest'));
}

if (count($_SESSION['cart']->contents) < 1)
{
    zen_redirect(zen_href_link(FILENAME_SHOPPING_CART));
}

$productModelANDQuantitySubqueries = array();
                                
foreach ($_SESSION['cart']->get_products() as $product)
{
    $id = $product['id'];
    if (strpos($id, ':') !== FALSE) $id = substr($id, 0, strpos($id, ':'));
    $model = $product['model'];
    $quantity = $product['quantity'];

    $productModelANDQuantitySubqueries[] = "SELECT m.manufacturers_id, m.manufacturers_name, m.manufacturers_min_order, (p.products_price * $quantity) AS total_price
    FROM zen_products p
    JOIN zen_manufacturers m ON p.manufacturers_id = m.manufacturers_id
    WHERE p.products_id = '$id'";
}

$modelsAndQuantityUnion = implode(" UNION ", $productModelANDQuantitySubqueries);

$manfMinToProductQuery = "SELECT manufacturers_id, manufacturers_name, manufacturers_min_order, SUM(total_price) as total_products_price
FROM ($modelsAndQuantityUnion) AS SQ
GROUP BY manufacturers_id
HAVING SUM(total_price) < manufacturers_min_order";

$manfMinToProductQueryResult = $db->Execute($manfMinToProductQuery);

if ($manfMinToProductQueryResult->RecordCount() > 0) zen_redirect(zen_href_link(FILENAME_SHOPPING_CART));