<div class="checkout-item-content" id="checkout-tax-ex-info">
                    
    <?php
    if (zen_is_logged_in())
    {
    ?>

    <form class="checkout-form">
        <p>
            Tax exemptions will be automatically applied to the cart. Before completing checkout verify through cart summary.
            You can either view current exemptions or add a new one.
        </p>
        <div class="mb-3 form-floating-label-container">
            <select class="form-select" id="tax-ex-status" name="tax-ex-status">
                <option 
                    value="false"
                    selected
                >
                    No Tax Exemption
                </option>
                <option
                    value="new"
                >
                    New Tax Exemption    
                </option>
                <option
                    data-tax-ex-first="" data-tax-ex-last="" data-tax-ex-street-address=""
                    data-tax-ex-city="" data-tax-ex-state="" data-tax-ex-zip=""
                    data-tax-ex-signed-date="" data-tax-ex-exp-date="" data-tax-ex-does-not-exp=""
                    data-tax-ex-type="" data-tax-ex-number="" data-tax-ex-reason=""
                    data-tax-ex-states="" data-tax-ex-id=""
                >
                    Exemption #1234 (UT)
                </option>
            </select>
            <label for="tax-ex-status">Tax Exemption Status</label>
        </div>
        <div id="#tax-ex-view-section"></div>
        <div class="d-none" id="tax-ex-form-content">
            <h3 class="text-center">Customer Details</h3>
            <div class="form-check mb-3">
                <input class="form-check-input" type="checkbox" id="tax-ex-same-as-shipping" name="tax-ex-same-as-shipping">
                <label class="form-check-label" for="tax-ex-same-as-shipping">
                    Same address as shipping
                </label>
            </div>
            <div class="mb-3 form-floating-label-container">
                <input type="text" class="form-control" id="tax-ex-company-name" name="tax-ex-company-name" placeholder="Input Company Name" />
                <label for="tax-ex-company-name">Company Name</label>
            </div>
            <div class="row">
                <div class="col-12 col-md-6">
                    <div class="mb-3 form-floating-label-container">
                        <input class="form-control" id="tax-ex-first-name" name="tax-ex-first-name" placeholder="Input First Name" />
                        <label for="tax-ex-first-name">First Name</label>
                    </div>
                </div>
                <div class="col-12 col-md-6">
                    <div class="mb-3 form-floating-label-container">
                        <input class="form-control" id="tax-ex-last-name" name="tax-ex-last-name" placeholder="Input Last Name" />
                        <label for="tax-ex-last-name">Last Name</label>
                    </div>
                </div>
            </div>
            <div class="mb-3 form-floating-label-container">
                <input class="form-control" id="tax-ex-street-address-one" name="tax-ex-street-address-one" placeholder="Input Street Address" />
                <label for="tax-ex-street-address-one">Street Address</label>
            </div>
            <div class="mb-3 form-floating-label-container">
                <input class="form-control" id="tax-ex-street-address-two" name="tax-ex-street-address-two" placeholder="Input Street Address Line Two" />
                <label for="tax-ex-street-address-two">Street Address 2 (Optional)</label>
            </div>
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="mb-3 form-floating-label-container">
                        <input class="form-control" id="tax-ex-city" name="tax-ex-city" placeholder="Input City Name" />
                        <label for="tax-ex-city">City</label>
                    </div>
                </div>
                <div class="col-12 col-md-4">
                    <div class="mb-3 form-floating-label-container">
                        <select class="form-select" id="tax-ex-customer-state" name="tax-ex-customer-state">
                            <option disabled selected>Choose...</option>
                            <?php
                                foreach ($state_abbreviations as $state)
                                {
                                    echo "<option value='{$state['id']}'>{$state['text']}</option>";
                                }
                            ?>
                        </select>
                        <label for="tax-ex-customer-state">State</label>
                    </div>
                </div>
                <div class="col-12 col-md-4">
                    <div class="mb-3 form-floating-label-container">
                        <input type="text" class="form-control" id="tax-ex-zip-code" name="tax-ex-zip-code" placeholder="Input Zip">
                        <label for="tax-ex-zip-code">Zip Code</label>
                    </div>
                </div>
            </div>
            <h3 class="text-center">Certificate Details</h3>
            <div class="row mb-3">
                <label for="tax-ex-signed-date" class="col-12 col-md-6 col-form-label">Signed Date</label>
                <div class="col-12 col-md-6">
                    <input type="date" class="form-control text-center text-uppercase" id="tax-ex-signed-date" name="tax-ex-signed-date" />
                </div>
            </div>
            <div class="row mb-3">
                <label for="tax-ex-expiration-date" class="col-12 col-md-6 col-form-label">Expiration Date</label>
                <div class="col-12 col-md-6">
                    <input type="date" class="form-control text-center text-uppercase" id="tax-ex-expiration-date" name="tax-ex-expiration-date" />
                    <div class="form-check d-flex align-items-center justify-content-center">
                        <!-- <input class="form-check-input" type="checkbox" id="tax-ex-no-exp" name="tax-ex-no-exp">
                        <label class="form-check-label col-form-label ps-2" for="tax-ex-no-exp">
                            No Expiration
                        </label> -->
                        <span class="text-center">If your certificate doesn't expire, please use the end of this calendar year.</span>
                    </div>
                </div>
            </div>
            <div class="row mb-3">
                <div class="col-12 col-md-4">
                    <div class="mb-3 form-floating-label-container">
                        <select class="form-select" id="tax-ex-type" name="tax-ex-type">
                            <option disabled selected>Tax Type</option>
                            <option value="1">Utah</option>
                            <option value="2">Nevaduh</option>
                            <option value="3">Stinky New York</option>
                        </select>
                        <label for="tax-ex-type">Tax Type</label>
                    </div>
                </div>
                <div class="col-12 col-md-4">
                    <div class="mb-3 form-floating-label-container">
                        <input class="form-control" id="tax-ex-tax-number" placeholder="Input Tax Number" />
                        <label for="tax-ex-tax-number">Tax Number</label>
                    </div>
                </div>
                <div class="col-12 col-md-4">
                    <div class="mb-3 form-floating-label-container">
                        <select class="form-select" id="tax-ex-reason" name="tax-ex-reason">
                            <option disabled selected>Reason</option>
                            <option value="1">Because</option>
                            <option value="2">Because but Better</option>
                            <option value="3">Taxes Suck</option>
                        </select>
                        <label for="tax-ex-reason">Reason</label>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="mb-3 form-floating-label-container">
                        <select class="form-select" id="tax-ex-certificate-state" name="tax-ex-certificate-state">
                            <option disabled selected>Choose...</option>
                        </select>
                        <label for="tax-ex-certificate-state">State</label>
                    </div>
                </div>
                <div class="col-12 col-md-8" id="tax-ex-states">
                    <div class="mb-3 form-floating-label-container">
                        <select class="form-select" id="tax-ex-selected-states" name="tax-ex-selected-states" size="5">
                            
                        </select>
                        <label for="tax-ex-selected-states">Selected States</label>
                    </div>
                    <button id="tax-ex-remove-selected-button" type="button" class="btn w-100">Remove Selected State</button>
                </div>
            </div>
            
            <div class="d-flex justify-content-center align-items-center">
                <div class="text-center">
                    <p id="tax-ex-file-info">Exemption File<br />(PDF only) max 8MB</p>
                    <div class="mb-0">
                        <input type="file" id="tax-ex-file" aria-label="Tax Exemption File Input" accept=".pdf" aria-labelledby="tax-ex-file-info" />
                        <label for="tax-ex-file"  class="file-upload-container">
                            Upload File
                        </label>
                    </div>
                    <p class="mb-3" id="tax-ex-file-output">No File Chosen</p>
                </div>
            </div>
            <div class="form-check">
                <input class="form-check-input" type="checkbox" value="" id="tax-ex-terms">
                <label class="form-check-label" for="tax-ex-terms">
                    I agree to the terms and conditions of this module
                </label>
            </div>
        </div>
        <div class="row mb-5">
            <div class="col-10 offset-1 col-md-8 offset-md-2">
                <button type="button" class="btn bg-westech-green text-white w-100" id="checkout-tax-ex-continue-button">Continue</button>
            </div>
        </div>
    </form>
    <?php
    }
    else
    {
    ?>
    <form class="checkout-form">
        <h4 class="text-center">You need to <a href="?main_page=register">create an account</a> or <a href="?main_page=login">login</a></h4>
        <div class="row mb-5">
            <div class="col-10 offset-1 col-md-8 offset-md-2">
                <button type="button" class="btn bg-westech-green text-white w-100" id="checkout-tax-ex-continue-button">Continue</button>
            </div>
        </div>
    </form>
    <?php
    }
    ?>

</div>