<?php
/**
 * checkout_success header_php.php
 *
 * @copyright Copyright 2003-2022 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: torvista 2022 Feb 18 Modified in v1.5.8-alpha $
 */

// This should be first line of the script:
$zco_notifier->notify('NOTIFY_HEADER_START_CHECKOUT_SUCCESS');

// if the customer is not logged on, redirect them to the shopping cart page
if (!zen_is_logged_in()) {
  zen_redirect(zen_href_link(FILENAME_TIME_OUT));
}

if (!isset($_GET['order']))
{
  zen_redirect(zen_href_link(FILENAME_ACCOUNT));
}

define('HEADING_TITLE', 'Checkout Success');

$correct_customer = true;
$customer_notified = false;
$show_success = true;
$success_body = "
<main class='container'>
  <div class='row'>
    ";

//check if this custom placed the order
$order_query = $db->Execute("SELECT customers_id FROM zen_orders WHERE orders_id = {$_GET['order']}");

if ($order_query->fields['customers_id'] != $_SESSION['customer_id'])
{
  $correct_customer = false;
  $show_success = false;
}

//check if this confirmation has been seen yet
$confirm_query = $db->Execute("SELECT customer_notified FROM zen_orders_status_history WHERE orders_id = {$_GET['order']} AND updated_by = 'ADN System'");

if ($confirm_query->fields['customer_notified'] != "-1")
{
  $customer_notified = true;
  $show_success = false;
}

if ($show_success && $correct_customer && !$customer_notified)
{
  include DIR_FS_CATALOG . DIR_WS_CLASSES . 'order.php';
  $order_detail = new order($_GET['order']);

  // prePrintPre($order_detail);

  $order_date = zen_date_long($order_detail->info['date_purchased']);
  $order_items = "";

  foreach ($order_detail->products as $product)
  {
    $product_image = zen_get_products_image($product['id'], zen_output_string($product['name']));
    $product_image = substr_replace($product_image, " class='cart-page-item-image' ", 4, 0);
    $product_model_and_name = $product['model'] . ' || ' . $product['name'];
    $product_price = number_format($product['final_price'], 2);
    $product_quantity = $product['qty'];
    $product_final_price = number_format(($product['final_price'] * $product_quantity), 2);

    $product_attributes = "";

    if (isset($product['attributes']))
    {
      $product_attributes .= "
      <div>
        <ul>
      ";

      foreach ($product['attributes'] as $attribute)
      {
        $attribute_text = $attribute['option'] . ' : ' . $attribute['value'];
        $prefix = $attribute['prefix'];
        $price = number_format($attribute['price'], 2);
        if ($attribute['price'] !== "0.0000") $attribute_text .= " ($prefix $$price)";

        $product_attributes .= "
        <li>$attribute_text</li>
        ";
      }

      $product_attributes .= "
        </ul>
      </div>
      ";
    }

    $order_items .= "
    <div class='row cart-page-item'>
      <div class='col-12 col-sm-3 col-md-2 col-lg-3 col-xl-2 text-center zoom-container'>
        $product_image
      </div>
      <div class='col-12 col-sm-9 col-md-10 col-lg-9 col-xl-10'>
        <div class='row'>
          <div class='col-12 col-sm-7 col-md-8 col-lg-7'>
            <p class='mb-0'>$product_model_and_name</p>
            <p class='text-muted'>$$product_price ea.</p>
            $product_attributes
          </div>
          <div class='col-12 col-sm-5 col-md-4 col-lg-5'>
            <div class='cart-page-item-quantity-summary'>
              <p class='text-muted cart-page-item-cost'>x$product_quantity : $$product_final_price</p>
            </div>
          </div>
        </div>
      </div>
    </div>
    ";
  }

  $shippingCompany = $order_detail->delivery['company'];
  $shippingName = $order_detail->delivery['name'];
  $shippingStreetAddress1 = $order_detail->delivery['street_address'];
  $shippingStreetAddress2 = $order_detail->delivery[''];
  $shippingStreetAddress3 = $order_detail->delivery[''];
  $shippingSuburb = $order_detail->delivery['suburb'];
  $shippingCity = $order_detail->delivery['city'];
  $shippingZip = $order_detail->delivery['postcode'];
  $shippingState = $order_detail->delivery['state'];
  $shippingCountry = $order_detail->delivery['country']['title'];

  $order_summary = "
  <div class='row cart-page-summary-container mb-3'>
    <div class='cart-page-summary'>
      <h4>Shipping To</h4>
      <div class='seperator w-100 m-0'></div>
  ";

  if (!empty($shippingCompany))
  {
    $order_summary .= "
    <p>Company: $shippingCompany</p>
    ";
  } 
  if (!empty($shippingName))
  {
    $order_summary .= "
    <p>Name: $shippingName</p>
    ";
  } 
  if (!empty($shippingStreetAddress1))
  {
    $order_summary .= "
    <p>Address: $shippingStreetAddress1</p>
    ";
  } 
  if (!empty($shippingSuburb))
  {
    $order_summary .= "
    <p>Address 2: $shippingSuburb</p>
    ";
  } 
  if (!empty($shippingCity))
  {
    $order_summary .= "
    <p>City: $shippingCity</p>
    ";
  } 
  if (!empty($shippingZip))
  {
    $order_summary .= "
    <p>ZIP: $shippingZip</p>
    ";
  } 
  if (!empty($shippingState))
  {
    $order_summary .= "
    <p>State: $shippingState</p>
    ";
  } 
  if (!empty($shippingCountry))
  {
    $order_summary .= "
    <p>Country: $shippingCountry</p>
    ";
  } 

  $order_summary .= "
    </div>
  </div>
  ";

  $order_summary .= "
  <div class='row cart-page-summary-container mb-3'>
    <div class='cart-page-summary'>
      <h4>Billed To</h4>
      <div class='seperator w-100 m-0'></div>
  ";

  $billingCompany = $order_detail->billing['company'];
  $billingName = $order_detail->billing['name'];
  $billingStreetAddress1 = $order_detail->billing['street_address'];
  $billingStreetAddress2 = $order_detail->billing[''];
  $billingStreetAddress3 = $order_detail->billing[''];
  $billingSuburb = $order_detail->billing['suburb'];
  $billingCity = $order_detail->billing['city'];
  $billingZip = $order_detail->billing['postcode'];
  $billingState = $order_detail->billing['state'];
  $billingCountry = $order_detail->billing['country']['title'];

  if (!empty($billingCompany))
  {
    $order_summary .= "
    <p>Company: $billingCompany</p>
    ";
  } 
  if (!empty($billingName))
  {
    $order_summary .= "
    <p>Name: $billingName</p>
    ";
  } 
  if (!empty($billingStreetAddress1))
  {
    $order_summary .= "
    <p>Address: $billingStreetAddress1</p>
    ";
  } 
  if (!empty($billingSuburb))
  {
    $order_summary .= "
    <p>Address 2: $billingSuburb</p>
    ";
  } 
  if (!empty($billingCity))
  {
    $order_summary .= "
    <p>City: $billingCity</p>
    ";
  } 
  if (!empty($billingZip))
  {
    $order_summary .= "
    <p>ZIP: $billingZip</p>
    ";
  } 
  if (!empty($billingState))
  {
    $order_summary .= "
    <p>State: $billingState</p>
    ";
  } 
  if (!empty($billingCountry))
  {
    $order_summary .= "
    <p>Country: $billingCountry</p>
    ";
  } 

  $order_summary .= "
    </div>
  </div>
  ";

  $order_summary .= "
  <div class='row cart-page-summary-container mb-3'>
    <div class='cart-page-summary'>
      <h4>Order Summary</h4>
  ";

  foreach ($order_detail->totals as $total)
  {
    $title = $total['title'];
    $text = $total['text'];

    if ($total['class'] == "ot_total")
    {
      $order_summary .= "
      <div class='seperator w-100 m-0'></div>
      <div class='d-flex justify-content-between'>
        <h3>$title</h3>
        <h3>$text</h3>
      </div>
      ";
    }
    else
    {
      $order_summary .= "
      <div class='d-flex justify-content-between'>
        <p>$title</p>
        <p>$text</p>
      </div>
      ";
    }
  }

  $order_summary .= "
    </div>
  </div>
  ";

  $googleSVG = '
  <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 85 36" class="injected-svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <g clip-path="url(#a-1)">
        <path fill="#4285F4" d="M20.778 13.43h-9.862v2.927h6.994c-.345 4.104-3.76 5.854-6.982 5.854-4.123 0-7.72-3.244-7.72-7.791 0-4.43 3.429-7.841 7.73-7.841 3.317 0 5.272 2.115 5.272 2.115l2.049-2.122s-2.63-2.928-7.427-2.928C4.725 3.644 0 8.8 0 14.367c0 5.457 4.445 10.777 10.988 10.777 5.756 0 9.969-3.942 9.969-9.772 0-1.23-.179-1.941-.179-1.941Z"></path>
        <path fill="#EA4335" d="M28.857 11.312c-4.047 0-6.947 3.163-6.947 6.853 0 3.744 2.813 6.966 6.994 6.966 3.786 0 6.887-2.893 6.887-6.886 0-4.576-3.607-6.933-6.934-6.933Zm.04 2.714c1.99 0 3.876 1.609 3.876 4.201 0 2.538-1.878 4.192-3.885 4.192-2.205 0-3.945-1.766-3.945-4.212 0-2.394 1.718-4.181 3.954-4.181Z"></path>
        <path fill="#FBBC05" d="M43.965 11.312c-4.046 0-6.946 3.163-6.946 6.853 0 3.744 2.813 6.966 6.994 6.966 3.785 0 6.886-2.893 6.886-6.886 0-4.576-3.607-6.933-6.934-6.933Zm.04 2.714c1.99 0 3.876 1.609 3.876 4.201 0 2.538-1.877 4.192-3.885 4.192-2.205 0-3.945-1.766-3.945-4.212 0-2.394 1.718-4.181 3.955-4.181Z"></path>
        <path fill="#4285F4" d="M58.783 11.319c-3.714 0-6.634 3.253-6.634 6.904 0 4.16 3.385 6.918 6.57 6.918 1.97 0 3.017-.782 3.79-1.68v1.363c0 2.384-1.448 3.812-3.633 3.812-2.11 0-3.169-1.57-3.537-2.46l-2.656 1.11c.943 1.992 2.839 4.07 6.215 4.07 3.693 0 6.508-2.327 6.508-7.205V11.734h-2.897v1.17c-.89-.96-2.109-1.585-3.726-1.585Zm.269 2.709c1.821 0 3.69 1.554 3.69 4.21 0 2.699-1.865 4.187-3.73 4.187-1.98 0-3.823-1.608-3.823-4.161 0-2.653 1.914-4.236 3.863-4.236Z"></path>
        <path fill="#EA4335" d="M78.288 11.302c-3.504 0-6.446 2.788-6.446 6.901 0 4.353 3.28 6.934 6.782 6.934 2.924 0 4.718-1.6 5.789-3.032l-2.389-1.59c-.62.962-1.656 1.902-3.385 1.902-1.943 0-2.836-1.063-3.39-2.094l9.266-3.845-.48-1.126c-.896-2.207-2.984-4.05-5.747-4.05Zm.12 2.658c1.263 0 2.171.671 2.557 1.476l-6.187 2.586c-.267-2.002 1.63-4.062 3.63-4.062Z"></path>
        <path fill="#34A853" d="M67.425 24.727h3.044V4.359h-3.044v20.368Z"></path>
    </g>
    <defs>
        <clipPath id="a-1">
            <path fill="#fff" d="M0 0h84.515v36H0z"></path>
        </clipPath>
    </defs>
  </svg>
';

  $success_body .= "
  <div class='d-flex flex-column'>
    <div class='d-flex flex-column'>
      <h2 class='text-primary-wtg text-center'>Thank you for your purchase!</h2>
      <p class='text-center'>Your order has been received. We may contact you to verify your purchase.</p>
      <p class='mb-0 text-center'>Additional verification is for your safety, as well as ours.</p>
      <p class='text-center'>We strive to provide a safe browsing environment to our customers and we appreciate your willingness to help us achieve our goal.</p>
    </div>
    <div class='d-flex flex-column'>
      <p>Order Number: {$_GET['order']}</p>
      <p>Order Date: $order_date</p>
      <div class='row mb-3'>
        <div class='col-12 col-lg-8 mb-3'>
          $order_items
          <div class='google-reviews d-flex justify-content-center m-5'>
           <a href='https://g.page/r/Cbr7m0c23unUEAI/review'><button type='button' class='btn bg-westech-green text-white p-5'>$googleSVG Please take a minute to leave us a review!</button></a>
          </div>
        </div>
        <div class='col-12 col-lg-4'>
          $order_summary
        </div>
      </div>
    </div>
  </div>
  ";

  $_SESSION['cart']->reset(true);
}
else
{
  if (!$correct_customer)
  {
    $success_body .= "<h3>You must be logged into the account that placed this order.</h3>";
  }
  else
  {
    if ($customer_notified)
    {
      $success_body .= "<h2>Our records indicate this order confirmation has already been viewed by the customer.</h2>";
      $success_body .= "<h3>For your safety, we will not display a confirmation after it has been viewed. If you require a copy of the confirmation, please <a href='/contact'>contact us</a>.</h3>";
    }
  }
}

$success_body .= "
  </div>
</main>";

// This should be last line of the script:
$zco_notifier->notify('NOTIFY_HEADER_END_CHECKOUT_SUCCESS');
