<?php
/**
 * Common Template - tpl_main_page.php
 *
 * Governs the overall layout of an entire page
 * Normally consisting of a header, left side column. center column. right side column and footer
 * For customizing, this file can be copied to /templates/your_template_dir/pagename
 * example: to override the privacy page
 * - make a directory /templates/my_template/privacy
 * - copy /templates/templates_defaults/common/tpl_main_page.php to /templates/my_template/privacy/tpl_main_page.php
 *
 * to override the global settings and turn off columns un-comment the lines below for the correct column to turn off
 * to turn off the header and/or footer uncomment the lines below
 * Note: header can be disabled in the tpl_header.php
 * Note: footer can be disabled in the tpl_footer.php
 *
 * $flag_disable_header = true;
 * $flag_disable_left = true;
 * $flag_disable_right = true;
 * $flag_disable_footer = true;
 *
 * // example to not display right column on main page when Always Show Categories is OFF
 *
 * if ($current_page_base == 'index' and $cPath == '') {
 *  $flag_disable_right = true;
 * }
 *
 * example to not display right column on main page when Always Show Categories is ON and set to categories_id 3
 *
 * if ($current_page_base == 'index' and $cPath == '' or $cPath == '3') {
 *  $flag_disable_right = true;
 * }
 *
 * @copyright Copyright 2003-2022 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: DrByte 2020 Dec 29 Modified in v1.5.8-alpha $
 */

if (!defined('IS_ADMIN_FLAG')) {
    die('Illegal Access');
}

/** bof DESIGNER TESTING ONLY: */
// $messageStack->add('header', 'this is a sample error message', 'error');
// $messageStack->add('header', 'this is a sample caution message', 'caution');
// $messageStack->add('header', 'this is a sample success message', 'success');
// $messageStack->add('main', 'this is a sample error message', 'error');
// $messageStack->add('main', 'this is a sample caution message', 'caution');
// $messageStack->add('main', 'this is a sample success message', 'success');
/** eof DESIGNER TESTING ONLY */

if (isset($_SESSION['devdata']))
{
  // echo $_SESSION['devdata'];
  unset($_SESSION['devdata']);
}

$header_template = 'tpl_header.php';
$footer_template = 'tpl_footer.php';
$left_column_file = 'column_left.php';
$right_column_file = 'column_right.php';
$body_id = ($this_is_home_page) ? 'indexHome' : str_replace('_', '', $_GET['main_page']);
?>
<body>


<?php
 /**
  * prepares and displays header output
  *
  */
  if (CUSTOMERS_APPROVAL_AUTHORIZATION == 1 && CUSTOMERS_AUTHORIZATION_HEADER_OFF == 'true' and ($_SESSION['customers_authorization'] != 0 or !zen_is_logged_in())) {
    $flag_disable_header = true;
  }
  require($template->get_template_dir('tpl_header.php',DIR_WS_TEMPLATE, $current_page_base,'common'). '/tpl_header.php');?>

<?php
 /**
  * prepares and displays center column
  *
  */
 require($body_code);
?>


<button id="scroll-to-top-button" onclick="window.scrollTo(0, 0)">
  <i class="fa-solid fa-arrow-up"></i>
</button>

<?php
 /**
  * prepares and displays footer output
  *
  */
  require($template->get_template_dir('tpl_footer.php',DIR_WS_TEMPLATE, $current_page_base,'common'). '/tpl_footer.php');
?>


<?php /* add any end-of-page code via an observer class */
  $zco_notifier->notify('NOTIFY_FOOTER_END', $current_page);
?>

<script src="https://code.jquery.com/jquery-3.6.1.min.js" integrity="sha256-o88AwQnZB+VDvE9tvIXrMQaPlFFSUTR+nldQm1LuPXQ=" crossorigin="anonymous"></script>
<script>
  /*
    Wait until all content is loaded
  */
  $(document).ready(() => {
    // Get scroll to top button using jquery
    const $scrollToTopButton = $("#scroll-to-top-button");

    /*
      watchScroll()
      Purpose: Watch the window scroll for dynamic views
      Params: NONE
      Returns: NONE
    */
    function watchScroll() {
      // Get window height and width
      const windowHeight = $(window).height();
      const windowWidth = $(window).width();
      
      // Dont do anything since its a desktop
      if(windowWidth > 991) {
        return;
      }

      // Get bottom view port value
      const bottomViewport = window.scrollY + windowHeight;

      // Check if bottom viewport is greater than the height +50
      // Check if scroll to top button is not visible
      if(bottomViewport >= windowHeight + 50 && !$scrollToTopButton.hasClass("d-block")) {
        // Make button visible
        $scrollToTopButton.addClass("d-block");
      } 
      // Check if bottom viewport is less than the height +50
      // Check if scroll to top button is visible
      else if(bottomViewport <= windowHeight + 50 && $scrollToTopButton.hasClass("d-block")) {
        // Hide button
        $scrollToTopButton.removeClass("d-block");
      }
    } // End watchScroll()

    /*
      $(window).scroll()
      Purpose: Watch window scroll event
      Params: NONE
      Returns: NONE
    */
    $(window).scroll(function () {
      // Watch scroll
      watchScroll();
    }); // END $(window).scroll()
  });
</script>
<?php
  $directory_array = $template->get_template_part($page_directory, '/^jscript_/', '.js');
  foreach($directory_array as $key => $value) {
    echo '<script  defer src="' . $page_directory . '/' . $value . '?d=' . time() . '"></script>' . "\n";
  }
  
  $directory_array = $template->get_template_part($template->get_template_dir('.js',DIR_WS_TEMPLATE, $current_page_base,'jscript'), '/^jscript_/', '.js');

  foreach($directory_array as $key => $value) {
    echo '<script defer src="' .  $template->get_template_dir('.js',DIR_WS_TEMPLATE, $current_page_base,'jscript') . '/' . $value . '?d=' . time() . '"></script>'."\n";
  }
?>
    <!-- JavaScript Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-OERcA2EqjJCMA+/3y+gxIOqMEjwtxJY7qPCqsdltbNJuaOe923+mo//f6V8Qbsw3" crossorigin="anonymous"></script>
    <script src="https://kit.fontawesome.com/d49dc9dfeb.js" crossorigin="anonymous"></script>
</body>
