<?php
  // Display all header alerts via messageStack:
  if ($messageStack->size('header') > 0) {
    echo $messageStack->output('header');
  }
  if (!empty($_GET['error_message'])) {
    echo zen_output_string_protected(urldecode($_GET['error_message']));
  }
  if (!empty($_GET['info_message'])) {
   echo zen_output_string_protected($_GET['info_message']);
}
// check whether to only display errors/alerts, or to also display the rest of the header
if (isset($flag_disable_header) && $flag_disable_header === true) {
  // do early-return from this template since $flag_disable_header is true
  return;
}

?>
<?php

$dropdowns = array();

$dropdowns['categories'] = $db->Execute("SELECT zen_categories.categories_id, zen_categories.sort_order, zen_categories_description.categories_name FROM `zen_categories` LEFT JOIN `zen_categories_description` ON zen_categories.categories_id = zen_categories_description.categories_id  WHERE `parent_id` = 2 AND zen_categories.categories_status = 1 ORDER BY zen_categories_description.categories_name ASC");
$dropdowns['brands'] = $db->Execute("SELECT zen_categories.categories_id, zen_categories.sort_order, zen_categories_description.categories_name FROM `zen_categories` LEFT JOIN `zen_categories_description` ON zen_categories.categories_id = zen_categories_description.categories_id  WHERE `parent_id` = 1 AND zen_categories.categories_status = 1 ORDER BY zen_categories_description.categories_name ASC");
$dropdowns['parts'] = $db->Execute("SELECT zen_categories.categories_id, zen_categories.sort_order, zen_categories_description.categories_name FROM `zen_categories` LEFT JOIN `zen_categories_description` ON zen_categories.categories_id = zen_categories_description.categories_id  WHERE `parent_id` = 4433 AND zen_categories.categories_status = 1 ORDER BY zen_categories_description.categories_name ASC");

?>  
<header>
    <nav class="navbar navbar-expand-md bg-westech-green pt-0" id="header-navbar">
        <div class=" container-fluid p-0 main-navbar-container">
            <div class="container-fluid bg-white p-0">
                <div class="container-lg navbar-core-components-container">
                
                    <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" aria-label="navbar button"
                        data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar" >
                        <span class="navbar-toggler-icon"></span>
                    </button>

                    <p class="fw-bold fs-5" id="navbar-brand-text">
                        The Pump and Tank Equipment Company<span class="registered-trademark">®</span><span id="navbar-contact-info"><br />
                        <img src="images/phone-solid.svg" alt="phone" height="16" width="16" /> <a class="text-black" href="tel:+18004338831">1 (800) 433-8831</a> <img src="images/clock-solid.svg" alt="time" height="16" width="16" /> 7:30 AM - 4:30 PM MST</span></p>
                    <a href="/" title="Westech Equipment Home Page" id="navbar-logo-container">
                        <img src="/images/westech-logo.webp" alt="Westech Equipment Logo" id="navbar-logo">
                    </a>
                    <div id="navbar-icons-container"></div>
                    <form role="search" id="navbar-search-form">
                        <div class="input-group" id="navbar-search-input-group">
                            <input type="text" class="form-control" id="navbar-search-input" placeholder="Search Catalog..." aria-label="Product" />
                            <button type="submit" aria-label="Search product button" id="navbar-search-icon-button" ><i class="fa-solid fa-magnifying-glass fa-lg"></i></button>
                        </div>
                        <div id="navbar-search-results-container">
                        </div>
                    </form>
                </div>
                <script>
                    async function updateCartDisplay(isAddedToCart = false, products = null) {
                        $cartDisplayAjax = await $.ajax(
                            {
                                type: "POST",
                                url: 'ajax_cart.php',
                                data: {
                                    'cart-action': 'display'
                                }
                            }
                        );

                        try {
                            $cartDisplayAjaxJ = JSON.parse($cartDisplayAjax);

                            if ($cartDisplayAjaxJ.code == 1) {
                                $("#navbar-icons-container").html($cartDisplayAjaxJ.content);
                                const checkoutPopupContent = `
                                    
                                `;
                                $("#checkout-popup").html(checkoutPopupContent);
                                // Add Checkout button to cart
                            }
                        } catch (e) {
                            alert("Cart couldn't be displayed correctly.");
                            console.log($cartDisplayAjax);
                            console.log(e);
                        }

                        // Add popup if item is added
                        if(isAddedToCart) {
                            // Try to get data from cart
                            try {
                                // Ajax query to get data using default post action
                                let cartData = await $.ajax(
                                    {
                                        type: "POST",
                                        url: 'ajax_cart.php'
                                    }
                                );
                                // parse item data to JSON
                                const { itemCount, total, isLoggedIn, cartLink, itemData } = JSON.parse(cartData);
                                
                                //if cart is empty, don't show popup
                                if (itemCount == 0) return;

                                // Create summary row
                                const summaryRow = `
                                    <div class="row cartPopupSummary">
                                        <div class="summaryContainer">
                                            <div class="itemsTotalCost">
                                                <p>
                                                    <span class="fw-bold">${itemCount}</span> ${itemCount > 1 ? "Items" :  "Item"} In Cart
                                                </p>
                                            </div>
                                            <div class="itemsTotalCount">
                                                <p>
                                                    Cart Subtotal:
                                                </p>
                                                <p class="fw-bold">
                                                    $${total}
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                `;

                                // Create checkout button
                                const proceedToCheckoutButton = `
                                    <div class="row pt-3">
                                        <a href="?main_page=checkout${isLoggedIn? '' : '_guest'}" title="checkout" class="cart-popup-checkout-button text-white">
                                            Proceed To Checkout
                                        </a>
                                    </div>
                                `;


                                // Create product display as an empty string
                                let productDisplays = '';
                                
                                // Loop through each item in the cart data
                                for(let key in itemData)
                                {
                                    // get current product
                                    const product = itemData[key];
                                    // Create a display for that product
                                    const productDisplay = `
                                        <div class="col-12">
                                            <div class="row cart-popup-product-display pt-2 pb-2">
                                                <div class="col-4">
                                                    <img src="images/${product.products_image}" alt="${product.products_name}" class="imgSize" />
                                                </div>
                                                <div class="col-8">
                                                <span class='brand-text-color'>${product.manufacturers_name}</span>
                                                <span class='model-text-color'>${product.products_model}</span>
                                                    <span>${product.products_name}</span>
                                                    <div>
                                                    <span class="fw-bold">$${product.productTotalPrice}</span>
                                                    </div>
                                                    <div class="item-update-section">
                                                        <div class="qty-count">
                                                            <div class="decrease-qty-icon center-content"><i data-id="${key}" data-current-quantity="${product.qty}" class="fa-solid fa-minus"></i></div>
                                                            <input type="number" data-id="${key}" class="cart-popup-qty form-control product-quantity-input" value="${product.qty}" />
                                                            <div class="increase-qty-icon center-content"><i data-id="${key}" data-current-quantity="${product.qty}" class="fa-solid fa-plus"></i></div>
                                                            
                                                        </div>
                                                        <div class="item-update-delete-button">
                                                            <button type="button" class="btn westech-green">
                                                                <i data-id="${key}" class="fa-solid fa-trash fa-lg text-darker-grey" aria-hidden="true"></i>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    `;
                                    // Add product to display
                                    productDisplays += productDisplay;
                                }
                                // Create the whole items display using products created from loop before
                                const itemAddedSection = `
                                    <div class="row mt-3 pt-3 cart-popup-item-section">
                                        ${productDisplays}
                                    </div>
                                `;

                                // Create proceed to checkout link 
                                const proceedToCartLink = `
                                    <div class="row pt-3 mt-3 pb-3">
                                        <a href="${cartLink}" title="cart" class="cart-popup-cart-link text-center text-black">
                                            View and Edit Cart
                                        </a>
                                    </div>
                                `;

                                // Contents reside in a container bootstrap element
                                // Add all items into one main HTML
                                const cartPopupContents = `
                                    <div class="cart-popup-arrow"></div>
                                    <div class="cart-popup-header">
                                        <button class="cart-popup-close">x</button>
                                    </div>
                                    ${summaryRow}
                                    ${proceedToCheckoutButton}
                                    <hr>
                                    ${itemAddedSection}
                                    <hr>
                                    ${proceedToCartLink}
                                `;

                                // Get checkout popup
                                const checkoutPopup = $("#checkout-popup");
                                // append contents
                                checkoutPopup.append(cartPopupContents);
                                // Show popup
                                checkoutPopup.addClass("show-checkout-popup");
                                // Create close button on click event
                                $(".cart-popup-close").click(function(event) {
                                    checkoutPopup.addClass("d-none");
                                });

                            } catch(e) {
                                console.log(e);
                                console.log("An unknown error occured");
                            }
                        }
                    }

                    async function updateCart(product_id, new_quantity) {
                        
                        if(new_quantity == 0){ 
                            const continueUpdateCart = confirm("Are you sure you want to remove this item from the cart?")
                            if(!continueUpdateCart) {
                                updateCartDisplay(true);
                                return;
                            }
                        }
                        let ajaxCall = await $.ajax({
                            type: "POST",
                            url: "ajax_cart.php",
                            data: {
                                "cart-action": "update",
                                "product_id": product_id,
                                "new_quantity": new_quantity
                            }
                        });

                        updateCartDisplay(true);
                    }

                    async function removeFromCart(product_id) {
                        let ajaxCall = await $.ajax({
                            type: "POST",
                            url: "ajax_cart.php",
                            data: {
                                "cart-action": "remove",
                                "product_id" : product_id
                            }
                        });

                        updateCartDisplay(true);
                    }

                    $(document).ready(updateCartDisplay());

                    $('#navbar-icons-container').on('change', '.cart-popup-qty', function() {
                        let new_quantity = $(this).val();
                        updateCart($(this).data('id'), new_quantity);
                    });

                    $('#navbar-icons-container').on('click', '.fa-minus', function() {
                        let new_quantity = $(this).data('current-quantity') - 1;
                        updateCart($(this).data('id'), new_quantity);
                    });

                    $('#navbar-icons-container').on('click', '.fa-plus', function() {
                        let new_quantity = $(this).data('current-quantity') + 1;
                        updateCart($(this).data('id'), new_quantity);
                    });

                    $('#navbar-icons-container').on('click', '.fa-trash', function() {
                        removeFromCart($(this).data('id'));
                    })
                </script>
            </div>
            <div class="container-lg navbar-link-components">
                <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasNavbar"
                    aria-labelledby="offcanvasNavbarLabel">
                    <div class="offcanvas-header bg-westech-green text-white">
                        <h5 class="offcanvas-title bg-westech-green text-white" id="offcanvasNavbarLabel">Westech Equipment</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                    </div>
                    <!-- <div class="border-top"></div> -->
                    <div class="offcanvas-body text-black bg-white">
                        <ul class="navbar-nav justify-content-start flex-grow-1">
                            <li class="nav-item">
                                <a class="nav-link dropdown-toggle header-nav-link" role="button" data-bs-toggle="dropdown"
                                    aria-expanded="false">
                                    CATEGORIES
                                </a>
                                <ul class="dropdown-menu navbar-dropdown-menu">
                                    <div class="navbar-dropdown-container">
                                        <li class="navbar-dropdown-header-container">
                                            <div class="navbar-dropdown-header">
                                                <i class="fa-solid fa-left-long fa-xl navbar-dropdown-header-icon"></i>
                                                <p class="navbar-dropdown-header-text">CATEGORIES</p>
                                            </div>
                                        </li>
                                        <?php

                                        foreach ($dropdowns['categories'] as $cat) {
                                            echo '<li>';
                                            echo '<a class="dropdown-item" href="?main_page=index&cPath=2_' . $cat['categories_id'] . '">' . $cat['categories_name'] . '</a>';
                                            echo '</li>';
                                        }

                                        ?>
                                    </div>
                                </ul>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link dropdown-toggle header-nav-link" role="button" data-bs-toggle="dropdown"
                                    aria-expanded="false">
                                    BRANDS
                                </a>
                                <ul class="dropdown-menu navbar-dropdown-menu">
                                    <div class="navbar-dropdown-container">
                                        <li class="navbar-dropdown-header-container">
                                            <div class="navbar-dropdown-header">
                                                <i class="fa-solid fa-left-long fa-xl navbar-dropdown-header-icon"></i>
                                                <p class="navbar-dropdown-header-text">BRANDS</p>
                                            </div>
                                        </li>
                                        <?php

                                        foreach ($dropdowns['brands'] as $cat) {
                                            echo '<li>';
                                            echo '<a class="dropdown-item" href="?main_page=index&cPath=1_' . $cat['categories_id'] . '">' . $cat['categories_name'] . '</a>';
                                            echo '</li>';
                                        }

                                        ?>
                                    </div>
                                </ul>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link dropdown-toggle header-nav-link" role="button" data-bs-toggle="dropdown"
                                    aria-expanded="false">
                                    PARTS
                                </a>
                                <ul class="dropdown-menu navbar-dropdown-menu">
                                    <div class="navbar-dropdown-container">
                                        <li class="navbar-dropdown-header-container">
                                            <div class="navbar-dropdown-header">
                                                <i class="fa-solid fa-left-long fa-xl navbar-dropdown-header-icon"></i>
                                                <p class="navbar-dropdown-header-text">PARTS</p>
                                            </div>
                                        </li>
                                        <?php

                                        foreach ($dropdowns['parts'] as $cat) {
                                            echo '<li>';
                                            echo '<a class="dropdown-item" href="?main_page=index&cPath=4433_' . $cat['categories_id'] . '">' . $cat['categories_name'] . '</a>';
                                            echo '</li>';
                                        }

                                        ?>
                                    </div>
                                </ul>
                            </li>
                            <li class="nav-item" id="navbar-account-nav-item">
                                <a class="nav-link dropdown-toggle header-nav-link" role="button" data-bs-toggle="dropdown"
                                    aria-expanded="false">
                                    ACCOUNT
                                </a>
                                <ul class="dropdown-menu navbar-dropdown-menu navbar-account-dropdown">
                                    <div class="navbar-dropdown-container">
                                        <li class="navbar-dropdown-header-container">
                                            <div class="navbar-dropdown-header">
                                                <i class="fa-solid fa-left-long fa-xl navbar-dropdown-header-icon"></i>
                                                <p class="navbar-dropdown-header-text">ACCOUNT</p>
                                            </div>
                                        </li>
                                        <?php if(zen_is_logged_in()) { ?>
                                            <li><a class="dropdown-item" href="<?php echo zen_href_link("login", '', 'SSL'); ?>">My Account</a></li>
                                            <li><a class="dropdown-item" href="<?php echo zen_href_link("logout", '', 'SSL'); ?>">Log Out</a></li>
                                        <?php  } else { ?>
                                            <li><a class="dropdown-item" href="<?php echo zen_href_link("login", '', 'SSL'); ?>">Login</a></li>
                                            <li><a class="dropdown-item" href="<?php echo zen_href_link("register", '', 'SSL'); ?>">Register</a></li>
                                        <?php } ?>
                                    </div>
                                </ul>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link-no-hover header-nav-link" href="<?php echo zen_href_link("contact_us", '', 'SSL'); ?>" title="Reach Out To Us!">CONTACT US</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </nav>
</header>
<p class="container-fluid text-center navWarningText">Is your order time-sensitive? <a class="text-black" href="mailto:contact@westechequipment.com" title="Westech Equipment Contact Email Address">Send us an email</a> or <a href="tel:1-800-433-8831" title="Westech Equipment Phone Number" class="text-black">call us</a> to see which suppliers are experiencing material shortages or delayed shipping times.</p>