<?php

$state_abbreviations = array(
    array('id' => 'AL', 'text' => 'Alabama'),
    array('id' => 'AK', 'text' => 'Alaska'),
    array('id' => 'AZ', 'text' => 'Arizona'),
    array('id' => 'AR', 'text' => 'Arkansas'),
    array('id' => 'CA', 'text' => 'California'),
    array('id' => 'CO', 'text' => 'Colorado'),
    array('id' => 'CT', 'text' => 'Connecticut'),
    array('id' => 'DE', 'text' => 'Delaware'),
    array('id' => 'DC', 'text' => 'District of Columbia'),
    array('id' => 'FL', 'text' => 'Florida'),
    array('id' => 'GA', 'text' => 'Georgia'),
    array('id' => 'HI', 'text' => 'Hawaii'),
    array('id' => 'ID', 'text' => 'Idaho'),
    array('id' => 'IL', 'text' => 'Illinois'),
    array('id' => 'IN', 'text' => 'Indiana'),
    array('id' => 'IA', 'text' => 'Iowa'),
    array('id' => 'KS', 'text' => 'Kansas'),
    array('id' => 'KY', 'text' => 'Kentucky'),
    array('id' => 'LA', 'text' => 'Louisiana'),
    array('id' => 'ME', 'text' => 'Maine'),
    array('id' => 'MD', 'text' => 'Maryland'),
    array('id' => 'MA', 'text' => 'Massachusetts'),
    array('id' => 'MI', 'text' => 'Michigan'),
    array('id' => 'MN', 'text' => 'Minnesota'),
    array('id' => 'MS', 'text' => 'Mississippi'),
    array('id' => 'MO', 'text' => 'Missouri'),
    array('id' => 'MT', 'text' => 'Montana'),
    array('id' => 'NE', 'text' => 'Nebraska'),
    array('id' => 'NV', 'text' => 'Nevada'),
    array('id' => 'NH', 'text' => 'New Hampshire'),
    array('id' => 'NJ', 'text' => 'New Jersey'),
    array('id' => 'NM', 'text' => 'New Mexico'),
    array('id' => 'NY', 'text' => 'New York'),
    array('id' => 'NC', 'text' => 'North Carolina'),
    array('id' => 'ND', 'text' => 'North Dakota'),
    array('id' => 'OH', 'text' => 'Ohio'),
    array('id' => 'OK', 'text' => 'Oklahoma'),
    array('id' => 'OR', 'text' => 'Oregon'),
    array('id' => 'PA', 'text' => 'Pennsylvania'),
    array('id' => 'RI', 'text' => 'Rhode Island'),
    array('id' => 'SC', 'text' => 'South Carolina'),
    array('id' => 'SD', 'text' => 'South Dakota'),
    array('id' => 'TN', 'text' => 'Tennessee'),
    array('id' => 'TX', 'text' => 'Texas'),
    array('id' => 'UT', 'text' => 'Utah'),
    array('id' => 'VT', 'text' => 'Vermont'),
    array('id' => 'VA', 'text' => 'Virginia'),
    array('id' => 'WA', 'text' => 'Washington'),
    array('id' => 'WV', 'text' => 'West Virginia'),
    array('id' => 'WI', 'text' => 'Wisconsin'),
    array('id' => 'WY', 'text' => 'Wyoming'),
    array('id' => 'AS', 'text' => 'American Samoa'),
    array('id' => 'GU', 'text' => 'Guam'),
    array('id' => 'MP', 'text' => 'Northern Marina Islands'),
    array('id' => 'PR', 'text' => 'Puerto Rico'),
    array('id' => 'UM', 'text' => 'US Minor Islands'),
    array('id' => 'VI', 'text' => 'Virgin Islands'),
    array('id' => 'AA', 'text' => 'Armed Forces America (Outside Canada)'),
    array('id' => 'AE', 'text' => 'Armed Forces Africa'),
    array('id' => 'AE', 'text' => 'Armed Forces Canada'),
    array('id' => 'AE', 'text' => 'Armed Forces Europe'),
    array('id' => 'AE', 'text' => 'Armed Forces Middle East'),
    array('id' => 'AP', 'text' => 'Armed Forces Pacific')
);

$currentYear = date("Y");

$checkout_dropdown_header_number = 1;

?>

<div id="shipping-address-modal-target"></div>

<main class="container">
    <div class="row pt-3">
        <div class="col-12 col-lg-8 checkout-items-container">
            <div class="checkout-item">
                <div class="d-flex align-items-center pb-3">
                    <h2 class="checkout-dropdown-header-number">
                        <?php echo $checkout_dropdown_header_number++; ?>
                    </h2>
                    <div>
                        <p class="checkout-dropdown-header-title mb-0">Account</p>
                        <p id="guest-header-subtext" class="d-none checkout-subheader"></p>
                    </div>
                    <button type="button" class="btn checkout-dropdown-btn d-none" id="guest-checkout-edit-button">
                        Edit
                    </button>
                </div>
                <div class="checkout-item-content d-block" id="guest-checkout-info">
                    <form class="checkout-form" id="guest-checkout-form">
                        <div class="mb-5 form-floating-label-container">
                            <h4 class='text-center'>Account Login</h4>
                            <div class="form-text mb-3" id="guest-checkout-login-help">If you have an account, you may log in here, and your cart will be added to your account. If you wish to continue without logging in, you may continue as a guest below.</div>
                            <div class="row">
                                <div class="col">
                                    <div class="mb-3 form-floating-label-container">
                                        <input class="form-control" id="login-email" name="login-email" placeholder="Input Email">
                                        <label for="login-email">Email</label>
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="mb-3 form-floating-label-container">
                                        <input type="password" class="form-control" id="login-password" name="login-password" placeholder="Input Password">
                                        <label for="login-password">Password</label>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-10 offset-1 col-md-8 offset-md-2">
                                    <button type="button" class="btn bg-westech-green text-white w-100" id="login-button">Login</button>
                                </div>
                            </div>
                            <div class="alert-box" id="alert-box-guest-login"></div>
                            <div class="form-text mb-3" id="guest-account-tip">By creating an account or logging in, you can save addresses and payment methods, upload tax exemptions, and see past orders.</div>
                            <div class="row">
                                <div class="col">
                                    <p class="text-center mb-1">Need an account? <a href="https://westechequipment.com/index.php?main_page=register">Register here</a></p>
                                </div>
                                <div class="col">
                                    <p class="text-center mb-1">Forgot Password? <a href="https://westechequipment.com/index.php?main_page=forgot_password">Reset here</a></p>
                                </div>
                            </div>
                            <div class="seperator mb-1"></div>
                            <h4 class='text-center'>Guest Checkout</h4>
                            <div class="row">
                                <div class="col-12 col-md-6">
                                    <div class="mb-3 form-floating-label-container">
                                        <input type="text" class="form-control" id="guest-first-name" name="guest-first-name" placeholder="Input First Name"  required/>
                                        <label for="guest-first-name">First Name</label>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6">
                                    <div class="mb-3 form-floating-label-container">
                                        <input type="text" class="form-control" id="guest-last-name" name="guest-last-name" placeholder="Input Last Name"  required/>
                                        <label for="guest-last-name">Last Name</label>
                                    </div>
                                </div>
                            </div>
                            <div class="mb-3 form-floating-label-container">
                                <input class="form-control" id="guest-email" name="guest-email" placeholder="Input Email">
                                <label for="guest-email">Email</label>
                            </div>
                            <div class="form-text mb-3" id="guest-checkout-terms-notice">By clicking the button below to checkout as a guest, you agree to our terms and conditions found <a href="?main_page=terms_and_conditions">here</a>.</div>
                            <div class="row mb-3">
                                <div class="d-flex col-10 offset-1 col-md-8 offset-md-2">
                                    <button type="button" class="btn bg-westech-green text-white w-100" id="guest-checkout-continue-button">Continue as a Guest</button>
                                </div>
                            </div>
                            <div class="alert-box" id="alert-box-guest-continue"></div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="checkout-item">
                <div class="d-flex align-items-center pb-3">
                    <h2 class="checkout-dropdown-header-number">
                        <?php echo $checkout_dropdown_header_number++; ?>
                    </h2>
                    <div>
                        <p class="checkout-dropdown-header-title mb-0">Shipping Address</p>
                        <p id="shipping-header-subtext" class="d-none checkout-subheader"></p>
                    </div>
                    <button type="button" class="btn checkout-dropdown-btn d-none" id="checkout-shipping-edit-button">
                        Edit
                    </button>
                </div>
                <div class="checkout-item-content" id="checkout-shipping-info">
                    <form class="checkout-form" id="shipping-form">
                        <div class="mb-3 form-floating-label-container">
                            <input type="text" class="form-control" id="shipping-company-name" name="shipping-company-name" placeholder="Input Company Name" />
                            <label for="shipping-company-name">Company Name (Optional)</label>
                        </div>
                        <div class="row">
                            <div class="col-12 col-md-6">
                                <div class="mb-3 form-floating-label-container">
                                    <input type="text" class="form-control" id="shipping-first-name" name="shipping-first-name" placeholder="Input First Name"  required/>
                                    <label for="shipping-first-name">First Name</label>
                                </div>
                            </div>
                            <div class="col-12 col-md-6">
                                <div class="mb-3 form-floating-label-container">
                                    <input type="text" class="form-control" id="shipping-last-name" name="shipping-last-name" placeholder="Input Last Name"  required/>
                                    <label for="shipping-last-name">Last Name</label>
                                </div>
                            </div>
                        </div>
                        <div class="mb-3 form-floating-label-container">
                            <input type="text" class="form-control input-shipping" id="shipping-street-address-one" name="shipping-street-address-one" placeholder="Input Shipping Address"  required/>
                            <label for="shipping-street-address-one">Street Address</label>
                        </div>
                        <div class="row">
                            <div class="col-12 col-md-6">
                                <div class="mb-3 form-floating-label-container">
                                    <input type="text" class="form-control input-shipping" id="shipping-street-address-two" name="shipping-street-address-two" placeholder="Shipping Address Line 2" />
                                    <label for="shipping-street-address-two">Street Address 2 (Optional)</label>
                                </div>
                            </div>
                            <div class="col-12 col-md-6">
                                <div class="mb-3 form-floating-label-container">
                                    <input type="text" class="form-control input-shipping" id="shipping-street-address-three" name="shipping-street-address-three" placeholder="Shipping Address Line 3" />
                                    <label for="shipping-street-address-three">Street Address 3 (Optional)</label>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 col-md-6">
                                <div class="mb-3 form-floating-label-container">
                                    <input type="text" class="form-control input-shipping" id="shipping-city" name="shipping-city" placeholder="Input City Name"  required/>
                                    <label for="shipping-city">City</label>
                                </div>
                            </div>
                            <div class="col-6 col-md-3">
                                <div class="form-floating-label-container">
                                    <select class="form-select" id="shipping-state" name="shipping-state" required>
                                        <option disabled selected>Choose...</option>
                                        <?php
                                        foreach ($state_abbreviations as $state)
                                        {
                                            echo "<option value='{$state['id']}'>{$state['text']}</option>";
                                        }
                                        ?>
                                    </select>
                                    <label for="shipping-state">State</label>
                                </div>
                            </div>
                            <div class="col-6 col-md-3">
                                <div class="mb-3 form-floating-label-container">
                                    <input type="text" class="form-control input-shipping" id="shipping-zip-code" name="shipping-zip-code" placeholder="Input Zip" required>
                                    <label for="shipping-zip-code">Zip Code</label>
                                </div>
                            </div>
                        </div>
                        <div class='row'>
                            <div class='mb-3 form-floating-label-container'>
                                <select class='form-select' id='shipping-country' name='shipping-country' required>
                                    <?php //use the line below if we ever support more than US ?>
                                    <!-- <option disabled selected>Select Country...</option> -->
                                    <option value='US'>United States</option>
                                </select>
                                <label for='shipping-country'>Country</label>
                            </div>
                        </div>
                        <div class="form-floating-label-container">
                            <input type="tel" class="form-control" id="shipping-phone-number" name="shipping-phone-number" placeholder="Input Phone Number" required/>
                            <label for="shipping-phone-number">Phone Number</label>
                        </div>
                        <div class="mb-1">
                            <div class="form-check form-check-inline mb-3">
                                <input class="form-check-input" type="checkbox" id="shipping-extra-residential">
                                <label class="form-check-label" for="shipping-extra-residential">Residential</label>
                            </div>
                            <div class="form-check form-check-inline mb-3">
                                <input class="form-check-input input-shipping" type="checkbox" id="shipping-extra-liftgate">
                                <label class="form-check-label" for="shipping-extra-liftgate">Liftgate Required</label>
                            </div>
                            <div class="form-check form-check-inline mb-3">
                                <input class="form-check-input input-shipping" type="checkbox" id="shipping-extra-restricted-access">
                                <label class="form-check-label" for="shipping-extra-restricted-access">Restricted Access</label>
                            </div>
                            <!-- <label for="shipping-method" class="form-label mb-3 fw-bold">Shipping Method:</label>
                            <select class="form-select" id="shipping-method" name="shipping-method" aria-describedby="shipping-method-help">
                                <option value="UPS Ground / Freight" selected>UPS Ground / Freight</option>
                            </select> -->
                            <div class="form-text" id="shipping-method-help">We may request additional charges to an LTL shipment if the destination is residential, requires a liftgate or has restricted access</div>
                        </div>
                        <div class="row">
                            <div id="shipping-result-target"></div>
                        </div>
                        <div class="row mb-5">
                            <div class="d-flex col-10 offset-1 col-md-8 offset-md-2">
                                <button type="button" class="btn bg-westech-green text-white w-100" id="checkout-shipping-continue-button">Continue</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="checkout-item">
                <div class="d-flex align-items-center pb-3">
                    <h2 class="checkout-dropdown-header-number">
                        <?php echo $checkout_dropdown_header_number++; ?>
                    </h2>
                    <div>
                        <p class="checkout-dropdown-header-title mb-0">Billing Address</p>
                        <p id="billing-header-subtext" class="d-none checkout-subheader"></p>
                    </div>
                    <button type="button" class="btn checkout-dropdown-btn d-none" id="checkout-billing-edit-button">
                        Edit
                    </button>
                </div>
                <div class="checkout-item-content" id="checkout-billing-info">
                    <form class="checkout-form">
                        <div class="form-check mb-3">
                            <input class="form-check-input" type="checkbox" id="billing-same-as-shipping" name="billing-same-as-shipping">
                            <label class="form-check-label" for="billing-same-as-shipping">
                                Same address as shipping
                            </label>
                        </div>
                        <div class="mb-3 form-floating-label-container">
                            <input type="text" class="form-control input-billing" id="billing-company-name" name="billing-company-name" placeholder="Input Company Name" />
                            <label for="billing-company-name">Company Name (Optional)</label>
                        </div>
                        <div class="row">
                            <div class="col-12 col-md-6">
                                <div class="mb-3 form-floating-label-container">
                                    <input type="text" class="form-control input-billing" id="billing-first-name" name="billing-first-name" placeholder="Input First Name"  required/>
                                    <label for="billing-first-name">First Name</label>
                                </div>
                            </div>
                            <div class="col-12 col-md-6">
                                <div class="mb-3 form-floating-label-container">
                                    <input type="text" class="form-control input-billing" id="billing-last-name" name="billing-last-name" placeholder="Input Last Name"  required/>
                                    <label for="billing-last-name">Last Name</label>
                                </div>
                            </div>
                        </div>
                        <div class="mb-3 form-floating-label-container">
                            <input type="text" class="form-control input-billing" id="billing-street-address-one" name="billing-street-address-one" placeholder="Input Billing Address"  required/>
                            <label for="billing-street-address-one">Street Address</label>
                        </div>
                        <div class="mb-3 form-floating-label-container">
                            <input type="text" class="form-control input-billing" id="billing-street-address-two" name="billing-street-address-two" placeholder="Billing Address Line 2" />
                            <label for="billing-street-address-two">Street Address 2 (Optional)</label>
                        </div>
                        <div class="mb-3 form-floating-label-container">
                            <input type="text" class="form-control input-billing" id="billing-street-address-three" name="billing-street-address-three" placeholder="Billing Address Line 3" />
                            <label for="billing-street-address-three">Street Address 3 (Optional)</label>
                        </div>
                        <div class="row">
                            <div class="col-12 col-md-6">
                                <div class="mb-3 form-floating-label-container">
                                    <input type="text" class="form-control input-billing" id="billing-city" name="billing-city" placeholder="Input City Name"  required/>
                                    <label for="billing-city">City</label>
                                </div>
                            </div>
                            <div class="col-6 col-md-3">
                                <div class="form-floating-label-container">
                                    <select class="form-select" id="billing-state" name="billing-state" required>
                                        <option disabled selected>Choose...</option>
                                        <?php
                                        foreach ($state_abbreviations as $state)
                                        {
                                            echo "<option value='{$state['id']}'>{$state['text']}</option>";
                                        }
                                        ?>
                                    </select>
                                    <label for="billing-state">State</label>
                                </div>
                            </div>
                            <div class="col-6 col-md-3">
                                <div class="mb-3 form-floating-label-container">
                                    <input type="text" class="form-control input-billing" id="billing-zip-code" name="billing-zip-code" placeholder="Input Zip" required>
                                    <label for="billing-zip-code">Zip Code</label>
                                </div>
                            </div>
                        </div>
                        <div class='row'>
                            <div class='form-floating-label-container'>
                                <select class='form-select' id='billing-country' name='billing-country' required>
                                    <?php //use the line below if we ever support more than US ?>
                                    <!-- <option disabled selected>Select Country...</option> -->
                                    <option value='US'>United States</option>
                                </select>
                                <label for='billing-country'>Country</label>
                            </div>
                        </div>
                        <p class="text-muted">For your security, your billing address and zip code are verified with your card's issuer. If the billing information you supply does not match with your card issuer's records, we may send you an email or call you to confirm your transaction.</p>
                        <div class="row mb-5">
                            <div class="col-10 offset-1 col-md-8 offset-md-2">
                                <button type="button" class="btn bg-westech-green text-white w-100" id="checkout-billing-continue-button">Continue</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="checkout-item">
                <div class="d-flex align-items-center pb-3">
                    <h2 class="checkout-dropdown-header-number">
                        <?php echo $checkout_dropdown_header_number++; ?>
                    </h2>
                    <div>
                        <p class="checkout-dropdown-header-title mb-0">Taxes</p>
                        <p id="checkout-tax-header-subtext" class="d-none checkout-subheader"></p>
                    </div>
                    <button type="button" class="btn checkout-dropdown-btn d-none" id="checkout-tax-edit-button">
                        Edit
                    </button>
                </div>
                <div class="checkout-item-content" id="checkout-tax-info">
                    <div class="checkout-form" id="checkout-tax-info-container">
                        <div class="row mb-3" id="checkout-tax-content-summary"></div>
                        <p>Taxes are calculated by shipping address only. Tax exemptions only apply when shipping to a state where you have a tax exemption.</p>
                        <div class="alert alert-warning">Tax exemptions are only available to customers who have <a href="/index.php?main_page=register">created an account</a>. <strong>Taxes are non-refundable</strong>.</div>
                        <div class="row mb-5" id="checkout-tax-content-buttons">
                            <p class="text-center mt-3">Do you need to upload an exemption certificate?</p>
                            <div class="d-flex col-10 offset-1 col-md-8 offset-md-2">
                                <a href="/index.php?main_page=register" class="w-100">
                                    <button type="button" class="btn bg-westech-green text-white w-100">Yes</button>
                                </a>
                                <div class="vr ms-4 me-4"></div>
                                <button type="button" class="btn bg-westech-green text-white w-100" id="checkout-tax-continue-button">No</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="checkout-item last-checkout-item">
                <div class="d-flex align-items-center pb-3">
                    <h2 class="checkout-dropdown-header-number">
                        <?php echo $checkout_dropdown_header_number++; ?>
                    </h2>
                    <div>
                        <p class="checkout-dropdown-header-title mb-0">Payment</p>
                        <p id="payment-header-subtext" class="d-none checkout-subheader"></p>
                    </div>
                    <button type="button" class="btn checkout-dropdown-btn d-none" id="checkout-payment-edit-button">
                        Edit
                    </button>
                </div>
                <div class="checkout-item-content" id="checkout-payment-info">
                    <div class="form-text mb-3" id="checkout-max-amount-notice">Note: We may decline an order with a total order amount over $5,000 and instead reach out to you and place the order directly. This is for the safety of our customers as well as our own. We apologize for any inconvenience, and will be offering an ACH payment option in the future for these transactions.</div>
                    <form class="checkout-form" id="payment-info-form">
                        <div class="mb-3 form-floating-label-container">
                        </div>
                        <input type="hidden" name="payment-info-saved-id">
                        <div class="row mb-3">
                            <div class="col-3 payment-icons">
                                <p class="mb-0 fw-bold payment-text">We Accept:</p>
                                <img src="/images/capture3.JPG" alt="accepted payment methods" class="img-fluid payment-method-image">
                            </div>
                        </div>
                        <div class="mb-3 form-floating-label-container">
                            <input class="form-control" id="payment-name-on-card" name="payment-name-on-card" placeholder="Input Name On Card"  required/>
                            <label for="payment-name-on-card">Name On Card</label>
                        </div>
                        <div class="mb-3 form-floating-label-container">
                            <input class="form-control" id="payment-card-number" name="payment-card-number" placeholder="Input Number On Card"  required/>
                            <label for="payment-card-number">Card Number</label>
                        </div>
                        <div class="row" id="payment-card-details">
                            <div class="col-6 col-md-4">
                                <div class="mb-3 form-floating-label-container">
                                    <select class="form-select" id="payment-card-expiration-month" name="payment-card-expiration-month" required>
                                        <option disabled selected value="">MM</option>
                                        <option value="01">01</option>
                                        <option value="02">02</option>
                                        <option value="03">03</option>
                                        <option value="04">04</option>
                                        <option value="05">05</option>
                                        <option value="06">06</option>
                                        <option value="07">07</option>
                                        <option value="08">08</option>
                                        <option value="09">09</option>
                                        <option value="10">10</option>
                                        <option value="11">11</option>
                                        <option value="12">12</option>
                                    </select>
                                    <label for="payment-card-expiration-month">Month</label>
                                </div>
                            </div>
                            <div class="col-6 col-md-4">
                                <div>
                                    <div class="mb-3 form-floating-label-container">
                                        <select class="form-select" id="payment-card-expiration-year" name="payment-card-expiration-year" required>
                                            <option disabled selected value="">YYYY</option>
                                            <?php
                                            for ($y = 0; $y < 11; $y++)
                                            {
                                                echo '<option value="' . ($currentYear + $y) . '">' . ($currentYear + $y) . '</option>';
                                            }
                                            ?>
                                        </select>
                                        <label for="payment-card-expiration-year">Year</label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6 col-md-4">
                                <div class="mb-3 form-floating-label-container secure-input">
                                    <i class="fa-solid fa-lock"></i>
                                    <input class="form-control" id="payment-card-cvv" name="payment-card-cvv" placeholder="###" required/>
                                    <label for="payment-card-cvv">CVV</label>
                                </div>
                            </div>
                        </div>
                        <div class="mb-3 form-floating-label-container">
                            <textarea class="form-control" id="payment-comment" name="payment-comment" rows="3" placeholder="Order Notes/Comments"></textarea>
                            <label for="payment-comment" class="form-label">Notes/Comments</label>
                        </div>
                        <div class='form-text mb-3'>
                            <h5><u>Terms and Conditions</u></h5>
                            <textarea class="form-control" id="textarea-terms" rows="5" readonly>
1. Introduction
    The WestechEquipment.com web site (the "Web Site") provided by Westech Equipment ("Company") includes an on-line service for its customers to obtain the status of orders and to allow for the purchase of products online (the "Service"). USE OF THE SERVICE ON THE WESTECH EQUIPMENT COMPANY WEB SITE IS EXPRESSLY CONDITIONED UPON THE CUSTOMER ACCEPTING EACH AND EVERY PROVISION CONTAINED IN THESE TERMS AND CONDITIONS. Please read these provisions carefully as these Terms and Conditions constitute a legally binding agreement ("Agreement") between Westech Equipment Company ("Westech Equipment") and the users of the Service (each a "Customer").

2. Future Changes.
    Westech Equipment reserves the right at any time to change or modify the Web Site, these Terms & Conditions, the Web Site Privacy Policy, and pricing. When changes are made, the current Terms and Conditions and Privacy Policy will be placed on the Web Site. Customers concerned about whether such changes have been made should ensure that they view the then current Terms and Conditions and Privacy Policy each time they use the Web Site. Any use of the Web Site or product order through the Web Site after such changes are posted constitutes your acceptance of the changed Terms and Conditions or Privacy Policy. If you do not agree to any such changes, please discontinue using the Web Site.

3. Accurate Information; Authority to Bind.
    Customers agree (a) to provide accurate, current, and complete information as may be required by Westech Equipment and (b) to update this information in the future if changes render the information inaccurate or misleading. Customers purchasing products from Westech Equipment represent that they are at least eighteen (18) years old and that they have the legal authority to bind any entity on behalf of which the Customer purports to represent. Westech Equipment relies upon this information and representation to provide service and fulfill orders purchased through the Web Site. Our Privacy Policy, which is incorporated herein by reference, sets forth our policy with respect to the information provided by Customers.

4. Password.
    Westech Equipment will provide a customer number and password. All terms and conditions of this Agreement are applicable to all passwords issued under this Agreement and accordingly, Customer agrees to assume sole responsibility for compliance therewith, for all charges incurred for each and every password issued under this Agreement and for maintaining the security respecting the passwords issued. Additional passwords may be provided to Customer upon written request, subject to Westech Equipment's polices for additional passwords then in effect.

5. Ownership/Limitations on Use.
    The Web Site, Service, its content, organization, gathering, graphics, design, compilation and other matters related thereto are protected under applicable copyrights, trademarks and other proprietary laws, including but not limited to intellectual property laws, and by international treaties. Customer does not acquire any title or ownership rights to the Web Site or Service or information accessed through the Service. Customer acknowledges and agrees that it will not take any action that would jeopardize, limit or interfere in any manner with the operation of the Web Site or Service.

    The [pricing] information available through the Service is the confidential information of Westech Equipment and is protected by copyright and other intellectual property laws. [Pricing] information received through the Service is to be used solely for internal purposes. Except with prior written authorization from Westech Equipment, no [pricing] information received through the Service may be duplicated, reproduced, distributed, or otherwise disseminated, in whole or in part, in any form, except that limited reproduction is permitted for distribution within your internal organization, or to other necessary and required parties within the referral process. Under no circumstances may copies produced under this provision be offered for sale or resale.

6. NO SERVICE WARRANTY.
    EACH CUSTOMER ACKNOWLEDGES THAT THE WEB SITE AND SERVICE ARE PROVIDED ON AN "AS IS" AND "AS AVAILABLE" BASIS AND THAT USE OF THE WEB SITE OR SERVICE IS AT THE CUSTOMER'S SOLE RISK. WESTECH EQUIPMENT MAKES NO WARRANTY WHATSOEVER ABOUT THE WEB SITE, THE SERVICE, ITS OPERATION OR AVAILABILITY, THE ACCURACY OF THE INFORMATION PROVIDED ON THE SITE OR SERVICE, OR THE SECURITY OF THE WEB SITE OR SERVICE. MOREOVER, WITH RESPECT TO THE WEB SITE AND SERVICE, WESTECH EQUIPMENT EXPRESSLY DISCLAIMS ALL WARRANTIES OF ANY KIND, WHETHER EXPRESS OR IMPLIED, INCLUDING, BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. MOREOVER, WESTECH EQUIPMENT MAKES NO WARRANTY THAT (A) THE WEB SITE OR SERVICE WILL MEET YOUR REQUIREMENTS, (B) THE WEB SITE OR SERVICE WILL BE UNINTERRUPTED, TIMELY, SECURE, OR ERROR-FREE, (C) TRANSMISSION OF DATA TO AND FROM THE WEB SITE OR SERVICE WILL BE TIMELY OR ERROR-FREE, OR (D) THE RESULTS THAT MAY BE OBTAINED FROM THE USE OF THE WEB SITE OR SERVICE WILL BE ACCURATE OR RELIABLE. THIS WARRANTY GIVES YOU SPECIFIC LEGAL RIGHTS, AND YOU MAY ALSO HAVE OTHER RIGHTS WHICH VARY FROM STATE TO STATE. SOME STATES DO NOT ALLOW LIMITATIONS ON HOW LONG AN IMPLIED WARRANTY LASTS, SO THE ABOVE LIMITATION MAY NOT APPLY TO YOU.

7. Purchase of Product.
    Customer may order goods from Westech Equipment ("Products") by placing an order online through the Service. Westech Equipment will have no obligation to fulfill timely orders for Products which are out-of-stock or otherwise unavailable [SEE SECTION 23 BELOW], but Westech Equipment will promptly notify Customer of such unavailability or delay as soon as it becomes aware of it. In certain circumstances orders may, solely at Westech Equipment's option, be accepted, or supplements to orders may be made, by fax transmission, telephone, e-mail, electronic data input or otherwise, any of which methods, but only if accepted in writing by an authorized representative of Westech Equipment, shall constitute an order or amendment to an order binding upon Customer hereunder. Any terms and conditions contained in any Customer documents that are different or in addition to the Terms and Conditions of this Agreement, including but not limited to letters, purchase orders or sales acknowledgements, are hereby rejected by Westech Equipment, are not a part of this Agreement or the business relationship of the parties, and shall be of no effect or binding upon Westech Equipment unless specifically agreed to in writing by an authorized officer of Westech Equipment. Failure by Westech Equipment specifically to object to provision contained in such Customer documents shall not in any way be deemed an alteration to or waiver of these Terms and Conditions. [Orders placed are not subject to cancellation by Customer - SEE SECTION 12 BELOW]

8. Customer Representations and Certain Covenants.
    Customer represents that if Customer is a corporation, partnership, limited liability company, or the like, that Customer is validly existing and in good standing under the laws of its state of incorporation. Customer represents that it has all requisite power to enter into this Agreement. Each person(s) accepting this Agreement on behalf of any corporation, partnership, limited liability Company, or the like, represents that he or she is duly authorized to accept this Agreement and to perform Customer's obligations under this Agreement. Customer shall be solely responsible for the use and disposition of the Products and agrees to use the Products only in accordance with all laws, rules and regulations applicable thereto.

9. Price and Other Expenses.
    Online prices are not valid for in store purchases, online orders cannot be picked up in store. All prices quoted by Westech Equipment through its Web Site for a particular order to a specific delivery location are delivered prices. The price quoted by the sales team is the purchase price of the Product(s), and includes shipping, but does not include any other expenses relating to the Product(s). The Customer shall be responsible for all other expenses relating to the Product(s) purchased, not covered by the standard arrangements contemplated above, including but not limited to (a) any federal, state, local, foreign or provincial taxes or tariffs, now or hereafter enacted, applicable to the Products, as further set forth in Section 13, below; (b) special transportation costs to the point of delivery specified by the Customer; (c) all charges in the event payment from Customer is delinquent, including, without limitation, all costs and expenses, including attorneys fees, of collecting any amount not paid when due hereunder, and; (d) all other expenses, not included in the sale and delivery contemplated above, of whatever kind or nature, relating to special insurance requirements, the purchase, shipment, transportation or delivery of Product. If the Customer chooses to arrange for transportation other than the arrangements contemplated hereby, then the Customer will be responsible for shipping and related costs and expenses. Prices are subject to change at any time in the sole discretion of Westech Equipment effective for all orders made after Westech Equipment posts a price change on its Web Site. Prices of Westech Equipment Products may be found on this Web Site and in printed materials distributed by Westech Equipment. Westech Equipment takes great efforts to ensure both printed materials and Web Site prices are kept current, but in the event of a conflict in price information between printed materials and this Web Site, prices on this Web Site shall govern.

10. Shipment, Risk of Loss, and Product Damaged in Freight.
    A. Shipment
        Unless otherwise agreed, all shipments will be made by third-party carriers chosen by Westech Equipment, at costs, tariffs and other charges, and in accordance with terms and conditions established by Westech Equipment from time to time. In the event that Customer elects to arrange transportation other than the arrangement contemplated hereby, then Customer shall be responsible for all costs, tariffs and charges of any nature associated with the shipment of any Product to Customer. In such case, the shipper will invoice Customer directly, or Westech Equipment may invoice Customer, for all such costs, tariffs and charges.

    B. Risk of Loss
        The risk of loss associated with any Product and title passes to Customer upon delivery of the goods to the shipping point, FOB, subject to the reservation of a security interest to Westech Equipment in Section 11 of this Agreement. Westech Equipment shall have no liability of any kind or nature, whether for consequential or other damages for any reason whatsoever, relating to shipment of Product purchased by Customer, including but not limited to damage to the product, taxes, duties, loss, theft or any illness of or personal injury to any person or property under any environmental, health or safety law.

    C. Product Damaged in Freight
        All shipments are FOB manufacturer's shipping point. The purchaser is responsible to inspect all shipments for loss or damage prior to receiving. Any freight claims created must be filed with the carrier.

    D. Residential Shipping
        We urge customers to ship to a secure address (ie. business / commercial address with receiving) when possible. We no longer ship to apartment complexes. Westech Equipment reserves the right to verify all orders to residential addresses before shipping product.

    E. Additional Freight Charges
        The following shipment types are all subject to additional freight charges: Residential, rural, restricted gates access, 2nd delivery charges, and redirection. These additional costs may not be known at the time of order and may require an additional payment be made to Westech Equipment by the Buyer. Buyer agrees to provide credit card payment information at the time of notification. If not paid at the time of notification Westech Equipment’s standard payment terms apply.

11. Payment and Credit.
    Customer shall pay for all Product in full payment before Product shipment. Unless otherwise indicated by Westech Equipment in writing, Customer agrees to remit payment in full to the address and account indicated on Westech Equipment invoices issued from time to time for all shipments, including shipments of any portion of the Product. No cash discounts for early payment will be granted unless approved in writing in advance by an authorized representative of Westech Equipment. When payment in full is not remitted according to the applicable terms, Customer shall be delinquent without further notice from Westech Equipment. Customer's right to purchase any Product is conditioned upon approval of Customer's credit and may be withdrawn or amended at any time by Westech Equipment in its sole discretion. Westech Equipment reserves the right, in its sole discretion, to change the credit terms, refuse shipment, or cancel unfilled orders at any time when, in its sole opinion, the financial condition or previous payment record of Customer so warrants. A late payment charge of two (2%) percent per month shall be added to all invoices which are delinquent, subject to federal, state and local laws, calculated from the original due date of the invoice until payment in full. In the event Customer is delinquent, Customer shall pay all costs of collection, including but not limited to reasonable attorneys' fees. Should Customer become delinquent in the payment of any sum due under this Agreement, all contractual or other obligations of Westech Equipment to Customer shall terminate without further notice to Customer. Westech Equipment retains, and Customer hereby grants Westech Equipment, a purchase money security interest in the Products, including all accessions to and replacements of them, to secure the payment of the purchase price of the Product, until Customer has made payment in full in accordance with the terms hereof, and Customer shall cooperate fully with Westech Equipment in executing such documents, including a Uniform Commercial Code financing statement, and accomplishing such filings and/or recordings thereof as Westech Equipment deems necessary for the perfection, protection and enforcement of such security interest.

12. Returns, Cancellations, Unclaimed or Refused Shipments, and Bank Chargebacks.
    A. Cancellation Prior to Shipping
        Any cancellation of an order prior to shipment must be in writing signed by the Customer and Westech Equipment. Upon such cancellation, Customer agrees to pay Westech Equipment a minimum of 6% of the order value. Items that are special order or custom built or manufactured are not refundable or subject to all costs and expenses incurred by Westech Equipment or manufacture assembly in connection with the order. Such costs and expenses shall include without limitation Westech Equipment's cost of labor applied to the order, overhead, costs of any materials applied to or ordered for the contract and any charges imposed upon Westech Equipment by its suppliers or subcontractors.

    B. Returns:
        No goods may be returned without the Seller's written permission. If such authorization is given, unless otherwise stated in the authorization, transportation charges must be prepaid by the Buyer. All goods authorized for return are subject to the Seller's inspection and acceptance, and must be returned in the factory packaging, in new/unused condition. Merchandise may only be returned within 14 days of sale and must be accompanied by the invoice number and/or a copy of the sales receipt. All goods, services or products that are non-stocking, special order, cut or fabricated to a specific size or length are not returnable. A MINIMUM of a 25% restocking fee and 6% credit card processing fee apply to all returned merchandise. No returns allowed on Goods under $100. It is understood that no goods can be returned for credit without adhering to the above conditions.

    C. Unclaimed or Refused Shipments
        The purchaser is responsible for all cost associated with refused or unclaimed orders including: return shipping, re-stocking, and other applicable fees. All fees will be added to the invoice.

    D. Bank Chargebacks
        Westech Equipment shall issue credits for returns and warranties based upon our standard terms of sale in accordance with Westech Equipment's Manufacturers' return goods policies. If the purchaser issues a chargeback, the purchaser is responsible for 25% of the purchase price in addition to any collection and bank costs including attorney's fees and interest.

13. Taxes and Other Charges.
    Customer is responsible for the payment of all federal, state, local, foreign, or provincial taxes (now or hereafter enacted), fees, or charges which may be assessed or levied now or hereafter on or on account of materials sold hereunder to Customer, whether termed a gross receipts tax, use tax, property tax, sales tax, manufacturers tax, excise tax, custom duties or taxes, inspection or testing fee, or any other tax, fee, or charge of any nature whatsoever imposed by any governmental authority on or measured by any transaction between Westech Equipment and Customer. Published prices do not include such taxes, which may be added by Westech Equipment to the invoice where Westech Equipment has a legal obligation to collect them. When Customer claims that this transaction is not subject to any such tax, or that Customer is exempt, or that Westech Equipment is not required to collect such tax, Customer agrees to provide Westech Equipment with any documentation necessary to support such a claim and to allow Westech Equipment to document its decision not to collect tax(es).

14. Product Warranty.
    The Products are warranted only to the extent provided by the manufacturer in its limited warranty, if any, pertaining thereto, a copy of which is available at Customer's request. WESTECH EQUIPMENT, HOWEVER, EXTENDS NO WARRANTY OR ANY KIND WITH RESPECT TO THE PRODUCTS, AND ANY AND ALL SUCH WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE ARE HEREBY DISCLAIMED.

15. EXCLUSION OF DAMAGES.
    THE REMEDIES PROVIDED HEREIN ARE CUSTOMER'S SOLE AND EXCLUSIVE REMEDIES. WESTECH EQUIPMENT SHALL NOT BE LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL, CONSEQUENTIAL OR PUNITIVE DAMAGES, WHETHER BASED ON CONTRACT, TORT, OR OTHER LEGAL THEORY ARISING OUT OF THE SALE, INSTALLATION, SERVICE OR USE OF THE PRODUCTS BY CUSTOMER OR ANY THIRD PARTY, EVEN IF WESTECH EQUIPMENT HAS BEEN ADVISED OF THE LIKELIHOOD OF SUCH LOSSES, AND IN NO EVENT SHALL THE LIABILITY OF WESTECH EQUIPMENT EXCEED THE UNIT PRICE OF THE DEFECTIVE PRODUCT. WESTECH EQUIPMENT NEITHER ASSUMES NOR AUTHORIZES ANY AGENT, EMPLOYEE, REPRESENTATIVE, OR ANY OTHER PERSON TO ASSUME FOR IT ANY OTHER LIABILITY IN CONNECTION WITH THE SALE, DELIVERY, SERVICE, OR USE OF ITS PRODUCT; AND UNLESS AN AFFIRMATION, REPRESENTATION, OR WARRANTY MADE BY AN AGENT, REPRESENTATIVE, OR EMPLOYEE IS SPECIFICALLY CONSENTED TO IN WRITING BY AN AUTHORIZED OFFICER OF WESTECH EQUIPMENT, IT SHALL NOT BE ENFORCEABLE BY CUSTOMER. SOME STATES DO NOT ALLOW THE EXCLUSION OR LIMITATION OF INCIDENTAL OR CONSEQUENTIAL DAMAGES, SO THE ABOVE LIMITATION OR EXCLUSION MAY NOT APPLY TO YOU.

16. Customer Indemnification.
    Customers shall indemnify, defend and hold Westech Equipment harmless from any and all liabilities, claims, demands, causes of action, or suits of whatever nature including, but not limited to, attorneys' fees and litigation expenses, arising from any: (i) breach by Customer of any representation or covenant made by Customer or User under this Agreement or to Westech Equipment; (ii) breach by Customer of any provision of the Terms and Conditions of this Agreement; (iii) failure of Customer to comply with applicable environmental, health and safety laws and (iv) any use by Customer or third parties of the Product(s) sold to Customer. Notwithstanding the foregoing, Customer shall not be liable to Westech Equipment for any portion of such liabilities that result from Westech Equipment's fraud, bad faith, or willful misconduct.

17. Term and Modification.
    This Agreement shall govern so long as Customer purchases any Product from Westech Equipment or uses this Web Site, provided, however, that this Agreement may be modified unilaterally by Westech Equipment's providing notice to Customer through any of the following means: Westech Equipment's posting of any modification or revised Agreement or terms on the Web Site or by Westech Equipment's providing written or electronic notice to Customer via any means reasonably calculated to provide actual notice to Customer including facsimile transmission, e-mail or other electronic mail, Federal Express or similar delivery, hand delivery, or ordinary first-class mail with postage prepaid. In such event, any modification or revision to the Agreement shall become effective upon publication thereof on Web Site or, if earlier, upon Customer's receipt of said notice, and shall only apply to Product purchase orders occurring after the effectiveness of such notice to Customer.

18. Termination.
    Westech Equipment reserves the right, in its sole discretion and without notice, to terminate access to the Service and disable the password issued to any Customer that Westech Equipment believes in good faith has (a) failed to abide by any provision of this Agreement, (b) provided false or inaccurate information to Westech Equipment, or (c) failed to maintain information provided current.

19. Noninterference.
    Customers are prohibited from using any robot, spider, other automatic device to monitor or copy portions of the Web Site or the content contained herein without Westech Equipment's prior written permission. Customers agree not to use any device, software or routine to interfere or attempt to interfere with the proper working of the Web Site or or Service or take any action that imposes an unreasonable or disproportionately large load on the Web Site. Customers of this Web Site agree not to download, reproduce, duplicate, copy or otherwise exploit any portion of the Web Site for the purpose of sale, resale, or making other commercial use thereof.

20. Authority to Export.
    All orders accepted for export are subject to issuance of an export license by the United States Government for export of the Product(s), and subject to Customer's providing Westech Equipment with the relevant import certificate, or any other document necessary to secure such export license and/or to permit the import of such goods into the country of destination.

21. Governing Law.
    Westech Equipment, which operates this Web Site, has a principal place of business in Utah. But this Web Site can be accessed anywhere in the United States and abroad. Because each of the states may have differing laws that may effect the interpretation of this Agreement, Customers agree that this Agreement will be governed and construed under the laws of the state of Utah, without resort to the choice of law provisions thereof. Moreover, Customers hereby irrevocably consent to the exclusive jurisdiction of the federal and state courts located in Utah for the purpose of resolving any and all disputes arising under this Agreement. Any action by Customer under or relating to this Agreement or use of the Web Site or Service must commence within six (6) months after such cause of action accrued.

22. Severability.
    If any provision or portion of this Agreement is not given legal effect by a court of competent jurisdiction, such provision or portion shall drop out of this Agreement and the remaining provisions and portions of this Agreement shall be construed and enforced.

23. Force Majeure.
    Westech Equipment shall not be responsible for any failure to perform the Service or for delays in shipment, delivery or any other nonperformance due to causes beyond its control, including, but not limited to, acts of God, labor disputes or shortages, acts or omissions of Customer, government or judicial authorities, or military authorities, delays in transportation, or inability to obtain necessary materials or supplies, all whether foreseen or unforeseen.

24. Entire Agreement/ Non-Waiver.
    This Agreement constitutes the entire understanding of the parties with respect to the subject matter hereof and supersedes all prior written and oral communications and understandings. Westech Equipment's failure to exercise any of its rights for any period shall not constitute or be deemed a waiver or forfeiture of such rights.

25. Third-Party Beneficiaries.
    This Agreement shall not confer any rights or remedies upon any third-party, other than the parties to this Agreement and their respective successors and permitted assigns.

26. Notice.
    Except as otherwise provided herein to the contrary, notice to be provided to Westech Equipment shall be given by actual delivery or by registered or certified, pre-paid U.S. postal service mail delivery, return receipt requested, to Westech Equipment at P.O. BOX 57307 Salt Lake City, UT 84157, or such other address as Westech Equipment shall publish on its Web Site for notices to be given to Westech Equipment. Notice to Customer shall by given by Westech Equipment by any means reasonably calculated to provide actual notice to Customer at the address specified by customer.

27. Core Exchanges
    For core exchanges, Customer understands, and agrees, that Westech Equipment requires a core returned to them within 30 days of original purchase. If Customer fails to return their core within the 30 day time frame, Westech Equipment will charge the Customer's credit card for the price of the core.
                            </textarea>
                            <p class="mt-3">What am I agreeing to?</p>
                            <ul>
                                <li>I understand Westech Equipment cannot guarantee shipping dates, especially with current supply shortages and abnormal lead times.</li>
                                <li>I understand it is my responsibility to contact Westech Equipment to ensure the product I am purchasing is appropriate for my application and timeline of expected reception BEFORE placing my order and agree that Westech Equipment is NOT responsible for a misorder in the case of a customer's failure to ensure their purchase will fulfil their needs. *</li>
                                <li>If I cancel my order after 24 hours of placing it, I will pay a minimum of a 6% processing fee.</li>
                                <li>If I cancel my order after 48 hours of placing it, I will pay a minimum of a 25% UP TO a maximum of 35% restocking fee** <em>plus</em> the fee mentioned above.</li>
                                <li>I understand any freight charges are subject to change, and additional charges may be applied for reasons including but not limited to: unusual product dimensions, residential addresses, handling, etc.</li>
                                <li>I understand that return orders are subject to inspection before any credit can be issued, and Westech Equipment reserves the right to deny a return based upon the condition of the product returned.</li>
                                <li>I understand that if I purchase a product that requires a core charge, I have 30 days to send a REBUILDABLE core to Westech Equipment in order to receive a refund of the core charge. I agree that Westech Equipment reserves the right to decline my core if it is not REBUILDABLE, providing reasonable evidence as to why my core is not REBUILDABLE. REBUILDABLE cores are non-modified, undamaged cores according to the inspection and certification of Westech Equipment and the core's OEM.</li>
                                <li>I forgo any credit or refund if my order is under the minimum purchase amount of $100.</li>
                            </ul>
                            <p>* We strive to provide outstanding service to our customers, and to ensure that this goal can be achieved, we provide our email <a href="mailto:contact@westechequipment.com">(contact@westechequipment.com)</a> and our office number <a href="tel:1-800-433-8831">(1800-433-8831)</a> where our customers can reach us with any questions or concerns during our normal operating hours (M-F, 7:30AM - 4:30PM).</p>
                            <p>** We assess a restocking fee on most of our electronic products because those products MUST be re-tested and re-certified before we can sell them again. We do this to ensure the upmost quality of <em>every</em> product we produce; and while other manufacturers might simply prefer to buy a new unit, we are committed to reducing our impact on the environment and economy.</p>
                        </div>
                        <div class="form-check mb-2 terms-agree-checkbox-container">
                            <input class="form-check-input" type="checkbox" id="terms-agree-checkbox"  required/>
                            <label class="form-check-label" for="terms-agree-checkbox">
                                <i class="fa-solid fa-lock"></i> I agree to the Terms and Conditions
                            </label>
                        </div>
                        <div class="form-check mb-5 terms-agree-checkbox-container">
                            <input class="form-check-input" type="checkbox" id="subscribe-email-checkbox">
                            <label class="form-check-label" for="subscribe-email-checkbox">
                                Subscribe to exclusive offers and news (Optional)
                            </label>
                        </div>
                        <div class="row">
                            <div class="col-10 offset-1 col-md-8 offset-md-2">
                                <button type="button" class="btn bg-westech-green text-white w-100" id="checkout-payment-checkout-button">Checkout</button>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-10 offset-1 col-md-8 offset-md-2" id="checkout-message-container">
                                <span id="checkout-message"></span>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-12 col-lg-4">
            <div class="cart-info-container"></div>
        </div>
    </div>
</main>