<?php

if (isset($_GET['token']))
{
?>

<main class="container-lg">
    <div class="center-content authentication-form-container">
        <?php echo zen_draw_form('reset-form', '', 'post', 'class="authetication-form" onsubmit="tryReset(event);"'); ?>
            <h3 class="text-center">Reset Your Password</h3>
            <div class="mb-3 form-floating-label-container">
                <input type="password" class="form-control" id="password-reset" name="password-reset" placeholder="Type a New Password" />
                <label for="password-reset">New Password</label>
            </div>
            <div class="mb-3 form-floating-label-container">
                <input type="password" class="form-control" id="password-confirm" name="password-confirm" placeholder="Type a New Password" />
                <label for="password-confirm">Confirm Password</label>
            </div>
            <div class="row mb-3">
                <div class="col-10 offset-1 col-md-8 offset-md-2">
                    <button type="submit" class="btn bg-westech-green text-white w-100" id="reset-button">Reset Password</button>
                </div>
            </div>
            <div id="alert-box"></div>
        </form>
    </div>
</main>

<script>
    async function tryReset(event) {
        event.preventDefault();
        $newPassword = $("#password-reset");
        $confirmPassword = $("#password-confirm");
        $passwordResetButton = $("#reset-button");
        $passwordResetButton.prop('disabled', true);
        $passwordResetButton.html('Processing Reset...');

        $newPasswordValue = $newPassword.val();
        $confirmPasswordValue = $confirmPassword.val();

        if ($newPasswordValue !== $confirmPasswordValue)
        {
            $passwordResetButton.prop('disabled', false);
            $passwordResetButton.html('Reset Password');
            return $('#alert-box').html(`<div class="alert alert-warning">Passwords should match. Please try again.</div>`);
        }

        let reset_password_results = await $.ajax(
            {
                type: "POST",
                url: "ajax_forgot_password.php",
                data: {
                    mode: "reset",
                    email: "<?php echo $token_check->fields['customers_email_address']; ?>",
                    password: $newPasswordValue
                }
            }
        );
        reset_password_resultsJ = JSON.parse(reset_password_results);
        if (reset_password_resultsJ.code == 0)
        {
            $passwordResetButton.prop('disabled', false);
            $passwordResetButton.html('Reset Password');
            return $('#alert-box').html(`<div class="alert alert-warning">${reset_password_resultsJ.message}</div>`);
        }
        $passwordResetButton.html("Password Reset");
        return $('#alert-box').html(`<div class="alert alert-success">Password reset! <a href="?main_page=login">Login now</a>.</div>`);
    }
</script>

<?php
}
else
{
?>

<main class="container-lg">
    <div class="center-content authentication-form-container">
        <?php echo zen_draw_form('forgot-form', '', 'post', 'class="authentication-form" onsubmit="sendEmail(event);"'); ?>
            <h3 class="text-center">Forgot Password</h3>
            <div class="mb-3 form-floating-label-container">
                <input type="email" class="form-control" id="forgot-email" name="forgot-email" placeholder="Input Email" />
                <label for="forgot-email">Email</label>
            </div>
            
            <div class="row mb-3">
                <div class="col-10 offset-1 col-md-8 offset-md-2">
                    <button type="submit" class="btn bg-westech-green text-white w-100" id="forgot-button">Send Password Reset</button>
                </div>
            </div>
            <div id="alert-box"></div>
            <p class="text-center mb-1">Password already reset? <a href="<?php echo zen_href_link("login", '', 'SSL'); ?>">Login here</a></p>
            <p class="text-center mb-1">Need an account? <a href="<?php echo zen_href_link("register", '', 'SSL'); ?>">Register here</a></p>
        </form>
    </div>
</main>

<script>
    async function sendEmail(event) {
        event.preventDefault();
        $passwordResetButton = $("#forgot-button");
        $passwordResetButton.prop("disabled", true);
        $passwordResetButton.html("Sending Email...");

        let inputEmail = $("#forgot-email").val();

        let forgot_password_results = await $.ajax(
            {
                type: "POST",
                url: "ajax_forgot_password.php",
                data: {
                    mode: "forgot",
                    email: inputEmail
                }
            }
        );
        forgot_password_resultsJ = JSON.parse(forgot_password_results);
        if(forgot_password_resultsJ.code == 0) {
            $passwordResetButton.prop('disabled', false);
            $passwordResetButton.html('Send Password Reset');
            return $('#alert-box').html(`<div class="alert alert-warning">${forgot_password_resultsJ.message}</div>`);
        }
        $passwordResetButton.html("Email Sent");
        return $('#alert-box').html(`<div class="alert alert-success">Email sent to ${inputEmail}. Please check your inbox to reset your password.</div>`);
    }
</script>

<?php
}