<main class="container-lg">
    <div class="center-content authentication-form-container">
        <?php echo zen_draw_form('login-form', '', 'post', 'class="authentication-form" onsubmit="login(event);"'); ?>
            <h3 class="text-center">Account Login</h3>
            <div class="mb-3 form-floating-label-container">
                <input class="form-control" id="login-email" name="login-email" placeholder="Input Email" />
                <label for="login-email">Email</label>
            </div>
            <div class="mb-3 form-floating-label-container">
                <input type="password" class="form-control" id="login-password" name="login-password" placeholder="Input Password" />
                <label for="login-password">Password</label>
            </div>
            
            <div class="row mb-3">
                <div class="col-10 offset-1 col-md-8 offset-md-2">
                    <button type="submit" class="btn bg-westech-green text-white w-100" id="login-button">Login</button>
                </div>
            </div>
            <div id="alert-box">
                
            </div>
            <p class="text-center mb-1">Need an account? <a href="<?php echo zen_href_link("register", '', 'SSL'); ?>">Register here</a></p>
            <p class="text-center mb-1">Forgot Password? <a href="<?php echo zen_href_link("forgot_password", '', 'SSL'); ?>">Reset it here</a></p>
        </form>
    </div>

</main>

<script>
    async function login(event) {
        event.preventDefault();
        let loginResult = await $.ajax({
            method: "POST",
            url: "ajax_login_process.php",
            data: {
                "mode": "login",
                "email": $("#login-email").val(),
                "password": $("#login-password").val(),
            }
        });
        loginResult = JSON.parse(loginResult);
        if(loginResult.code === 0) {
            return $('#alert-box').html(`<div class="alert alert-danger">${loginResult.message}</div>`);
        }
        console.log(loginResult);
        // return $('#alert-box').html(`<div class="alert alert-success">${loginResult.message}</div>`);
        window.location.href = "<?php echo zen_href_link("account", '', 'SSL'); ?>";
    }
</script>