<?php

$success_body = "
<main class='container'>
  <div class='row'>
    ";

include DIR_FS_CATALOG . DIR_WS_CLASSES . 'order.php';
$order_detail = new order($oID);

$order_date = zen_date_long($order_detail->info['date_purchased']);
$order_items = "";

foreach ($order_detail->products as $product)
{
  $product_image = zen_get_products_image($product['id'], zen_output_string($product['name']));
  $product_image = substr_replace($product_image, " class='cart-page-item-image' ", 4, 0);
  $product_model_and_name = $product['model'] . ' || ' . $product['name'];
  $product_price = number_format($product['final_price'], 2);
  $product_quantity = $product['qty'];
  $product_final_price = number_format(($product['final_price'] * $product_quantity), 2);

  $product_attributes = "";

  if (isset($product['attributes']))
  {
    $product_attributes .= "
    <div>
      <ul>
    ";

    foreach ($product['attributes'] as $attribute)
    {
      $attribute_text = $attribute['option'] . ' : ' . $attribute['value'];
      $prefix = $attribute['prefix'];
      $price = number_format($attribute['price'], 2);
      if ($attribute['price'] !== "0.0000") $attribute_text .= " ($prefix $$price)";

      $product_attributes .= "
      <li>$attribute_text</li>
      ";
    }

    $product_attributes .= "
      </ul>
    </div>
    ";
  }

  $order_items .= "
  <div class='row m-0 px-1 cart-page-item'>
    <div class='col-12 col-sm-3 col-md-2 col-lg-3 col-xl-2 text-center zoom-container'>
      $product_image
    </div>
    <div class='col-12 col-sm-9 col-md-10 col-lg-9 col-xl-10'>
      <div class='row'>
        <div class='col-12 col-sm-7 col-md-8 col-lg-7'>
          <p class='mb-0'>$product_model_and_name</p>
          <p class='text-muted'>$$product_price ea.</p>
          $product_attributes
        </div>
        <div class='col-12 col-sm-5 col-md-4 col-lg-5'>
          <div class='cart-page-item-quantity-summary'>
            <p class='text-muted cart-page-item-cost'>x$product_quantity : $$product_final_price</p>
          </div>
        </div>
      </div>
    </div>
  </div>
  ";
}

$shippingCompany = $order_detail->delivery['company'];
$shippingName = $order_detail->delivery['name'];
$shippingStreetAddress1 = $order_detail->delivery['street_address'];
$shippingStreetAddress2 = $order_detail->delivery[''];
$shippingStreetAddress3 = $order_detail->delivery[''];
$shippingSuburb = $order_detail->delivery['suburb'];
$shippingCity = $order_detail->delivery['city'];
$shippingZip = $order_detail->delivery['postcode'];
$shippingState = $order_detail->delivery['state'];
$shippingCountry = $order_detail->delivery['country']['title'];

$order_summary_shipping = "
<div class='cart-page-summary-container mb-3 d-flex'>
  <div class='cart-page-summary w-100'>
    <h4>Shipping To</h4>
    <div class='seperator w-100 m-0'></div>
";

if (!empty($shippingCompany))
{
  $order_summary_shipping .= "
  <p class='m-0'>Company: $shippingCompany</p>
  ";
} 
if (!empty($shippingName))
{
  $order_summary_shipping .= "
  <p class='m-0'>Name: $shippingName</p>
  ";
} 
if (!empty($shippingStreetAddress1))
{
  $order_summary_shipping .= "
  <p class='m-0'>Address: $shippingStreetAddress1</p>
  ";
} 
if (!empty($shippingSuburb))
{
  $order_summary_shipping .= "
  <p class='m-0'>Address 2: $shippingSuburb</p>
  ";
} 
if (!empty($shippingCity))
{
  $order_summary_shipping .= "
  <p class='m-0'>City: $shippingCity</p>
  ";
} 
if (!empty($shippingZip))
{
  $order_summary_shipping .= "
  <p class='m-0'>ZIP: $shippingZip</p>
  ";
} 
if (!empty($shippingState))
{
  $order_summary_shipping .= "
  <p class='m-0'>State: $shippingState</p>
  ";
} 
if (!empty($shippingCountry))
{
  $order_summary_shipping .= "
  <p class='m-0'>Country: $shippingCountry</p>
  ";
} 

$order_summary_shipping .= "
  </div>
</div>
";

$order_summary_billing = "
<div class='cart-page-summary-container mb-3 d-flex'>
  <div class='cart-page-summary w-100'>
    <h4>Billed To</h4>
    <div class='seperator w-100 m-0'></div>
";

$billingCompany = $order_detail->billing['company'];
$billingName = $order_detail->billing['name'];
$billingStreetAddress1 = $order_detail->billing['street_address'];
$billingStreetAddress2 = $order_detail->billing['suburb'];
$billingSuburb = $order_detail->billing['suburb'];
$billingCity = $order_detail->billing['city'];
$billingZip = $order_detail->billing['postcode'];
$billingState = $order_detail->billing['state'];
$billingCountry = $order_detail->billing['country']['title'];

if (!empty($billingCompany))
{
  $order_summary_billing .= "
  <p class='m-0'>Company: $billingCompany</p>
  ";
} 
if (!empty($billingName))
{
  $order_summary_billing .= "
  <p class='m-0'>Name: $billingName</p>
  ";
} 
if (!empty($billingStreetAddress1))
{
  $order_summary_billing .= "
  <p class='m-0'>Address: $billingStreetAddress1</p>
  ";
} 
if (!empty($billingSuburb))
{
  $order_summary_billing .= "
  <p class='m-0'>Address 2: $billingSuburb</p>
  ";
} 
if (!empty($billingCity))
{
  $order_summary_billing .= "
  <p class='m-0'>City: $billingCity</p>
  ";
} 
if (!empty($billingZip))
{
  $order_summary_billing .= "
  <p class='m-0'>ZIP: $billingZip</p>
  ";
} 
if (!empty($billingState))
{
  $order_summary_billing .= "
  <p class='m-0'>State: $billingState</p>
  ";
} 
if (!empty($billingCountry))
{
  $order_summary_billing .= "
  <p class='m-0'>Country: $billingCountry</p>
  ";
} 

$order_summary_billing .= "
  </div>
</div>
";

$order_summary_cart = "
<div class='cart-page-summary-container d-flex flex-grow-1 justify-content-center'>
  <div class='cart-page-summary d-flex flex-column justify-content-center'>
    <h4>Order Summary</h4>
";

foreach ($order_detail->totals as $total)
{
  $title = $total['title'];
  $text = $total['text'];

  if ($total['class'] == "ot_total")
  {
    $order_summary_cart .= "
    <div class='seperator w-100 m-0'></div>
    <div class='d-flex justify-content-between'>
      <h3>$title</h3>
      <h3>$text</h3>
    </div>
    ";
  }
  else
  {
    $order_summary_cart .= "
    <div class='d-flex justify-content-between'>
      <p>$title</p>
      <p>$text</p>
    </div>
    ";
  }
}

$order_summary_cart .= "
  </div>
</div>
";

$googleSVG = '
<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 85 36" class="injected-svg" xmlns:xlink="http://www.w3.org/1999/xlink">
  <g clip-path="url(#a-1)">
      <path fill="#4285F4" d="M20.778 13.43h-9.862v2.927h6.994c-.345 4.104-3.76 5.854-6.982 5.854-4.123 0-7.72-3.244-7.72-7.791 0-4.43 3.429-7.841 7.73-7.841 3.317 0 5.272 2.115 5.272 2.115l2.049-2.122s-2.63-2.928-7.427-2.928C4.725 3.644 0 8.8 0 14.367c0 5.457 4.445 10.777 10.988 10.777 5.756 0 9.969-3.942 9.969-9.772 0-1.23-.179-1.941-.179-1.941Z"></path>
      <path fill="#EA4335" d="M28.857 11.312c-4.047 0-6.947 3.163-6.947 6.853 0 3.744 2.813 6.966 6.994 6.966 3.786 0 6.887-2.893 6.887-6.886 0-4.576-3.607-6.933-6.934-6.933Zm.04 2.714c1.99 0 3.876 1.609 3.876 4.201 0 2.538-1.878 4.192-3.885 4.192-2.205 0-3.945-1.766-3.945-4.212 0-2.394 1.718-4.181 3.954-4.181Z"></path>
      <path fill="#FBBC05" d="M43.965 11.312c-4.046 0-6.946 3.163-6.946 6.853 0 3.744 2.813 6.966 6.994 6.966 3.785 0 6.886-2.893 6.886-6.886 0-4.576-3.607-6.933-6.934-6.933Zm.04 2.714c1.99 0 3.876 1.609 3.876 4.201 0 2.538-1.877 4.192-3.885 4.192-2.205 0-3.945-1.766-3.945-4.212 0-2.394 1.718-4.181 3.955-4.181Z"></path>
      <path fill="#4285F4" d="M58.783 11.319c-3.714 0-6.634 3.253-6.634 6.904 0 4.16 3.385 6.918 6.57 6.918 1.97 0 3.017-.782 3.79-1.68v1.363c0 2.384-1.448 3.812-3.633 3.812-2.11 0-3.169-1.57-3.537-2.46l-2.656 1.11c.943 1.992 2.839 4.07 6.215 4.07 3.693 0 6.508-2.327 6.508-7.205V11.734h-2.897v1.17c-.89-.96-2.109-1.585-3.726-1.585Zm.269 2.709c1.821 0 3.69 1.554 3.69 4.21 0 2.699-1.865 4.187-3.73 4.187-1.98 0-3.823-1.608-3.823-4.161 0-2.653 1.914-4.236 3.863-4.236Z"></path>
      <path fill="#EA4335" d="M78.288 11.302c-3.504 0-6.446 2.788-6.446 6.901 0 4.353 3.28 6.934 6.782 6.934 2.924 0 4.718-1.6 5.789-3.032l-2.389-1.59c-.62.962-1.656 1.902-3.385 1.902-1.943 0-2.836-1.063-3.39-2.094l9.266-3.845-.48-1.126c-.896-2.207-2.984-4.05-5.747-4.05Zm.12 2.658c1.263 0 2.171.671 2.557 1.476l-6.187 2.586c-.267-2.002 1.63-4.062 3.63-4.062Z"></path>
      <path fill="#34A853" d="M67.425 24.727h3.044V4.359h-3.044v20.368Z"></path>
  </g>
  <defs>
      <clipPath id="a-1">
          <path fill="#fff" d="M0 0h84.515v36H0z"></path>
      </clipPath>
  </defs>
</svg>
';

$success_body .= "
<div class='d-flex flex-column'>
  <div class='d-flex flex-column'>
    <p class='text-center'>Order Date: $order_date</p>
    <div class='d-flex flex-row justify-content-evenly'>
      <div class='d-flex flex-fill'>
        $order_summary_shipping
      </div>
      <div class='d-flex flex-fill'>
        $order_summary_billing
      </div>
    </div>
    <div class='d-flex mb-3'>
      <div class='d-flex flex-column'>
        $order_items
      </div>
      <div class='d-flex flex-column'>
        $order_summary_cart
      </div>
    </div>
    <div class='google-reviews d-flex justify-content-center m-1'>
      <a href='https://g.page/r/Cbr7m0c23unUEAI/review'><button type='button' class='btn p-3'>$googleSVG Leave a Review</button></a>
    </div>
  </div>
</div>
";

$success_body .= "
  </div>
</main>";

echo $success_body;