<?php
/**
 * Page Template
 *
 * Displays page-not-found message and site-map (if configured)
 *
 * @copyright Copyright 2003-2022 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: DrByte 2020 Dec 25 Modified in v1.5.8-alpha $
 */
?>
<div class="container-lg">
  <h1>Page Not Found</h1>

  <p><strong>Sorry, we had an issue finding the page you're looking for.</strong></p>

  <p>Common causes for seeing this page include misspelled URLs, moved/deleted pages or a server malfunction. You can try reloading the page, searching our products below, or <a class="text-black" href="?main_page=contact_us">contacting us</a> for assistance.</p>

  <ul class="nav nav-tabs justify-content-center" role="tablist" id="home-page-tabs">
    <li class="nav-item me-1" role="presentation">
      <button class="nav-link active home-tab-button" id="shop-by-category-button" data-bs-toggle="tab" data-bs-target="#shop-by-category-tab" type="button" role="tab" aria-controls="shop-by-category-tab" aria-selected="true">
          Shop By Category
      </button>
    </li>
    <li class="nav-item" role="presentation">
      <button class="nav-link home-tab-button" id="shop-by-brand-button" data-bs-toggle="tab" data-bs-target="#shop-by-brand-tab" type="button" role="tab" aria-controls="shop-by-brand-tab" aria-selected="false">
          Shop By Brand
      </button>
    </li>
  </ul>
  <div class="tab-content pt-3 mb-4" id="myTabContent">
    <div class="tab-pane show active" id="shop-by-category-tab" role="tabpanel" aria-labelledby="shop-by-category-button">
      <ul class="list-type-style-none home-tab-list">
      <?php

      foreach ($dropdowns['categories'] as $cat) {
          echo '<li>';
          echo '<a class="home-tab-list-link" href="?main_page=index&cPath=2_' . $cat['categories_id'] . '">' . $cat['categories_name'] . '</a>';
          echo '</li>';
      }

      ?>
      </ul>
    </div>
    <div class="tab-pane" id="shop-by-brand-tab" role="tabpanel" aria-labelledby="shop-by-brand-button">
      <ul class="list-type-style-none home-tab-list">
          <?php

          foreach ($dropdowns['brands'] as $cat) {
              echo '<li>';
              echo '<a class="home-tab-list-link" href="?main_page=index&cPath=1_' . $cat['categories_id'] . '">' . $cat['categories_name'] . '</a>';
              echo '</li>';
          }

          ?>
      </ul>
    </div>
  </div>
</div>