<main class="container-lg">
    <div class="center-content authentication-form-container">
        <?php echo zen_draw_form('register-form', '', 'post', 'class="authentication-form" onsubmit="register(event);"'); ?>
            <h3 class="text-center">Account Registration</h3>
            <div class="row">
                <div class="col-12 col-md-6">
                    <div class="mb-3 form-floating-label-container">
                        <input class="form-control" id="register-f-name" name="register-f-name" placeholder="John" required/>
                        <label for="register-f-name">First Name</label>
                    </div>
                </div>
                <div class="col-12 col-md-6">
                    <div class="mb-3 form-floating-label-container">
                        <input class="form-control" id="register-l-name" name="register-l-name" placeholder="Smith" required/>
                        <label for="register-l-name">Last Name</label>
                    </div>
                </div>
            </div>
            <div class="mb-3 form-floating-label-container">
                <input type="email" class="form-control" id="register-email" name="register-email" placeholder="Input Email" required/>
                <label for="register-email">Email</label>
            </div>
            <div class="mb-3 form-floating-label-container">
                <input type="password" class="form-control" id="register-password" name="register-password" placeholder="Input Password" required/>
                <label for="register-password">Password</label>
            </div>
            <div class="mb-3 form-floating-label-container">
                <input type="password" class="form-control" id="register-confirm-password" name="register-confirm-password" placeholder="Input Password" required/>
                <label for="register-confirm-password">Confirm Password</label>
            </div>
            <div class="row mb-3">
                <div class="col-10 offset-1 col-md-8 offset-md-2">
                    <button type="submit" class="btn bg-westech-green text-white w-100" id="register-button">Register</button>
                </div>
            </div>
            <div id="alert-box">
                
            </div>
            <p class="text-center mb-1">Already have a account? <a href="<?php echo zen_href_link("login", '', 'SSL'); ?>">Login Here</a></p>
            <p class="text-center mb-1">Forgot Password? <a href="<?php echo zen_href_link("forgot_password", '', 'SSL'); ?>">Reset here</a></p>
        </form>
    </div>
</main>

<script>
    async function register(event) {
        event.preventDefault();
        $registerButton = $("#register-button");
        $registerButton.prop("disabled", true);
        $registerButton.html("Registering...");

        let account_results = await $.ajax({
            type: "POST",
            url: "ajax_register_process.php",
            data: {
                fname: $("#register-f-name").val(),
                lname: $("#register-l-name").val(),
                email: $('#register-email').val(),
                password: $('#register-password').val(),
                confirm_password: $('#register-confirm-password').val()
            }
        });
        console.log(account_results);
        account_results = JSON.parse(account_results);
        if(account_results.result_code === 0) {
            $registerButton.prop("disabled", false);
            $registerButton.html("Register");
            return $('#alert-box').html(`<div class="alert alert-danger">${account_results.message}</div>`);
        }
        $registerButton.html("Registered!");
        return $('#alert-box').html(`<div class="alert alert-success">${account_results.message}</div>`);
    }

</script>