<?php
/**
 * Page Template
 *
 * Loaded automatically by index.php?main_page=search_result.
 * Displays results of search
 *
 * @copyright Copyright 2003-2022 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: DrByte 2020 Dec 25 New in v1.5.8-alpha $
 */
    include(DIR_WS_MODULES . zen_get_module_directory(FILENAME_PRODUCT_LISTING));
    $query = $result->sql_query;
    function renderProducts() {
        global $query;
        global $db;
        $products = "";
        $productList= $db->Execute($query);
        foreach($productList as $product) {
            $isBaseProduct = $product['is_base_product'];
            $manufactureText =  $product['manufacturers_name'];
            $brands_to_rebuilt = array(
                "PMP NEW", "ESCO SERVICES", "DAVIS AIRTECH","FREEDOM ELECTRONICS", "RDM", "FREEDOM / RDM OUTRIGHT", "GLOBAL LIGHT", "PMP", 
            );
            if (array_search(strtoupper($manufactureText), $brands_to_rebuilt)) {
                $manufactureText = '<em>Rebuilt Part</em>';
            }
            $productBoldText = "Model # " . $product['products_model']. " (" . $manufactureText . ")";
            $productName = $product['products_name'];
            $productAltName = $product['products_alt_name'];
            $imagePath = "/images/" . $product['products_image'];
            $productName = $product['products_name'];
            $price = "";
            
            $urlLink = "?main_page=product_info&products_id=" . $product['products_id'];
            if($isBaseProduct) {
                $subProductList = $db->Execute("select distinct p.*, p.products_price, pd.products_name, pd.products_alt_name, p.products_model, pd.*
                from " . "zen_products_xsell" . " xp, " . "zen_products" . " p, " . "zen_products_description" . " pd
                where xp.products_id = '" . $product['products_id'] . "'
                and xp.xsell_id = p.products_id
                and p.products_id = pd.products_id
                and xp.xsell_placement = '". "options" ."'
                order by xp.sort_order asc limit " . "100");
                if($subProductList->RecordCount() > 0 && !$product['product_is_call'] ){ 
                    $lowestPrice = 1000000000000.00;
                    foreach($subProductList as $subProduct) {
                        if($subProduct['products_price'] < $lowestPrice) {
                            $lowestPrice = $subProduct['products_price'];
                        }
                    }
                    $formattedPrice = number_format($lowestPrice, 2);
                    $price = "Starting at $$formattedPrice ";
                } 
            } else if($product['product_is_call'] == "1") {
                $price = "Call For Price";
            } else {
                $price = "Starting at $" . number_format($product['products_price'], 2);
            }
            $freeShippingElement = $product['product_is_always_free_shipping'] ? "<p class='product-item-free-shipping'>Free Shipping</p>" : "";
            $products .= "
                <a class='products-grid-item' href='$urlLink' title='$productName link'>
                    $freeShippingElement
                    <div class='products-grid-item-product'>
                        <img class='img-fluid' src='$imagePath' alt='$productName Image' />
                        <p class='fs-6 fw-bold product-item-additional-info'>$productBoldText</p>
                        <p class='product-item-name'>$productName</p>
                        <p class='product-item-alt-name'>$productAltName</p>
                        <p class='product-item-price fw-bold text-danger'>$price</p>
                    </div>
                </a>
            ".PHP_EOL;
        }
        return $products;
    }


?>
<main class="container-lg">
  <h1>Search Results</h1>
  <div class="row">
    <div id="productsListingTopNumber" class="navSplitPagesResult back">
        <?php echo $result->display_count(TEXT_DISPLAY_NUMBER_OF_PRODUCTS); ?>
    </div>
  </div>
  <div class="row">
    <div id="products-grid">
        <?php echo renderProducts(); ?>
    </div>
  </div>
  <div class="row">
    <div id="productsListingListingTopLinks" class="navSplitPagesLinks forward">
        <?php
            $max_display_page_links = $max_display_page_links ?? 25;
            $paginateAsUL = $paginateAsUL ?? false;
        ?>
        <?php echo TEXT_RESULT_PAGE . $listing_split->display_links($max_display_page_links, zen_get_all_get_params(array('page', 'info', 'x', 'y', 'main_page')), $paginateAsUL); ?>
    </div>

    <div id="productsListingBottomNumber" class="navSplitPagesResult back">
        <?php echo $result->display_count(TEXT_DISPLAY_NUMBER_OF_PRODUCTS); ?>
    </div>
  </div>

  
  
</main>
