<?php
/**
 * Page Template
 *
 * Loaded automatically by index.php?main_page=product_info.
 * Displays details of a typical product
 *
 * @copyright Copyright 2003-2022 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: Scott C Wilson 2021 Aug 07 Modified in v1.5.8-alpha $
 */
 //require(DIR_WS_MODULES . '/debug_blocks/product_info_prices.php');
  echo "<pre>";
  // echo "START";
  // echo "\n";
  // print_r($productQueryResult);
  print_r($product_info);
  // print_r($product_info->fields);
  // echo "\n";

  // echo "END";
  // echo "\n";
  echo "</pre>";

  $productTitle = "<h1><span class='brand-text-color'>$manufacturers_name</span> <span class='model-text-color'>$products_model</span> $products_name</h1>".PHP_EOL;
  $productAlternateName = $product_info->fields["products_alt_name"];
  $isFreeShipping = $product_info->fields["product_is_always_free_shipping"];
  $isMadeInTheUsa = $product_info->fields["madein"];
  $warrantyLength = $product_info->fields["warranty"];
  $productDescription = $product_info->fields["products_description"];

  function echoIfTrue($expression, $print_me) {
    if($expression == true) {
      echo $print_me;
    }
  }
?>

<main class="container-lg">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <!-- START PHP TO RENDER BREADCRUMB ROUTE  -->
            <li class="breadcrumb-item"><a href="#">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page">Library</li>
            <!-- END PHP TO RENDER BREADCRUMB ROUTE  -->
        </ol>
    </nav>
    <div class="row">
        <div class="col-sm-12 col-lg-4">
            <div class="product-page-image-container pb-3">
                <!-- 
                    START PHP TO CHECK IF ITEM HAS FREE SHIPPING 
                    - If free shipping render the free shipping image
                    - If no free shipping then render nothing
                -->
                <!-- {{#if freeShipping}} -->
                <?php
                  echoIfTrue($isFreeShipping, '<img class="p-absolute" src="/images/always-free-shipping.gif" alt="Free shippping" />');
                ?>
                <!-- STOP PHP TO CHECK IF ITEM HAS FREE SHIPPING -->
                <div class="d-flex justify-content-center">
                    <img class="img-fluid" src="<?php echo $products_image; ?>" alt="<?php echo $products_name; ?> preview" />
                </div>
                <div class="row">
                    <!-- 
                        START PHP TO CHECK IF ITEM HAS MANUFACTURE WARRANTY
                            -Change Image source with proper manufatruer warranty length  
                            - If No warranty then render nothing                  
                    -->
                    <!-- {{#if oneYearWarranty}} -->
                      <?php
                        echoIfTrue(
                          $warrantyLength > 0,
                          "<div class='col-4 col-sm-3 col-md-2 col-lg-3'>
                            <img class='img-fluid product-sub-image' src='/images/$warrantyLength-year-mfr-warranty.png' alt='' />
                          </div>".PHP_EOL
                        );
                      ?>
                        
                    <!-- {{/if}} -->
                    <!-- END PHP TO CHECK IF ITEM HAS MANUFATURER WARRANTY -->
                    <!-- START PHP TO CHECK IF ITEM IS MADE IN THE USA -->
                    <!-- {{#if madeInTheUsa}} -->
                      <?php
                        echoIfTrue(
                          $isMadeInTheUsa, 
                          '<div class="col-4 col-sm-3 col-md-2 col-lg-3">
                            <img class="img-fluid product-sub-image" src="/images/made-in-usa.jpg" alt="" />
                          </div>'
                        );
                      ?>
                        
                    <!-- {{/if}} -->
                    <!-- END PHP TO CHECK IF ITEM IS MADE IN THE USA -->
                </div>
            </div>
            <!-- START PHP TO CHECK IF ITEM HAS FREE SHIPPING -->
            <?php echoIfTrue($isFreeShipping, '<p class="mb-0 text-center">*Free shipping Excludes Hawaii and Alaska</p>'); ?>
            <!-- END PHP TO CHECK IF ITEM HAS FREE SHIPPING -->
            <p class="text-center">*Image is a representation of this item. Actual item may vary.*<br />Hover over image to zoom</p>
        </div>
        <div class="col-sm-12 col-lg-8 pb-5">
            <div class="row pb-4">
                <!-- START PHP TO POPULATE PRODUCT HEADER INFORMATION -->
                <?php echo $productTitle; ?>
                <p><?php echo $productAlternateName; ?></p>
                <!-- END PHP TO POPULATE PRODUCT HEADER INFORMATION -->
                <div class="seperator"></div>
            </div>
            <div class="row">
                <!-- START PHP TO CHECK TO SEE IF THE PRODUCT IS SHIPPED BY MANUFATURER -->
                <!-- {{#if shippedByManufature}} -->
                    <p class="fw-bold m-0">Ships From Manufaturer</p>
                <!-- {{/if}} -->
                <!-- END PHP TO CHECK TO SEE IF THE PRODUCT IS SHIPPED BY MANUFATURER -->
                <!-- START PHP TO RENDER OTHER ICONS -->
                <!-- END PHP TO RENDER OTHER ICONS -->
                <div>
                    <!-- 
                        START PHP TO CHECK IF THERE IS MORE THAN 1 MODEL  
                            - If there is display: Select Model &amp; Quantity
                            - If only one product display: Select Quantity:
                      -->
                    <p class="table-description">Select Model &amp; Quantity:</p>
                    <!-- END PHP TO CHECK IF THERE IS MORE THAN 1 MODEL  -->
                </div>
                <div class="table-responsive">
                    <table class="table table-bordered product-table">
                        <thead>
                            <tr class="bg-dark-grey">
                                <th scope="col">Model #</th>
                                <th scope="col">Description</th>
                                <th scope="col">Price</th>
                                <th scope="col">Qty</th>
                            </tr>
                        </thead>
                        <tbody>
                          <?php
                            foreach($product_info->result as $product) {
                              $price = number_format($product['products_price'], 2);
                              echo "
                                <th scope='row'>$products_model</th>
                                <td>$products_name</td>
                                <td>$$price</td>
                                <td>
                                    <input name='products_id[43203]' type='text' class='form-control product-quantity-input' placeholder='0' aria-label='product quantity' aria-describedby='product quantity' />
                                </td>
                              ".PHP_EOL;
                            }
                          ?>
                        </tbody>
                    </table>
                </div>
                <!-- 
                    START PHP TO CHECK TO SEE IF THERE ARE OPTIONAL PRODUCTS 
                        - If there are optional products then render the html below
                        - If there are no optional products then don't render anything
                -->
                <div>
                    <p class="table-description">Add Optional Accessories</p>
                </div>
                <div class="table-responsive pb-3">
                    <table class="table table-bordered product-table">
                        <thead>
                            <tr class="bg-dark-grey">
                                <th scope="col">Model #</th>
                                <th scope="col">Description</th>
                                <th scope="col">Price</th>
                                <th scope="col">Qty</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <th scope="row">CL10-XP9</th>
                                <td>Magnetic Starter - Magnetic Starter - 1 1/2 - 5 HP, 1PH</td>
                                <td>$221.17</td>
                                <td>
                                    <input name="product-quantity" type="text" class="form-control product-quantity-input" placeholder="0" aria-label="product quantity" aria-describedby="product quantity" />
                                </td>
                            </tr>
                            <tr>
                                <th scope="row">MAG START 5 HP 1 PH</th>
                                <td>9,000 lb. Capacity, Conventional Power Controls, 143 in. Height</td>
                                <td>$13</td>
                                <td>
                                    <input name="product-quantity" type="text" class="form-control product-quantity-input" placeholder="0" aria-label="product quantity" aria-describedby="product quantity" />
                                </td>
                            </tr>
                            <tr>
                                <th scope="row">CL10-XP9-3</th>
                                <td>9,000 lb. Capacity, Conventional Power Controls, 143 in. Height</td>
                                <td>$1,0000</td>
                                <td>
                                    <input name="model-quantity" type="text" class="form-control product-quantity-input" placeholder="0" aria-label="product quantity" aria-describedby="product quantity" />
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <!-- END PHP TO CHECK TO SEE IF THERE ARE OPTIONAL PRODUCTS -->
                <div class="pb-3 product-buttons-container">
                    <button type="button" class="btn product-page-button bg-message-light-red">
                        <i class="fa-solid fa-plus fa-lg product-button-icon"></i>ADD TO CART
                    </button>
                    <!-- RENDER BUTTON AFTER  ITEM IS ADDED TO CART-->
                    <button type="button" class="btn product-page-button bg-westech-green">
                        <i class="fa-solid fa-arrow-right fa-lg product-button-icon"></i>GO TO CHECKOUT
                    </button>
                    <!-- END RENDER BUTTON AFTER  ITEM IS ADDED TO CART-->
                </div>
                <div>
                    <a href="mailto:contact@westechequipment.com" class="product-contact-us-section bg-grey text-center d-block">Have a question? Click to email or Call 1-800-433-8831</a>
                </div>
            </div>
        </div>
    </div>
    <!-- 
        START PHP TO RENDER ADDITIONAL PRODUCT INFORMATION
    -->
    <nav>
        <div class="nav nav-tabs" id="product-page-tabs" role="tablist">
            <!-- 
                START RENDER BUTTON FOR EACH TAB 
                    - "active" class will be the initial tab to be shown
                        - aria-selected attribute should be set to true if "active" class exists
                    - id's must be different for each tab
                    - aria-controls attribute must match the tab content div id

            -->
            <?php
              echoIfTrue(
                $products_description != "", 
                "
                  <button class='nav-link active' id='description-tab-button' data-bs-toggle='tab' data-bs-target='#description-tab' type='button' role='tab' aria-controls='product-page-tabs' aria-selected='true'>Description</button>
                ".PHP_EOL
              );
            ?>
            <!-- END RENDER BUTTON FOR EACH TAB  -->
        </div>
    </nav>
    <div class="tab-content mb-3" id="product-page-tab-content">
        <!-- 
            START RENDER A DIV FOR EACH TAB
        -->
        <?php 
          echoIfTrue(
            $products_description != "",
            "
              <div class='tab-pane fade show active' id='description-tab' role='tabpanel' aria-labelledby='description-tab-button'>$productDescription</div
            ".PHP_EOL
          );
        ?>
    </div>
    <!--  END PHP TO RENDER ADDITIONAL PRODUCT INFORMATION -->
</main>











<div class="centerColumn" id="productGeneral">

<!--bof Form start-->
<?php echo zen_draw_form('cart_quantity', zen_href_link(zen_get_info_page($_GET['products_id']), zen_get_all_get_params(array('action')) . 'action=add_product', $request_type), 'post', 'enctype="multipart/form-data"') . "\n"; ?>
<!--eof Form start-->

<?php if ($messageStack->size('product_info') > 0) echo $messageStack->output('product_info'); ?>

<!--bof Category Icon -->
<?php if ($module_show_categories != 0) {?>
<?php
/**
 * display the category icons
 */
require($template->get_template_dir('/tpl_modules_category_icon_display.php',DIR_WS_TEMPLATE, $current_page_base,'templates'). '/tpl_modules_category_icon_display.php'); ?>
<?php } ?>
<!--eof Category Icon -->

<!--bof Prev/Next top position -->
<?php if (PRODUCT_INFO_PREVIOUS_NEXT == 1 or PRODUCT_INFO_PREVIOUS_NEXT == 3) { ?>
<?php
/**
 * display the product previous/next helper
 */
require($template->get_template_dir('/tpl_products_next_previous.php',DIR_WS_TEMPLATE, $current_page_base,'templates'). '/tpl_products_next_previous.php'); ?>
<?php } ?>
<!--eof Prev/Next top position-->

<!--bof Main Product Image -->
<?php
  if (!empty($products_image)) {
  ?>
<?php
/**
 * display the main product image
 */
   require($template->get_template_dir('/tpl_modules_main_product_image.php',DIR_WS_TEMPLATE, $current_page_base,'templates'). '/tpl_modules_main_product_image.php'); ?>
<?php
  }
?>
<!--eof Main Product Image-->

<!--bof Product Name-->
<h1 id="productName" class="productGeneral"><?php echo $products_name; ?></h1>
<!--eof Product Name-->

<!--bof Product Price block -->
<h2 id="productPrices" class="productGeneral">
<?php
// base price
  if ($show_onetime_charges_description == 'true') {
    $one_time = '<span>' . TEXT_ONETIME_CHARGE_SYMBOL . TEXT_ONETIME_CHARGE_DESCRIPTION . '</span><br>';
  } else {
    $one_time = '';
  }
  echo $one_time . ((zen_has_product_attributes_values((int)$_GET['products_id']) and $flag_show_product_info_starting_at == 1) ? TEXT_BASE_PRICE : '') . zen_get_products_display_price((int)$_GET['products_id']);
?></h2>
<!--eof Product Price block -->

<!--bof free ship icon  -->
<?php if(zen_get_product_is_always_free_shipping($products_id_current) && $flag_show_product_info_free_shipping) { ?>
<div id="freeShippingIcon"><?php echo TEXT_PRODUCT_FREE_SHIPPING_ICON; ?></div>
<?php } ?>
<!--eof free ship icon  -->

 <!--bof Product description -->
<?php if ($products_description != '') { ?>
<div id="productDescription" class="productGeneral biggerText"><?php echo stripslashes($products_description); ?></div>
<?php } ?>
<!--eof Product description -->
<br class="clearBoth">

<!--bof Add to Cart Box -->
<?php
if (CUSTOMERS_APPROVAL == 3 and TEXT_LOGIN_FOR_PRICE_BUTTON_REPLACE_SHOWROOM == '') {
  // do nothing
} else {
?>
            <?php
    $display_qty = (($flag_show_product_info_in_cart_qty == 1 and $_SESSION['cart']->in_cart($_GET['products_id'])) ? '<p>' . PRODUCTS_ORDER_QTY_TEXT_IN_CART . $_SESSION['cart']->get_quantity($_GET['products_id']) . '</p>' : '');
            if ($products_qty_box_status == 0 or $products_quantity_order_max== 1) {
              // hide the quantity box and default to 1
              $the_button = '<input type="hidden" name="cart_quantity" value="1">' . zen_draw_hidden_field('products_id', (int)$_GET['products_id']) . zen_image_submit(BUTTON_IMAGE_IN_CART, BUTTON_IN_CART_ALT);
            } else {
              // show the quantity box
    $the_button = PRODUCTS_ORDER_QTY_TEXT . '<input type="text" name="cart_quantity" value="' . $products_get_buy_now_qty . '" maxlength="6" size="4" aria-label="' . ARIA_QTY_ADD_TO_CART . '"><br>' . zen_get_products_quantity_min_units_display((int)$_GET['products_id']) . '<br>' . zen_draw_hidden_field('products_id', (int)$_GET['products_id']) . zen_image_submit(BUTTON_IMAGE_IN_CART, BUTTON_IN_CART_ALT);
            }
    $display_button = zen_get_buy_now_button($_GET['products_id'], $the_button);
  ?>
  <?php if ($display_qty != '' or $display_button != '') { ?>
    <div id="cartAdd">
    <?php
      echo $display_qty;
      echo $display_button;
            ?>
          </div>
  <?php } // display qty and button ?>
<?php } // CUSTOMERS_APPROVAL == 3 ?>
<!--eof Add to Cart Box-->

<!--bof Product details list  -->
<?php if ( (($flag_show_product_info_model == 1 and $products_model != '') or ($flag_show_product_info_weight == 1 and $products_weight !=0) or ($flag_show_product_info_quantity == 1) or ($flag_show_product_info_manufacturer == 1 and !empty($manufacturers_name))) ) { ?>
<ul id="productDetailsList" class="floatingBox back">
  <?php echo (($flag_show_product_info_model == 1 and $products_model !='') ? '<li>' . TEXT_PRODUCT_MODEL . $products_model . '</li>' : '') . "\n"; ?>
  <?php echo (($flag_show_product_info_weight == 1 and $products_weight !=0) ? '<li>' . TEXT_PRODUCT_WEIGHT .  $products_weight . TEXT_PRODUCT_WEIGHT_UNIT . '</li>'  : '') . "\n"; ?>
  <?php echo (($flag_show_product_info_quantity == 1) ? '<li>' . $products_quantity . TEXT_PRODUCT_QUANTITY . '</li>'  : '') . "\n"; ?>
  <?php echo (($flag_show_product_info_manufacturer == 1 and !empty($manufacturers_name)) ? '<li>' . TEXT_PRODUCT_MANUFACTURER . $manufacturers_name . '</li>' : '') . "\n"; ?>
</ul>
<br class="clearBoth">
<?php
  }
?>
<!--eof Product details list -->
<?php
if ($flag_show_ask_a_question) {
?>
<!-- bof Ask a Question -->
<br>
<span id="productQuestions" class="biggerText">
<b><?php echo '<a href="' . zen_href_link(FILENAME_ASK_A_QUESTION, 'pid=' . $_GET['products_id'], 'SSL') . '">' . ASK_A_QUESTION . '</a>'; ?></b>
</span>
<br class="clearBoth">
<!-- eof Ask a Question -->
<?php
}
?>

<!--bof Attributes Module -->
<?php
  if ($pr_attr->fields['total'] > 0) {
?>
<?php
/**
 * display the product attributes
 */
  require($template->get_template_dir('/tpl_modules_attributes.php',DIR_WS_TEMPLATE, $current_page_base,'templates'). '/tpl_modules_attributes.php'); ?>
<?php
  }
?>
<!--eof Attributes Module -->

<!--bof Quantity Discounts table -->
<?php
  if ($products_discount_type != 0) { ?>
<?php
/**
 * display the products quantity discount
 */
 require($template->get_template_dir('/tpl_modules_products_quantity_discounts.php',DIR_WS_TEMPLATE, $current_page_base,'templates'). '/tpl_modules_products_quantity_discounts.php'); ?>
<?php
  }
?>
<!--eof Quantity Discounts table -->

<!--bof Additional Product Images -->
<?php
/**
 * display the products additional images
 */
  require($template->get_template_dir('/tpl_modules_additional_images.php',DIR_WS_TEMPLATE, $current_page_base,'templates'). '/tpl_modules_additional_images.php'); ?>
<!--eof Additional Product Images -->

<!--bof Prev/Next bottom position -->
<?php if (PRODUCT_INFO_PREVIOUS_NEXT == 2 or PRODUCT_INFO_PREVIOUS_NEXT == 3) { ?>
<?php
/**
 * display the product previous/next helper
 */
 require($template->get_template_dir('/tpl_products_next_previous.php',DIR_WS_TEMPLATE, $current_page_base,'templates'). '/tpl_products_next_previous.php'); ?>
<?php } ?>
<!--eof Prev/Next bottom position -->

<!--bof Reviews button and count-->
<?php
  if ($flag_show_product_info_reviews == 1) {
    // if more than 0 reviews, then show reviews button; otherwise, show the "write review" button
    if ($reviews->fields['count'] > 0 ) { ?>
<div id="productReviewLink" class="buttonRow back"><?php echo '<a href="' . zen_href_link(FILENAME_PRODUCT_REVIEWS, zen_get_all_get_params()) . '">' . zen_image_button(BUTTON_IMAGE_REVIEWS, BUTTON_REVIEWS_ALT) . '</a>'; ?></div>
<br class="clearBoth">
<p class="reviewCount"><?php echo ($flag_show_product_info_reviews_count == 1 ? TEXT_CURRENT_REVIEWS . ' ' . $reviews->fields['count'] : ''); ?></p>
<?php } else { ?>
<div id="productReviewLink" class="buttonRow back"><?php echo '<a href="' . zen_href_link(FILENAME_PRODUCT_REVIEWS_WRITE, zen_get_all_get_params(array())) . '">' . zen_image_button(BUTTON_IMAGE_WRITE_REVIEW, BUTTON_WRITE_REVIEW_ALT) . '</a>'; ?></div>
<br class="clearBoth">
<?php
  }
}
?>
<!--eof Reviews button and count -->


<!--bof Product date added/available-->
<?php
  if ($products_date_available > date('Y-m-d H:i:s')) {
    if ($flag_show_product_info_date_available == 1) {
?>
  <p id="productDateAvailable" class="productGeneral centeredContent"><?php echo sprintf(TEXT_DATE_AVAILABLE, zen_date_long($products_date_available)); ?></p>
<?php
    }
  } else {
    if ($flag_show_product_info_date_added == 1) {
?>
      <p id="productDateAdded" class="productGeneral centeredContent"><?php echo sprintf(TEXT_DATE_ADDED, zen_date_long($products_date_added)); ?></p>
<?php
    } // $flag_show_product_info_date_added
  }
?>
<!--eof Product date added/available -->

<!--bof Product URL -->
<?php
  if (!empty($products_url)) {
    if ($flag_show_product_info_url == 1) {
?>
    <p id="productInfoLink" class="productGeneral centeredContent"><?php echo sprintf(TEXT_MORE_INFORMATION, zen_href_link(FILENAME_REDIRECT, 'action=product&products_id=' . zen_output_string_protected($_GET['products_id']), 'NONSSL', true, false)); ?></p>
<?php
    } // $flag_show_product_info_url
  }
?>
<!--eof Product URL -->

<!--bof also purchased products module-->
<?php require($template->get_template_dir('tpl_modules_also_purchased_products.php', DIR_WS_TEMPLATE, $current_page_base,'templates'). '/' . 'tpl_modules_also_purchased_products.php');?>
<!--eof also purchased products module-->

<!--bof Form close-->
</form>
<!--bof Form close-->
</div>
