<?php

/**
 * Ceon Advanced Shipper Custom Product Field Value Info Script - Looks up the title for a field's
 * value.
 * 
 * @package     ceon_advanced_shipper
 * @author      Conor Kerr <zen-cart.advanced-shipper@dev.ceon.net>
 * @copyright   Copyright 2007-2012 Ceon
 * @copyright   Portions Copyright 2003-2006 Zen Cart Development Team
 * @copyright   Portions Copyright 2003 osCommerce
 * @link        http://dev.ceon.net/web/zen-cart/advanced-shipper
 * @license     http://www.gnu.org/copyleft/gpl.html   GNU Public License V2.0
 * @version     $Id: advshipper_manufacturer_info.php 578 2012-01-05 18:50:09Z conor $
 */

require('includes/application_top.php');

$languages = zen_get_languages();

require_once(DIR_WS_FUNCTIONS . 'advshipper.php');

require_once(DIR_WS_FUNCTIONS . 'advshipper_custom_product_field_functions.php');

// Check and parse the input variable
$field_values_string = isset($_GET['field_values_string']) ? $_GET['field_values_string'] : null;

// Initialise the response variable
$answer = '';

$field_values = explode('--cpfv--', $field_values_string);

if (is_null($field_values_string) || sizeof($field_values) == 0) {
	// Necessary details missing!
	$answer = '-1';
} else {
	for ($i = 0, $n = sizeof($field_values); $i < $n; $i++) {
		// Get the details for the current field value
		$field_value = $field_values[$i];
		
		// Look up and use title for field value, instead of value itself, if specified
		$field_value_title = advshipperGetCustomFieldValueTitle($field_value);
		
		if ($field_value_title == false) {
			// Fall back to using the value as the title
			$field_value_title = $field_value;
		}
		
		if ($field_value_title != '') {
			$field_value_title = str_replace('(())', '', $field_value_title);
			
			$field_value_title = str_replace('|', '/', $field_value_title);
			
			// Build return string
			// Format: Field value
			//         Field value title
			$answer .= $field_value . '|' . $field_value_title . '||';
		} else {
			// Problem occurred looking up field value's details!
			$answer = '-1';
			
			break;
		}
	}
	if ($answer != '-1') {
		$answer = substr($answer, 0, strlen($answer) - 2);
	}
}

header('Content-Type: text/javascript');

?>
_cba.ready (
	<?php  echo $_GET['_cba_request_id'];?>,
	"<?php echo addslashes($answer);?>"
);
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>