<?php

require 'includes/application_top.php';

?>

<!doctype html>
<html <?php echo HTML_PARAMS; ?>>
    <head>
    <?php require DIR_WS_INCLUDES . 'admin_html_head.php'; ?>
    </head>
    <body>
        <?php require(DIR_WS_INCLUDES . 'header.php'); ?>

        <form>
            <input type='hidden' name='cmd' value='freightquote_test'>

            <input type='number' name='order_freight_query_OID' placeholder='Order ID'>

            <input type='number' name='order_freight_query_BILLED_FREIGHT' placeholder='Billed Freight'>

            <input type='submit' name='order_freight_query_SUBMIT'>
        </form>
        <br>

        <?php

        if (isset($_GET['order_freight_query_SUBMIT'])) {
            $oID = $_GET['order_freight_query_OID'] ?? null;
            if (!is_numeric($oID)) die('Submitted Order ID was not numeric.');

            $orderQuery = $db->Execute("SELECT * FROM zen_orders WHERE orders_id = $oID");
            if ($orderQuery->RecordCount() !== 1) die("Order ID $oID does not exist.");

            include DIR_FS_CATALOG . DIR_WS_CLASSES . 'order.php';
            $order = new order($oID);

            $billedFreight = $_GET['order_freight_query_BILLED_FREIGHT'];

            if ($order->info['shipping_method'] !== "Freight LTL") echo '<p style="color: red;">Warning: Shipping method is not exclusively freight.</p>';

            $products = $order->products;
            $productsSorted = array();
            $prids = array();
            $pridsStrippedAndImploded = "";

            foreach ($products as $product) {
                if (is_numeric($product['id'])) {
                    $prids[] = $product['id'];
                } else {
                    echo '<p style="color: red">prid ' . $product['id'] . ' is not numeric!</p>';
                }
            }

            $pridsStrippedAndImploded = implode('\', \'', $prids);
            
            echo $pridsStrippedAndImploded;
            
            $prodManfZoneQuery = 
                "SELECT
                    p.products_id, p.products_model, p.products_price_w, p.products_weight, p.manufacturers_id, 
                    p.product_is_always_free_shipping, p.is_core, p.products_freightquote_enable, p.products_freightquote_class,
                    p.products_freightquote_length, p.products_freightquote_width, p.products_freightquote_height,
                    p.products_freightquote_package_type, m.manufacturers_id, m.manufacturers_name, m.manufacturers_address_1, m.manufacturers_city,
                    m.manufacturers_zip, z.zone_code, z.zone_name
                FROM zen_products AS p
                LEFT JOIN zen_manufacturers AS m ON p.manufacturers_id = m.manufacturers_id
                LEFT JOIN zen_zones AS z ON m.manufacturers_state = z.zone_id
                WHERE p.products_id IN ('$pridsStrippedAndImploded')
                ";
            
            $prodManfZoneQueryResult = $db->Execute($prodManfZoneQuery);

            include '../includes/modules/freightquote/func.freightquote.php';

            echo '<pre>';
            print_r($prodManfZoneQueryResult->fields);
            echo '</pre>';

        }

        ?>
    </body>
</html>
<?php

require 'includes/application_bottom.php';