<?php
/**
 *
 * @package google product search feeder
 * @copyright Copyright 2007 Numinix Technology http://www.numinix.com
 * @copyright Portions Copyright 2003-2006 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: google_product_search.php 20 2012-09-21 21:22:20Z numinix $
 */
  require('includes/application_top.php');
  if(isset($_GET['action']) && ($_GET['action'] == 'delete')) {
    if (file_exists(DIR_FS_CATALOG . GOOGLE_PRODUCTS_DIRECTORY . $_GET['file'])) {
      unlink(DIR_FS_CATALOG . GOOGLE_PRODUCTS_DIRECTORY . $_GET['file']);
    }
    zen_redirect(zen_href_link(FILENAME_GOOGLE_PRODUCT_SEARCH));
  }
  $available_languages = $db->Execute("SELECT code, languages_id FROM " . TABLE_LANGUAGES . " ORDER BY code ASC;");
  $available_currencies = $db->Execute("SELECT code FROM " . TABLE_CURRENCIES . " ORDER BY code ASC;");
  $all_products_quantity = $db->Execute('SELECT p.products_id FROM ' . TABLE_PRODUCTS . ' p WHERE p.products_status = 1 AND p.products_type <> 3 AND p.product_is_call <> 1 AND p.product_is_free <> 1');
?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="includes/stylesheet.css">
<link rel="stylesheet" type="text/css" href="includes/cssjsmenuhover.css" media="all" id="hoverJS">
<!-- plugin files -->
<link rel="stylesheet" href="includes/modules/google_product_search_feeder/css/nmx_modules_normalize.min.css">
<link rel="stylesheet" href="includes/modules/google_product_search_feeder/css/nmx_modules_framework.css">
<link rel="stylesheet" href="includes/modules/google_product_search_feeder/css/nmx_google_product_search_feeder.css">
<link rel="stylesheet" href="includes/modules/google_product_search_feeder/css/nmx_google_product_search_feeder_overrides.css">
<!-- end plugin files -->
<script language="javascript" src="includes/menu.js"></script>
<script language="javascript" src="includes/general.js"></script>
<script type="text/javascript">
  <!--
  function init()
  {
    cssjsmenu('navbar');
    if (document.getElementById)
    {
      var kill = document.getElementById('hoverJS');
      kill.disabled = true;
    }
  }
  // -->
</script>

</head>
<body onload="init()">
<!-- header //-->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- header_eof //-->

<!-- body //-->
<div id="googleMerchantWrapper" class="nmx-module">
	
	<!-- header plugin breadcrumb -->
	<div class="nmx-container-breadcrumb nmx-container-fluid">
		<span><a href="<?php echo zen_href_link(FILENAME_DEFAULT) ?>"><?php echo HEADING_HOME; ?></a></span> <span><?php echo HEADING_TITLE; ?></span>
	</div>
	<!-- end header plugin breadcrumb -->

	<!-- header plugin name -->
	<div class="nmx-container-header">
		<h1><?php echo HEADING_TITLE; ?></h1>
	</div>
	<!-- end header plugin name -->
	
	<!-- content -->
	<div class="nmx-container-fluid">
		<!-- row -->
		<div class="nmx-row">
	    
	    <!--BOF LEFT WRAPPER-->
	    <div class="nmx-col-md-3 nmx-generate-feeder" id="leftWrapper">
	    
		    <!--BOF FEED WRAPPER-->
		    <div class="nmx-panel">
		      <div class="nmx-panel-body">
		      	<form method="get" name="google" class="nmx-mb0" action="<?php echo HTTP_SERVER . DIR_WS_CATALOG . FILENAME_GOOGLE_PRODUCT_SEARCH; ?>.php" target="_blank">
			        <!--div class="feedName">Feed Type</div>
			        <select name="FeedType" id="feedSelect" />
			          <option>Product</option>
			          <option>Documents</option>
			          <option>News</option>
			        </select-->
			        <input type="hidden" name="key" value="<?php echo GOOGLE_PRODUCTS_ACCESS_KEY; ?>" />
			        <input type="hidden" name="feed" value="fy_un_tp" />
			        <div class="nmx-form-group">
			          <label>Max Products:</label>
			          <input type="text" name="limit" class="nmx-form-control" value="<?php echo ((int)GOOGLE_PRODUCTS_MAX_PRODUCTS > 0 ? (int)GOOGLE_PRODUCTS_MAX_PRODUCTS : ''); ?>" />
			        </div>
			        <div class="nmx-form-group">
			          <label>Starting Point:</label>
			          <input type="text" name="offset" class="nmx-form-control" value="<?php echo ((int)GOOGLE_PRODUCTS_START_PRODUCTS > 0 ? (int)GOOGLE_PRODUCTS_START_PRODUCTS : ''); ?>" />
			        </div>
			       
		        	<div class="nmx-form-group">
			          <label>Currency:</label>
			          <select name="currency_code" class="nmx-form-control">
			          	<option value="0">Default</option>
			          	<?php 
			          	while (!$available_currencies->EOF) {
			          	  echo '<option value="' . $available_currencies->fields['code'] . '"' . (GOOGLE_PRODUCTS_CURRENCY == $available_currencies->fields['code'] ? ' selected="selected"' : '') . '>' . $available_currencies->fields['code'] . '</option>' . "\n";
						  $available_currencies->MoveNext();
						} 
			          	?>
			          </select>          
			        </div>
			        <div class="nmx-form-group">
			        	<label>Language:</label>
						<select name="language_id" class="nmx-form-control">
							<option value="0">Default</option>
							<?php 
								while (!$available_languages->EOF) {
									echo '<option value="' . $available_languages->fields['languages_id'] . '"' . (GOOGLE_PRODUCTS_LANGUAGE == $available_languages->fields['languages_id'] ? ' selected="selected"' : '') . '>' . $available_languages->fields['code'] . '</option>' . "\n";
								  	$available_languages->MoveNext();
								} 
							?>
						</select>
			        </div>
			    	<div class="nmx-btn-container" id="confirm">
			    		<input class="nmx-btn nmx-btn-primary" type="submit" value="Confirm" />
			    	</div>
			        
				</form>
		      </div>
		    </div>
		    <!--EOF FEED WRAPPER-->
	        
		    <!--BOF CRON URL WRAPPER-->
		    <div class="nmx-panel">
		      <div class="nmx-panel-heading">
		      	<span class="nmx-panel-title">Cron URL</span>
		      </div>
		      <div class="nmx-panel-body">
		      	<div class="nmx-form-group">
					<input type="text" class="nmx-form-control" name="CronJob" id="cronURL" value="<?php echo 'cd ' . DIR_FS_CATALOG . ' && php -f ' . FILENAME_GOOGLE_PRODUCT_SEARCH . '.php feed=fy_un_tp key=' . GOOGLE_PRODUCTS_ACCESS_KEY . ' language_id=1 currency_code=USD'; ?>" />
		        </div>
				<div>
				<input type="checkbox" id="batch" name="batch" value="Batch" onchange="setCronUrl(this)">
				<label for="batch"> <small>Enable batch generation (recommended for merchants with large products and limited server capability)</small></label><br>
				</div>
		        <div class="nmx-btn-container nmx-form-group">
	        		<button class="nmx-btn nmx-btn-primary js-btn--copy" data-clipboard-action="copy" data-clipboard-target="#cronURL">Copy</button>
	        	</div>
		        <p>Copy the above command and add it to your cron tab or contact your host for assistance.</p>
		      </div>
		    </div>
		    <!--EOF CRON URL WRAPPER-->

		    <?php if(defined('MODULE_ADVANCED_SHIPPER_STATUS') && strtolower(MODULE_ADVANCED_SHIPPER_STATUS) == 'yes'){ ?>
		    <!--BOF CEON SHIPPER WRAPPER-->
		    <div class="nmx-panel">
		      <div class="nmx-panel-heading">
		      	<span class="nmx-panel-title">Ceon Shipping Rate</span>
		      </div>
		      <div class="nmx-panel-body">
		        <div class="nmx-btn-container nmx-form-group">
		        	<input type="text" name="starting_point" placeholder="Starting Point">
	        		<button id="js-btn--ceon" class="nmx-btn nmx-btn-primary js-btn--copy">Upload</button>
	        	</div>
	        	<div>
	        		<p>Total # of products: <?php echo $all_products_quantity->RecordCount(); ?></p>
	        	</div>
		        <p>Upload Advanced shipping rate to database.</p>
		        <div id="result-feed">
		        </div>
		      </div>
		    </div>
		    <!--EOF CEON SHIPPER WRAPPER-->
	    	<?php } ?>
		    <!--BOF GOOGLE MERCHANT WRAPPER-->
		    <div class="nmx-panel">
		      <div class="nmx-panel-heading">
		      	<span class="nmx-panel-title">Merchant Center</span>
		      </div>
		      <div class="nmx-panel-body">
		        <ul class="nmx-ls-no nmx-google-links">
		        	<li><a href="http://www.google.com/merchants/merchantdashboard" target="_blank">Manage your Google Merchant Center Account</a></li>
		        	<li><a href="http://www.google.com/support/merchants/bin/answer.py?hl=en&answer=188494#other" target="_blank">Learn about Product Feed Specifications</a></li>
		        	<li><a href="http://www.numinix.com/forum/viewtopic.php?t=6" target="_blank">Get support for this tool in the Numinix User Forum</a></li>
		        </ul>
		      </div>
		    </div>
		    <!--EOF GOOGLE MERCHANT WRAPPER-->

	  	</div>
	  	<!--EOF LEFT WRAPPER-->
	    
	  <!--BOF RIGHT WRAPPER-->
	  <div class="nmx-col-md-9 nmx-files-feeder" id="rightWrapper">
	    <!--BOF DOWNLOAD WRAPPER-->
	    <table class="nmx-table nmx-table--bordered js-nmx-table--responsive">
	    	<thead>
	    		<tr>
	    			<th>Date (DD/MM/YYYY)</th>
	    			<th>Download Link</th>
	    			<th>Action</th>
	    		</tr>
	    	</thead>
	    	<tbody id="availableDownloads">
	    		<?php
					if ($handle = opendir(DIR_FS_CATALOG . GOOGLE_PRODUCTS_DIRECTORY)) {
					  while (false !== ($file = readdir($handle))) {
					    if ($file != "." && $file != ".." && $file != 'index.html') {
					    $filetime = filemtime(DIR_FS_CATALOG . GOOGLE_PRODUCTS_DIRECTORY . $file);
					    $date = date('j/m/Y', $filetime);
					?>
					      <tr class="dwnldWrapB">
					        <td><?php echo $date; ?></td>
					        <td><a href="<?php echo HTTP_SERVER . DIR_WS_CATALOG . GOOGLE_PRODUCTS_DIRECTORY . $file; ?>" target="_blank"><?php echo $file;?></a></td>
					        <td>
					            <a class="nmx-btn nmx-btn-primary nmx-btn-sm" href="<?php echo HTTP_SERVER . DIR_WS_CATALOG . FILENAME_GOOGLE_PRODUCT_SEARCH; ?>.php?feed=fn_uy&upload_file=<?php echo $file; ?>&key=<?php echo GOOGLE_PRODUCTS_ACCESS_KEY; ?>" target="_blank">Upload</a>
					            <a class="nmx-btn nmx-btn-default nmx-btn-sm" href="<?php echo zen_href_link(FILENAME_GOOGLE_PRODUCT_SEARCH, 'file='.$file.'&action=delete');?>">Delete</a>
					        </td>
					      </tr>
					<?php
					    }
					  }
					  closedir($handle);
					}
					?>
	    	</tbody>
	    </table>
	    <!--EOF DOWNLOAD WRAPPER-->
	    <!--BOF GMCF PROCESS WRAPPER-->
	    <div class="gmcfWrappers" id="processWrapper">
	      <div id="processOutput" class="messageStackSuccess"></div>
	    </div>
	    <!--EOF GMCF PROCESS WRAPPER-->
	  </div>
	  <!--EOF RIGHT WRAPPER-->

	  </div>
	  <!-- end/row -->
	</div>
	<!-- end/content -->
</div>
<!-- body_eof //-->

<!-- footer //-->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<!-- footer_eof //-->
<?php include(DIR_WS_INCLUDES . 'modules/google_product_search_feeder/js/google_product_search.php'); ?>

<script src="includes/modules/google_product_search_feeder/js/clipboard.min.js"></script>
<script>var clipboard = new Clipboard('.js-btn--copy');</script>
<script type="text/javascript">
jQuery(document).ready(function() {
	jQuery('#js-btn--ceon').on('click',function(){
		var starting_point = 0;
		console.log('ceon is clicked');
		if(jQuery('input[name=starting_point]').val() !== ''){
			var starting_point = jQuery('input[name=starting_point]').val();
		}
		console.log(starting_point);
		jQuery.ajax({
			url: "<?php echo HTTPS_SERVER.DIR_WS_CATALOG .'adv_shipper.php'?>",
			type: 'get',
			data: {
				'count': starting_point
			},
			beforeSend: function(){
				jQuery('#result-feed').html('<p>Processing...<img src="images/ajax-loader.gif" /></p>');
			},
			success: function(result){
				console.log(result);
				jQuery('#result-feed').append('<p id="current-count">'+result+' products uploaded</p>');
				if(result < <?php echo $all_products_quantity->RecordCount(); ?>){
					repeatajaxcall(result);
				}
			},
			error: function(xhr,exception){
				if(xhr.status == "522"){
					repeatajaxcall(starting_point)
				}
			}
		});
	});

	function repeatajaxcall(current_count){
		jQuery.ajax({
			url: "<?php echo HTTP_SERVER.DIR_WS_CATALOG .'adv_shipper.php'?>",
			type: 'get',
			data: {
				'count':current_count
			},
			success: function(result){
				console.log(result);
				jQuery('#current-count').html(result+' products uploaded');
				 if(result < <?php echo $all_products_quantity->RecordCount(); ?>){
				 	repeatajaxcall(result);
				 } else {
				 	console.log('finished');
				 	jQuery('#result-feed').html('<p>Finished</p><p id="current-count">'+<?php echo $all_products_quantity->RecordCount(); ?>+' # of products uploaded</p>');
				 }
			},
			error: function(xhr,exception){
				if(xhr.status == "522" || xhr.status == "523"){
					repeatajaxcall(current_count)
				}
			}
		});
	}
	
});
function setCronUrl(e){

	limit = (jQuery('input[name="limit"]').val() > 0 ? '&limit=' + jQuery('input[name="limit"]').val() : '');
    offset = (jQuery('input[name="offset"]').val() > 0 ? '&offset=' + jQuery('input[name="offset"]').val() : '');
    language_id = (jQuery('select[name="language_id"]').val() > 0 ? '&language_id=' + jQuery('select[name="language_id"]').val() : '');
    currency_code = (jQuery('select[name="currency_code"]').val() != 0 ? '&currency_code=' + jQuery('select[name="currency_code"]').val() : '');

	if (e.checked == true) {
		var value = "<?php echo 'wget \'' . HTTP_SERVER . DIR_WS_CATALOG . FILENAME_GOOGLE_PRODUCT_SEARCH . '.php?feed=fy_un_tp\\&key=' . GOOGLE_PRODUCTS_ACCESS_KEY; ?>" + limit + offset + language_id + currency_code + '&batch=true'+"'";
		document.getElementById("cronURL").value = value;
	} else {
		var value = "<?php echo 'wget \'' . HTTP_SERVER . DIR_WS_CATALOG . FILENAME_GOOGLE_PRODUCT_SEARCH . '.php?feed=fy_un_tp\\&key=' . GOOGLE_PRODUCTS_ACCESS_KEY; ?>" + limit + offset + language_id + currency_code + "'";
		document.getElementById("cronURL").value = value;
	}
}
</script>
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>