<?php

/**
 * Ceon URI Mappings Manager Action Class.
 *
 * @package     ceon_uri_mappings_manager
 * @author      Conor Kerr <zen-cart.uri-mappings-manager@ceon.net>
 * @copyright   Copyright 2011-2012 Ceon
 * @copyright   Copyright 2003-2007 Zen Cart Development Team
 * @copyright   Portions Copyright 2003 osCommerce
 * @link        http://ceon.net/software/business/zen-cart/uri-mappings-manager
 * @license     http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version     $Id: class.CeonUMMAction.php 1059 2012-10-01 16:43:34Z conor $
 */

/**
 * Load in the parent class if not already loaded
 */
require_once(DIR_FS_CATALOG . DIR_WS_CLASSES . 'class.CeonURIMappingAdmin.php');


// {{{ CeonUMMAction

/**
 * Simply provides shared functionality for the action classes.
 *
 * @package     ceon_uri_mappings_manager
 * @abstract
 * @author      Conor Kerr <zen-cart.uri-mappings-manager@ceon.net>
 * @copyright   Copyright 2011-2012 Ceon
 * @copyright   Copyright 2003-2007 Zen Cart Development Team
 * @copyright   Portions Copyright 2003 osCommerce
 * @link        http://ceon.net/software/business/zen-cart/uri-mappings-manager
 * @license     http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 */
class CeonUMMAction extends CeonURIMappingAdmin
{
	// {{{ properties
	
	/**
	 * The output generated for this action.
	 *
	 * @var     string
	 * @access  protected
	 */
	protected $_output;
	
	/**
	 * Maintains a list of any errors encountered for this action.
	 *
	 * @var     array
	 * @access  protected
	 */
	protected $_error_messages = array();
	
	/**
	 * Should AJAX be used for progress indicators?
	 *
	 * @var     boolean
	 * @access  protected
	 */
	protected $_use_ajax_progress_indicators = null;
	
	/**
	 * How often (in milliseconds) should AJAX progress indicators update their status? 
	 *
	 * @var     integer
	 * @access  protected
	 */
	protected $_ajax_progress_refresh_sec = null;
	
	/**
	 * How often (in seconds) should standard progress indicators "update their status" (Resubmit)? 
	 *
	 * @var     integer
	 * @access  protected
	 */
	protected $_standard_progress_refresh_sec = null;
	
	// }}}
	
	
	// {{{ Class Constructor
	
	/**
	 * Creates a new instance of the class.
	 * 
	 * @access  public
	 */
	public function __construct($use_ajax_progress_indicators = null, $ajax_progress_refresh_sec = null,
		$standard_progress_refresh_sec = null)
	{
		$this->_use_ajax_progress_indicators = $use_ajax_progress_indicators;
		
		$this->_ajax_progress_refresh_sec = $ajax_progress_refresh_sec;
		
		$this->_standard_progress_refresh_sec = $standard_progress_refresh_sec;
		
		parent::__construct();
		
		// Simple processing of posted variables, carried across from an earlier version of the software. Simply
		// sets the variables as properties of this instance
		foreach ($_POST as $key => $value) {
			$this->_posted_data[$key] = $value;
		}
	}
	
	// }}}
	
	
	// {{{ getOutput()
	
	/**
	 * Returns the output generated by this action.
	 *
	 * @access  public
	 * @return  string     The HTML output for this action.
	 */
	public function getOutput()
	{
		return $this->_output;
	}
	
	// }}}
	
	
	// {{{ getErrorMessages()
	
	/**
	 * Returns any error messages for this action.
	 *
	 * @access  public
	 * @return  array      The error messages for this action.
	 */
	public function getErrorMessages()
	{
		return $this->_error_messages;
	}
	
	// }}}
}

// }}}
