<?php

/**
 * Ceon URI Mappings Manager Alternate URIs Class.
 *
 * @package     ceon_uri_mappings_manager
 * @author      Conor Kerr <zen-cart.uri-mappings-manager@ceon.net>
 * @copyright   Copyright 2011-2012 Ceon
 * @copyright   Copyright 2003-2007 Zen Cart Development Team
 * @copyright   Portions Copyright 2003 osCommerce
 * @link        http://ceon.net/software/business/zen-cart/uri-mappings-manager
 * @license     http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version     $Id: class.CeonUMMAlternateURIs.php 1059 2012-10-01 16:43:34Z conor $
 */

/**
 * Load in the Ceon URI Mappings Manager Action class so it can be extended
 */
require_once(DIR_WS_CLASSES . 'class.CeonUMMAction.php');


// {{{ CeonUMMAlternateURIs

/**
 * Displays the list of alternate URIs for the site, allowing their management.
 *
 * @package     ceon_uri_mappings_manager
 * @author      Conor Kerr <zen-cart.uri-mappings-manager@ceon.net>
 * @copyright   Copyright 2011-2012 Ceon
 * @copyright   Copyright 2003-2007 Zen Cart Development Team
 * @copyright   Portions Copyright 2003 osCommerce
 * @link        http://ceon.net/software/business/zen-cart/uri-mappings-manager
 * @license     http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 */
class CeonUMMAlternateURIs extends CeonUMMAction
{
	// {{{ Class Constructor
	
	/**
	 * Creates a new instance of the class.
	 * 
	 * @access  public
	 */
	public function __construct($use_ajax_progress_indicators, $ajax_progress_refresh_sec,
		$standard_progress_refresh_sec)
	{
		// Load the language definition file for the current language
		@include_once(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . 'ceon_umm_alternate_uris.php');
		
		if (!defined('TEXT_NOTES') && $_SESSION['language'] != 'english') {
			// Fall back to english language file
			@include_once(DIR_WS_LANGUAGES . 'english/' . 'ceon_umm_alternate_uris.php');
		}
		
		parent::__construct($use_ajax_progress_indicators, $ajax_progress_refresh_sec,
			$standard_progress_refresh_sec);
		
		// Run the actual functionality and build the output
		$this->_buildAlternateURIsPanel();
	}
	
	// }}}
	
	
	// {{{ _buildAlternateURIsPanel()
	
	/**
	 * Not implemented in full as yet.
	 *
	 * @access  protected
	 * @return  none
	 */
	protected function _buildAlternateURIsPanel()
	{
		global $db, $languages, $num_languages, $ceon_uri_mapping_demo, $messageStack;
		
		$content = '';
		
		$content .= '<p>' . TEXT_NOTES . '</p>';
		
		
		$this->_output = $content;
	}
	
	// }}}
}

// }}}
