<?php

/**
 * Ceon URI Mappings Manager Manage/Auto-generate URIs Class.
 *
 * @package     ceon_uri_mappings_manager
 * @author      Conor Kerr <zen-cart.uri-mappings-manager@ceon.net>
 * @copyright   Copyright 2011-2012 Ceon
 * @copyright   Copyright 2003-2007 Zen Cart Development Team
 * @copyright   Portions Copyright 2003 osCommerce
 * @link        http://ceon.net/software/business/zen-cart/uri-mappings-manager
 * @license     http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version     $Id: class.CeonUMMCreateManage.php 1059 2012-10-01 16:43:34Z conor $
 */

/**
 * Load in the Ceon URI Mappings Manager Action class so it can be extended
 */
require_once(DIR_WS_CLASSES . 'class.CeonUMMAction.php');


// {{{ CeonUMMCreateManage

/**
 * Handles/builds main section of the Ceon URI Mappings Manager, where the URI mappings can be
 * viewed/generated/edited/deleted and the templates can be set for categories/products/manufacturers.
 *
 * @package     ceon_uri_mappings_manager
 * @author      Conor Kerr <zen-cart.uri-mappings-manager@ceon.net>
 * @copyright   Copyright 2011-2012 Ceon
 * @copyright   Copyright 2003-2007 Zen Cart Development Team
 * @copyright   Portions Copyright 2003 osCommerce
 * @link        http://ceon.net/software/business/zen-cart/uri-mappings-manager
 * @license     http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 */
class CeonUMMCreateManage extends CeonUMMAction
{
	// {{{ Class Constructor
	
	/**
	 * Creates a new instance of the class.
	 * 
	 * @access  public
	 */
	public function __construct($use_ajax_progress_indicators, $ajax_progress_refresh_sec,
		$standard_progress_refresh_sec)
	{
		// Load the language definition file for the current language
		@include_once(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . 'ceon_umm_create_manage.php');
		
		if (!defined('TEXT_SET_MAPPING_TEMPLATES') && $_SESSION['language'] != 'english') {
			// Fall back to english language file
			@include_once(DIR_WS_LANGUAGES . 'english/' . 'ceon_umm_create_manage.php');
		}
		
		parent::__construct($use_ajax_progress_indicators, $ajax_progress_refresh_sec,
			$standard_progress_refresh_sec);
		
		// Is the software running in script/AJAX/IFrame Mode? If so, let the appropriate method take over 
		$this->_handleAutomatedProcess();
		
		// Run the actual functionality and build the output
		$this->_buildCreateManagePanel();
	}
	
	// }}}
	
	
	// {{{ _handleAutomatedProcess()
	
	/**
	 * Checks if this software is being run in script mode, or if an AJAX call has been made to the software.
	 * Carries out any operation requried for the script mode or handles any AJAX request accordingly and returns
	 * the appropriate XML. If running in automated mode, the runtime process will be ended once the appropriate
	 * method has output its data. If not in an automated process mode, this will simply return.
	 *
	 * @access  protected
	 * @return  none
	 */
	protected function _handleAutomatedProcess()
	{
		if (isset($_GET['ajax'])) {
			$this->_handleAJAXRequest();
		}
		
		return;
	}
	
	// }}}
	
	
	// {{{ _buildCreateManagePanel()
	
	/**
	 * Builds the create/manage URIs panel. Performs the appropriate functionality and builds the output.
	 *
	 * @access  protected
	 * @return  none
	 */
	protected function _buildCreateManagePanel()
	{
		global $ceon_uri_mapping_demo;
		
		$content = '';
		
		// Analyse query string parameters to identify any buttons which have been clicked
		if (isset($_GET['manage-mappings']) || isset($_GET['manage-mapping-templates'])) {
			// Must check which object type is to be managed. This can be ascertained by looking at the page which
			// has called the manage method
			switch ($_GET['listing']) {
				case 'categories':
					$object_type = 'category';
					break;
				case 'products':
					$object_type = 'product';
					break;
				case 'manufacturers':
					$object_type = 'manufacturer';
					break;
				case 'ez-pages':
					$object_type = 'ez-page';
					break;
				case 'other-pages':
					$object_type = 'other-page';
					break;
			}
			
			$object_id = (isset($_GET['manage-mappings']) ? (int) $_GET['manage-mappings'] :
				(int) $_GET['manage-mapping-templates']);
		}
		
		// Dispatch to the appropriate method
		if (isset($this->_posted_data['auto-gen-cats'])) {
			require_once(DIR_WS_CLASSES . 'class.CeonUMMCreateManageAutogenCategories.php');
			
			$action_instance = new CeonUMMCreateManageAutogenCategories($this->_use_ajax_progress_indicators,
				$this->_ajax_progress_refresh_sec, $this->_standard_progress_refresh_sec);
			
			$action_instance->autogenerateMappingsForCategorySelection();
			
		} else if (isset($this->_posted_data['auto-gen-products'])) {
			require_once(DIR_WS_CLASSES . 'class.CeonUMMCreateManageAutogenProducts.php');
			
			$action_instance = new CeonUMMCreateManageAutogenProducts($this->_use_ajax_progress_indicators,
				$this->_ajax_progress_refresh_sec, $this->_standard_progress_refresh_sec);
			
			$action_instance->autogenerateMappingsForSelectedProducts();
			
		} else if (isset($_GET['manage-mappings'])) {
			require_once(DIR_WS_CLASSES . 'class.CeonUMMCreateManageObjMappings.php');
			
			$action_instance = new CeonUMMCreateManageObjMappings($object_type, $object_id);
			
		} else if (isset($_GET['manage-mapping-templates'])) {
			require_once(DIR_WS_CLASSES . 'class.CeonUMMCreateManageObjMappingTemplates.php');
			
			$action_instance = new CeonUMMCreateManageObjMappingTemplates($object_type, $object_id);
			
		} else if (isset($_GET['listing']) && $_GET['listing'] == 'products') {
			// Build and display listing for current category
			require_once(DIR_WS_CLASSES . 'class.CeonUMMCreateManageCategoriesProducts.php');
			
			$action_instance = new CeonUMMCreateManageCategoriesProducts();
			
			$action_instance->buildProductListing();
			
		} else if (isset($_GET['listing']) && $_GET['listing'] == 'categories') {
			require_once(DIR_WS_CLASSES . 'class.CeonUMMCreateManageCategoriesProducts.php');
			
			$action_instance = new CeonUMMCreateManageCategoriesProducts();
			
			$action_instance->buildCategoryListing();
			
		} else if (isset($_GET['listing']) && $_GET['listing'] == 'manufacturers') {
			require_once(DIR_WS_CLASSES . 'class.CeonUMMCreateManageManufacturers.php');
			
			$action_instance = new CeonUMMCreateManageManufacturers();
			
		} else if (isset($_GET['listing']) && $_GET['listing'] == 'ez-pages') {
			require_once(DIR_WS_CLASSES . 'class.CeonUMMCreateManageEZPages.php');
			
			$action_instance = new CeonUMMCreateManageEZPages();
			
		} else if (isset($_GET['listing']) && $_GET['listing'] == 'other-pages') {
			require_once(DIR_WS_CLASSES . 'class.CeonUMMCreateManageOtherPages.php');
			
			$action_instance = new CeonUMMCreateManageOtherPages();
			
		} else {
			require_once(DIR_WS_CLASSES . 'class.CeonUMMCreateManageIndex.php');
			
			$action_instance = new CeonUMMCreateManageIndex();
		}
		
		$content = $action_instance->getOutput();
		
		$errors = $action_instance->getErrorMessages();
		
		foreach ($errors as $error_message) {
			$this->_error_messages[] = $error_message;
		}
		
		$this->_output = $content;
	}
	
	// }}}
	
	
	// {{{ _handleAJAXRequest()
	
	/**
	 * Handles the autogeneration of mappings via an AJAX request. Parses the information sent, performs any
	 * auto-generation required and outputs the XML response to the AJAX request.
	 *
	 * @access  protected
	 * @return  none
	 */
	protected function _handleAJAXRequest()
	{
		if (isset($this->_posted_data['generate-product-mappings'])) {
			require_once(DIR_WS_CLASSES . 'class.CeonUMMCreateManageAutogenCategories.php');
			
			$action_instance = new CeonUMMCreateManageAutogenCategories($this->_use_ajax_progress_indicators,
				$this->_ajax_progress_refresh_sec, $this->_standard_progress_refresh_sec);
			
			$action_instance->handleCategoriesProductsAJAXRequest();
			
		} else {
			require_once(DIR_WS_CLASSES . 'class.CeonUMMCreateManageAutogenProducts.php');
			
			$action_instance = new CeonUMMCreateManageAutogenProducts($this->_use_ajax_progress_indicators,
				$this->_ajax_progress_refresh_sec, $this->_standard_progress_refresh_sec);
			
			$action_instance->handleProductsAJAXRequest();
		}
	}
	
	// }}}
}

// }}}
