<?php

/**
 * Ceon URI Mappings Manager Import Old URIs Class.
 *
 * @package     ceon_uri_mappings_manager
 * @author      Conor Kerr <zen-cart.uri-mappings-manager@ceon.net>
 * @copyright   Copyright 2011-2012 Ceon
 * @copyright   Copyright 2003-2007 Zen Cart Development Team
 * @copyright   Portions Copyright 2003 osCommerce
 * @link        http://ceon.net/software/business/zen-cart/uri-mappings-manager
 * @license     http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version     $Id: class.CeonUMMImportOldURIs.php 1059 2012-10-01 16:43:34Z conor $
 */

/**
 * Load in the Ceon URI Mappings Manager Action class so it can be extended
 */
require_once(DIR_WS_CLASSES . 'class.CeonUMMAction.php');


// {{{ CeonUMMImportOldURIs

/**
 * Scans all pages on a site and saves any static URIs generated by some SEO software as historical URIs in the
 * Ceon URI Mapping database.
 *
 * @package     ceon_uri_mappings_manager
 * @author      Conor Kerr <zen-cart.uri-mappings-manager@ceon.net>
 * @copyright   Copyright 2011-2012 Ceon
 * @copyright   Copyright 2003-2007 Zen Cart Development Team
 * @copyright   Portions Copyright 2003 osCommerce
 * @link        http://ceon.net/software/business/zen-cart/uri-mappings-manager
 * @license     http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 */
class CeonUMMImportOldURIs extends CeonUMMAction
{
	// {{{ Class Constructor
	
	/**
	 * Creates a new instance of the class.
	 * 
	 * @access  public
	 */
	public function __construct($use_ajax_progress_indicators, $ajax_progress_refresh_sec,
		$standard_progress_refresh_sec)
	{
		// Load the language definition file for the current language
		@include_once(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . 'ceon_umm_import_old_uris.php');
		
		if (!defined('TEXT_INTRO_1') && $_SESSION['language'] != 'english') {
			// Fall back to english language file
			@include_once(DIR_WS_LANGUAGES . 'english/' . 'ceon_umm_import_old_uris.php');
		}
		
		parent::__construct($use_ajax_progress_indicators, $ajax_progress_refresh_sec,
			$standard_progress_refresh_sec);
		
		// Run the actual functionality and build the output
		$this->_buildImportOldURIsPanel();
	}
	
	// }}}
	
	
	// {{{ _buildImportOldURIsPanel()
	
	/**
	 * Not implemented in full as yet.
	 *
	 * @access  protected
	 * @return  none
	 */
	protected function _buildImportOldURIsPanel()
	{
		$content = '';
		
		// Dispatch to the appropriate method
		if (isset($_GET['import-uris'])) {
			$content .= $this->_buildImportIFrame();
		} else {
			$content .= $this->_buildIntroPanel();
		}
		
		$this->_output = $content;
	}
	
	// }}}
	
	
	// {{{ _buildIntroPanel()
	
	/**
	 * Builds a subpanel which describes what this section does and allows the user to initiate the import process.
	 *
	 * @access  protected
	 * @return  none
	 */
	protected function _buildIntroPanel()
	{
		global $db, $ceon_uri_mapping_demo;
		
		$content = '';
		
		$content .= '<p>' . TEXT_INTRO_1 . '</p>' . "\n";
		
		$content .= '<h3 class="ImportOldURIsTitle">' . TEXT_WHAT_ARE_HISTORICAL_URIS . '</h3>' . "\n";
		
		$content .= '<p>' . TEXT_HISTORICAL_URIS_DESC_1 . '</p>' . "\n";
		
		
		$content .= '<h3 class="ImportOldURIsTitle">' . TEXT_PROCESS_OVERVIEW_TITLE . '</h3>' . "\n";
		
		$content .= '<p>' . TEXT_PROCESS_OVERVIEW_DESC_1 . '</p>' . "\n";
		
		$content .= '<p>' . TEXT_PROCESS_OVERVIEW_DESC_2 . '</p>' . "\n";
		
		$content .= '<p>' . TEXT_PROCESS_OVERVIEW_ONLY_PRODUCTS_CATEGORIES_AT_THIS_TIME . '</p>' . "\n";
		
		$content .= '<p>' . TEXT_PROCESS_OVERVIEW_NEW_AUTO_IDENTIFICATION_CREATION . '</p>' . "\n";
		
		
		// Build information about automatic historical URI creation
		// Build direct link to configuration option for user's convenience
		$config_option_link_result = $db->Execute("
			SELECT
				configuration_id,
				configuration_group_id
			FROM
				" . TABLE_CONFIGURATION . "
			WHERE
				configuration_key =
					'CEON_URI_MAPPINGS_MANAGER_ADD_HISTORICAL_URIS_FOR_UNMAPPED_SEO_MODULE_PAGES';");
		
		if (!$config_option_link_result->EOF) {
			$params = 'gID=' . $config_option_link_result->fields['configuration_group_id'] . '&cID=' .
				$config_option_link_result->fields['configuration_id'] . '&action=edit';
			
			$config_option_link = zen_href_link(FILENAME_CONFIGURATION, $params);
		}
		
		$content .= '<h3 class="ImportOldURIsTitle">' . TEXT_AUTO_IDENTIFICATION_CREATION_TITLE . '</h3>' . "\n";
		
		$content .= '<p>' . TEXT_NEW_AUTO_IDENTIFICATION_CREATION_DESC_1 . '</p>' . "\n";
		
		$enabled_disabled = (CEON_URI_MAPPINGS_MANAGER_ADD_HISTORICAL_URIS_FOR_UNMAPPED_SEO_MODULE_PAGES == 1 ?
			TEXT_ENABLED_LC : TEXT_DISABLED_LC);
		
		$enabled_disabled_set = (CEON_URI_MAPPINGS_MANAGER_ADD_HISTORICAL_URIS_FOR_UNMAPPED_SEO_MODULE_PAGES == 1 ?
			TEXT_DISABLED_LC : TEXT_ENABLED_LC);
		
		$content .= '<p>' . sprintf(TEXT_NEW_AUTO_IDENTIFICATION_CREATION_DESC_2, $enabled_disabled,
			$enabled_disabled_set, $config_option_link) . '</p>' . "\n";
		
		$content .= '<p>' . TEXT_NEW_AUTO_IDENTIFICATION_CREATION_DESC_3 . '</p>' . "\n";
		
		// Attempt to detect the SEO software installed, to provide the most specific instructions possible for the
		// user
		$can_output_import_link = false;
		
		$html_output_path = DIR_FS_CATALOG . DIR_WS_INCLUDES . 'functions/' . 'html_output.php';
		
		if (defined('SEO_ENABLED')) {
			// Ultimate SEO URLs is installed
			$content .= '<fieldset class="Steps"><legend>' . TEXT_ULTIMATE_SEO_URLS_PROCESS_STEPS_TITLE .
				'</legend>' . "\n";
			
			// Check if mods are present in html_output.php
			$html_output_mods_present = false;
			
			$html_output_source = file_get_contents($html_output_path);
			
			if (strpos($html_output_source, '$GLOBALS[\'seo_urls\']->href_link') !== false) {
				$html_output_mods_present = true;
			}
			
			if (SEO_ENABLED == 'true') {
				$content .= '<p class="Ticked">' . TEXT_STORE_APPEARS_TO_HAVE_ULTIMATE_SEO_URLS_INSTALLED_ENABLED .
					'</p>' . "\n";
			} else {
				$content .= '<p class="Ticked">' . TEXT_STORE_APPEARS_TO_HAVE_ULTIMATE_SEO_URLS_INSTALLED .
					'</p>' . "\n";
			}
			
			if (SEO_ENABLED == 'true') {
				if (CEON_URI_MAPPING_ENABLED == 1) {
					$content .= '<div class="Crossed">' . "\n";
				} else {
					$content .= '<p class="Ticked">' . TEXT_CEON_URI_MAPPING_DISABLED . '</p>' . "\n";
					
					if (!$html_output_mods_present) {
						$content .= '<div class="Crossed">' . "\n";
					} else {
						// Ultimate SEO URLs is enabled, its core mods were found and Ceon URI Mapping is disabled
						$can_output_import_link = true;
						
						$content .= '<div class="RemainingInstructions">' . "\n";
					}
				}
			} else {
				$content .= '<div class="Crossed">' . "\n";
			}
			
			$content .= '<ol>' . "\n";
			
			if (SEO_ENABLED != 'true') {
				$content .= '<li>' ."\n";
				
				$content .= '<p>' . TEXT_ULTIMATE_SEO_URLS_SHOULD_BE_ENABLED . '</p>' . "\n";
				
				$content .= '<p class="Step">' . TEXT_HOW_TO_ENABLE_ULTIMATE_SEO_URLS . '</p>' . "\n";
				
				$content .= '</li>' . "\n";
			}
			
			if (CEON_URI_MAPPING_ENABLED == 1) {
				$content .= '<li>' ."\n";
				
				$content .= '<p>' . TEXT_CEON_URI_MAPPING_ENABLED . '</p>' . "\n";
				
				$content .= '<p>' . TEXT_CEON_URI_MAPPING_ENABLED_DESC_1 . '</p>' . "\n";
				
				$content .= '<p>' . TEXT_CEON_URI_MAPPING_ENABLED_DESC_2 . '</p>' . "\n";
				
				$content .= '<p class="Step">' . TEXT_HOW_TO_DISABLE_CEON_URI_MAPPING . '</p>' . "\n";
				
				$content .= '</li>' . "\n";
			}
			
			
			$content .= '<li>' ."\n";
			
			if (!$html_output_mods_present) {
				$content .= '<p>' . TEXT_ULTIMATE_SEO_URLS_HTML_OUTPUT_MODS_MISSING . '</p>' . "\n";
				
				$content .= '<p class="Step">' .
					sprintf(TEXT_APPLY_ULTIMATE_SEO_URLS_HTML_OUTPUT_MODS, $html_output_path) . '</p>' .
					"\n";
				
				$content .= '<p class="Step">' . TEXT_HOW_TO_APPLY_ULTIMATE_SEO_URLS_HTML_OUTPUT_MODS .
					'</p>' . "\n";
			} else {
				$content .= '<p>' . TEXT_ULTIMATE_SEO_URLS_HTML_OUTPUT_MODS_IN_PLACE . '</p>' . "\n";
				
				$content .= '<p class="Step">' .
					sprintf(TEXT_HOW_TO_CHECK_ULTIMATE_SEO_URLS_MODS, $html_output_path) . '</p>' . "\n";
			}
			
			$content .= '<p class="Step">' . TEXT_ULTIMATE_SEO_URLS_HTML_OUTPUT_MODS_PRESENT_FOR_BOTH_INFO .
				'</p>' . "\n";
			
			$content .= '</li>' . "\n";
			
			
			$content .= '<li>' ."\n";
			
			if (SEO_ENABLED == 'true') {
				if (CEON_URI_MAPPING_ENABLED == 1) {
					if (!$html_output_mods_present) {
						$content .= '<p>' . TEXT_ONCE_ULTIMATE_SEO_URLS_CORE_FILE_MODS_MADE_CEON_URI_MAPPING_DISABLED_BUTTON_BECOMES_AVAILABLE . '</p>' .
							"\n";
					} else {
						$content .= '<p>' . TEXT_ONCE_CEON_URI_MAPPING_DISABLED_BUTTON_BECOMES_AVAILABLE . '</p>' .
							"\n";
					}
				} else {
					if (!$html_output_mods_present) {
						$content .= '<p>' .
							TEXT_ONCE_ULTIMATE_SEO_URLS_CORE_FILE_MODS_MADE_BUTTON_BECOMES_AVAILABLE . '</p>' .
							"\n";
					} else {
						$content .= '<p>' . TEXT_BUTTON_IS_AVAILABLE . '</p>' . "\n";
					}
				}
			} else {
				if (CEON_URI_MAPPING_ENABLED == 0) {
					$content .= '<p>' . TEXT_ONCE_ULTIMATE_SEO_URLS_ENABLED_BUTTON_BECOMES_AVAILABLE . '</p>' .
						"\n";
				} else {
					$content .= '<p>' .
						TEXT_ONCE_ULTIMATE_SEO_URLS_ENABLED_AND_CEON_URI_MAPPING_DISABLED_BUTTON_BECOMES_AVAILABLE .
						'</p>' . "\n";
				}
			}
			
			$content .= '</li>' . "\n";
			
			
			$content .= '<li>' ."\n";
			
			$content .= '<p>' . TEXT_ULTIMATE_SEO_URLS_AFTER_IMPORT . '</p>' . "\n";
			
			$content .= '<p class="Step">' . TEXT_HOW_TO_DISABLE_ULTIMATE_SEO_URLS . '</p>' . "\n";
			
			$content .= '</li>' . "\n";
			
			
			$content .= '<li>' ."\n";
			
			$content .= '<p>' . TEXT_ULTIMATE_SEO_URLS_DISABLE_OLD_REWRITE_RULE . '</p>' . "\n";
			
			$content .= '<div class="Step">' . TEXT_ULTIMATE_SEO_URLS_HOW_TO_DISABLE_REWRITE_RULE . '</div>' .
				"\n";
			
			$content .= '</li>' . "\n";
			
			
			$content .= '<li>' ."\n";
			
			$content .= '<p>' . TEXT_ULTIMATE_SEO_URLS_CHECK_REWRITE_RULE . '</p>' . "\n";
			
			$content .= '<div class="Step">' . TEXT_ULTIMATE_SEO_URLS_WHAT_TO_SET_REWRITE_RULE_TO . '</div>' .
				"\n";
			
			$content .= '</li>' . "\n";
			
			
			$content .= '<li>' ."\n";
			
			$content .= '<p>' . TEXT_CEON_URI_MAPPING_CAN_BE_ENABLED . '</p>' . "\n";
			
			$content .= '</li>' . "\n";
			
			
			$content .= '<li>' ."\n";
			
			$content .= '<p>' . TEXT_CREATE_MANAGE_URIS . '</p>' . "\n";
			
			$content .= '</li>' . "\n";
			
			$content .= '</ol>' . "\n";
			
			$content .= '</div>' . "\n";
			
			
			$content .= '</fieldset>' . "\n";
		}
		
		if (defined('SSU_STATUS')) {
			// Simple SEO URLs is installed
			$content .= '<fieldset class="Steps"><legend>' . TEXT_SSU_PROCESS_STEPS_TITLE . '</legend>' . "\n";
			
			// Check if mods are present in html_output.php
			$html_output_mods_present = false;
			
			$html_output_source = file_get_contents($html_output_path);
			
			if (strpos($html_output_source, '$ssu->ssu_link') !== false) {
				$html_output_mods_present = true;
			}
			
			if (SSU_STATUS == 'true') {
				$content .= '<p class="Ticked">' . TEXT_STORE_APPEARS_TO_HAVE_SSU_INSTALLED_ENABLED . '</p>' .
					"\n";
			} else {
				$content .= '<p class="Ticked">' . TEXT_STORE_APPEARS_TO_HAVE_SSU_INSTALLED . '</p>' . "\n";
			}
			
			if (SSU_STATUS == 'true') {
				if (CEON_URI_MAPPING_ENABLED == 1) {
					$content .= '<div class="Crossed">' . "\n";
				} else {
					$content .= '<p class="Ticked">' . TEXT_CEON_URI_MAPPING_DISABLED . '</p>' . "\n";
					
					if (!$html_output_mods_present) {
						$content .= '<div class="Crossed">' . "\n";
					} else {
						// Simple SEO URLs is enabled, its core mods were found and Ceon URI Mapping is disabled
						$can_output_import_link = true;
						
						$content .= '<div class="RemainingInstructions">' . "\n";
					}
				}
			} else {
				$content .= '<div class="Crossed">' . "\n";
			}
			
			$content .= '<ol>' . "\n";
			
			if (SSU_STATUS != 'true') {
				$content .= '<li>' ."\n";
				
				$content .= '<p>' . TEXT_SSU_SHOULD_BE_ENABLED . '</p>' . "\n";
				
				$content .= '<p class="Step">' . TEXT_HOW_TO_ENABLE_SSU . '</p>' . "\n";
				
				$content .= '</li>' . "\n";
			}
			
			if (CEON_URI_MAPPING_ENABLED == 1) {
				$content .= '<li>' ."\n";
				
				$content .= '<p>' . TEXT_CEON_URI_MAPPING_ENABLED . '</p>' . "\n";
				
				$content .= '<p>' . TEXT_CEON_URI_MAPPING_ENABLED_DESC_1 . '</p>' . "\n";
				
				$content .= '<p>' . TEXT_CEON_URI_MAPPING_ENABLED_DESC_2 . '</p>' . "\n";
				
				$content .= '<p class="Step">' . TEXT_HOW_TO_DISABLE_CEON_URI_MAPPING . '</p>' . "\n";
				
				$content .= '</li>' . "\n";
			}
			
			
			$content .= '<li>' ."\n";
			
			if (!$html_output_mods_present) {
				$content .= '<p>' . TEXT_SSU_HTML_OUTPUT_MODS_MISSING . '</p>' . "\n";
				
				$content .= '<p class="Step">' . sprintf(TEXT_APPLY_SSU_HTML_OUTPUT_MODS, $html_output_path) .
					'</p>' . "\n";
				
				$content .= '<p class="Step">' . TEXT_HOW_TO_APPLY_SSU_HTML_OUTPUT_MODS . '</p>' . "\n";
			} else {
				$content .= '<p>' . TEXT_SSU_HTML_OUTPUT_MODS_IN_PLACE . '</p>' . "\n";
				
				$content .= '<p class="Step">' . sprintf(TEXT_HOW_TO_CHECK_SSU_MODS, $html_output_path) . '</p>' .
					"\n";
			}
			
			$content .= '<p class="Step">' . TEXT_SSU_HTML_OUTPUT_MODS_PRESENT_FOR_BOTH_INFO . '</p>' . "\n";
			
			$content .= '</li>' . "\n";
			
			
			$content .= '<li>' ."\n";
			
			if (SSU_STATUS != 'true') {
				if (CEON_URI_MAPPING_ENABLED == 1) {
					if (!$html_output_mods_present) {
						$content .= '<p>' . TEXT_ONCE_SSU_CORE_FILE_MODS_MADE_CEON_URI_MAPPING_DISABLED_BUTTON_BECOMES_AVAILABLE . '</p>' .
							"\n";
					} else {
						$content .= '<p>' . TEXT_ONCE_CEON_URI_MAPPING_DISABLED_BUTTON_BECOMES_AVAILABLE . '</p>' .
							"\n";
					}
				} else {
					if (!$html_output_mods_present) {
						$content .= '<p>' .
							TEXT_ONCE_SSU_CORE_FILE_MODS_MADE_BUTTON_BECOMES_AVAILABLE . '</p>' . "\n";
					} else {
						$content .= '<p>' . TEXT_BUTTON_IS_AVAILABLE . '</p>' . "\n";
					}
				}
			} else {
				if (CEON_URI_MAPPING_ENABLED == 0) {
					$content .= '<p>' . TEXT_ONCE_SSU_ENABLED_BUTTON_BECOMES_AVAILABLE . '</p>' . "\n";
				} else {
					$content .= '<p>' .
						TEXT_ONCE_SSU_ENABLED_AND_CEON_URI_MAPPING_DISABLED_BUTTON_BECOMES_AVAILABLE . '</p>' .
						"\n";
				}
			}
			
			$content .= '</li>' . "\n";
			
			
			$content .= '<li>' ."\n";
			
			$content .= '<p>' . TEXT_SSU_AFTER_IMPORT . '</p>' . "\n";
			
			$content .= '<p class="Step">' . TEXT_HOW_TO_DISABLE_SSU . '</p>' . "\n";
			
			$content .= '</li>' . "\n";
			
			
			$content .= '<li>' ."\n";
			
			$content .= '<p>' . TEXT_SSU_DISABLE_OLD_REWRITE_RULE . '</p>' . "\n";
			
			$content .= '<div class="Step">' . TEXT_SSU_HOW_TO_DISABLE_REWRITE_RULE . '</div>' .
				"\n";
			
			$content .= '</li>' . "\n";
			
			
			$content .= '<li>' ."\n";
			
			$content .= '<p>' . TEXT_CEON_URI_MAPPING_CAN_BE_ENABLED . '</p>' . "\n";
			
			$content .= '</li>' . "\n";
			
			
			$content .= '<li>' ."\n";
			
			$content .= '<p>' . TEXT_CREATE_MANAGE_URIS . '</p>' . "\n";
			
			$content .= '</li>' . "\n";
			
			
			$content .= '</ol>' . "\n";
			
			$content .= '</div>' . "\n";
			
			
			$content .= '</fieldset>' . "\n";
		}
		
		
		if (function_exists('unMagicSeoDoSeo')) {
			// MagicSEO is installed
			$content .= '<fieldset class="Steps"><legend>' . TEXT_MAGIC_SEO_URLS_PROCESS_STEPS_TITLE .
				'</legend>' . "\n";
			
			if (1 == 1) {
				$content .= '<p class="Ticked">' . TEXT_STORE_APPEARS_TO_HAVE_MAGIC_SEO_URLS_INSTALLED . '</p>' .
					"\n";
				
				if (CEON_URI_MAPPING_ENABLED == 1) {
					$content .= '<div class="Crossed">' . "\n";
				} else {
					// Magic SEO URLs is installed, can't yet tell if it is enabled and if any core mods were found
					// but Ceon URI Mapping is disabled so assume all is okay
					$can_output_import_link = true;
					
					$content .= '<p class="Ticked">' . TEXT_CEON_URI_MAPPING_DISABLED . '</p>' . "\n";
					
					$content .= '<div class="Ticked">' . "\n";
				}
				
				$content .= '<ol>' . "\n";
				
				if (CEON_URI_MAPPING_ENABLED == 1) {
					$content .= '<li>' ."\n";
					
					$content .= '<p>' . TEXT_CEON_URI_MAPPING_ENABLED . '</p>' . "\n";
					
					$content .= '<p>' . TEXT_CEON_URI_MAPPING_ENABLED_DESC_1 . '</p>' . "\n";
					
					$content .= '<p>' . TEXT_CEON_URI_MAPPING_ENABLED_DESC_2 . '</p>' . "\n";
					
					$content .= '<p class="Step">' . TEXT_HOW_TO_DISABLE_CEON_URI_MAPPING . '</p>' . "\n";
					
					$content .= '</li>' . "\n";
				}
				
				$content .= '<li>' ."\n";
				
				$content .= '<p>' . TEXT_MAGIC_SEO_URLS_SHOULD_BE_ENABLED . '</p>' . "\n";
				
				$content .= '</li>' . "\n";
				
				/*$content .= '<li>' ."\n";
				
				if (CEON_URI_MAPPING_ENABLED == 0) {
					$content .= '<p>' . TEXT_ONCE_MODULE_ENABLED_BUTTON_BECOMES_AVAILABLE . '</p>' . "\n";
				} else {
					$content .= '<p>' .
						TEXT_ONCE_MAGIC_SEO_URLS_ENABLED_AND_CEON_URI_MAPPING_DISABLED_BUTTON_BECOMES_AVAILABLE .
						'</p>' . "\n";
				}
				
				$content .= '</li>' . "\n";*/
			}
			
			$content .= '<li>' ."\n";
			
			$content .= '<p>' . TEXT_MAGIC_SEO_URLS_AFTER_IMPORT . '</p>' . "\n";
			
			$content .= '</li>' . "\n";
			
			
			$content .= '<li>' ."\n";
			
			$content .= '<p>' . TEXT_CEON_URI_MAPPING_CAN_BE_ENABLED . '</p>' . "\n";
			
			$content .= '</li>' . "\n";
			
			
			$content .= '<li>' ."\n";
			
			$content .= '<p>' . TEXT_CREATE_MANAGE_URIS . '</p>' . "\n";
			
			$content .= '</li>' . "\n";
			
			
			$content .= '</ol>' . "\n";
			
			$content .= '</div>' . "\n";
			
			$content .= '</fieldset>' . "\n";
		}
		
		
		if (!defined('SEO_ENABLED') && !defined('SSU_STATUS') && !function_exists('unMagicSeoDoSeo')) {
			// None of Ultimate SEO URLs, Simple SEO URLs or MagicSEO is installed, output generic text
			$content .= '<fieldset class="Steps"><legend>' . TEXT_PROCESS_STEPS . '</legend>' . "\n";
			
			$content .= '<p>' . TEXT_COULDNT_IDENTIFY_URL_MODULE . '</p>' . "\n";
			
			$content .= '<p>' . TEXT_CONTACT_ADD_SUPPORT . '</p>' . "\n";
			
			$content .= '<ol>' . "\n";
			
			
			$content .= '<li>' ."\n";
			
			$content .= '<p>' . TEXT_SOFTWARE_SHOULD_BE_ENABLED . '</p>' . "\n";
			
			$content .= '</li>' . "\n";
			
			if (CEON_URI_MAPPING_ENABLED == 1) {
				$content .= '<li>' ."\n";
				
				$content .= '<p>' . TEXT_CEON_URI_MAPPING_ENABLED . '</p>' . "\n";
				
				$content .= '<p>' . TEXT_CEON_URI_MAPPING_ENABLED_DESC_1 . '</p>' . "\n";
				
				$content .= '<p>' . TEXT_CEON_URI_MAPPING_ENABLED_DESC_2 . '</p>' . "\n";
				
				$content .= '<p class="Step">' . TEXT_HOW_TO_DISABLE_CEON_URI_MAPPING . '</p>' . "\n";
				
				$content .= '</li>' . "\n";
			} else {
				$can_output_import_link = true;
			}
			
			
			$content .= '<li>' ."\n";
			
			if (CEON_URI_MAPPING_ENABLED == 0) {
				$content .= '<p>' . TEXT_BUTTON_SHOULD_BE_USED . '</p>' . "\n";
			} else {
				$content .= '<p>' . TEXT_ONCE_CEON_URI_MAPPING_DISABLED_BUTTON_BECOMES_AVAILABLE . '</p>' . "\n";
			}
			
			$content .= '</li>' . "\n";
			
			
			$content .= '<li>' ."\n";
			
			$content .= '<p>' . TEXT_UNKNOWN_AFTER_IMPORT . '</p>' . "\n";
			
			$content .= '</li>' . "\n";
			
			
			$content .= '<li>' ."\n";
			
			$content .= '<p>' . TEXT_CEON_URI_MAPPING_CAN_BE_ENABLED . '</p>' .
				"\n";
			
			$content .= '</li>' . "\n";
			
			
			$content .= '<li>' ."\n";
			
			$content .= '<p>' . TEXT_CREATE_MANAGE_URIS . '</p>' . "\n";
			
			$content .= '</li>' . "\n";
			
			
			$content .= '</ol>' . "\n";
			
			$content .= '</fieldset>' . "\n";
		}
		
		
		if (!$can_output_import_link) {
			return $content;
		}
		
		$params = zen_get_all_get_params();
		
		$params .= 'import-uris=1';
		
		$link = zen_href_link(FILENAME_CEON_UMM, $params, 'NONSSL');
		
		$content .= '<fieldset class="Import"><legend>' . TEXT_IMPORT_TITLE . '</legend>' . "\n";
		
		$content .= '<p>' . TEXT_IMPORT_CATEGORIES_PRODUCTS_URIS_INTRO . '</p>' . "\n";
		
		$content .= '<p class="ButtonLink FloatLeft"><a href="' . $link . '">' .
			TEXT_IMPORT_CATEGORIES_PRODUCTS_URIS_LINK . '</a></p>';
		
		$content .= '</fieldset>' . "\n";
		
		return $content;
	}
	
	// }}}
	
	
	// {{{ _buildImportIFrame()
	
	/**
	 * Builds a subpanel with an IFrame that loads and starts the import URIs script on the catalog side.
	 *
	 * @access  protected
	 * @return  none
	 */
	protected function _buildImportIFrame()
	{
		global $ceon_uri_mapping_demo;
		
		$params = 'admin-dir-path=' . urlencode(DIR_WS_ADMIN);
		
		// Link is catalog side
		$link = HTTP_CATALOG_SERVER . DIR_WS_CATALOG . FILENAME_CEON_UMM_IMPORT_OLD_URIS;
		
		$link .= '?' . $params;
		
		$content = '<iframe frameborder="0" src="' . $link . '" id="ceon_umm_import_iframe">' . "\n";
		
		$content .= '</iframe>' . "\n";
		
		return $content;
	}
	
	// }}}
}

// }}}
