<?php
/*
 * Overall class for numinix premium/subscription plugins. Soemday we will encode this but until that point it'll just be visable
 */
define('SECONDS_IN_A_WEEK', 604800);
//$_SESSION['emailed_support'] = 0; //todo: remove this after testing
class nxPluginLicCheck
{
    // this get the information about the store
    function __construct()
    {
        //SERVER_NAME is sometimes blank because it is dependent on the server config, so use HTTP_HOST in that case.
        $domain              = (strlen($_SERVER['SERVER_NAME']) > 0) ? $_SERVER['SERVER_NAME'] : $_SERVER['HTTP_HOST'];
        $this->server_domain = md5($this->clean_website_url($domain));
        $this->store_owner   = STORE_OWNER;
        $this->admin_email   = STORE_OWNER_EMAIL_ADDRESS;
        $this->store_phone   = STORE_TELEPHONE_CUSTSERVICE;
        $this->store_name    = STORE_NAME;
        $this->expires_date = '0000-00-00';
    }
    // this is where the plugin key from the init file is added to strt the process
    // this is actaully a set function
    function getPluginKey($plugin_key)
    {
        $this->plugin_key = $plugin_key;
    }
    // this takes the plugin key and splits into it's need parts
    function getPluginFacts()
    {
        $plugin_key_array       = explode(":", $this->plugin_key);
        $this->version_key      = base64_decode($plugin_key_array[0]);
        $this->installer_folder = DIR_FS_ADMIN . 'includes/installers/' . base64_decode($plugin_key_array[1]);
        $this->enable           = base64_decode($plugin_key_array[2]);
        $this->plugin_id        = base64_decode($plugin_key_array[3]);
        $this->plugin_name      = base64_decode($plugin_key_array[4]);
        $this->license_key      = str_replace("_VERSION", "", $this->version_key) . '_KEY';
        $this->installers       = scandir($this->installer_folder, 1);
        usort($this->installers, 'version_compare');
        //$this->installers = array_reverse($this->installers);
        $this->files_version = substr(end($this->installers), 0, -4);
        if (defined($this->version_key))
        {
            $this->installed_version = constant($this->version_key);
        }
    }
    // this pulls the current license stored in the local database
    function pullLocalLic()
    {
        if (!defined($this->license_key))
        {
            $this->current_key_defined = 0;
            return false;
        }
        if (constant($this->license_key) == '')
        {
            $this->current_key_defined = 0;
            return false;
        }
        $this->current_key_defined = 1;
        // the key should follow this format
        //[EXPIRES: UNIX TIME]:[Domain]:[KILL SWITCH ACTIVE]:[MAX_VERSION]:[RENEW DATE]
        $current_lic_array         = explode(':', constant($this->license_key));
        // calculate expiration time (note: strototime will break on some servers outside of North America)
        $this->loc_expires         = base64_decode($current_lic_array[0]);
        //$expires = new DateTime();
        $expires                   = NXDateTime::createFromFormat('Y-m-d H:i:s', $this->loc_expires);
        if (!$expires) //string could not be parsed into a DateTime
        {
            $expires = NXDateTime::createFromFormat('Y-m-d H:i:s', $this->loc_expires);
            if (!$expires) //second attempt also failed
            {
                if (!$_SESSION['license_expired_message'])
                {
                    $_SESSION['license_expired_message'] = true;
                    /*
                    $message                             = 'The expiry in the license could not be parsed into a datetime.  This usually happens when there is not a valid license.  It also could mean that the site has an old version of the plugin that cannot be disabled by the license check script.  Domain: ' . $this->clean_website_url($_SERVER['SERVER_NAME']) . ' Details: ' . json_encode($this);
                    zen_mail('support@numinix.com', 'support@numinix.com', 'Plugin License: Invalid exiry/Non-existant ' . $this->plugin_name, $message, $this->store_owner, 'support@numinix.com', array(
                        'EMAIL_MESSAGE_HTML' => $message
                    ));
                    */
                }
            }
            return false;
        }
        $this->expires_date    = $expires->format('U');
        $this->loc_domain      = $current_lic_array[1];
        $this->loc_kill_active = base64_decode($current_lic_array[2]);
        $this->loc_max_version = base64_decode($current_lic_array[3]);
        $this->loc_renew_date  = base64_decode($current_lic_array[4]);
        return true;
    }
    // here we are gettign the json payload to use to request the license from numinix.com
    function createJsonData()
    {
        //SERVER_NAME is sometimes blank because it is dependent on the server config, so use HTTP_HOST in that case.
        $domain          = (strlen($_SERVER['SERVER_NAME']) > 0) ? $_SERVER['SERVER_NAME'] : $_SERVER['HTTP_HOST'];
        $this->json_data = array(
            'verison_key' => $this->version_key,
            'plugin_id' => $this->plugin_id,
            'files_version' => $this->files_verison,
            'installed_version' => $this->installed_version,
            'domain' => $this->clean_website_url($domain),
            'store_owner' => $this->store_owner,
            'admin_email' => $this->admin_email,
            'customer_phone' => $this->store_phone,
            'store_name' => $this->store_name,
            'cyper' => md5('numinix'),
            'current_key_defined' => $this->current_key_defined
        );
    }
    // Now it's time to check with the mother ship if there is a valid plugin license
    function pullRemoteLic()
    {
        $this->createJsonData();
        $url             = 'https://direct.numinix.com/module_license/check.php';
        $ch              = curl_init($url);
        $jsonDataEncoded = json_encode($this->json_data);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonDataEncoded);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
        ));
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
        $raw_result = curl_exec($ch);
        if ($raw_result == false)
        {
            $message = 'The license could not be verified from the numinix_plugins class.  Curl error: ' . curl_error($ch);
            $this->showMessage($this->plugin_name . ' licence could not be verified due to a connection error. Please contact Numinix (support@numinix.com) and provide your server IP address for whitelisting.', '', 'caution');
        }
        else
        {
            $this->json_result = json_decode($raw_result);
            $this->addJsonResultVars();
            $this->saveNewLicKey();
        }
    }
    // ok so now we got the respoinse let's split this up into some usable variables
    function addJsonResultVars()
    {
        $result                    = $this->json_result;
        $this->max_version_allowed = $result->max_version;
        $expires                   = NXDateTime::createFromFormat('Y-m-d H:i:s', $result->expires);
        if (!$expires) //string could not be parsed into a DateTime.  See if it is formatted without the time.
        {
            $expires = NXDateTime::createFromFormat('Y-m-d H:i:s', $this->loc_expires);
        }
        if (!$expires)
        {
            $this->expires_date = '0000-00-00';
        }
        else
        {
            $this->expires_date = $expires->format('U');
        }
        $this->renew_date     = $result->renew_date;
        $this->disable_active = $result->disable_active;
        $this->new_lic_key    = $result->license_key;
        $this->instant_fail   = $result->instant_fail;
        $current_lic_array    = explode(':', $this->new_lic_key);
        $this->loc_domain     = $current_lic_array[1];
    }
    // disable the plugin, optional, only when plugin has module_ENABLED defined
    function disablePlugin($error = '')
    {
        global $db;
        if (defined($this->enable) && constant($this->enable) == 'true' && $_SESSION['fails' . $this->plugin_id] >= 5)
        {
            //if (defined($this->enable) && constant($this->enable) == 'true') {
            $db->Execute('UPDATE ' . TABLE_CONFIGURATION . " SET configuration_value='false' WHERE configuration_key='" . $this->enable . "'");
            $this->showMessage('This module has been disabled because you don\'t have an active/valid license for your domain', '427', 'error');
            if (!$_SESSION['emailed_support'])
            {
                $_SESSION['emailed_support'] = true;
                $message                     = $error . '  Plugin was disabled on client site.  Domain: ' . $this->clean_website_url($_SERVER['SERVER_NAME']) . ' Details: ' . json_encode($this);
                zen_mail('support@numinix.com', 'support@numinix.com', 'Plugin disabled ' . $this->plugin_name, $message, $this->store_owner, $this->admin_email, array(
                    'EMAIL_MESSAGE_HTML' => $message
                ));
            }
        }
    }
    function pluginLicInvalid()
    {
        $this->disablePlugin('458: License is invalid.  This means that numinix.com returned an instant fail when it could not find a license for the domain/plugin pair. ');
        $_SESSION['fails' . $this->plugin_id]++;
        $this->disable_plugin = true;
        $this->showMessage('Please contact <a href="numinix.com">numinix.com</a> there is an error when verifing your license', '458', 'error');
    }
    function pluginExpired()
    {
        $this->disablePlugin('447: License has expired.  Expiry date of license: ' . $this->expires_date . ' .Current time: ' . time());
        $_SESSION['fails' . $this->plugin_id]++;
        $this->disable_plugin = true;
        $this->showMessage('Your License Has Expired Please Contact <a href="numinix.com">numinix.com</a>', '447', 'error');
    }
    function domainMismatched()
    {
        $this->disablePlugin('477: Domain mismatch.  This means that the locally stored license does not match the domain of the server.');
        $_SESSION['fails' . $this->plugin_id]++;
        $this->disable_plugin = true;
        $this->showMessage('Please contact <a href="numinix.com">numinix.com</a> there is an error when verifing your license', '477', 'error');
    }
    // wait this verison is newer than what you should have...where'd you get these files from? huh?
    function versionNotAllowed()
    {
        $this->showMessage('Please contact <a href="numinix.com">numinix.com</a> there is an error when verifing your license', '457', 'error');
    }
    // We don't have a change oil light in zencart, so lets let them know it's time to renew.
    function warnExpires()
    {
        // if expires within 1 week
        if ($this->expires_date > 0 && $this->expires_date < time() + SECONDS_IN_A_WEEK)
        {
            //     if ($this->loc_kill_active == '1') {
            $this->showMessage($this->plugin_name . ' is about to expire.  If you have an active subscription then it will be automatically renewed and you may disregard this warning.', '', 'caution');
            //      } else {
            //        $this->showMessage($this->plugin_name . ' is about to expire, renew now to get future updates', '', 'caution');
            //     }
            if (!isset($_SESSION['checked_remote_license'][$this->version_key]) || $_SESSION['checked_remote_license'][$this->version_key] == false)
            {
                $_SESSION['checked_remote_license'][$this->version_key] = true;
                $this->pullRemoteLic();
            }
        }
    }
    // just because it's easier to show the messgaes with a function, let's cheat and use this.
    // Messages should show in module's configuration page only, if module is installed and plugin license valid
    function showMessage($message = 'Please contact <a href="numinix.com">numinix.com</a> there is an error when verifing your license ', $code = '', $level = 'warning')
    {
        global $messageStack;
        if (constant($this->version_key) && strpos($_SERVER["SCRIPT_NAME"], 'configuration') == false && $code != '458')
        {
            return false;
        }
        $complete_message = $message . ' for <b>' . $this->plugin_name . '</b>';
        if ($code != '')
        {
            $complete_message .= ' Code: ' . $code;
        }
        $messageStack->add($complete_message, $level);
    }
    // ok you have passed the tests, now it's actually, finally time to install/upgrade
    function runInstaller()
    {
        global $db, $messageStack;
        $configuration_group_id = '';
        if (defined($this->version_key))
        {
            $current_version = constant($this->version_key);
        }
        else
        {
            $current_version = "0.0.0";
            $db->Execute("INSERT INTO " . TABLE_CONFIGURATION_GROUP . " (configuration_group_title, configuration_group_description, sort_order, visible) VALUES ('" . $this->plugin_name . "', 'Set " . $this->plugin_name . " Options', '1', '1');");
            $configuration_group_id = $db->Insert_ID();
            $db->Execute("UPDATE " . TABLE_CONFIGURATION_GROUP . " SET sort_order = " . $configuration_group_id . " WHERE configuration_group_id = " . $configuration_group_id . ";");
            $db->Execute("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Version', '" . $this->version_key . "', '0.0.0', 'Version installed:', " . $configuration_group_id . ", 0, NOW(), NOW(), NULL, NULL);");
        }
        if ($configuration_group_id == '')
        {
            $config                 = $db->Execute("SELECT configuration_group_id FROM " . TABLE_CONFIGURATION . " WHERE configuration_key= '" . $this->version_key . "'");
            $configuration_group_id = $config->fields['configuration_group_id'];
        }
        if (version_compare($this->files_version, $current_version) > 0)
        {
            foreach ($this->installers as $installer)
            {
                $installer_version = substr($installer, 0, -4);
                if (version_compare($this->files_version, $installer_version) >= 0 && version_compare($current_version, $installer_version) < 0)
                {
                    include($this->installer_folder . '/' . $installer);
                    $current_version = str_replace("_", ".", $installer_version);
                    $db->Execute("UPDATE " . TABLE_CONFIGURATION . " SET configuration_value = '" . $current_version . "' WHERE configuration_key = '" . $this->version_key . "' LIMIT 1;");
                    $messageStack->add("Installed " . $this->plugin_name . " v" . $current_version, 'success');
                }
            }
        }
        $db->Execute("UPDATE " . TABLE_CONFIGURATION . " SET configuration_group_id='" . $configuration_group_id . "' WHERE configuration_key='" . $this->license_key . "'");
    }
    /*
     *  Create a record in the local configuration table to store the remote license and limit remote license checks.
     */
    function saveNewLicKey()
    {
        global $db;
        if ($this->new_lic_key != '')
        {
            if (!defined($this->license_key))
            {
                // Add ON DUPLICATE KEY statement for the case of new installation
                $db->Execute("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, sort_order, last_modified, date_added, use_function, set_function) VALUES
                        ('Module License Key', '" . $this->license_key . "', '" . $this->new_lic_key . "', 'License Key this will need to be renewed with your subscription', 0, NOW(), NOW(), 'zen_cfg_password_display', 'zen_cfg_password_input(')
                  ON DUPLICATE KEY UPDATE configuration_key='" . $this->license_key . "';");
            }
            elseif ($this->new_lic_key)
            {
                $db->Execute("UPDATE " . TABLE_CONFIGURATION . " SET configuration_value= '" . $this->new_lic_key . "' WHERE configuration_key='" . $this->license_key . "';");
            }
            $this->disable_plugin = false;
        }
    }
    // is the lic that is here valid?
    function checkLicValid($supress_errors = false)
    {
        // license validation check, for remote check and fresh installation
        if ($this->instant_fail == '1')
        {
            $this->pluginLicInvalid();
            return false;
        }
        //expired check
        if ($this->expires_date < time())
        {
            if (!$supress_errors)
            {
                $this->pluginExpired();
            }
            return false;
        }
        // domain incorrect check
        if ($this->server_domain != $this->loc_domain)
        {
            if (!$supress_errors)
            {
                $this->domainMismatched();
            }
            return false;
        }
        // files too new check
        /*
        if (version_compare($this->files_version, $this->loc_max_version) > 0) {
        $this->versionNotAllowed();
        return false;
        }
        */
        // ok permission to proceed
        return true;
    }
    /*
     * Core plugin logic. This function is called by the auto_loader
     */
    function nxPluginLicense($module_license)
    {
        // load plugin key
        $this->getPluginKey($module_license);
        // get all the info we need
        $this->getPluginFacts();
        if ($_SERVER['SERVER_NAME'] == 'localhost') //local use, give all permission
        {
            $this->runInstaller();
            return;
        }
        elseif (!defined($this->version_key) && $this->installers) //new install, missing params are ok
        {
        }
        elseif (!defined($this->enable)) //catch bad module settings in the init_include
        {
            if ($_SESSION['emailed_support'] == 0)
            {
                mail('kristin@numinix.com', 'License check with invalid parameters', 'A license check was triggered, but the settings in the module\'s init_includes file or on the website are incorrrect.  Hint: it is probably because the enable variable is named incorrectly in the init_include file or the module is only partially installed. Details: ' . json_encode($this));
                $_SESSION['emailed_support'] = true;
                return;
            }
        }
        elseif (constant($this->enable) == 'false') //plugin is already disabled, prevent excessive remote checks.
        {
            return;
        }
        $this->disable_plugin = false;
        //  $is_valid = false;//default
        $found_local_license  = $this->pullLocalLic();
        if ($found_local_license)
        {
            $this->disable_plugin = $this->checkLicValid(true) ? false : true; //suppress errors for now, so we can check the remote licence again before proceeding with an error.
        }
        if ($this->disable_plugin) //if there is no local license or it isn't valid, pull the remote license.
        {
            if (!isset($_SESSION['checked_remote_license'][$this->version_key]['disable_plugin']))
            {
                $this->pullRemoteLic();
                $this->disable_plugin = $this->checkLicValid(); // check a second time, if still invalid this will disable the module.
                $_SESSION['checked_remote_license'][$this->version_key]['disable_plugin'] = $this->disable_plugin;
            } else {
                $this->disable_plugin = $_SESSION['checked_remote_license'][$this->version_key]['disable_plugin'];
            }
        }
        if (!$this->disable_plugin)
        {
            $_SESSION['fails' . $this->plugin_id] = 0;
            $this->warnExpires();
            $this->runInstaller();
        }
    }
    // helpfull to narrow down the actual domain
    function clean_website_url($domain)
    {
        $domain          = strtolower($domain);
        $array_to_remove = array(
            "www.",
            "http:",
            "https:",
            "/",
            "\\"
        );
        foreach ($array_to_remove as $remove)
        {
            $domain = str_replace($remove, "", $domain);
        }
        //account for long domains, e.g. test.sub.domain.com
        /*     $domain = explode('.', $domain);
        $tld = array_pop($domain);
        $name = array_pop($domain);
        $domain = "$name.$tld";
        */
        $return = zen_db_prepare_input($domain);
        return $return;
    }
}
class NXDateTime extends DateTime
{
    public static function createFromFormat($format, $time, $timezone = null)
    {
        if (!$timezone)
            $timezone = new DateTimeZone(date_default_timezone_get());
        $version = explode('.', phpversion());
        if (((int) $version[0] >= 5 && (int) $version[1] >= 2 && (int) $version[2] > 17))
        {
            return parent::createFromFormat($format, $time, $timezone);
        }
        return new DateTime(date($format, strtotime($time)), $timezone);
    }
}