<?php

/**
 * @package     ceon_advanced_shipper
 * @author      Conor Kerr <zen-cart.advanced-shipper@dev.ceon.net>
 * @copyright   Copyright 2007-2012 Ceon
 * @copyright   Portions Copyright 2003-2006 Zen Cart Development Team
 * @copyright   Portions Copyright 2003 osCommerce
 * @link        http://dev.ceon.net/web/zen-cart/advanced-shipper
 * @version     $Id: advshipper_product_selector.js 981 2012-03-27 16:28:46Z conor $
 */

?>

function advshipperSelectOptions()
{
	// Get the current selections
	try {
		all_options = document.getElementById('select_options_all_options').checked;
		select_options = document.getElementById('select_options_select_options').checked;
	} catch (e) {
		all_options = document.select_options_form.eval('select_options_all_options').checked;
		select_options = document.select_options_form.eval('select_options_select_options').checked;
	}
	
	select_options_panel = document.getElementById('select_options_panel');
	
	if (all_options) {
		// Hide the panel for option selections
		select_options_panel.style.display = 'none';
	} else {
		select_options_panel.style.display = '';
	}
}


function advshipperProductSelected(product_id_selected)
{
	var selected_product_and_options_string = product_id_selected;
	
	// Does the product have any options?
	var all_options = document.getElementById('select_options_all_options');
	
	if (all_options != undefined) {
		try {
			all_options = document.getElementById('select_options_all_options').checked;
			select_options = document.getElementById('select_options_select_options').checked;
		} catch (e) {
			all_options = document.select_options_form.eval('select_options_all_options').checked;
			select_options = document.select_options_form.eval('select_options_select_options').checked;
		}
		
		// Have any specific options been selected for this product?
		if (!all_options) {
			// Identify the selected options
			selected_product_and_options_string += advshipperSelectedOptions();
		}
	}
	
	window.opener.advshipperAddProduct(selected_product_and_options_string);
	
	window.close();
}
