<?php

/** 
 * Ceon URI Mappings Manager Admin Import Old URIs Language Defines.
 *
 * @package     ceon_uri_mappings_manager
 * @author      Conor Kerr <zen-cart.uri-mappings-manager@ceon.net>
 * @copyright   Copyright 2011-2012 Ceon
 * @copyright   Copyright 2003-2007 Zen Cart Development Team
 * @copyright   Portions Copyright 2003 osCommerce
 * @link        http://ceon.net/software/business/zen-cart/uri-mappings-manager
 * @license     http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version     $Id: ceon_umm_import_old_uris.php 1059 2012-10-01 16:43:34Z conor $
 */

define('TEXT_INTRO_1', 'This section allows you to import URIs the site is <strong>currently</strong> using, as historical URIs.');

define('TEXT_WHAT_ARE_HISTORICAL_URIS', 'What are Historical URIs?');

define('TEXT_HISTORICAL_URIS_DESC_1', 'Ceon URI Mapping maintains a record of all the URIs individual products/pages etc. have used in the past, so if any attempt is made to access the store from them, the user (or search engine) can be directed to the correct, &ldquo;current&rdquo; URI for the product/page/whatever. These mappings are called Historical URIs.');


define('TEXT_PROCESS_OVERVIEW_TITLE', 'Batch Import Process Overview');

define('TEXT_PROCESS_OVERVIEW_DESC_1', 'When the import button is clicked, the software will scan the store and record all the URIs it is <strong>currently</strong> using for its categories and products, storing them in the Ceon URI Mapping database as historical URIs.');

define('TEXT_PROCESS_OVERVIEW_DESC_2', 'For this to work, the &ldquo;old&rdquo; SEO software must still be installed on the store, and enabled, so that the URIs the store is currently using are those generated by the SEO software.');

define('TEXT_PROCESS_OVERVIEW_ONLY_PRODUCTS_CATEGORIES_AT_THIS_TIME', 'Please note that at this time the software only has a batch import button below for category and product URIs. Manufacturer URIs, EZ-Page URIs and the &ldquo;standard&rdquo; Zen Cart page URIs do not yet have a batch import in this software. They should have by/in version 2.0.0.');

define('TEXT_PROCESS_OVERVIEW_NEW_AUTO_IDENTIFICATION_CREATION', 'However, the software <strong>is</strong> capable of importing other types of URIs from their Ultimate SEO URLs and/or Simple SEO URLs format, in a different manner...');

define('TEXT_AUTO_IDENTIFICATION_CREATION_TITLE', 'Automatic Mapping &amp; Import of Old Ultimate SEO URL and/or Simple SEO URL URIs');

define('TEXT_NEW_AUTO_IDENTIFICATION_CREATION_DESC_1', 'As of version 1.4.0, an option has been introduced which, when enabled, automatically creates historical URIs for any Ultimate SEO URLs category, product, manufacturer, EZ-Page, product review page or product review info page URIs, and/or Simple SEO URLs category, product, manufacturer or EZ-Page URIs, whenever a URI is first used and identified (by matching against its format).');

define('TEXT_NEW_AUTO_IDENTIFICATION_CREATION_DESC_2', 'This functionality is currently <strong>%s</strong>. It can be %s using the <a href="%s" target="_blank">option in <em>Configuration</em> &gt; <em>Ceon URI Mappings Manager</em></a>.');

if (!defined('TEXT_ENABLED_LC')) {
	define('TEXT_ENABLED_LC', 'enabled');
}
if (!defined('TEXT_DISABLED_LC')) {
	define('TEXT_DISABLED_LC', 'disabled');
}

define('TEXT_NEW_AUTO_IDENTIFICATION_CREATION_DESC_3', 'Whenever a user/search engine indexer visits any &ldquo;old&rdquo; URI of the page types listed above, Ceon URI Mapping:UMM Edition will create a historical URI mapping there and then and redirect the user to the current URI for the page.');


define('TEXT_ULTIMATE_SEO_URLS_PROCESS_STEPS_TITLE', 'Ultimate SEO URLs Category/Product URIs Batch Import Process Steps');

define('TEXT_STORE_APPEARS_TO_HAVE_ULTIMATE_SEO_URLS_INSTALLED_ENABLED', 'It appears that this store has the Ultimate SEO URLs module installed and enabled.');

define('TEXT_STORE_APPEARS_TO_HAVE_ULTIMATE_SEO_URLS_INSTALLED', 'It appears that this store has the Ultimate SEO URLs module installed.');
define('TEXT_ULTIMATE_SEO_URLS_SHOULD_BE_ENABLED', 'It should be enabled so that it is responsible for outputting the URIs on the site.');


define('TEXT_SSU_PROCESS_STEPS_TITLE', 'Simple SEO URLs Category/Product URIs Batch Import Process Steps');

define('TEXT_STORE_APPEARS_TO_HAVE_SSU_INSTALLED_ENABLED', 'It appears that this store has the Simple SEO URLs module installed and enabled.');
define('TEXT_STORE_APPEARS_TO_HAVE_SSU_INSTALLED', 'It appears that this store has the Simple SEO URLs module installed.');
define('TEXT_SSU_SHOULD_BE_ENABLED', 'It should be enabled so that it is responsible for outputting the URIs on the site.');


define('TEXT_MAGIC_SEO_URLS_PROCESS_STEPS_TITLE', 'Magic SEO URLs Category/Product URIs Batch Import Process Steps');

define('TEXT_STORE_APPEARS_TO_HAVE_MAGIC_SEO_URLS_INSTALLED', 'It appears that this store has the Magic SEO URLs module installed.');
define('TEXT_MAGIC_SEO_URLS_SHOULD_BE_ENABLED', 'Magic SEO URLs should be enabled so that it is responsible for outputting the URIs on the site.');

define('TEXT_PROCESS_STEPS', 'Batch Import Process Steps');

define('TEXT_COULDNT_IDENTIFY_URL_MODULE', 'Ceon URI Mappings Manager could not identify any other URI/SEO software in use for this store. At this time, only Ultimate SEO URLs, Simple SEO URLs or Magic SEO URLs can be identified.');
define('TEXT_CONTACT_ADD_SUPPORT', 'If the store is using URI/SEO software it would be appreciated if you could get in touch with information about the software, so we can add more specific instructions for importing URIs from it.');
define('TEXT_SOFTWARE_SHOULD_BE_ENABLED', 'The software should be enabled so that it is responsible for outputting the URIs on the site.');

define('TEXT_CEON_URI_MAPPING_DISABLED', 'Ceon URI Mapping is currently disabled.');
define('TEXT_CEON_URI_MAPPING_ENABLED', 'Ceon URI Mapping is currently enabled.');

define('TEXT_CEON_URI_MAPPING_ENABLED_DESC_1', 'The batch import functionality is designed only to import old static URIs generated by SEO software.');
define('TEXT_CEON_URI_MAPPING_ENABLED_DESC_2', 'Ceon URI Mapping must be disabled so that its URIs aren\'t being used on the store at the time of import.');
define('TEXT_HOW_TO_DISABLE_CEON_URI_MAPPING', 'Go to &ldquo;Configuration&rdquo; &gt; &ldquo;Ceon URI Mapping (SEO)&rdquo;, click on &ldquo;Edit&rdquo; beside &ldquo;Enable/Disable URI Mapping&rdquo;, click the radio button beside 0 and click &ldquo;Update&rdquo;.');

define('TEXT_HOW_TO_ENABLE_ULTIMATE_SEO_URLS', 'Go to &ldquo;Configuration&rdquo; &gt; &ldquo;SEO URLs&rdquo;, click on &ldquo;Edit&rdquo; beside &ldquo;Enable SEO URLs?&rdquo;, click the radio button beside &ldquo;true&rdquo; and click &ldquo;Update&rdquo;.');

define('TEXT_HOW_TO_ENABLE_SSU', 'Go to &ldquo;Configuration&rdquo; &gt; &ldquo;Simple SEO URL&rdquo;, click on &ldquo;Edit&rdquo; beside &ldquo;Set SSU Status&rdquo;, click the radio button beside &ldquo;true&rdquo; and click &ldquo;Update&rdquo;.');

define('TEXT_ULTIMATE_SEO_URLS_HTML_OUTPUT_MODS_MISSING', 'As well as Ultimate SEO URLs being enabled, the core file modifications to html_output.php, required for Ultimate SEO URLs to have Zen Cart generate its format for URIs, must also be present, but this software could not find them!');
define('TEXT_APPLY_ULTIMATE_SEO_URLS_HTML_OUTPUT_MODS', 'You must make sure that the file <code>%s</code> has the modifications to it which are required for Ultimate SEO URLs to work.');
define('TEXT_HOW_TO_APPLY_ULTIMATE_SEO_URLS_HTML_OUTPUT_MODS', 'The Ultimate SEO URLs modifications for html_output.php should be &ldquo;merged&rdquo; into the file.. this will then result in a file that has a <code>zen_href_link</code> function <strong>and</strong> an <code>original_zen_href_link</code> function.');
define('TEXT_ULTIMATE_SEO_URLS_HTML_OUTPUT_MODS_PRESENT_FOR_BOTH_INFO', 'The Ceon URI Mapping modifications to this file should then be part of the <code>original_zen_href_link</code> function. At this stage of the process, it is fine - recommended in fact - to have the modifications for both pieces of software present in html_output.php at the same time.');

define('TEXT_ULTIMATE_SEO_URLS_HTML_OUTPUT_MODS_IN_PLACE', 'The core file modifications to html_output.php, required for Ultimate SEO URLs to have Zen Cart generate its format for URIs, appear to be present.');
define('TEXT_HOW_TO_CHECK_ULTIMATE_SEO_URLS_MODS', 'Sometimes they are commented out though, to disable them, so it might be worthwhile just taking a quick look at the file <code>%s</code>, to verify that the <code>original_zen_href_link</code> function is not commented out.');

define('TEXT_SSU_HTML_OUTPUT_MODS_MISSING', 'As well as Simple SEO URLs being enabled, the core file modifications to html_output.php, required for Simple SEO URLs to have Zen Cart generate its format for URIs, must also be present, but this software could not find them!');
define('TEXT_APPLY_SSU_HTML_OUTPUT_MODS', 'You must make sure that the file <code>%s</code> has the modifications to it which are required for Simple SEO URLs to work.');
define('TEXT_HOW_TO_APPLY_SSU_HTML_OUTPUT_MODS', 'The Simple SEO URLs modifications for html_output.php should be &ldquo;merged&rdquo; into the file.. this will then result in a file that has a slightly modified <code>zen_href_link</code> function with a block added to it that begins with <code>//bof simple seo url</code>.');
define('TEXT_SSU_HTML_OUTPUT_MODS_PRESENT_FOR_BOTH_INFO', 'The Ceon URI Mapping modifications to this file should be part of the <code>zen_href_link</code> function. At this stage of the process, it is fine - recommended in fact - to have the modifications for both pieces of software present in html_output.php at the same time.');

define('TEXT_SSU_HTML_OUTPUT_MODS_IN_PLACE', 'The core file modifications to html_output.php, required for Simple SEO URLs to have Zen Cart generate its format for URIs, appear to be present.');
define('TEXT_HOW_TO_CHECK_SSU_MODS', 'Sometimes they are commented out though, to disable them, so it might be worthwhile just taking a quick look at the file <code>%s</code>, to verify that, within the <code>zen_href_link</code> function the block for Simple SEO URLs, which begins with <code>//bof simple seo url</code> is not commented out.');

define('TEXT_ONCE_CEON_URI_MAPPING_DISABLED_BUTTON_BECOMES_AVAILABLE', 'Once Ceon URI Mapping is disabled, the button to generate category and product URIs will be available below.');
define('TEXT_ONCE_ULTIMATE_SEO_URLS_ENABLED_BUTTON_BECOMES_AVAILABLE', 'Once Ultimate SEO URLs is enabled, the button to import category and product URIs will be available below.');
define('TEXT_ONCE_SSU_ENABLED_BUTTON_BECOMES_AVAILABLE', 'Once Simple SEO URLs is enabled, the button to import category and product URIs will be available below.');
define('TEXT_ONCE_MODULE_ENABLED_BUTTON_BECOMES_AVAILABLE', 'Once it is enabled, the button to import category and product URIs will be available below.');
define('TEXT_ONCE_ULTIMATE_SEO_URLS_CORE_FILE_MODS_MADE_CEON_URI_MAPPING_DISABLED_BUTTON_BECOMES_AVAILABLE', 'Once Ultimate SEO URLs\'s core file modifications have been verified, and Ceon URI Mapping is disabled, the button to import category and product URIs will be available below.');
define('TEXT_ONCE_ULTIMATE_SEO_URLS_ENABLED_AND_CEON_URI_MAPPING_DISABLED_BUTTON_BECOMES_AVAILABLE', 'Once Ultimate SEO URLs is enabled, its core file modifications have been verified, and Ceon URI Mapping is disabled, the button to import category and product URIs will be available below.');
define('TEXT_ONCE_ULTIMATE_SEO_URLS_CORE_FILE_MODS_MADE_BUTTON_BECOMES_AVAILABLE', 'Once the core file modifications for Ultimate SEO URLs have been verified, the button to import category and product URIs will be available below.');
define('TEXT_ONCE_SSU_CORE_FILE_MODS_MADE_CEON_URI_MAPPING_DISABLED_BUTTON_BECOMES_AVAILABLE', 'Once Simple SEO URLs\'s core file modifications have been verified, and Ceon URI Mapping is disabled, the button to import category and product URIs will be available below.');
define('TEXT_ONCE_SSU_ENABLED_AND_CEON_URI_MAPPING_DISABLED_BUTTON_BECOMES_AVAILABLE', 'Once Simple SEO URLs is enabled, and Ceon URI Mapping is disabled, the button to import category and product URIs will be available below.');
define('TEXT_ONCE_SSU_CORE_FILE_MODS_MADE_BUTTON_BECOMES_AVAILABLE', 'Once the core file modifications for Simple SEO URLs have been verified, the button to import category and product URIs will be available below.');
define('TEXT_ONCE_MAGIC_SEO_URLS_ENABLED_AND_CEON_URI_MAPPING_DISABLED_BUTTON_BECOMES_AVAILABLE', 'Once Magic SEO URLs is enabled, and Ceon URI Mapping is disabled, the button to import category and product URIs will be available below.');
define('TEXT_BUTTON_SHOULD_BE_USED', 'The button to import category and product URIs can then be used.');
define('TEXT_ONCE_CEON_URI_MAPPING_DISABLED_BUTTON_BECOMES_AVAILABLE', 'When Ceon URI Mapping is disabled, the button to import category and product URIs will be available below.');

define('TEXT_BUTTON_IS_AVAILABLE', 'The button to import the category/product URIs can now be used.');

define('TEXT_ULTIMATE_SEO_URLS_AFTER_IMPORT', 'After the button is used, and the import process has completed, Ultimate SEO URLs should be disabled.');
define('TEXT_SSU_AFTER_IMPORT', 'After the button is used, and the import process has completed, Simple SEO URLs should be disabled.');
define('TEXT_MAGIC_SEO_URLS_AFTER_IMPORT', 'After the batch import button below is used, and the import process has completed, Magic SEO URLs should be disabled.');
define('TEXT_UNKNOWN_AFTER_IMPORT', 'After the button is used, and the import process has completed, the URI/SEO software should be disabled.');

define('TEXT_HOW_TO_DISABLE_ULTIMATE_SEO_URLS', 'Go to &ldquo;Configuration&rdquo; &gt; &ldquo;SEO URLs&rdquo;, click on &ldquo;Edit&rdquo; beside &ldquo;Enable SEO URLs?&rdquo;, click the radio button beside &ldquo;false&rdquo; and click &ldquo;Update&rdquo;.');

define('TEXT_HOW_TO_DISABLE_SSU', 'Go to &ldquo;Configuration&rdquo; &gt; &ldquo;Simple SEO URL&rdquo;, click on &ldquo;Edit&rdquo; beside &ldquo;Set SSU Status&rdquo;, click the radio button beside &ldquo;false&rdquo; and click &ldquo;Update&rdquo;.');

define('TEXT_ULTIMATE_SEO_URLS_DISABLE_OLD_REWRITE_RULE', 'The rewrite rule for Ultimate SEO URLs must then also be disabled, otherwise Ceon URI Mapping cannot actually handle the old URIs!');
define('TEXT_ULTIMATE_SEO_URLS_HOW_TO_DISABLE_REWRITE_RULE', '<p>The old Ultimate SEO URLs rewrite rule directives can either be removed or commented out.</p>
<p>You can remove/comment out can be all the rewrite directives originally added for Ultimate SEO URLs, but <strong>at the very least</strong>, the following directives must be disabled.. they are shown here commented out, by placing a hash (#) at the start of each line:</p>
<p><code>#RewriteCond %{REQUEST_FILENAME} !-f [NC] 
<br />#RewriteCond %{REQUEST_FILENAME} !-d
<br />#RewriteRule ^(.*).html$ index\.php?main_page=$1&%{QUERY_STRING} [L]</code></p>');

define('TEXT_SSU_DISABLE_OLD_REWRITE_RULE', 'The rewrite rule for Simple SEO URLs must then also be disabled, otherwise Ceon URI Mapping cannot actually handle the old URIs!');
define('TEXT_SSU_HOW_TO_DISABLE_REWRITE_RULE', '<p>The old Simple SEO URLs rewrite rule directives can either be removed or commented out.</p>
<p>You can remove/comment out can be all the rewrite directives originally added for Simple SEO URLs, but <strong>at the very least</strong>, the following directives must be disabled.. they are shown here commented out, by placing a hash (#) at the start of each line:</p>
<p><code>#RewriteCond %{REQUEST_FILENAME} !-f [NC] 
<br />#RewriteCond %{REQUEST_FILENAME} !-d
<br />#RewriteRule ^(.*) index.php?/$1 [E=VAR1:$1,QSA,L]</code></p>');

define('TEXT_ULTIMATE_SEO_URLS_CHECK_REWRITE_RULE', 'To have Ceon URI Mapping handle the old Ultimate SEO URLs URIs you must make sure that the Ceon URI Mapping rewrite rule for the store allows the use of the .html extension - <strong>the standard example rewrite rule does not!</strong>');
define('TEXT_ULTIMATE_SEO_URLS_WHAT_TO_SET_REWRITE_RULE_TO', '<p>To allow the mapping of URIs ending in &ldquo;.html&rdquo;, the following <code>RewriteCond</code> from the example rule should be changed from:</p>
<p><code>RewriteCond %{REQUEST_URI} !\.[a-zA-Z]{2,5}$</code></p>
<p>to:</p>
<p class="NoMarginBottom"><code>RewriteCond %{REQUEST_URI} !\.[a-zA-Z]{2,5}$ [OR]</code>
<br /><code>RewriteCond %{REQUEST_URI} \.(html)$ [NC]</code></p>');

define('TEXT_CEON_URI_MAPPING_CAN_BE_ENABLED', 'Ceon URI Mapping can then be enabled, so the store can use Ceon URI Mapping URIs!');

define('TEXT_CREATE_MANAGE_URIS', 'The Create/Manage URIs tab above can be used to auto-generate URIs for all of the store\'s categories/products/manufacturers/EZ-Pages and other standard Zen Cart pages.');


define('TEXT_IMPORT_TITLE', 'Import');
define('TEXT_IMPORT_CATEGORIES_PRODUCTS_URIS_INTRO', 'Click the following button to import the URIs for all the store\'s Categories and Products');

define('TEXT_IMPORT_CATEGORIES_PRODUCTS_URIS_LINK', 'Import URIs for all the store\'s Categories and Products');
