<?php

require 'includes/application_top.php';

if (isset($_POST['ajaxOption']))
{
    function getCoordinatesForPercent($percent) {
        $x = cos(2 * pi() * $percent);
        $y = sin(2 * pi() * $percent);
      
        return array(
            'x' => $x,
            'y' => $y
        );
    }

    $ajaxOptionResult = array(
        'code' => 0,
        'message' => "Couldn't complete AJAX request."
    );

    $result_set = array(
        'RSsortBy' => 'GROSS',
        'RSmaxSlices' => 15,
        'RSmonths' => 12,
        'RSsortOrder' => SORT_DESC,
        //secondary graph result set variables
        'RSssortBy' => 'GROSS',
        'RSsmaxSlices' => 15,
        'RSssortOrder' => SORT_DESC
    );

    if (isset($_POST['modify_result_set']))
    {
        foreach ($_POST['modify_result_set'] as $mrsK => $mrsV)
        {
            $result_set[$mrsK] = $mrsV;
        }
    }

    $selected = $_POST['selectedManufacturer'] ?? -1;

    switch ($_POST['ajaxOption'])
    {
        default:

            foreach ($result_set as $rsK => $rsV)
            {
                $$rsK = $rsV;
            }

            if ($RSsortOrder == 'SORT_DESC') $RSsortOrder = SORT_DESC;
            if ($RSsortOrder == 'SORT_ASC') $RSsortOrder = SORT_ASC;

            if ($RSssortOrder == 'SORT_DESC') $RSssortOrder = SORT_DESC;
            if ($RSssortOrder == 'SORT_ASC') $RSssortOrder = SORT_ASC;

            $orders_query = "
            SELECT
                zop.products_id,
                SUM(zop.products_price * zop.products_quantity) AS total_gross_sold,
                SUM(zop.products_quantity) AS total_sold,
                zp.products_model,
                zp.manufacturers_id,
                zm.manufacturers_name
            FROM
                zen_orders zo
            INNER JOIN
                zen_orders_products zop ON zo.orders_id = zop.orders_id
            INNER JOIN
                zen_products zp ON zop.products_id = zp.products_id
            INNER JOIN
                zen_manufacturers zm ON zp.manufacturers_id = zm.manufacturers_id
            WHERE
                zo.date_purchased >= DATE_SUB(now(), INTERVAL $RSmonths MONTH)
            GROUP BY
                zop.products_id";

            $orders_query_result = $db->Execute($orders_query);

            $orders_query_manufacturer_array = array('totals' => array('GROSS' => 0, 'VOLUME' => 0), 'manfs' => array());

            foreach ($orders_query_result as $order_query_resultset)
            {
                $total_gross_sold = (float)$order_query_resultset['total_gross_sold'];
                $total_sold = (float)$order_query_resultset['total_sold'];
                
                //do this after splicing the array for accurate results!
                // $orders_query_manufacturer_array['totals']['GROSS'] += $total_gross_sold;
                // $orders_query_manufacturer_array['totals']['VOLUME'] += $total_sold;

                $orders_query_manufacturer_array['manfs'][$order_query_resultset['manufacturers_id']] ??= array('name' => $order_query_resultset['manufacturers_name'], 'GROSS' => 0, 'VOLUME' => 0, 'products' => array());

                if ($order_query_resultset['manufacturers_name'] !== strip_tags($order_query_resultset['manufacturers_name']))
                {
                    $orders_query_manufacturer_array['manfs'][$order_query_resultset['manufacturers_id']]['name'] = (strip_tags($order_query_resultset['manufacturers_name']) . ' (STOCK)');
                }

                $orders_query_manufacturer_array['manfs'][$order_query_resultset['manufacturers_id']]['GROSS'] += $total_gross_sold;
                $orders_query_manufacturer_array['manfs'][$order_query_resultset['manufacturers_id']]['VOLUME'] += $total_sold;

                $orders_query_manufacturer_array['manfs'][$order_query_resultset['manufacturers_id']]['products'][$order_query_resultset['products_id']] = array(
                    'model' => $order_query_resultset['products_model'],
                    'GROSS' => $total_gross_sold,
                    'VOLUME' => $total_sold
                );
            }

            function customSort($a, $b) {
                global $RSsortBy;
                global $RSsortOrder;

                if ($RSsortOrder == SORT_ASC)
                {
                    return $a[$RSsortBy] - $b[$RSsortBy];
                }
                if ($RSsortOrder == SORT_DESC)
                {
                    return $b[$RSsortBy] - $a[$RSsortBy];
                }
            }

            uasort($orders_query_manufacturer_array['manfs'], 'customSort');

            $orders_query_manufacturer_array['manfs'] = array_slice($orders_query_manufacturer_array['manfs'], 0, $RSmaxSlices, true);

            foreach ($orders_query_manufacturer_array['manfs'] as $manfID => $manfDetails)
            {
                $orders_query_manufacturer_array['totals']['GROSS'] += $manfDetails['GROSS'];
                $orders_query_manufacturer_array['totals']['VOLUME'] += $manfDetails['VOLUME'];
            }

            $display = "";
            $displaySecondary = "";
            $pieDisplaySecondary = "";
            $secondaryPieKey = "";
            
            $RSother = ($RSsortBy == 'GROSS')? 'VOLUME' : 'GROSS';

            $pieDisplayNumber = ($RSsortBy == 'GROSS')? number_format($orders_query_manufacturer_array['totals'][$RSsortBy], 2) : $orders_query_manufacturer_array['totals'][$RSsortBy];
            $pieDisplayOther = ($RSsortBy == 'GROSS')? $orders_query_manufacturer_array['totals'][$RSother] : number_format($orders_query_manufacturer_array['totals'][$RSother], 2);

            $pieDisplay = "<svg width='500' height='500' viewBox='-1.5 -1.5 3 3' style='height: 500px; transform: rotate(-90deg);'>";
            $pieDisplay .= "<text x='-1.5' y='-1.2' style='font: bold 0.25px sans-serif; transform: rotate(90deg);'>$pieDisplayNumber ($pieDisplayOther)</text>";

            $pieKey = '<div class="graph_key">';
            $columnCount = ceil($RSmaxSlices/12);
            $pieKey .= '<ul class="list-group" style="column-count: ' . $columnCount . '; column-fill: auto; column-gap: 0px; max-height: 500px; overflow: auto;">';

            $currentAngle = 0;
            $secondaryAngle = 0;

            foreach ($orders_query_manufacturer_array['manfs'] as $manfID => $manfDetails)
            {
                $percent = $manfDetails[$RSsortBy] / $orders_query_manufacturer_array['totals'][$RSsortBy];

                $start = getCoordinatesForPercent($currentAngle);

                $currentAngle += $percent;

                $stop = getCoordinatesForPercent($currentAngle);

                $d = 'M ' . $start['x'] . ' ' . $start['y'] . ' A 1 1 0 ' . ($percent > 0.50 ? '1' : '0') . ' 1 ' . $stop['x'] . ' ' . $stop['y'] . ' L 0 0';

                $color = '#' . substr(hash('sha256', $manfDetails['name']), 0, 6);

                $pieDisplay .= '<path d="' . $d . '" fill="' . $color . '" data-manf="' . $manfID . '" data-sortby-current="' . $manfDetails[$RSsortBy] . '" data-per="' . $percent . '">';
                $pieDisplay .= '</path>';

                $pieNumber = ($RSsortBy == 'GROSS') ? number_format($manfDetails[$RSsortBy], 2) : $manfDetails[$RSsortBy];
                $pieOther = ($RSsortBy = 'GROSS')? $manfDetails[$RSother] : number_format($manfDetails[$RSother], 2);

                $pieKey .= "<li class='list-group-item' data-manf='" . $manfID . "'><div style='display: inline-block; width: 15px; height: 15px; border: 1px solid #ddd; background-color: " . $color . ";'></div> " . $manfDetails['name'] . " - $pieNumber ($pieOther)</li>";

                if ($manfID == $selected)
                {
                    $manfProducts = $manfDetails['products'];

                    function customSortS($a, $b) {
                        global $RSssortBy;
                        global $RSssortOrder;
        
                        if ($RSssortOrder == SORT_ASC)
                        {
                            return $a[$RSssortBy] - $b[$RSssortBy];
                        }
                        if ($RSssortOrder == SORT_DESC)
                        {
                            return $b[$RSssortBy] - $a[$RSssortBy];
                        }
                    }

                    uasort($manfProducts, 'customSortS');

                    $manfProducts = array_slice($manfProducts, 0, $RSsmaxSlices, true);

                    $productTotals = array(
                        'GROSS' => 0,
                        'VOLUME' => 0
                    );

                    foreach ($manfProducts as $productID => $productDetails)
                    {
                        $productTotals['GROSS'] += $productDetails['GROSS'];
                        $productTotals['VOLUME'] += $productDetails['VOLUME'];
                    }

                    $RSsother = ($RSssortBy == 'GROSS')? 'VOLUME' : 'GROSS';

                    $pieDisplaySecondaryNumber = ($RSssortBy == 'GROSS')? number_format($productTotals[$RSssortBy], 2) : $productTotals[$RSssortBy];
                    $pieDisplaySecondaryOther = ($RSssortBy == 'GROSS')? $productTotals[$RSsother] : number_format($productTotals[$RSsother], 2);

                    $pieDisplaySecondary .= "<svg width='500' height='500' viewBox='-1.5 -1.5 3 3' style='height: 500px; transform: rotate(-90deg);'>";
                    $pieDisplaySecondary .= "<text x='-1.5' y='-1.2' style='font: bold 0.25px sans-serif; transform: rotate(90deg);'>$pieDisplaySecondaryNumber ($pieDisplaySecondaryOther)</text>";
                    $pieKeySecondary = '<div class="graph_key">';
                    $pieKeySecondary .= '<ul class="list-group" style="column-count: ' . $columnCount . '; column-fill: auto; column-gap: 0px; max-height: 500px; overflow: auto;">'; 

                    foreach ($manfProducts as $productID => $productDetails)
                    {
                        $percentSecondary = $productDetails[$RSssortBy] / $productTotals[$RSssortBy];

                        $startSecondary = getCoordinatesForPercent($secondaryAngle);

                        $secondaryAngle += $percentSecondary;

                        $stopSecondary = getCoordinatesForPercent($secondaryAngle);

                        $dSecondary = 'M ' . $startSecondary['x'] . ' ' . $startSecondary['y'] . ' A 1 1 0 ' . ($percentSecondary > 0.50 ? '1' : '0') . ' 1 ' . $stopSecondary['x'] . ' ' . $stopSecondary['y'] . ' L 0 0';

                        $colorSecondary = '#' . substr(hash('sha256', $productDetails['model']), 0, 6);

                        $pieDisplaySecondary .= '<path d="' . $dSecondary . '" fill="' . $colorSecondary . '" data-prod="' . $productID . '" data-sortby-current="' . $productDetails[$RSssortBy] . '" data-per="' . $percentSecondary . '">';
                        $pieDisplaySecondary .= '</path>';

                        $pieSecondaryNumber = ($RSssortBy == 'GROSS')? number_format($productDetails[$RSssortBy], 2) : $productDetails[$RSssortBy];
                        $pieSecondaryOther = ($RSssortBy == 'GROSS')? $productDetails[$RSsother] : number_format($productDetails[$RSsother], 2);

                        $pieKeySecondary .= "<li class='list-group-item' data-prod='" . $productID . "'><div style='display: inline-block; width: 15px; height: 15px; border: 1px solid #ddd; background-color: " . $colorSecondary . ";'></div> " . $productDetails['model'] . " - $pieSecondaryNumber ($pieSecondaryOther)</li>";
                    }

                    $displaySecondary = "
                        <div style='display: flex;'>$pieDisplaySecondary</div>
                        <div style='display: flex; flex-grow: 1;'>$pieKeySecondary</div>
                    ";
                }
            }

            $pieKey .= "</ul>";
            $pieKey .= "</div>";
            $pieKeySecondary .= "</ul>";
            $pieKeySecondary .= "</div>";

            $pieDisplay .= "</svg>";

            $display = "
                <div style='display: flex;'>$pieDisplay</div>
                <div style='display: flex; flex-grow: 1;'>$pieKey</div>
            ";

            $ajaxOptionResult = array(
                'code' => 1,
                'result' => $orders_query_manufacturer_array,
                'display' => $display,
                'displaySecondary' => $displaySecondary
            );

            break;
    }

    echo json_encode($ajaxOptionResult);
}
else
{
?>

<!doctype html>
<html <?php echo HTML_PARAMS; ?>>
    <head>
    <?php require DIR_WS_INCLUDES . 'admin_html_head.php'; ?>
    </head>
    <body>
        <?php require(DIR_WS_INCLUDES . 'header.php'); ?>

        <div class="container-fluid">
            <h1>Custom Sales Report</h1>

            <div class="container-graphs">
                <div style='display: flex; flex-direction: column;'>
                    <div id='primary-graph-controls' style='display: flex; flex-direction: row;'>
                        <div class='display: flex;'>
                            <button class='RSfilter-button' data-var='RSsortBy' data-alt='VOLUME'>GROSS</button>
                        </div>
                        <div class='display: flex;'>
                            <input type='number' class='RSfilter-input' data-var='RSmaxSlices' value='15' min='1'>
                        </div>
                        <div class='display: flex;'>
                            <input type='number' class='RSfilter-input' data-var='RSmonths' value='12' min='1'>
                        </div>
                        <div class='display: flex;'>
                            <button class='RSfilter-button' data-var='RSsortOrder' data-alt='SORT_ASC'>SORT_DESC</button>
                        </div>
                    </div>
                    <div class="container-graph-primary-target" style='display: flex; flex-direction: row;'></div>
                    <div id='secondary-graph-controls' style='display: flex; flex-direction: row;'>
                        <div class='display: flex;'>
                            <button class='RSsfilter-button' data-var='RSssortBy' data-alt='VOLUME' disabled>GROSS</button>
                        </div>
                        <div class='display: flex;'>
                            <input type='number' class='RSsfilter-input' data-var='RSsmaxSlices' value='15' min='1' disabled>
                        </div>
                        <div class='display: flex;'>
                            <button class='RSsfilter-button' data-var='RSssortOrder' data-alt='SORT_ASC' disabled>SORT_DESC</button>
                        </div>
                    </div>
                    <div class="container-graph-secondary-target" style='display: flex; flex-direction: row;'></div>
                </div>
            </div>

            <script>
                let modify_result_set_data_manf = {};
                let data = {
                    ajaxOption: ''
                };

                async function callAjax_manfGraph() {
                    data.modify_result_set = modify_result_set_data_manf;

                    let ajaxResult = await $.ajax(
                        {
                            type: 'POST',
                            data: data
                        }
                    );

                    ajaxResultJ = JSON.parse(ajaxResult);

                    if (ajaxResultJ.displaySecondary != '') {
                        $('.RSsfilter-input, .RSsfilter-button').prop('disabled', false);
                    }

                    $('.container-graph-primary-target').html(ajaxResultJ.display);
                    $('.container-graph-secondary-target').html(ajaxResultJ.displaySecondary);
                }

                callAjax_manfGraph();

                $('#primary-graph-controls').on('click', '.RSfilter-button', function() {
                    let v = $(this).data('var');
                    let alt = $(this).data('alt');
                    let current = $(this).html();
                    $(this).html(alt);
                    $(this).data('alt', current);

                    modify_result_set_data_manf[v] = alt;

                    callAjax_manfGraph();
                });

                $('#primary-graph-controls').on('change', '.RSfilter-input', function() {
                    let v = $(this).data('var');
                    let current = $(this).val();

                    modify_result_set_data_manf[v] = current;

                    callAjax_manfGraph();
                });

                $('.container-graph-primary-target').on('click', 'li, path', function() {
                    data.selectedManufacturer = $(this).data('manf');

                    callAjax_manfGraph();
                });

                $('#secondary-graph-controls').on('click', '.RSsfilter-button', function() {
                    let v = $(this).data('var');
                    let alt = $(this).data('alt');
                    let current = $(this).html();
                    $(this).html(alt);
                    $(this).data('alt', current);

                    modify_result_set_data_manf[v] = alt;

                    callAjax_manfGraph();
                });

                $('#secondary-graph-controls').on('change', '.RSsfilter-input', function() {
                    let v = $(this).data('var');
                    let current = $(this).val();

                    modify_result_set_data_manf[v] = current;

                    callAjax_manfGraph();
                });
            </script>
        </div>

        <?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
    </body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>

<?php

}

?>
