# Contribution Guidelines

## Ways To Contribute

There are numerous ways to contribute to [Zen Cart&reg;](https://www.zen-cart.com/):

1. Enter duplicatable bug reports as Issues on github.
2. Submit PRs containing bug fixes or new features on github
3. Build plugins as 3rd party contributions which shopowners can install to their own site
4. Post snippets of bugfixes or minor tweaks to assist with solving specific questions posted on our support forum at [https://www.zen-cart.com/forum.php](https://www.zen-cart.com/forum.php)

Seasoned open source contributor? Review the guidelines below, fork the repo and start contributing PRs! 

First timer?  Take a look at our [getting started](https://docs.zen-cart.com/dev/contributing/introduction/) document.

## Guidelines
When submitting bug reports, issues, plugins, or code as pull requests, please adhere to the following guidelines:

* Please search previous suggestions before making a new one, as yours may be a duplicate.
* Each suggestion/report/pull-request should be separate. Don't mix multiple issues into one. See our [git workflow](https://docs.zen-cart.com/dev/contributing/github_workflow/) for details.
* Code submissions should comply with the [Coding Standards](https://docs.zen-cart.com/dev/contributing/coding_standards/).
* If reporting a bug/issue, please provide exact steps which one can take to recreate the bug, starting from a brand new fresh install. See [Guidelines for Reporting Bugs](https://docs.zen-cart.com/dev/contributing/issues/).
* If providing a suggestion, please also **explain the business problem the suggestion will solve**.
* If publishing a plugin, be sure it complies with the [Plugin Contribution Guidelines](https://docs.zen-cart.com/dev/plugins/rules/)
* Check your spelling and grammar.

Thank you for your contributions!


&nbsp;  
  
*&copy;Copyright 2003-2020, Zen Cart&reg;. All rights reserved.*

