<?php

// unset($_SESSION['listing_filter']);

include 'includes/application_top.php';

$ccID = $_POST['ccID'];
$page = $_POST['page'] ?? ($_SESSION['listing_filter'][$ccID]['page'] ?? 1);
$postCPath = $_POST['cPath'];
$excludeClause = '';
$products = '';
$filters = '';

$status = array(
    'result' => 0,
    'message' => "Couldn't adjust product listing with selected filters"
);

if (isset($_POST['filterOption'], $_POST['filterValue'], $_POST['filterToggle'])) {

    $filterOption = $_POST['filterOption'];
    $filterValue = $_POST['filterValue'];
    $filterToggle = $_POST['filterToggle'] == 'true';

    if ($filterToggle) {
        $_SESSION['listing_filter'] = $_SESSION['listing_filter'] ?? array();
        $_SESSION['listing_filter'][$ccID] = $_SESSION['listing_filter'][$ccID] ?? array();
        $_SESSION['listing_filter'][$ccID][$filterOption] = $_SESSION['listing_filter'][$ccID][$filterOption] ?? array();
        $_SESSION['listing_filter'][$ccID]['page'] = $page;

        if (!in_array($filterValue, $_SESSION['listing_filter'][$ccID][$filterOption])) $_SESSION['listing_filter'][$ccID][$filterOption][] = $filterValue;
    } else {
        if (in_array($filterValue, $_SESSION['listing_filter'][$ccID][$filterOption])) unset($_SESSION['listing_filter'][$ccID][$filterOption][array_search($filterValue, $_SESSION['listing_filter'][$ccID][$filterOption])]);

        if (empty($_SESSION['listing_filter'][$ccID][$filterOption])) unset($_SESSION['listing_filter'][$ccID][$filterOption]);
    }
} elseif (isset($_POST['page'])) {
    $_SESSION['listing_filter'][$ccID]['page'] = $_POST['page'];
}

if (isset($_SESSION['listing_filter'][$ccID]) && !empty($_SESSION['listing_filter'][$ccID])) {

    $excludeSubqueries = array();
    $excludeSubquery = '';

    foreach ($_SESSION['listing_filter'][$ccID] as $filterOptionId => $filterOptionValues) {
        if ($filterOptionId == 'page') continue;

        $foi = $filterOptionId;
        $fovs = $filterOptionValues;
        $fovsAsString = implode(', ', $fovs);

        if ($foi == '000') {
            $excludeClause .= " AND m.manufacturers_id IN ($fovsAsString)";
        }
        else {
            $excludeSubqueries[] = "
            (
                SELECT 1
                FROM zen_products_attributes pa
                WHERE pa.options_id = $foi
                AND pa.options_values_id IN ($fovsAsString)
                AND pa.products_id = p.products_id
            )";
        }
    }

    if (!empty($excludeSubqueries)) {
        $excludeSubquery = implode("
        AND EXISTS", $excludeSubqueries);

        $excludeClause .= "
        AND (EXISTS $excludeSubquery)";
    }
}

//get products in category
$filtered_listing_query = "SELECT p.products_id, p.products_model, p.products_image, p.products_price,
        p.product_is_call, p.product_is_always_free_shipping, p.is_base_product, p.is_exchange,
        p.is_core,
    pd.products_name, pd.products_alt_name,
    m.manufacturers_id, m.manufacturers_name
FROM zen_products p
JOIN zen_products_description pd ON pd.products_id = p.products_id
JOIN zen_manufacturers m ON m.manufacturers_id = p.manufacturers_id
JOIN zen_products_to_categories p2c ON p2c.products_id = p.products_id
WHERE p.products_status = 1 AND p2c.categories_id = $ccID $excludeClause
GROUP BY p.products_id
ORDER BY p.products_sort_order, pd.products_name, p.products_id DESC";

$count_key = 'p.products_id';
$splitResult = new splitPageResults($filtered_listing_query, 25, $count_key);
$filtered_listing_query_split = $splitResult->sql_query;

$productList = $db->Execute($filtered_listing_query_split);
$options = array();
foreach ($productList as $product) {
    $productId = $product['products_id'];
    $productName = $product['products_name'];
    $productAltName = $product['products_alt_name'];
    $isBaseProduct = $product['is_base_product'] == 1;
    $isExchange = $product['is_exchange'] == '1';
    $isCall = $product['product_is_call'] == '1';
    $manufacturerId = $product['manufacturers_id'];
    $manufacturerName =  $product['manufacturers_name'];
    $productBoldText = "Model # " . $product['products_model']. " (" . $manufacturerName . ")";
    $brands_to_rebuilt = array(
        "PMP NEW", "ESCO SERVICES", "DAVIS AIRTECH","FREEDOM ELECTRONICS", "RDM", "FREEDOM / RDM OUTRIGHT", "GLOBAL LIGHT", "PMP", 
    );
    if (in_array(strtoupper($manufacturerName), $brands_to_rebuilt)) {
        $manufacturerName = '<em>(REBUILT PART)</em>';
    }
    $imagePath = "/images/" . $product['products_image'];
    $productName = $product['products_name'];
    $price = "";
    
    $urlLink = isset($postCPath ) && !empty($postCPath ) ? "?main_page=product_info&cPath=$postCPath&products_id=$productId" : "?main_page=product_info&products_id=$productId";
    
    if ($isBaseProduct && $isCall != 1) {
        $subProductListQuery = "SELECT MIN(p.products_price) as min_price
        FROM zen_products_xsell px
        INNER JOIN zen_products p on px.xsell_id = p.products_id
        WHERE px.products_id = $productId
            AND px.xsell_placement = 'options'
            AND p.product_is_call <> 1
            AND p.is_core <> 1";

        $subProductListResult = $db->Execute($subProductListQuery);
        $lowestPrice = $subProductListResult->fields['min_price'];
        $formattedPrice = number_format($lowestPrice, 2);
        $price = "Starting at $$formattedPrice ";
    } else if ($isCall) {
        $price = "Call For Price";
    } else {
        $price = "Only $" . number_format($product['products_price'], 2);
    }
    $freeShippingElement = $product['product_is_always_free_shipping'] ? "<p class='product-item-free-shipping'>Free Shipping</p>" : "";

    $products .= "
        <a class='products-grid-item' href='$urlLink' title='$productName link'>
            $freeShippingElement
            <div class='products-grid-item-product'>
                <img class='img-fluid' src='$imagePath' alt='$productName Image'/>
                <div class='fs-6 fw-bold product-item-additional-info'>$productBoldText</div>
                <p class='product-item-name'>$productName</p>
                <p class='product-item-alt-name'>$productAltName</p>
                <p class='product-item-price fw-bold text-danger'>$price</p>
            </div>
        </a>
    ".PHP_EOL;

    if (!isset($options['000']['options']['indexed'])) {
        $options['000']['filterName'] = "Manufacturer";
        $options['000']['options']['indexed'][] = $manufacturerId;
        $options['000']['options']['filter'][] = array(
            'id' => $manufacturerId,
            'text' => $manufacturerName
        );
    }
}

$productIds = array();

$all_products_query = $db->Execute($filtered_listing_query);

foreach ($all_products_query as $product) {
    $productIds[] = $product['products_id'];
}

if (empty($productIds)) {
    $status = array(
        'result' => 1,
        'filter' => array(
            'session' => $_SESSION['listing_filter'][$ccID],
            'query' => array(
                'listing' => $filtered_listing_query
            )
        ),
        'contents' => array(
            'filter' => $filters,
            'listing' => array(
                'products' => '',
                'forward' => "<div class='alert alert-light' role='alert'>No products were returned using the selected criteria.",
                'back' => ''
            )
        )
    );
} else {
    $list_of_product_ids_string = implode(', ', $productIds);

    $read_only_attributes_ordered_query =
    "SELECT pa.options_id, pa.options_values_id,
        po.products_options_name, po.products_options_sort_order,
        pov.products_options_values_name, pov.products_options_values_sort_order
    FROM zen_products_attributes pa
    INNER JOIN zen_products_options po ON pa.options_id = po.products_options_id
    INNER JOIN zen_products_options_values pov ON pa.options_values_id = pov.products_options_values_id
    WHERE pa.products_id IN ($list_of_product_ids_string) AND po.products_options_type = 5
    ORDER BY po.products_options_sort_order ASC, pov.products_options_values_sort_order ASC, po.products_options_name ASC, pov.products_options_values_name ASC
    ";

    $read_only_attributes_ordered_result = $db->Execute($read_only_attributes_ordered_query);
    foreach ($read_only_attributes_ordered_result as $read_only_attribute) {
        $attribute = $read_only_attribute;

        $optionId = $attribute['options_id'];
        $optionValueId = $attribute['options_values_id'];
        $optionName = $attribute['products_options_name'];
        $optionValueName = $attribute['products_options_values_name'];
        
        if (!isset($options[$optionId])) {
            $options[$optionId] = array('filterName' => $optionName);
        }
        if (!isset($options[$optionId]['options'])) {
            $options[$optionId]['options']['indexed'] = array();
            $options[$optionId]['options']['filter'] = array();
        }
        if (!in_array($optionValueId, $options[$optionId]['options']['indexed'])) {
            $options[$optionId]['options']['indexed'][] = $optionValueId;

            $options[$optionId]['options']['filter'][] = array(
                'id' => $optionValueId,
                'text' => $optionValueName
            );
        }
    }

    foreach($options as $key => $filter) {
        $filterName = $filter['filterName'];
        $filterOptions = "";
        $numberOfOptions = count($filter['options']);
        if($numberOfOptions > 0) {
            foreach($filter['options']['filter'] as $option) {
                $opID = $option['id'];
                $opText = $option['text'];

                $checked = "";
            
                if (isset($_SESSION['listing_filter'][$ccID]["$key"]) && ($_SESSION['listing_filter'][$ccID]["$key"] == "$opID")) $checked = 'checked=\'checked\'';

                $filterOptions .= "
                <div class='form-check'>
                    <input class='form-check-input filter-checkbox' type='checkbox' $checked id='$key-$opID-radio-button' data-filter-option-id='$key' data-filter-option-value-id='$opID'/>
                    <label class='form-check-label' for='$key-$opID-radio-button'>
                        $opText
                    </label>
                </div>
                ";
            }

            $filters .= "<li class='product-attribute'>
                <p class='products-page-attribute-title'>$filterName</p>
                <form>
                    $filterOptions
                </form>
            </li>";
        }
    }

    $max_display_page_links = 5;
    $paginateAsUL = $paginateAsUL ?? false;

    $status = array(
        'result' => 1,
        'filter' => array(
            'session' => $_SESSION['listing_filter'][$ccID] ?? null,
            'query' => array(
                'filters' => $read_only_attributes_ordered_query,
                'listing' => $filtered_listing_query
            )
        ),
        'contents' => array(
            'filter' => $filters,
            'listing' => array(
                'products' => $products,
                'forward' => $splitResult->display_links($max_display_page_links, '', $paginateAsUL, '', false),
                'back' => $splitResult->display_count(TEXT_DISPLAY_NUMBER_OF_PRODUCTS)
            )
        )
    );
}

echo json_encode($status);