<?php

include 'includes/application_top.php';
require(DIR_WS_MODULES . zen_get_module_directory('require_languages.php'));
include(DIR_WS_MODULES . zen_get_module_directory(FILENAME_CREATE_ACCOUNT));

$safePost['mode'] = htmlspecialchars($_POST['mode']);
$safePost['firstName'] = htmlspecialchars($_POST['first'] ?? '');
$safePost['lastName'] = htmlspecialchars($_POST['last'] ?? '');
$safePost['email'] = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
$safePost['password'] = htmlspecialchars($_POST['password'] ?? '');

$status = array(
    "code" => 0,
    "message" => "No implementation for " . $safePost['mode']
);

$email = $safePost['email'];

if (filter_var($email, FILTER_VALIDATE_EMAIL))
{
    $email_check = "SELECT customers_id, customers_password, customers_default_address_id, customers_secret FROM zen_customers WHERE customers_email_address = :email: ORDER BY customers_id DESC LIMIT 1";

    $email_check = $db->bindVars($email_check, ":email:", $safePost['email'], 'string');

    $email_check_result = $db->Execute($email_check);

    switch ($safePost['mode'])
    {
        case 'login':

            $password = $safePost['password'];

            if ($email_check_result->RecordCount() !== 1 || !password_verify($password, $email_check_result->fields['customers_password']))
            {
                $status = array(
                    "code" => 0,
                    "message" => "The username or password was incorrect. Please try again."
                );
                break;
            }

            $_SESSION['customer_id'] = $email_check_result->fields['customers_id'];
            $_SESSION['$customers_email_address'] = $safePost['email'];
            $_SESSION['customer_default_address_id'] = $email_check_result->fields['customers_default_address_id'];

            $customer = new Customer;
            $customer->login($email_check_result->fields['customers_id']);

            if (SESSION_RECREATE == 'True') {
                zen_session_recreate();
            }

            $zc_check_basket_before = 0;
            // save current cart contents count if required
            if (SHOW_SHOPPING_CART_COMBINED > 0) {
                $zc_check_basket_before = $_SESSION['cart']->count_contents();
            }

            // check current cart contents count if required
            $zc_check_basket_after = $_SESSION['cart']->count_contents();
            if (SHOW_SHOPPING_CART_COMBINED > 0 && $zc_check_basket_after > 0 && $zc_check_basket_before != $zc_check_basket_after) {
                if (SHOW_SHOPPING_CART_COMBINED == 2) {
                    // warning only do not send to cart
                    $messageStack->add_session('header', WARNING_SHOPPING_CART_COMBINED, 'caution');
                }
                if (SHOW_SHOPPING_CART_COMBINED == 1) {
                    // show warning and send to shopping cart for review
                    if (!(isset($_GET['gv_no']))) {
                        $messageStack->add_session('shopping_cart', WARNING_SHOPPING_CART_COMBINED, 'caution');
                        zen_redirect(zen_href_link(FILENAME_SHOPPING_CART, '', 'NONSSL'));
                    } else {
                        $messageStack->add_session('header', WARNING_SHOPPING_CART_COMBINED, 'caution');
                    }
                }
            }
            // end contents merge notice

            $status = array(
                "code" => 1,
                "message" => "Login successful, please wait..."
            );

            break;
        case 'guest':

            //guest has already tried to check out
            if (isset($_SESSION['temp_customer_id']))
            {
                $status = array(
                    "code" => 1,
                    "message" => "User may proceed to checkout as a guest."
                );

                break;
            }

            $temp_cID = 0;

            if ($email_check_result->RecordCount() == 1)
            {
                if (empty($email_check_result->fields['customers_secret']))
                {
                    $status = array(
                        "code" => 0,
                        "message" => "It appears that email belongs to a full customer account. Please log in above to continue or <a href='?main_page=forgot_password'>reset your password</a>."
                    );

                    break;
                }

                $account_orders_check = $db->Execute("SELECT payment_method FROM zen_orders WHERE customers_id = {$email_check_result->fields['customers_id']} AND payment_method <> 'guest'");

                if ($account_orders_check->RecordCount() >= 1)
                {
                    $status = array(
                        "code" => 0,
                        "message" => "The email you provided has logged in before. Please log in above to continue or <a href='?main_page=forgot_password'>reset your password</a>."
                    );

                    break;
                }

                $temp_cID = $email_check_result->fields['customers_id'];
            }
            else
            {
                $hashpass = password_hash(date("Ymdhis"), PASSWORD_DEFAULT);
                $secret = md5($safePost['email'] . date("Ymdhis"));

                $insertGuest = $db->Execute("INSERT INTO `zen_customers` (customers_firstname, customers_lastname, customers_email_address, customers_password, customers_secret) VALUES ('{$safePost['firstName']}', '{$safePost['lastName']}', '{$safePost['email']}', '{$hashpass}', '{$secret}')");

                $insertGuestIdQuery = $db->Execute("SELECT customers_id FROM zen_customers WHERE customers_email_address = '{$safePost['email']}' ORDER BY customers_id DESC LIMIT 1");
                $temp_cID = $insertGuestIdQuery->fields['customers_id'];

                $currentDatetime = time();
                $insertGuestInfo = $db->Execute("INSERT INTO zen_customers_info (customers_info_id, customers_info_date_account_created) VALUES ({$temp_cID}, FROM_UNIXTIME(\"{$currentDatetime}\"))");
            }

            $_SESSION['customers_email_address'] = $safePost['email'];
            $_SESSION['temp_customer_id'] = $temp_cID;

            $status = array(
                "code" => 1,
                "message" => "User may proceed to checkout as a guest."
            );

            break;
        default:
            break;
    }
}
else
{
    $status = array(
        "code" => 0,
        "message" => "The email you provided appears to be invalid. If you believe this to be an error, please contact us or try again."
    );
}

echo json_encode($status);