<?php

include 'includes/application_top.php';

$postAction = "";
if (isset($_POST['post-action']))
{
    $postAction = $_POST['post-action'];
}
$postData = "";
if (isset($_POST['post-data']))
{
    $postData = $_POST['post-data'];
}

$status = array(
    "code" => 0,
    "message" => "No post action implemented for " . $postAction,
);

$useLive = true;

switch ($postAction)
{

    case 'get-payments':

        $profile = adn_get_profile($_SESSION['id']);

        if ($profile['messages']['message'][0]['code'] !== "E00040")
        {
            $status = array(
                adn_get_payment_profiles($profile['profile']['customerProfileId'])
            );
        }

        break;
    case 'add-payment':

        $profile = adn_get_profile($_SESSION['customer_id'], $useLive);
        $adn_create_profile = false;

        if ($profile['messages']['message'][0]['code'] == "E00040")
        {
            $adn_profileDetails = array(
                "merchantCustomerId" => $_SESSION['customer_id'],
                "email" => $_SESSION['customers_email_address']
            );

            $adn_create_profile = adn_create_profile($adn_profileDetails, $useLive);
            $profile = adn_get_profile($_SESSION['customer_id'], $useLive);
        }

        $bill_details = array(
            "firstName" => $postData['paymentNameOnCardFirst'],
            "lastName" => $postData['paymentNameOnCardLast'],
            "address" => $postData['paymentAddressStreet'],
            "city" => $postData['paymentAddressCity'],
            "state" => $postData['paymentAddressState'],
            "zip" => $postData['paymentAddressZip']
        );

        $card_details = array(
            "cardNumber" => $postData['paymentCardNumber'],
            "expirationDate" => $postData['paymentCardExpirationYear'] . '-' . $postData['paymentCardExpirationMonth'],
            "cardCode" => $postData['paymentCardCvv']
        );

        $adn_add_payment = adn_create_payment_profile($profile['profile']['customerProfileId'], $bill_details, $card_details, $postData['paymentDefault'], 'liveMode', $useLive);

        $message = "";
        switch ($adn_add_payment['messages']['message'][0]['code'])
        {
            case 'E00039':
                $message = "A duplicate record of this payment method already exists";
                break;
            // case '':
            //     break;
            default:
                $message = $adn_add_payment['messages']['message'][0]['code'];
                break;
        }

        if ($adn_add_payment['messages']['resultCode'] == "Error")
        {
            $status = array(
                "code" => 0,
                "message" => "There was an error adding your payment method (" . $message .  "). Please try again or contact us for assistance.",
                "full-response" => $adn_add_payment
            );
            break;
        }

        $status = array(
            "code" => 1,
            "message" => "Your payment method was added."
        );

        break;
    case 'delete-payment':

        $profile = adn_get_profile($_SESSION['customer_id'], $useLive);

        $profile_id = $profile['profile']['customerProfileId'];

        $delete = adn_delete_payment_profile($profile_id, $postData['paymentProfileId'], $useLive);

        if ($delete['messages']['resultCode'] == "Ok") {
            $status = array(
                "code" => 1,
                "message" => "Payment method saved successfully."
            );
            break;
        }

        $status = array(
            "code" => 0,
            "message" => "An error occurred. Please try again or contact us for assistance."
        );
        break;

}

echo json_encode($status);