<?php

include 'includes/application_top.php';

$safePost = filter_input_array(INPUT_POST, [
    'email' => FILTER_VALIDATE_EMAIL,
]);

$safePost['fname'] = htmlspecialchars($_POST['fname']);
$safePost['lname'] = htmlspecialchars($_POST['lname']);
$safePost['password'] = htmlspecialchars($_POST['password']);
$safePost['confirm_password'] = htmlspecialchars($_POST['confirm_password']);

$status = array(
    "result_code" => 0,
    "message" => "The registration process was interrupted. Please try again. If your error isn't resolved, please contact us."
);

try {

    $password_regex = "/(?=(.*[0-9])+)(?=(.*[a-z])+)(?=(.*[A-Z])+)(?=(.*[!@#$%&])+).{10,}/";

    if ((empty($safePost['fname'])) || (empty($safePost['fname'])))
    {
        throw new Exception("First and last name fields are required.");
    }

    if ((!filter_var($safePost['email'], FILTER_VALIDATE_EMAIL)) || (empty($safePost['email'])))
    {
        throw new Exception("The email you provided was invalid. If you believe this to be an error, please contact us.");
    }

    if ((!preg_match($password_regex, $safePost['password'])) || (empty($safePost['password'])))
    {
        throw new Exception("The password you provided was invalid. Passwords require 10 characters, at least 1 upper-case letter, 1 lower-case, 1 digit, and a special character of !, @, #, $, %, or &. If you believe this to be an error, please contact us.");
    }

    if (($safePost['password'] !== $safePost['confirm_password']) || (empty($safePost['confirm_password'])))
    {
        throw new Exception("The passwords you provided did not match. If you believe this to be an error, please contact us.");
    }

    $currentDatetime = time();
    $hashpass = password_hash($safePost['password'], PASSWORD_DEFAULT);
    $email_md5 = md5($safePost['email']);

    $get_existing = $db->Execute("SELECT * FROM zen_customers WHERE customers_email_address = '{$safePost['email']}'");

    if ($get_existing->RecordCount() > 0)
    {
        $status = array(
            "result_code" => 0,
            "message" => "Email may already be associated with an account. If you believe this to be an error, please contact us. Otherwise, <a href=" . zen_href_link("login", '', 'SSL') . ">login</a>."
        );
    }
    else
    {
        $insert_customer = $db->Execute("INSERT INTO `zen_customers` (customers_firstname, customers_lastname, customers_email_address, customers_password, customers_secret) VALUES ('{$safePost['fname']}', '{$safePost['lname']}', '{$safePost['email']}', '{$hashpass}', '{$email_md5}')");

        $customer_id_query = $db->Execute("SELECT customers_id FROM zen_customers WHERE customers_email_address = '{$safePost['email']}'");
        $customer_id_result = $customer_id_query->fields['customers_id'];

        $insert_customer_info = $db->Execute("INSERT INTO `zen_customers_info` (customers_info_id, customers_info_date_account_created) VALUES ({$customer_id_result}, FROM_UNIXTIME(\"{$currentDatetime}\"))");

        $email_html = array(
            "EMAIL_GREETING" => "Hello, {$safePost['fname']}!",
            "EMAIL_WELCOME" => "<p>Welcome to Westech.</p>",
            "EMAIL_MESSAGE_HTML" => "<p>Your email was used to create an account at <a href='https://westechequipment.com'>westechequipment.com</a>. If this wasn't you, you can ignore this email, or <a href='https://westechequipment.com?main_page=contact_us'>contact us</a> for manual removal.</p>",
            "EMAIL_CONTACT_OWNER" => "",
            "EMAIL_CLOSURE" => "<p>Sincerely,</p><p>The Westech Team</p><p>The Pump and Tank Equipment Store</p><p>Quality Since 1971</p>",
            "EMAIL_FOOTER_COPYRIGHT" => "&#169; " . date("Y") . " Westech Equipment",
            "EMAIL_DISCLAIMER" => "By creating an account you agree to our <a href='https://westechequipment.com/?main_page=terms_and_conditions'>terms and conditions</a>.",
            "EMAIL_SPAM_DISCLAIMER" => "<p>We comply with the CAN-SPAM Act. You can unsubscribe from future emails <a href='https://new.westechequipment.com?main_page=unsubscribe&token={$safePost['email']}'>here.</a></p>",
            "EXTRA_INFO" => "",
        );

        zen_mail(($safePost['fname'] . " " . $safePost['lname']), $safePost['email'], "Welcome to Westech!", "Your account was created successfully.", "Westech Equipment", "contact@westechequipment.com", $email_html, "welcome");
        
        $status = array(
            "result_code" => 1,
            "message" => "Your account has been created. <a href='?main_page=login'>Click here to login</a>."
        );
    }
}
catch (Exception $e)
{
    $status = array(
        "result_code" => 0,
        "message" => $e->getMessage()
    );
}

echo json_encode($status);