<?php

include 'includes/application_top.php';

$postAction = "";
if (isset($_POST['post-action']))
{
    $postAction = $_POST['post-action'];
}
else
{
    $status = array(
        'code' => 0,
        'message' => "Incorrect POST body. Please try again. (0x0)"
    );
}
$postData = "";
if (isset($_POST['post-data']))
{
    $postData = $_POST['post-data'];
}
else
{
    $status = array(
        'code' => 0,
        'message' => "Incorrect POST body. Please try again. (0x1)"
    );
}

$status = array(
    'code' => 0,
    'message' => "Incorrect POST body. Please try again. (0x2:" . $postAction . ')',
);

function parseSurchargeTags($surcharge, &$result = array()) {
    $pattern = '/<(.*?)>(.*?)<\/\1>/';

    if (preg_match_all($pattern, $surcharge, $matches, PREG_SET_ORDER)) {
        foreach ($matches as $match) {
            $tagName = $match[1];
            $tagContent = $match[2];
            $result[$tagName] = array();

            if (preg_match($pattern, $tagContent, $innerMatches)) {
                parseSurchargeTags($tagContent, $result[$tagName]);
            } else {
                $result[$tagName] = $tagContent;
            }
        }
    }
}

function calculateSurcharge($surcharge) {
    if (is_numeric($surcharge))
    {
        return array(
            'surcharge' => $surcharge,
            'method' => "flatrate",
            'value' => $surcharge
        );
    }

    $surchargesParsed = array();
    if ($surcharge !== strip_tags($surcharge)) parseSurchargeTags($surcharge, $surchargesParsed);

    return $surchargesParsed;
}

function advShipperZipMatchesRegion($address, $target) {

    $ranges = explode(',', trim($target));

    foreach ($ranges as $range)
    {
        $range = trim($range);

        if (strpos($range, $address['country']) !== FALSE)
        {
            if (strpos($range, ":") === FALSE) return ($address['country'] == $range);
            
            $zip = $address['zip'];
            $minmax = explode('-', substr($range, (strpos($range, ":") + 1)));

            if (sizeof($minmax) == 1)
            {
                if ($zip == $minmax[0]) return true;
            }

            $min = $minmax[0];
            $max = $minmax[1];


            if (($min <= $zip) && ($zip <= $max)) return true;
        }
    }

    return false;
}

function getAdvShipperDetails($method, $shipTo) {
    global $db;

    $advShipperMethodQuery = "SELECT
    rc.region, rc.countries_postcodes, rc.max_weight_per_package, rc.surcharge,
    ruc.shipping_service_2da, ruc.shipping_service_gnd
    FROM zen_advshipper_region_configs rc
    LEFT JOIN zen_advshipper_region_ups_configs ruc ON rc.method = ruc.method AND rc.region = ruc.region
    WHERE rc.method = '$method'
    ORDER BY rc.region ASC";

    $advShipperMethodResult = $db->Execute($advShipperMethodQuery);

    $maxPackageWeight = 150;
    $surcharge = array();
    $service = 0;

    //loop through all matching regions. it's assumed that the first matching region is the region to use for calculation, as they should be in a "fall-through" order
    while (!$advShipperMethodResult->EOF)
    {
        $methodZips = $advShipperMethodResult->fields['countries_postcodes'];
        //check if this method applies to customer's zip code
        $shipToZipAndCountry = array(
            'zip' => $shipTo['zip'],
            'country' => $shipTo['country']
        );
        if (advShipperZipMatchesRegion($shipToZipAndCountry, $methodZips))
        {
            $maxPackageWeight = $advShipperMethodResult->fields['max_weight_per_package'];
    
            //can be either a flat rate or a a formatted rate (20 OR <format>20</format>)
            $surcharge = calculateSurcharge($advShipperMethodResult->fields['surcharge']);
    
            //if 2da is true, make service code = 2, which is 2nd day air, or 3, which is UPS ground, or error ($service == 0 || ($service !== 2 || 3))
            if ($advShipperMethodResult->fields['shipping_service_2da'] == 1) $service = 2;
            if ($advShipperMethodResult->fields['shipping_service_gnd'] == 1) $service = 3;
            //should realistically never throw, as all products should be 2da or ground
            if (!in_array($service, array(2, 3))) throw new Exception('(m' . $method . ') Invalid service type. (' . $service . ') (' . $advShipperMethodResult->fields['shipping_service_gnd'] . ')');
            
            return array(
                'targetZone' => $advShipperMethodResult->fields['countries_postcodes'],
                'region' => $advShipperMethodResult->fields['region'],
                'maxPackageWeight' => $maxPackageWeight,
                'surcharge' => $surcharge,
                'service' => $service,
                'method' => $method
            );
        }

        $advShipperMethodResult->MoveNext();
    }

    return false;
}

function checkAdvShipperMethods($manfID, $prid, $shipTo) {
    global $db;

    $advShipperProductQuery = "SELECT
    zamp.method
    FROM zen_advshipper_method_products zamp
    LEFT JOIN zen_advshipper_method_configs zamc on zamp.method = zamc.method
    WHERE zamp.product_id = '$prid'
    ORDER BY zamc.sort_order ASC LIMIT 1";

    $advShipperProductResult = $db->Execute($advShipperProductQuery);

    if ($advShipperProductResult->RecordCount() == 1) return getAdvShipperDetails($advShipperProductResult->fields['method'], $shipTo);

    $advShipperManfQuery = "SELECT
    zamm.method
    FROM zen_advshipper_method_manufacturers zamm
    LEFT JOIN zen_advshipper_method_configs zamc on zamm.method = zamc.method
    WHERE zamm.manufacturer_id = '$manfID'
    ORDER BY zamc.sort_order ASC LIMIT 1";

    $advShipperManfResult = $db->Execute($advShipperManfQuery);

    if ($advShipperManfResult->RecordCount() == 1) return getAdvShipperDetails($advShipperManfResult->fields['method'], $shipTo);

    return false;
}

function callAPIs($cartShipInfo, $shipTo) {
    $apiDetails = array(
        'products' => array(
            'freight' => array(),
            'package' => array()
        ),
        'advShipper' => array(),
        'sent' => array(
            'freight' => array(),
            'package' => array()
        ),
        'received' => array(
            'freight' => array(),
            'package' => array()
        ),
        'totals' => array(
                'freight' => 0.00,
                'package' => 0.00
            )
    );

    foreach ($cartShipInfo as $cartShipInfoXManfId => $cartShipInfoXManf)
    {
        if (!empty($cartShipInfoXManf['freight']))
        {
            foreach ($cartShipInfoXManf['freight'] as $freightItemID => $freightItemInfo)
            {
                if (!$freightItemInfo['is_core'])
                {
                    $apiDetails['products']['freight'][] = array(
                        'id' => $freightItemID,
                        'price' => $freightItemID['freight'],
                        'weight' => $freightItemInfo['weight'] + 40, //+40lbs for pallet weight
                        'length' => $freightItemInfo['length'],
                        'width' => $freightItemInfo['width'],
                        'height' => $freightItemInfo['height'],
                        'freight_class' => $freightItemInfo['freight_class'],
                        'packing_type' => $freightItemInfo['packing_type'],
                        'quantity' => $freightItemInfo['quantity']
                    );
                }
            }

            
            $apiFreightCall = ups_rate_freight($shipTo, $cartShipInfoXManf['address'], $apiDetails['products']['freight'], true);
            if (isset($apiFreightCall['received']['response']['errors'])) throw new Exception("An error occurred while calculating freight. Please refresh the page and try again. If this issue persists, please contact us for assistance. ({$apiFreightCall['received']['response']['errors'][0]['code']}) (" . print_r($apiFreightCall['received'], true) . ")");
            if (isset($apiFreightCall['received']['Fault'])) throw new Exception("An error occurred while calculating freight. Please refresh the page and try again. If this issue persists, please contact us for assistance. ({$apiFreightCall['received']['Fault']['faultstring']}) (" . print_r($apiFreightCall['received'], true) . ")");
            $apiDetails['sent']['freight'][] = $apiFreightCall['sent'];
            $apiDetails['received']['freight'][] = $apiFreightCall['received'];
            $apiDetails['totals']['freight'] += $apiFreightCall['received']['FreightRateResponse']['TotalShipmentCharge']['MonetaryValue'];
        }

        if (!empty($cartShipInfoXManf['package']))
        {
            $advShipperDetail = array();
            $advShipperSurchargeTotals = 0.00;

            foreach ($cartShipInfoXManf['package'] as $packageItemID => $packageItemInfo)
            {
                if (!$packageItemInfo['is_core'])
                {
                    $advShipperDetail = checkAdvShipperMethods($cartShipInfoXManfId, $packageItemID, $shipTo);
                    if ($advShipperDetail !== FALSE)
                    {
                        $apiDetails['advShipper'][] = $advShipperDetail;
                    }
    
                    $minimumPackageWeight = 7;
                    $packageItemInfo['weight'] = max($packageItemInfo['weight'], $minimumPackageWeight);

                    $maxWeightPerPackage = $advShipperDetail['maxPackageWeight'] ?? 150;
                    $maxNumberOfItemsToPack = floor($maxWeightPerPackage/$packageItemInfo['weight']);

                    $steps = array();

                    while ($packageItemInfo['quantity'] > 0)
                    {
                        $numberOfItemsToPack = min($packageItemInfo['quantity'], $maxNumberOfItemsToPack);

                        $packageItemInfo['quantity'] -= $numberOfItemsToPack;

                        $apiDetails['products']['package'][] = array(
                            'id' => $packageItemID,
                            'weight' => $packageItemInfo['weight'],
                            'quantity' => $numberOfItemsToPack,
                            'price' => $numberOfItemsToPack * $packageItemInfo['price']
                        );
                        
                        //apply surcharges per package
                        if ($advShipperDetail !== FALSE)
                        {
                            $advShipperSurchargeTotals += $advShipperDetail['surcharge']['value'];
                        }
                    }
                }
            }

            $service = $advShipperDetail['service'] ?? '03';
            $apiPackageCall = ups_rate_package($shipTo, $cartShipInfoXManf['address'], $apiDetails['products']['package'], $service);
            if (isset($apiPackageCall['received']['response']['errors'])) throw new Exception("An error occurred while calculating shipping. Please refresh the page and try again. If this issue persists, please contact us for assistance. ({$apiPackageCall['received']['response']['errors'][0]['code']}) (" . print_r($apiPackageCall['received'], true) . ")");
            if (isset($apiPackageCall['received']['Fault'])) throw new Exception("An error occurred while calculating shipping. Please refresh the page and try again. If this issue persists, please contact us for assistance. ({$apiPackageCall['received']['Fault']['faultstring']}) (" . print_r($apiPackageCall['received'], true) . ")");
            $apiDetails['sent']['package'][] = $apiPackageCall['sent'];
            $apiDetails['received']['package'][] = $apiPackageCall['received'];
            if (isset($apiPackageCall['received']['RateResponse']['RatedShipment']['NegotiatedRateCharges']['TotalCharge']['MonetaryValue']))
            {
                $apiDetails['totals']['package'] += $apiPackageCall['received']['RateResponse']['RatedShipment']['NegotiatedRateCharges']['TotalCharge']['MonetaryValue'] * 1.10;
            }
            else
            {
                $apiDetails['totals']['package'] += $apiPackageCall['received']['RateResponse']['RatedShipment']['TotalCharges']['MonetaryValue'];
            }
            $apiDetails['totals']['package'] += $advShipperSurchargeTotals;
        }
    }

    return $apiDetails;
}

function stripAttributesDataFromPrid($prid) {
    if (strpos($prid, ':') !== FALSE)
    {
        return substr($prid, 0, strpos($prid, ':'));
    }

    return $prid;
}

function sortCartByManfs() {
    global $db;

    $cartContents = $_SESSION['cart']->contents;

    $pridsStrippedWithInfo = array();

    foreach ($cartContents as $productID => $productInfo)
    {
        $pridStripped = stripAttributesDataFromPrid($productID);

        $pridsStrippedWithInfo[$pridStripped] = $productInfo;
    }

    $pridsStrippedAndImploded = implode('\', \'', array_keys($pridsStrippedWithInfo));

    $prodManfZoneQuery = 
        "SELECT
        p.products_id, p.products_price_w, p.products_weight, p.manufacturers_id, p.product_is_always_free_shipping,
        p.is_core, p.products_freightquote_enable, p.products_freightquote_class, p.products_freightquote_length,
        p.products_freightquote_width, p.products_freightquote_height, p.products_freightquote_package_type,
        m.manufacturers_id, m.manufacturers_name, m.manufacturers_address_1, m.manufacturers_city, m.manufacturers_zip,
        z.zone_code, z.zone_name
        FROM zen_products AS p
        LEFT JOIN zen_manufacturers AS m ON p.manufacturers_id = m.manufacturers_id
        LEFT JOIN zen_zones AS z ON m.manufacturers_state = z.zone_id
        WHERE p.products_id IN ('$pridsStrippedAndImploded')
        ";
    
    $prodManfZoneResults = $db->Execute($prodManfZoneQuery);

    $cartByManfs = array();

    while (!$prodManfZoneResults->EOF)
    {
        if ($prodManfZoneResults->fields['products_weight'] == 0)
        {
            //can't ship products that weigh 0
            return "0W";
        }

        $manfID = $prodManfZoneResults->fields['manufacturers_id'];
        $manfName = $prodManfZoneResults->fields['manufacturers_name'];
        $manfStreet = $prodManfZoneResults->fields['manufacturers_address_1'];
        $manfCity = $prodManfZoneResults->fields['manufacturers_city'];
        $manfZip = $prodManfZoneResults->fields['manufacturers_zip'];
        $manfZC = $prodManfZoneResults->fields['zone_code'];
        $manfZN = $prodManfZoneResults->fields['zone_name'];
        $prid = $prodManfZoneResults->fields['products_id'];
        $price = $prodManfZoneResults->fields['products_price_w'];
        $weight = $prodManfZoneResults->fields['products_weight'];
        $freeShipping = $prodManfZoneResults->fields['product_is_always_free_shipping'];
        $core = $prodManfZoneResults->fields['is_core'];
        $fqE = $prodManfZoneResults->fields['products_freightquote_enable'];
        $fqC = $prodManfZoneResults->fields['products_freightquote_class'];
        $fqL = $prodManfZoneResults->fields['products_freightquote_length'];
        $fqW = $prodManfZoneResults->fields['products_freightquote_width'];
        $fqH = $prodManfZoneResults->fields['products_freightquote_height'];
        $fqP = $prodManfZoneResults->fields['products_freightquote_package_type'];
        $packageTypesToCodes = array(
            'Bag' => '07',
            'Bale' => '31',
            'Barrel' => '08',
            'Basket' => '32',
            'Bin' => '33',
            'Box' => '34',
            'Bunch' => '35',
            'Bundle' => '10',
            'Cabinet' => '36',
            'Can' => '11',
            'Carboy' => '37',
            'Carrier' => '38',
            'Carton' => '39',
            'Case' => '40',
            'Cask' => '54',
            'Container' => '41',
            'Crate' => '14',
            'Cylinder' => '15',
            'Drum' => '16',
            'Loose' => '42',
            'Other' => '99',
            'Package' => '43',
            'Pail' => '44',
            'Pallet' => '18',
            'Pieces' => '45',
            'Pipe Line' => '46',
            'Rack' => '53',
            'Reel' => '47',
            'Roll' => '20',
            'Skid' => '48',
            'Spool' => '19',
            'Tank' => '49',
            'Tube' => '03',
            'Unit' => '50',
            'Van Pack' => '51',
            'Wrapped' => '52'
        );
        //if code isn't found, default to pallet
        $fqP = $packageTypesToCodes[$fqP] ?? '18';

        if (!isset($cartByManfs[$manfID]))
        {
            $cartByManfs[$manfID] = array(
                'address' => array(
                    'name' => $manfName,
                    'addressLine' => $manfStreet,
                    'city' => $manfCity,
                    'state' => $manfZC,
                    'zip' => $manfZip,
                    'country' => 'US',
                    'ZC' => $manfZC,
                    'ZN' => $manfZN
                ),
                'freight' => array(),
                'package' => array(),
                'free' => array()
            );
        }

        if ($freeShipping)
        {
            $cartByManfs[$manfID]['free'][$prid] = array(
                'quantity' => $pridsStrippedWithInfo[$prid]['qty']
            );
        }
        else
        {
            if ($fqE == 1)
            {
                $cartByManfs[$manfID]['freight'][$prid] = array(
                    'price' => $price,
                    'weight' => $weight,
                    'length' => $fqL,
                    'width' => $fqW,
                    'height' => $fqH,
                    'freight_class' => $fqC,
                    'packing_type' => $fqP,
                    'quantity' => $pridsStrippedWithInfo[$prid]['qty']
                );
            }
            else
            {
                $cartByManfs[$manfID]['package'][$prid] = array(
                    'weight' => $weight,
                    'quantity' => $pridsStrippedWithInfo[$prid]['qty'],
                    'price' => $price
                );
            }
        }

        $prodManfZoneResults->MoveNext();
    }

    return $cartByManfs;
}

function generateCandidateModal($candidates) {
    $candidateModal = "";

    $candidateModal .= "<div class='modal fade' id='candidate-modal' data-bs-backdrop='static' data-bs-keyboard='false' tabindex='-1' aria-labelledby='staticBackdropLabel' role='dialog' aria-hidden='true'>";
    $candidateModal .= "<div class='modal-dialog modal-dialog-centered modal-dialog-scrollable'>";
    $candidateModal .= "<div class='modal-content'>";

    $candidateModal .= "<div class='modal-header flex-column'>";
    $candidateModal .= "<h5 class='modal-title mb-3' id='staticBackdropLabel'>Select Your Address</h5>";
    $candidateModal .= "<p>UPS couldn't validate the address you provided. Please select the closest match.</p>";
    $candidateModal .= "</div>";
    
    $candidateModal .= "<div class='modal-body'>";
    
    $candidateModal .= "<ul class='list-group'>";
    $useActive = true;
    foreach ($candidates as $candidate)
    {
        $active = ($useActive)? "class='list-group-item bg-westech-green text-white' aria-current='true'" : "class='list-group-item'";

        $dataArray = array();

        foreach ($candidate['AddressKeyFormat'] as $addressPart => $addressPartValue)
        {
            //convert PascalCase to snake-case
            $addressPart = strtolower(preg_replace('/(?<!^)[A-Z]/', '-$0', $addressPart));

            if (is_array($addressPartValue))
            {
                $addressPartValue = implode(',', $addressPartValue);

                $addressPartValue = "[$addressPartValue]";
            }

            $dataArray[] = "data-$addressPart='$addressPartValue'";
        }

        $dataArray[] = "data-code='{$candidate['AddressClassification']['Code']}'";

        $dataString = implode(' ', $dataArray);

        $candidateModal .= "<li $active $dataString>";
        $candidateModal .= "<h5>{$candidate['AddressKeyFormat']['Region']}</h5>";
        $candidateAddressLine = ((is_array($candidate['AddressKeyFormat']['AddressLine']))? implode(', ', $candidate['AddressKeyFormat']['AddressLine']) : $candidate['AddressKeyFormat']['AddressLine']) . ((isset($candidate['AddressKeyFormat']['Urbanization']))? ", {$candidate['AddressKeyFormat']['Urbanization']}" : '');
        $candidateModal .= "<p>$candidateAddressLine</p>";
        $candidateModal .= "</li>";

        $useActive = false;
    }
    $candidateModal .= "</ul>";

    $candidateModal .= "</div>";
    
    $candidateModal .= "<div class='modal-footer'>";
    $candidateModal .= "<p>Please note that if you use an address UPS cannot validate, you are responsible for additional fees that UPS assesses on your delivery.</p>";
    $candidateModal .= "<button type='button' class='btn btn-danger' id='shipping-address-modal-target-cancel' data-bs-dismiss='modal' aria-label='Close'>Use My Entered Address</button>";
    $candidateModal .= "<button type='button' class='btn bg-westech-green text-white' id='shipping-address-modal-target-select' data-bs-dismiss='modal'>Use Selected Address</button>";
    $candidateModal .= "</div>";

    $candidateModal .= "</div>";
    $candidateModal .= "</div>";
    $candidateModal .= "</div>";

    return $candidateModal;
}

switch ($postAction)
{
    case 'quotes':
        $status = array(
            'code' => 0,
            'message' => 'API request was interrupted. Please try again.'
        );

        $debug = array();

        //whether or not we use production servers when requesting quotes from UPS
        $useLive = true;

        try 
        {
            //verify input
            //keys of input that cannot be empty
            $inputNotEmptyKeys = array(
                'name',
                'addressLine1',
                'city',
                'state',
                'zip',
                'country'
            );

            foreach ($inputNotEmptyKeys as $key)
            {
                if (empty($postData[$key])) throw new Exception("Invalid POST body. Please refresh the page and try again or contact us if this problem persists.");
            }

            $cartShipInfo = sortCartByManfs();

            if ($cartShipInfo == "0W") throw new Exception("One or more products in your cart are not configured for shipping. Please contact us for assitance. (0W)");
            
            //prepare API calls
            $shipTo = array(
                'name' => $postData['name'],
                'addressLine1' => $postData['addressLine1'],
                'addressLine2' => $postData['addressLine2'],
                'addressLine3' => $postData['addressLine3'],
                'city' => $postData['city'],
                'state' => $postData['state'],
                'zip' => $postData['zip'],
                'country' => $postData['country'],
                'residentialIndicator' => $postData['residentialCharge'],
                'liftgateIndicator' => $postData['liftgateCharge'],
                'restrictedAccessIndicator' => $postData['restrictedAccessCharge']
            );

            //make API calls
            $apiCalls = callAPIs($cartShipInfo, $shipTo);
            
            $shippingTotalFreight = $apiCalls['totals']['freight'];
            $shippingTotalPackage = $apiCalls['totals']['package'];
            $shippingMethod = "";
            if ($shippingTotalPackage > 0)
            {
                // $shippingMethod = "UPS Ground";
                $shippingMethod = "Ground";
            }
            if ($shippingTotalFreight > 0)
            {
                // $shippingMethod = "TForce Freight";
                $shippingMethod = "Freight LTL";
            }
            if ($shippingTotalPackage > 0 && $shippingTotalFreight > 0)
            {
                // $shippingMethod = "UPS Ground + TForce Freight";
                $shippingMethod = "Ground + Freight LTL";
            }
            if ($shippingTotalPackage == 0 && $shippingTotalFreight == 0)
            {
                $shippingMethod = "Free Shipping";
            }
            if ($shippingTotalPackage < 0 || $shippingTotalPackage === null || $shippingTotalFreight < 0 || $shippingTotalFreight === null)
            {
                throw new Exception('UPS costs cannot be NULL or negative.');
            }

            $valuesArray = array(
                'totals' => array(
                    'freight' => $shippingTotalFreight,
                    'package' => $shippingTotalPackage,
                ),
                'total' => $shippingTotalFreight + $shippingTotalPackage,
                'method' => $shippingMethod
            );

            $status = array(
                'code' => 1,
                'api' => $apiCalls,
                'values' => $valuesArray
            );
        }
        catch (Exception $e)
        {
            $status = array(
                'code' => 0,
                'message' => $e->getMessage()
            );
        }

        $_SESSION['shipping']['status'] = $status;

        break;
    case 'addresses':

        $status = array(
            'code' => 0,
            'message' => 'Address validation was interrupted. Please try again or contact us for assistance.'
        );

        //multiple candidates can be found using 500 Main Avenue, Memphis FL 33101

        $address = array(
            'line1' => $postData['line1'],
            'line2' => $postData['line2'],
            'city' => $postData['city'],
            'state' => $postData['state'],
            'zip' => $postData['zip'],
            'country' => $postData['country']
        );

        if (isset($postData['line3'])) $address['line3'] = $postData['line3'];
        if (isset($postData['urbanization'])) $address['urbanization'] = $postData['urbanization'];

        $ups_validate_address_result = ups_validate_address($address);

        $uvar = $ups_validate_address_result['received']['XAVResponse'];

        if (isset($uvar['NoCandidatesIndicator']))
        {
            if (in_array($uvar['AddressClassification']['Code'], array(1, 2)))
            {
                $status = array(
                    'code' => 1,
                    'subcode' => 2,
                    'display' => '',
                    'req' => $ups_validate_address_result['sent'],
                    'res' => $ups_validate_address_result['received']
                );

                break;
            }

            $status = array(
                'code' => 0,
                'subcode' => 1,
                'message' => 'Could not resolve address. Please try again.',
                'req' => $ups_validate_address_result['sent'],
                'res' => $uvar
            );

            break;
        }

        if (isset($uvar['AmbiguousAddressIndicator']))
        {
            $candidateModal = generateCandidateModal($uvar['Candidate']);

            $status = array(
                'code' => 1,
                'subcode' => 0,
                'display' => $candidateModal,
                'req' => $ups_validate_address_result['sent'],
                'res' => $ups_validate_address_result['received']
            );

            break;
        }

        if (isset($uvar['ValidAddressIndicator']))
        {
            if (isset($uvar['Candidate']['AddressClassification']))
            {
                $candidateModal = generateCandidateModal(array($uvar['Candidate']));

                $status = array(
                    'code' => 1,
                    'subcode' => 1,
                    'display' => $candidateModal,
                    'req' => $ups_validate_address_result['sent'],
                    'res' => $ups_validate_address_result['received']
                );
            }

            break;
        }

        $status = array(
            'code' => 0,
            'message' => 'Address validation failed. Please try again or contact us for assistance.',
            'req' => $ups_validate_address_result['sent'],
            'res' => $ups_validate_address_result['received'],
            'url' => $ups_validate_address_result['url']
        );

        break;
}

echo json_encode($status);