<?php
/**
 * Observer for Ceon URI Mapping canonical link creation. Watches includes/init_includes/init_canonical.php
 * This observer must load before includes/init_includes/init_canonical.php is loaded (by includes/auto_loaders/config.canonical.php)
 *
 * @package     ceon_uri_mapping
 * @author      Conor Kerr <zen-cart.uri-mapping@ceon.net>
 * @author      Ceon Support
 * @copyright   Copyright 2008-2020 Ceon
 * @copyright   Copyright 2003-2007 Zen Cart Development Team
 * @copyright   Portions Copyright 2003 osCommerce
 * @license     http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version     2020 - 5.1.0
 **/

class zcObserverCeonCanonical extends base
{
	public function __construct() {
		// Notifier was added in Zen Cart 1.5.5 allowing removal of the includes/init_includes/overrides/init_canonical.php file.
		$this->attach($this, array('NOTIFY_INIT_CANONICAL_FINAL'));
	}
	
	/**
	 * Notifier information:
	 * in ZC 1.5.5 (and all sub-versions):
	 * $zco_notifier->notify ('NOTIFY_INIT_CANONICAL_FINAL', $current_page, $excludeParams, $canonicalLink);
	 * Same in ZC 1.5.6.
	 * Same in ZC 1.5.7.
	 **/
	public function notify_init_canonical_final(&$cClass, $notifier, $current_page, &$excludeParams, &$canonicalLink) {
		if (isset($GLOBALS['ceon_uri_mapping_canonical_uri'])) {
		  // Use the canonical URI generated by Ceon URI Mapping
			$canonicalLink = $GLOBALS['ceon_uri_mapping_canonical_uri'];
		}
	}
	
	/**
	 * Notifier information:
	 * in ZC 1.5.5 (and all sub-versions):
	 * $zco_notifier->notify ('NOTIFY_INIT_CANONICAL_FINAL', $current_page, $excludeParams, $canonicalLink);
	 * Same in ZC 1.5.6.
	 **/
	public function updateNotifyInitCanonicalFinal(&$cClass, $notifier, $current_page, &$excludeParams, &$canonicalLink) {
		$this->notify_init_canonical_final($cClass, $notifier, $current_page, $excludeParams, $canonicalLink);
	}
	
	/**
	 * This function is expected to load only if the camelcased notifier is not found or if installed in a version of Zen Cart that
	 *   does not support loading the camelcased update{Notifier} function, i.e. pre-Zen Cart 1.5.3.  Therefore the function is
	 *   written from the perspective of such previous version and that the camelcased function exists.
	 **/
	public function update(&$cClass, $notifier, $current_page) {
		$this->notify_init_canonical_final($cClass, $notifier, $current_page, $GLOBALS['excludeParams'], $GLOBALS['canonicalLink']);
	}
}
