<?php

/** 
 * Ceon URI Mappings Manager Admin Language Defines.
 *
 * @package     ceon_uri_mappings
 * @author      Conor Kerr <zen-cart.uri-mapping@ceon.net>
 * @copyright   Copyright 2011-2012 Ceon
 * @copyright   Copyright 2003-2007 Zen Cart Development Team
 * @copyright   Portions Copyright 2003 osCommerce
 * @link        http://ceon.net/software/business/zen-cart/uri-mapping
 * @license     http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version     $Id: ceon_uri_mapping_admin.php 1027 2012-07-17 20:31:10Z conor $
 */

define('TEXT_ERROR_NO_PLACEMENT_TAGS_FOUND_IN_TEMPLATE', 'No placement tags were found in the template!');
define('TEXT_ERROR_AN_OPENING_BRACKET_WITHOUT_CLOSING', 'An opening bracket for a placement tag has been found with no matching closing bracket.');
define('TEXT_ERROR_X_OPENING_BRACKETS_WITHOUT_CLOSING', '%s opening brackets for placement tags have been found which have no matching closing bracket.');
define('TEXT_ERROR_A_CLOSING_BRACKET_WITHOUT_OPENING', 'A closing bracket for a placement tag has been found without a matching opening bracket.');
define('TEXT_ERROR_X_CLOSING_BRACKETS_WITHOUT_OPENING', '%s closing brackets for placement tags have been found which have no matching opening bracket.');
define('TEXT_ERROR_INVALID_PLACEMENT_TAG', '&ldquo;%s&rdquo; is not a valid placement tag for this template!');
define('TEXT_ERROR_MAPPING_TEMPLATE_MUST_HAVE_PLACEMENT_TAGS', 'The template must include at least one placement tag!');
define('TEXT_ERROR_MAPPING_TEMPLATE_MUST_NOT_JUST_USE_DIR_WS_CATALOG_TAG', 'The {dir-ws-catalog} placement tag cannot be the only tag. The template must include at least one other type of placement tag!');

define('TEXT_PLACEMENT_TAG_TOOLTIP_DIR_WS_CATALOG', '<span title="The path to the store on the server" style="white-space: nowrap; cursor: help;">{dir-ws-catalog}</span>');
define('TEXT_PLACEMENT_TAG_TOOLTIP_CATEGORY_CATEGORY_PATH', '<span title="The full category path of all the parent categories for the category" style="white-space: nowrap; cursor: help;">{category-path}</span>');
define('TEXT_PLACEMENT_TAG_TOOLTIP_CATEGORY_NAME', '<span title="The name of the category" style="white-space: nowrap; cursor: help;">{category-name}</span>');
define('TEXT_PLACEMENT_TAG_TOOLTIP_CATEGORY_ID', '<span title="The category\'s ID" style="white-space: nowrap; cursor: help;">{category-id}</span>');
define('TEXT_PLACEMENT_TAG_TOOLTIP_LANGUAGE_CODE', '<span title="The language\'s code (en, de, es, etc...)" style="white-space: nowrap; cursor: help;">{language-code}</span>');
define('TEXT_PLACEMENT_TAG_TOOLTIP_LANGUAGE_NAME', '<span title="The language\'s name (English, German, Spanish, etc...)" style="white-space: nowrap; cursor: help;">{language-name}</span>');
define('TEXT_PLACEMENT_TAG_TOOLTIP_LANGUAGE_DIRECTORY', '<span title="The language\'s directory (english, german, spanish, etc...)" style="white-space: nowrap; cursor: help">{language-directory}</span>');
define('TEXT_PLACEMENT_TAG_TOOLTIP_PRODUCT_CATEGORY_PATH', '<span title="The full category path of all the parent categories for the product" style="white-space: nowrap; cursor: help;">{category-path}</span>');
define('TEXT_PLACEMENT_TAG_TOOLTIP_PRODUCT_MANUFACTURER_NAME', '<span title="The name of the manufacturer of the product" style="white-space: nowrap; cursor: help;">{manufacturer-name}</span>');
define('TEXT_PLACEMENT_TAG_TOOLTIP_PRODUCT_NAME', '<span title="The name of the product" style="white-space: nowrap; cursor: help;">{product-name}</span>');
define('TEXT_PLACEMENT_TAG_TOOLTIP_PRODUCT_MODEL', '<span title="The product\'s model code" style="white-space: nowrap; cursor: help;">{product-model}</span>');
define('TEXT_PLACEMENT_TAG_TOOLTIP_PRODUCT_ID', '<span title="The product\'s ID" style="white-space: nowrap; cursor: help;">{product-id}</span>');
define('TEXT_PLACEMENT_TAG_TOOLTIP_MANUFACTURER_NAME', '<span title="The name of the manufacturer" style="white-space: nowrap; cursor: help;">{manufacturer-name}</span>');
define('TEXT_PLACEMENT_TAG_TOOLTIP_MANUFACTURER_ID', '<span title="The manufacturer\'s ID" style="white-space: nowrap; cursor: help;">{manufacturer-id}</span>');
define('TEXT_PLACEMENT_TAG_TOOLTIP_EZ_PAGE_NAME', '<span title="The name of the EZ-Page" style="white-space: nowrap; cursor: help;">{ez-page-name}</span>');
define('TEXT_PLACEMENT_TAG_TOOLTIP_EZ_PAGE_ID', '<span title="The EZ-Page\'s ID" style="white-space: nowrap; cursor: help;">{ez-page-id}</span>');
define('TEXT_PLACEMENT_TAG_TOOLTIP_OTHER_PAGE_DEFINE_TEXT', '<span title="The text from the language define associated with the page" style="white-space: nowrap; cursor: help;">{page-define-text}</span>');

define('TEXT_VALID_PLACEMENT_TAGS_FOR_CATEGORY_MAPPING_TEMPLATE', 'The placement tags (hold mouse over each for more info) which can be used for a category mapping template are: {dir-ws-catalog}, {category-path}, {category-name}, {category-id}, {language-code}, {language-name}, and/or {language-directory}');
define('TEXT_VALID_PLACEMENT_TAGS_FOR_PRODUCT_MAPPING_TEMPLATE', 'The placement tags (hold mouse over each for more info) which can be used for a product mapping template are: {dir-ws-catalog}, {category-path}, {language-code}, {language-name}, {language-directory}, {manufacturer-name}, {product-name}, {product-model} and/or {product-id}');
define('TEXT_VALID_PLACEMENT_TAGS_FOR_MANUFACTURER_MAPPING_TEMPLATE', 'The placement tags (hold mouse over each for more info) which can be used for a manufacturer mapping template are: {dir-ws-catalog}, {manufacturer-name} and/or {manufacturer-id}');
define('TEXT_VALID_PLACEMENT_TAGS_FOR_EZ_PAGE_MAPPING_TEMPLATE', 'The placement tags (hold mouse over each for more info) which can be used for an EZ-Page mapping template are: {dir-ws-catalog}, {language-code}, {language-name}, {language-directory}, {ez-page-name} and/or {ez-page-id}');
define('TEXT_VALID_PLACEMENT_TAGS_FOR_OTHER_PAGE_MAPPING_TEMPLATE', 'The placement tags (hold mouse over each for more info) which can be used for a page mapping template are: {dir-ws-catalog}, {language-code}, {language-name}, {language-directory}, and/or {page-define-text}');
